      FUNCTION COVAR4(P1,P2) 
C***                COVARIANCE FUNCTION 
C*** DERIVED FROM THE SUM OF COVARIANCES IN TWO DIMENSIONS 
C*** SEE JOURNEL AND HUIJBREGTS FUNCTION COVA, P 382. 
C*** THIS SUBPROGRAM WAS WRITTEN BY W.D. GRUNDY, MARCH 1981 
C***               INPUT VARIABLES 
C***    P1(1)       X-COORDINATE OF FIRST POINT 
C***    P2(1)       X-COORDINATE OF SECOND POINT 
C***    P1(2)       Y-COORDINATE OF FIRST POINT 
C***    P2(2)       Y-COORDINATE OF SECOND POINT 
C***    NEST        NUMBER OF NESTED VARIOGRAMS 
C***    C0          NUGGET EFFECT 
C***    C(NEST)     C-VALUES OF VARIOGRAMS 
C***    AVALU(NEST) A-VALUES OF VARIOGRAMS 
C***    ANGLE(NEST) ANGLES OF ROTATION OF ANISOTROPIC VARIOGRAMS ABOUT 
C***                EAST-WEST AXIS.  EAST IS TAKEN AS ZERO DEGREES. 
C***                ANGLES ARE ENTERED IN DECIMAL DEGREES. 
C***                NEGATIVE ANGLE INDICATES CLOCKWISE ROTATION. 
C***                POSITIVE ANGLE INDICATES COUNTER-CLOCKWISE ROTATION 
C***                IF ANISOTROPY IS GEOMETRIC, ANGLE IS THE BEARING 
C***                OF THE MAJOR AXIS OF THE ELLIPSE. 
C***                IF ANISOTROPY IS ZONAL, ANGLE IS THE BEARING 
C***                OF THE DIRECTION OF VARIATION. 
C***   AFH(NEST)    ANISOTROPY RATIOS OF VARIOGRAMS 
C***                AFH=0     INDICATES ZONAL ANISOTROPY 
C***                AFH>0     INDICATES GEOMETRIC ANISOTROPY 
C***                AFH=1     INDICATES ISOTROPY 
C***    SILL        C0 PLUS SUM OF C'S 
C***    ITYPE(NEST) VARIOGRAM TYPE 
C***                =1 INDICATES SPHERICAL VARIOGRAM 
C***                =2 INDICATES EXPONENTIAL VARIOGRAM 
C***                =3 INDICATES LINEAR VARIOGRAM 
C***                =4 INDICATES GAUSSIAN VARIOGRAM 
C***                =5 INDICATES CUBIC VARIOGRAM 
C***    AISI(NEST)     ANISOTROPY CORRECTION FACTOR 
C***    BISI(NEST)     ANISOTROPY CORRECTION FACTOR 
C***    CISI(NEST)     ANISOTROPY CORRECTION FACTOR 
C***    ANISOTROPY CORRECTION FACTORS ARE COMPUTED 
C***    IN SUBROUTINE VARIN4 
$INCLUDE: 'MYST.INC' 
      DIMENSION P1(2),P2(2) 
      CHARACTER*8 IHOLID 
C      CHARACTER*4 IVIB 
      INTEGER*4 IVIB 
      INTEGER*2 EX,EY 
      COMMON /COV4/ P(1830),ID(60),W(60),IHOL(51),R(60) 
      XD=P1(1)-P2(1) 
      YD=P1(2)-P2(2) 
      TEMP=0. 
      IF((ABS(XD)+ABS(YD))-1.E-06) 10,10,20 
   10 CONTINUE
      COVAR4=SILL 
      GO TO 120 
   20 CONTINUE
CSSK      DO 110 I=1,NEST 
      DO I=1,NEST 
C***    COMPUTE DISTANCE USING ANISOTROPY CORRECTION ALGORITHM 
C***    SEE JOURNEL AND HUIJBREGTS, PP. 179-181 
        A=AISI(I)*XD+CISI(I)*YD 
        B=CISI(I)*XD+BISI(I)*YD 
        H=SQRT(A*A+B*B) 
        IF(H.LT.1.E-03.AND.AFH(I).EQ.0.) GO TO 110 
        GO TO (30,50,70,80,90),ITYPE(I) 
   30   CONTINUE
C***    SPHERICAL VARIOGRAM 
        IF(H-AVALU(I)) 40,40,110
   40   CONTINUE 
        E=H/AVALU(I) 
        TEMP=TEMP+C(I)*(1.-1.5*E+0.5*E*E*E) 
        GO TO 110 
   50   CONTINUE
C***    EXPONENTIAL VARIOGRAM 
C***    TEST FOR EXPONENTIAL UNDERFLOW 
        TEST=-H/AVALU(I) 
        IF(TEST+38.) 110,110,60 
   60   CONTINUE
        TEMP=TEMP+C(I)*EXP(TEST) 
        GO TO 110 
C***    LINEAR VARIOGRAM 
   70   CONTINUE
        TEMP=TEMP+C(I)-SLOPE(I)*H**(AVALU(I)) 
        GO TO 110
   80   CONTINUE 
C***    GAUSSIAN VARIOGRAM 
C***    TEST FOR EXPONENTIAL UNDERFLOW 
        TEST=-((H/AVALU(I))**2) 
        IF(TEST+38.) 110,110,60 
   90   CONTINUE
C***    CUBIC VARIOGRAM 
        IF(H-AVALU(I))100,100,110 
  100   CONTINUE
        RR=H/AVALU(I) 
        TEMP=TEMP+C(I)*(1.-7.*RR**2+8.75*RR**3 
     &                   -3.5*RR**5+0.75*RR**7) 
  110   CONTINUE
      ENDDO
      COVAR4=TEMP 
  120 RETURN 
      END 
