C **************************************************************
C
C   S U B R O U T I N E     C H D B L D
C
C  FUNCTION - BUILD A HEADER FOR A CELL FILE
C
C
C  INPUT - WIND XMIN,XMAX,YMIN,YMAX
C          IHEAD   EXISTING HEADER
C         IENTR - 0- BUILD  1-UPDATE
C  RETURNED -
C
C **********************************************************
C
      SUBROUTINE CHDBLD(WIND,IHEAD,IENTR)
C
      COMMON /IDEVIC/ LDEVL(128)
C      COMMON /IO/    NPRNT,IOIN
$INCLUDE : 'IO.INC'
      COMMON /STRNG/ ICARD(80),ICARDP,LENICD
      INTEGER IHEAD(128),ITMP(128),IANS(40),ICOM(10)
      REAL WIND(4),AWIND(4)
      DOUBLE PRECISION TOTAC,RATIO,HEIT,WIDTH,DBSIZ
      LOGICAL MCOMP
      EQUIVALENCE(ITMP(68),AWIND(1)),(ITMP(78),ACRES),
     +            (ITMP(80),YSIDE),  (ITMP(82),XSIDE)
C
C  SET MAX FLOATING POINT VALUE
C
      RMAX = 9999999.0
C
       IUNITS=LDEVL(32)
C
C  CLEAR FOR VECTOR TO RASTER AND ALL CLEAR WORDS FOR RASTER
C
       IHEAD(1)=2
       IHEAD(50)=0
       IHEAD(58)=0
       IHEAD(59)=0
       IHEAD(63) = 0
       IHEAD(64) = 1
       IHEAD(65) = 0
       IHEAD(66) = 0
       IHEAD(76) = 0
       IHEAD(86) = 0
       IHEAD(87) = 0
       CALL CLEAR(IHEAD(92),36)
C
C  ENTER DESCRIPTION
C
       WRITE(NPRNT,90100) (IHEAD(I),I=20,49)
90100  FORMAT(' ENTER DESCRIPTION',/,' [',30A2,']',\)
       call readin(ICARD,80,ICARDP,is)
       IF (ICARD(1) .EQ. 0) GO TO 180
       DO 140 I=1,ICARDP
         IF (ICARD(I) .LE. 0) ICARD(I)=32
  140  CONTINUE
       CALL PACKC(ICARD,IANS,60)
       DO 160 I=1,30
         IHEAD(I+19)=IANS(I)
  160  CONTINUE
  180  CONTINUE
       IF (IENTR .EQ. 1) GO TO 90000
C
C  MOVE TO TEMPORARY ARRAY TO ALLOW EQUIVALENCING OF INPUT ARRAY
C
       DO 200 I=1,128
         ITMP(I) = IHEAD(I)
  200  CONTINUE
C
C    USER CHOOSES ACRES OR METERS OPTION
C
  300 WRITE(NPRNT,90300)
90300 FORMAT(' Enter [A]cres or [M]eters on a side     '\)
      call readin(ICARD,80,ICARDP,is)
      call decip(ICARD,ICOM,ICARDP)
      IF (ICOM(1).EQ.0) GO TO 300
      IF(MCOMP(ICOM(1),'M',1,IER)) GO TO 340
C
C  ACRES OPTION: USER INPUTS RATIO AND CELL SIZE,
C                PROGRAM CALCULATES HEIGHT AND WIDTH
C
  310 CONTINUE
      WRITE(NPRNT,90310)
90310 FORMAT(' Enter cell size ratio Y/X [default=1.00]',\)
      call readin(ICARD,80,ICARDP,is)
      CALL FNUM(ICARD,80,YX,ICARDP)
      IF (YX .LE. 0) YX = 1.0
      RATIO = YX
C
      IUNITS = 0
 320  IF(IUNITS.EQ.0) WRITE(NPRNT,90320)
90320 FORMAT(' Enter cell size in acres                ')
      IF(IUNITS.EQ.1) WRITE(NPRNT,1050)
 1050 FORMAT(' Enter cell size in Hectares'\)
      call readin(ICARD,80,ICARDP,is)
      CALL FNUM(ICARD,80,ACRES,ICARDP)
      IF (ACRES .LE. 0.0) GO TO 320
C
      IF(IUNITS.EQ.1) ACRES=ACRES*2.47
C
      DBSIZ = 4046.856422
      IF(MCOMP(IHEAD(77),'F',1,IER)) DBSIZ =43560.00
      TOTAC=DBLE(ACRES) * DBSIZ
      WIDTH = DSQRT(TOTAC/RATIO)
      HEIT  = WIDTH * RATIO
      IF (RATIO .EQ. 1.0D0) HEIT=WIDTH
      YSIDE = HEIT
      XSIDE =WIDTH
      GO TO 390
C
C  METERS OPTION: USER INPUTS LENGTH OF SIDES,
C                PROGRAM CALCULATES RATIO AND AREA
C
  340 CONTINUE
      WRITE(NPRNT,90340)
90340 FORMAT(' Please enter cell width in meters       '\)
      call readin(ICARD,80,ICARDP,is)
      K=0
      CALL FNUM(ICARD,80,XSIDE,ICARDP)
      IF (XSIDE.LE.0) GO TO 340
C
  350 CONTINUE
      WRITE(NPRNT,90350)
90350 FORMAT(' Please enter cell height in meters      ',\)
      call readin(ICARD,80,ICARDP,is)
      CALL FNUM(ICARD,80,YSIDE,ICARDP)
      IF (YSIDE.LE.0) GO TO 350
C
      DBSIZ = 0.0002471053815
      ACRES = XSIDE * DBSIZ * YSIDE
      HEIT = XSIDE
      WIDTH = YSIDE
  390 CONTINUE
C
C.....COMPUTE NEW WINDOW TO BEGIN & END ON EVEN INCREMENT OF CELL SIZE ......
      AWIND(1)=SNGL(DNINT(DBLE(WIND(1))/WIDTH)*WIDTH)
      AWIND(2)=SNGL(DNINT(DBLE(WIND(2))/WIDTH)*WIDTH)
      AWIND(3)=SNGL(DNINT(DBLE(WIND(3))/HEIT)*HEIT)
      AWIND(4)=SNGL(DNINT(DBLE(WIND(4))/HEIT)*HEIT)
C.....COMPUTE NEW #ROWS AND #COLUMNS ......
      ITMP(60) = IDINT (DNINT ((DBLE(AWIND(4)) - DBLE(AWIND(3)))
     +           / HEIT))
      ITMP(61) = IDINT (DNINT ((DBLE(AWIND(2)) - DBLE(AWIND(1)))
     +           / WIDTH))
C
C.....CHECK FOR OVERFLOW .....
      CELLCT = FLOAT(ITMP(60)) * FLOAT(ITMP(61))
      IF (CELLCT .GT. RMAX) WRITE(NPRNT,90400) RMAX
90400 FORMAT(' TOO MANY CELLS FOR THIS COMPUTER  MAXIMUM IS ',F11.2)
      IF (CELLCT .GT. RMAX) GO TO 300
C
C  MOVE BACK INTO OUTPUT ARRAY
C
       DO 500 I=1,128
         IHEAD(I) = ITMP(I)
  500  CONTINUE
C
C  JUMP OUT
C
90000  CONTINUE
       RETURN
       END
