%% Figure 2a
%
clear
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure2a.mat','X','Xsup','Y','P','Polyfit')
figure, hold on
for k = 1:length(X(1,:))
    plot(X(:,k),Y(:,k),'ko'),
    fplot(@(x) polyval(Polyfit(k,:),x),[-100 700],'k')
end
figure, hold on
for k = 1:length(X(1,:))
    plot(Xsup(:,k),Y(:,k),'ko')
end
%
% FigureRef = 'Figure2a';
% for k=1:5
% T = array2table([X(:,k),Xsup(:,k),Y(:,k)],...
%     'VariableNames',{'X1','X2','Y'})
% SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(k) '.txt']
% writetable(T,SaveInfos)  
% end
%% Figure 2b
%
clear
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure2b.mat','X','Xsup','Y','Polyfit','P')
figure(3),clf, hold on
for k = 1:length(X(1,:))
    plot(X(:,k),Y(:,k),'ko'),fplot(@(x) polyval(Polyfit(:,k),x),[-100 700],'k')
end
figure(4),clf, hold on
for k = 1:length(X(1,:))
    plot(Xsup(:,k),Y(:,k),'ko')
end
%
% FigureRef = 'Figure2b';
% for k=1:11
% T = array2table([X(:,k),Xsup(:,k),Y(:,k)],...
%     'VariableNames',{'X1','X2','Y'})
% SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(k) '.txt']
% writetable(T,SaveInfos)  
% end
%% Figure 2c
clear
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure2c.mat','X','Xsup','Y','Polyfit','P')
figure, hold on
for k = 1:length(X(1,:))
    plot(X(:,k),Y(:,k),'ko'),fplot(@(x) polyval(Polyfit(:,k),x),[-100 700],'k')
end
figure, hold on
for k = 1:length(X(1,:))
    plot(Xsup(:,k),Y(:,k),'ko')
end
%
% FigureRef = 'Figure2c';
% for k=1:11
% T = array2table([X(:,k),Xsup(:,k),Y(:,k)],...
%     'VariableNames',{'X1','X2','Y'})
% SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(k) '.txt']
% writetable(T,SaveInfos)  
% end
%% Figure 3a
clear
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure3a.mat','X','Y','c','Xth','Yth','error_X','error_Y')
figure,hold on
for k=1:length(X)
    errorbar(X{k},Y{k},error_Y{k},error_Y{k},error_X{k},error_X{k})
    plot(Xth{k},Yth{k},'.')
end

FigureRef = 'Figure3a';
for k=1:4
    T = array2table([Xth{k},Yth{k}],...
        'VariableNames',{'X','Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\rheometer' num2str(k) '.txt']
    writetable(T,SaveInfos)
    
    T = array2table([X{k}',Y{k}',error_X{k}',error_Y{k}'],...
        'VariableNames',{'X','Y','error_X','error_Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\TIRF' num2str(k) '.txt']
    writetable(T,SaveInfos)
end
%% FIgure 3b
clear
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure3b.mat','Xwater','Ywater',...
    'Xrheo','Yrheo','C','LAMBDA','ETA_0','ETA_INF','NN','XX_PAM_TIRF','YY_PAM_TIRF',...
    'error_XX_PAM_TIRF','error_YY_PAM_TIRF','XX_water_TIRF','YY_water_TIRF','error_XX_water_TIRF','error_YY_water_TIRF')

cmap=flipud(summer(4));

figure,clf,hold on
clear gca
for k=1:4
    stephane = @(gamma) ( ETA_INF(k) +(ETA_0(k)-ETA_INF(k))*(1+(LAMBDA(k)*gamma)^2)^((NN(k)-1)/2) )/ETA_INF(k);
    fplot(stephane,[0.1 10000],'Color',cmap(k,:))
    plot(Xrheo{k},Yrheo{k},'.','Color',cmap(k,:))
    plot(Xwater{k},Ywater{k},'k.')
    
    errorbar(XX_PAM_TIRF{k},YY_PAM_TIRF{k},error_YY_PAM_TIRF{k},error_YY_PAM_TIRF{k},error_YY_PAM_TIRF{k},error_XX_PAM_TIRF{k},'o','Color',cmap(k,:))
    errorbar(XX_water_TIRF{k},YY_water_TIRF{k},error_YY_water_TIRF{k},error_YY_water_TIRF{k},error_YY_water_TIRF{k},error_XX_water_TIRF{k},'ko')
end
set(gca,'XScale','log','YScale','log')

FigureRef = 'Figure3b';
if exist(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])==0
    mkdir(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])
end

for k=1:4
    T = array2table([Xrheo{k},Yrheo{k}],...
        'VariableNames',{'X','Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\rheometer_PAM' num2str(k) '.txt']
    writetable(T,SaveInfos)
    
    T = array2table([Xwater{k},Ywater{k}],...
        'VariableNames',{'X','Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\rheometer_water' num2str(k) '.txt']
    writetable(T,SaveInfos)
    
    
    T = array2table([XX_PAM_TIRF{k}',YY_PAM_TIRF{k}',error_XX_PAM_TIRF{k}',error_YY_PAM_TIRF{k}'],...
        'VariableNames',{'X','Y','error_X','error_Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\TIRF_PAM' num2str(k) '.txt']
    writetable(T,SaveInfos)
    
    T = array2table([XX_water_TIRF{k}',YY_water_TIRF{k}',error_XX_water_TIRF{k}',error_YY_water_TIRF{k}'],...
        'VariableNames',{'X','Y','error_X','error_Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\TIRF_water' num2str(k) '.txt']
    writetable(T,SaveInfos)
end

%% FIgure 3c
clear
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure3c.mat','X_TIRF_water','Y_TIRF_water','error_Y_TIRF_water','error_X_TIRF_water',...
        'X_TIRF','Y_TIRF','error_Y_TIRF','error_X_TIRF','Xrheo','Yrheo','Xrheo_water','Yrheo_water')


cmap=flipud(summer(4));

figure,clf,hold on
clear gca
for k=1:4
    plot(Xrheo{k},Yrheo{k},'.','Color',cmap(k,:))
    plot(Xrheo_water{k},Yrheo_water{k},'k.')
    errorbar(X_TIRF_water{k},Y_TIRF_water{k},error_Y_TIRF_water{k},error_Y_TIRF_water{k},error_X_TIRF_water{k},error_X_TIRF_water{k},'ko')
    errorbar(X_TIRF{k},Y_TIRF{k},error_Y_TIRF{k},error_Y_TIRF{k},error_X_TIRF{k},error_X_TIRF{k},'o','Color',cmap(k,:))
end
set(gca,'XScale','log','YScale','log')

FigureRef = 'Figure3c';
if exist(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])==0
    mkdir(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])
end

for k=1:4
    T = array2table([Xrheo{k},Yrheo{k}],...
        'VariableNames',{'X','Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\rheometer_PAM' num2str(k) '.txt']
    writetable(T,SaveInfos)
    
    T = array2table([Xrheo_water{k},Yrheo_water{k}],...
        'VariableNames',{'X','Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\rheometer_water' num2str(k) '.txt']
    writetable(T,SaveInfos)
    
    
    T = array2table([X_TIRF{k}',Y_TIRF{k}',error_X_TIRF{k}',error_Y_TIRF{k}'],...
        'VariableNames',{'X','Y','error_X','error_Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\TIRF_PAM' num2str(k) '.txt']
    writetable(T,SaveInfos)
    
    T = array2table([X_TIRF_water{k}',Y_TIRF_water{k}',error_X_TIRF_water{k}',error_Y_TIRF_water{k}'],...
        'VariableNames',{'X','Y','error_X','error_Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\TIRF_water' num2str(k) '.txt']
    writetable(T,SaveInfos)
end

%% Figure 4
FigureRef = 'Figure4a';
if exist(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])==0
    mkdir(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])
end


Y1 = [-32.46 -22.97 -69.78];
error_Y1 = [7.441 10.1 5.304];
mean_Y1 = -36.93;

T = array2table([Y1',error_Y1'],...
    'VariableNames',{'Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(1) '.txt']
writetable(T,SaveInfos)
    
Y2 = [-82.34 -98.31 -39.37 -75.44];
error_Y2 = [4.399 8.184 27.29 16.23];
mean_Y2 = -61.77;

T = array2table([Y2',error_Y2'],...
    'VariableNames',{'Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(2) '.txt']
writetable(T,SaveInfos)

Y3 =       [217 313.3 414.6  437.9];
error_Y3 = [119 84.1  95.63  94.09];

T = array2table([Y3',error_Y3'],...
    'VariableNames',{'Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(3) '.txt']
writetable(T,SaveInfos)
%% Figure 5a
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure5a.mat','X1','X2','X3','X4','Y1','Y2','Y3','Y4',...
    'error_Y1','error_Y2','error_Y3','error_Y4','')

C1 = 0.1;
C2 = 0.25;
C3 = 0.5;
C4 = 2;
a_fit = 1.9639;

cmap = flipud(summer(4))
clear gca
figure,clf, hold on
errorbar(X1,Y1,error_Y1,'o','COlor',cmap(1,:))
errorbar(X2,Y2,error_Y2,'o','COlor',cmap(2,:))
errorbar(X3,Y3,error_Y3,'o','COlor',cmap(3,:))
errorbar(X4,Y4,error_Y4,'o','COlor',cmap(4,:))
set(gca,'XScale','log','YSCale','log')
fplot(@(x) a_fit*x,[1 1000])

FigureRef = 'Figure5a';
if exist(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])==0
    mkdir(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])
end
T = array2table([X1',Y1',error_Y1'],...
    'VariableNames',{'X','Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(1) '.txt']
writetable(T,SaveInfos)
T = array2table([X2',Y2',error_Y2'],...
    'VariableNames',{'X','Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(2) '.txt']
writetable(T,SaveInfos)
T = array2table([X3',Y3',error_Y3'],...
    'VariableNames',{'X','Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(3) '.txt']
writetable(T,SaveInfos)
T = array2table([X4',Y4',error_Y4'],...
    'VariableNames',{'X','Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(4) '.txt']
writetable(T,SaveInfos)
%% Figure 5b
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure5b.mat','X','Y','errorY')

figure,clf,
clear gca
errorbar(X,Y,errorY,'bo')
set(gca,'XScale','log')
xlim([1 1000])
ylim([-4 0])

FigureRef = 'Figure5b';
if exist(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])==0
    mkdir(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])
end
T = array2table([X',Y',errorY'],...
    'VariableNames',{'X','Y','error_Y'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(1) '.txt']
writetable(T,SaveInfos)
%% Figure 6
load('C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\Figure6.mat','X','Y','fit','XM')
cmap = autumn(5);
figure,hold on
for k=1:5
    plot(X{k},Y{k},'o','Color',cmap(k,:))
    fplot(@(x) fit(k)*x,[-10 10],'Color',cmap(k,:))
end

FigureRef = 'Figure6';
if exist(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])==0
    mkdir(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])
end

for k=1:5
    T = array2table([X{k}',Y{k}'],...
        'VariableNames',{'X','Y'});
    SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(k) '.txt']
    writetable(T,SaveInfos)
end
%% Figure 7
X =    [0.01347 0.02852 0.04601 0.06507 0.09203 0.1301 0.1301];
Y =    [8.909   17.78   19.68   30.26   37.81   71.39  83.38];
CPAM = [2       2       0.1     0.25    0.5     2      2];
CNACL= [1.61    0.54    0       0       0       0      0];
fit = 545.9681;

figure,plot(X,Y,'o')
hold on
fplot(@(x) fit*x , [0 0.15])

FigureRef = 'Figure7';
if exist(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])==0
    mkdir(['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\'  FigureRef])
end

T = array2table([X',Y',CPAM',CNACL'],...
    'VariableNames',{'X','Y','PAM','[NaCl]'});
SaveInfos =['C:\Gabriel_PhD\My_papers_figures\Soft_Matter\Matlab\OpenData\' FigureRef '\data' num2str(1) '.txt']
writetable(T,SaveInfos)