#' Determine if this is a monotonously increasing function
#' This is any sequence that is generated by \link{seq}
#' that increases in steps of one.
#' @param sequence a sequence of numbers
#' @export
is_mis <- function(sequence) {
  all(
    sequence ==
    seq(from = sequence[1], length.out = length(sequence), by = 1)
  )
}
