var WTData = function(title, details, util, api ) {
	this.title = title;
	this.details = details;
	this.util = util;
	this.api = api;
};

WTData.prototype.appendLinkItem = function( list, link, name ) {
	if(!name) name = link;
	var vlink = link.replace(/\s/g, '_');
	list.append($('<li></li>').append($('<a href="'+vlink+'"></a>').append(name)));
};

WTData.prototype.populateList = function( list, data ) {
	var me = this;
	me.appendLinkItem( list, data.location, "<b>DOWNLOAD</b>" );

	var types = $('<ul></ul>');
	$.each(data.types, function(i, type) {
		types.append($('<li>'+type+'</li>'));
	});
	list.append($('<li><b>Data Types</b></li>')).append(types);

	if(data.inputtoworkflows.length) {
		var plinks = $('<ul></ul>');
		$.each(data.inputtoworkflows, function(i, link) {
			var name = link.replace(/.+\//, '');
			me.appendLinkItem( plinks, link, name );
		});
		list.append($('<li><b>Used as Input in the following Workflows:</b></li>')).append(plinks);
	}

	if(data.generatedbyworkflows.length) {
		var plinks = $('<ul></ul>');
		$.each(data.generatedbyworkflows, function(i, link) {
			var name = link.replace(/.+\//, '');
			me.appendLinkItem( plinks, link, name );
		});
		list.append($('<li><b>Generated by the following Workflows:</b></li>')).append(plinks);
	}

	/*var plinks = $('<ul></ul>');
	$.each(data.pubbylinks, function(i, link) {
		var name = link.replace(/.+\//, '');
		me.appendLinkItem( plinks, link, name );
	});
	list.append($('<li><b>Usage</b></li>')).append(plinks);*/
};

WTData.prototype.getList = function( item, data ) {
	var list = $('<ul></ul>');
	var me = this;

	if(data && data.WTData) {
		me.populateList(list, data.WTData);
	}
	item.data('list', list);
	return list;
};


WTData.prototype.display = function( item ) {
	var me = this;
	item.data('data', me.details);

	var list = me.getList( item, me.details );
	var header = $('<div class="heading"></div>').append($('<b>Data</b>'));
	item.append(header);
	var wrapper = $('<div style="padding:5px"></div>');
	wrapper.append(list);
	item.append(wrapper);

};

