% Taku Ito
% 08/18/2016

% This is a general script to import EDATs into MATLAB and produce stim files according to the type of stimulus files you want.
% Originally created to create stimulus files for auditory v visual visual task rule contrasts, i.e., constant/hi-pitch versus vertical/red sensory task rules
addpath('../scripts/');
% Subject numbers - this will need to incrementally edited as more subjects become preprocessed
subjNums = [013 014 016 017 018 021 023 024 025 026 027 028 030 031 032 033 034 035 037 038 039 040 042 043 045 046 047 048 049 050 053 055 057 062];% 063 066 067 068 069 070 072 074 075 077 081 086 088]; %041 
% excluding subject 041
% Need to create this for ReffuncToAFNI function
subjNumStr = '013 014 016 017 018 021 023 024 025 026 027 028 030 031 032 033 034 035 037 038 039 040 042 043 045 046 047 048 049 050 053 055 057 062';% 063 066 067 068 069 070 072 074 075 077 081 086 088'; %041
subjNumStr = strread(subjNumStr, '%s', 'delimiter', ' ');

% Import fMRI Behavioral EDAT files
EDATImport = taku_EDATImportBySubj_IndivRITL('_fMRI_CPRO.txt', subjNums);

% Run reference function, converting trial information to TR-by-TR info
reffunc = takuReffunc_ModalityControl_v3(EDATImport, 'modControl');

% Put all subjects into a single vector
reffunc_vector = takuReffuncVector_IndivRITL(reffunc);

%%
% ReffuncToAFNI - create stimulus timingfiles in the current directory
[dmat, dLabels] = ReffuncToAFNI(reffunc_vector, subjNumStr, 8, [1:8], [581 581 581 581 581 581 581 581], .785,...
    {'MiniblockEncoding1',   'MiniblockProbe1', ...
     'MiniblockEncoding2',   'MiniblockProbe2', ...
     'MiniblockEncoding3',   'MiniblockProbe3', ...
     'MiniblockEncoding4',   'MiniblockProbe4', ...
     'MiniblockEncoding5',   'MiniblockProbe5', ...
     'MiniblockEncoding6',   'MiniblockProbe6', ...
     'MiniblockEncoding7',   'MiniblockProbe7', ...
     'MiniblockEncoding8',   'MiniblockProbe8', ...
     'MiniblockEncoding9',   'MiniblockProbe9', ...
     'MiniblockEncoding10',  'MiniblockProbe10', ...
     'MiniblockEncoding11',  'MiniblockProbe11', ...
     'MiniblockEncoding12',  'MiniblockProbe12', ...
     'MiniblockEncoding13',  'MiniblockProbe13', ...
     'MiniblockEncoding14',  'MiniblockProbe14', ...
     'MiniblockEncoding15',  'MiniblockProbe15', ...
     'MiniblockEncoding16',  'MiniblockProbe16', ...
     'MiniblockEncoding17',  'MiniblockProbe17', ...
     'MiniblockEncoding18',  'MiniblockProbe18', ...
     'MiniblockEncoding19',  'MiniblockProbe19', ...
     'MiniblockEncoding20',  'MiniblockProbe20', ...
     'MiniblockEncoding21',  'MiniblockProbe21', ...
     'MiniblockEncoding22',  'MiniblockProbe22', ...
     'MiniblockEncoding23',  'MiniblockProbe23', ...
     'MiniblockEncoding24',  'MiniblockProbe24', ...
     'MiniblockEncoding25',  'MiniblockProbe25', ...
     'MiniblockEncoding26',  'MiniblockProbe26', ...
     'MiniblockEncoding27',  'MiniblockProbe27', ...
     'MiniblockEncoding28',  'MiniblockProbe28', ...
     'MiniblockEncoding29',  'MiniblockProbe29', ...
     'MiniblockEncoding30',  'MiniblockProbe30', ...
     'MiniblockEncoding31',  'MiniblockProbe31', ...
     'MiniblockEncoding32',  'MiniblockProbe32', ...
     'MiniblockEncoding33',  'MiniblockProbe33', ...
     'MiniblockEncoding34',  'MiniblockProbe34', ...
     'MiniblockEncoding35',  'MiniblockProbe35', ...
     'MiniblockEncoding36',  'MiniblockProbe36', ...
     'MiniblockEncoding37',  'MiniblockProbe37', ...
     'MiniblockEncoding38',  'MiniblockProbe38', ...
     'MiniblockEncoding39',  'MiniblockProbe39', ...
     'MiniblockEncoding40',  'MiniblockProbe40', ...
     'MiniblockEncoding41',  'MiniblockProbe41', ...
     'MiniblockEncoding42',  'MiniblockProbe42', ...
     'MiniblockEncoding43',  'MiniblockProbe43', ...
     'MiniblockEncoding44',  'MiniblockProbe44', ...
     'MiniblockEncoding45',  'MiniblockProbe45', ...
     'MiniblockEncoding46',  'MiniblockProbe46', ...
     'MiniblockEncoding47',  'MiniblockProbe47', ...
     'MiniblockEncoding48',  'MiniblockProbe48', ...
     'MiniblockEncoding49',  'MiniblockProbe49', ...
     'MiniblockEncoding50',  'MiniblockProbe50', ...
     'MiniblockEncoding51',  'MiniblockProbe51', ...
     'MiniblockEncoding52',  'MiniblockProbe52', ...
     'MiniblockEncoding53',  'MiniblockProbe53', ...
     'MiniblockEncoding54',  'MiniblockProbe54', ...
     'MiniblockEncoding55',  'MiniblockProbe55', ...
     'MiniblockEncoding56',  'MiniblockProbe56', ...
     'MiniblockEncoding57',  'MiniblockProbe57', ...
     'MiniblockEncoding58',  'MiniblockProbe58', ...
     'MiniblockEncoding59',  'MiniblockProbe59', ...
     'MiniblockEncoding60',  'MiniblockProbe60', ...
     'MiniblockEncoding61',  'MiniblockProbe61', ...
     'MiniblockEncoding62',  'MiniblockProbe62', ...
     'MiniblockEncoding63',  'MiniblockProbe63', ...
     'MiniblockEncoding64',  'MiniblockProbe64', ...
     'MiniblockEncoding65',  'MiniblockProbe65', ...
     'MiniblockEncoding66',  'MiniblockProbe66', ...
     'MiniblockEncoding67',  'MiniblockProbe67', ...
     'MiniblockEncoding68',  'MiniblockProbe68', ...
     'MiniblockEncoding69',  'MiniblockProbe69', ...
     'MiniblockEncoding70',  'MiniblockProbe70', ...
     'MiniblockEncoding71',  'MiniblockProbe71', ...
     'MiniblockEncoding72',  'MiniblockProbe72', ...
     'MiniblockEncoding73',  'MiniblockProbe73', ...
     'MiniblockEncoding74',  'MiniblockProbe74', ...
     'MiniblockEncoding75',  'MiniblockProbe75', ...
     'MiniblockEncoding76',  'MiniblockProbe76', ...
     'MiniblockEncoding77',  'MiniblockProbe77', ...
     'MiniblockEncoding78',  'MiniblockProbe78', ...
     'MiniblockEncoding79',  'MiniblockProbe79', ...
     'MiniblockEncoding80',  'MiniblockProbe80', ...
     'MiniblockEncoding81',  'MiniblockProbe81', ...
     'MiniblockEncoding82',  'MiniblockProbe82', ...
     'MiniblockEncoding83',  'MiniblockProbe83', ...
     'MiniblockEncoding84',  'MiniblockProbe84', ...
     'MiniblockEncoding85',  'MiniblockProbe85', ...
     'MiniblockEncoding86',  'MiniblockProbe86', ...
     'MiniblockEncoding87',  'MiniblockProbe87', ...
     'MiniblockEncoding88',  'MiniblockProbe88', ...
     'MiniblockEncoding89',  'MiniblockProbe89', ...
     'MiniblockEncoding90',  'MiniblockProbe90', ...
     'MiniblockEncoding91',  'MiniblockProbe91', ...
     'MiniblockEncoding92',  'MiniblockProbe92', ...
     'MiniblockEncoding93',  'MiniblockProbe93', ...
     'MiniblockEncoding94',  'MiniblockProbe94', ...
     'MiniblockEncoding95',  'MiniblockProbe95', ...
     'MiniblockEncoding96',  'MiniblockProbe96', ...
     'MiniblockEncoding97',  'MiniblockProbe97', ...
     'MiniblockEncoding98',  'MiniblockProbe98', ...
     'MiniblockEncoding99',  'MiniblockProbe99', ...
     'MiniblockEncoding100', 'MiniblockProbe100', ...
     'MiniblockEncoding101', 'MiniblockProbe101', ...
     'MiniblockEncoding102', 'MiniblockProbe102', ...
     'MiniblockEncoding103', 'MiniblockProbe103', ...
     'MiniblockEncoding104', 'MiniblockProbe104', ...
     'MiniblockEncoding105', 'MiniblockProbe105', ...
     'MiniblockEncoding106', 'MiniblockProbe106', ...
     'MiniblockEncoding107', 'MiniblockProbe107', ...
     'MiniblockEncoding108', 'MiniblockProbe108', ...
     'MiniblockEncoding109', 'MiniblockProbe109', ...
     'MiniblockEncoding110', 'MiniblockProbe110', ...
     'MiniblockEncoding111', 'MiniblockProbe111', ...
     'MiniblockEncoding112', 'MiniblockProbe112', ...
     'MiniblockEncoding113', 'MiniblockProbe113', ...
     'MiniblockEncoding114', 'MiniblockProbe114', ...
     'MiniblockEncoding115', 'MiniblockProbe115', ...
     'MiniblockEncoding116', 'MiniblockProbe116', ...
     'MiniblockEncoding117', 'MiniblockProbe117', ...
     'MiniblockEncoding118', 'MiniblockProbe118', ...
     'MiniblockEncoding119', 'MiniblockProbe119', ...
     'MiniblockEncoding120', 'MiniblockProbe120', ...
     'MiniblockEncoding121', 'MiniblockProbe121', ...
     'MiniblockEncoding122', 'MiniblockProbe122', ...
     'MiniblockEncoding123', 'MiniblockProbe123', ...
     'MiniblockEncoding124', 'MiniblockProbe124', ...
     'MiniblockEncoding125', 'MiniblockProbe125', ...
     'MiniblockEncoding126', 'MiniblockProbe126', ...
     'MiniblockEncoding127', 'MiniblockProbe127', ...
     'MiniblockEncoding128', 'MiniblockProbe128'},...
    {'\w*_Enc\w*_Miniblock1_\w*', '\w*_Probe\w*_Miniblock1_\w*', ...
     '\w*_Enc\w*_Miniblock2_\w*', '\w*_Probe\w*_Miniblock2_\w*', ...
     '\w*_Enc\w*_Miniblock3_\w*', '\w*_Probe\w*_Miniblock3_\w*', ...
     '\w*_Enc\w*_Miniblock4_\w*', '\w*_Probe\w*_Miniblock4_\w*', ...
     '\w*_Enc\w*_Miniblock5_\w*', '\w*_Probe\w*_Miniblock5_\w*', ...
     '\w*_Enc\w*_Miniblock6_\w*', '\w*_Probe\w*_Miniblock6_\w*', ...
     '\w*_Enc\w*_Miniblock7_\w*', '\w*_Probe\w*_Miniblock7_\w*', ...
     '\w*_Enc\w*_Miniblock8_\w*', '\w*_Probe\w*_Miniblock8_\w*', ...
     '\w*_Enc\w*_Miniblock9_\w*', '\w*_Probe\w*_Miniblock9_\w*', ...
     '\w*_Enc\w*_Miniblock10_\w*', '\w*_Probe\w*_Miniblock10_\w*', ...
     '\w*_Enc\w*_Miniblock11_\w*', '\w*_Probe\w*_Miniblock11_\w*', ...
     '\w*_Enc\w*_Miniblock12_\w*', '\w*_Probe\w*_Miniblock12_\w*', ...
     '\w*_Enc\w*_Miniblock13_\w*', '\w*_Probe\w*_Miniblock13_\w*', ...
     '\w*_Enc\w*_Miniblock14_\w*', '\w*_Probe\w*_Miniblock14_\w*', ...
     '\w*_Enc\w*_Miniblock15_\w*', '\w*_Probe\w*_Miniblock15_\w*', ...
     '\w*_Enc\w*_Miniblock16_\w*', '\w*_Probe\w*_Miniblock16_\w*', ...
     '\w*_Enc\w*_Miniblock17_\w*', '\w*_Probe\w*_Miniblock17_\w*', ...
     '\w*_Enc\w*_Miniblock18_\w*', '\w*_Probe\w*_Miniblock18_\w*', ...
     '\w*_Enc\w*_Miniblock19_\w*', '\w*_Probe\w*_Miniblock19_\w*', ...
     '\w*_Enc\w*_Miniblock20_\w*', '\w*_Probe\w*_Miniblock20_\w*', ...
     '\w*_Enc\w*_Miniblock21_\w*', '\w*_Probe\w*_Miniblock21_\w*', ...
     '\w*_Enc\w*_Miniblock22_\w*', '\w*_Probe\w*_Miniblock22_\w*', ...
     '\w*_Enc\w*_Miniblock23_\w*', '\w*_Probe\w*_Miniblock23_\w*', ...
     '\w*_Enc\w*_Miniblock24_\w*', '\w*_Probe\w*_Miniblock24_\w*', ...
     '\w*_Enc\w*_Miniblock25_\w*', '\w*_Probe\w*_Miniblock25_\w*', ...
     '\w*_Enc\w*_Miniblock26_\w*', '\w*_Probe\w*_Miniblock26_\w*', ...
     '\w*_Enc\w*_Miniblock27_\w*', '\w*_Probe\w*_Miniblock27_\w*', ...
     '\w*_Enc\w*_Miniblock28_\w*', '\w*_Probe\w*_Miniblock28_\w*', ...
     '\w*_Enc\w*_Miniblock29_\w*', '\w*_Probe\w*_Miniblock29_\w*', ...
     '\w*_Enc\w*_Miniblock30_\w*', '\w*_Probe\w*_Miniblock30_\w*', ...
     '\w*_Enc\w*_Miniblock31_\w*', '\w*_Probe\w*_Miniblock31_\w*', ...
     '\w*_Enc\w*_Miniblock32_\w*', '\w*_Probe\w*_Miniblock32_\w*', ...
     '\w*_Enc\w*_Miniblock33_\w*', '\w*_Probe\w*_Miniblock33_\w*', ...
     '\w*_Enc\w*_Miniblock34_\w*', '\w*_Probe\w*_Miniblock34_\w*', ...
     '\w*_Enc\w*_Miniblock35_\w*', '\w*_Probe\w*_Miniblock35_\w*', ...
     '\w*_Enc\w*_Miniblock36_\w*', '\w*_Probe\w*_Miniblock36_\w*', ...
     '\w*_Enc\w*_Miniblock37_\w*', '\w*_Probe\w*_Miniblock37_\w*', ...
     '\w*_Enc\w*_Miniblock38_\w*', '\w*_Probe\w*_Miniblock38_\w*', ...
     '\w*_Enc\w*_Miniblock39_\w*', '\w*_Probe\w*_Miniblock39_\w*', ...
     '\w*_Enc\w*_Miniblock40_\w*', '\w*_Probe\w*_Miniblock40_\w*', ...
     '\w*_Enc\w*_Miniblock41_\w*', '\w*_Probe\w*_Miniblock41_\w*', ...
     '\w*_Enc\w*_Miniblock42_\w*', '\w*_Probe\w*_Miniblock42_\w*', ...
     '\w*_Enc\w*_Miniblock43_\w*', '\w*_Probe\w*_Miniblock43_\w*', ...
     '\w*_Enc\w*_Miniblock44_\w*', '\w*_Probe\w*_Miniblock44_\w*', ...
     '\w*_Enc\w*_Miniblock45_\w*', '\w*_Probe\w*_Miniblock45_\w*', ...
     '\w*_Enc\w*_Miniblock46_\w*', '\w*_Probe\w*_Miniblock46_\w*', ...
     '\w*_Enc\w*_Miniblock47_\w*', '\w*_Probe\w*_Miniblock47_\w*', ...
     '\w*_Enc\w*_Miniblock48_\w*', '\w*_Probe\w*_Miniblock48_\w*', ...
     '\w*_Enc\w*_Miniblock49_\w*', '\w*_Probe\w*_Miniblock49_\w*', ...
     '\w*_Enc\w*_Miniblock50_\w*', '\w*_Probe\w*_Miniblock50_\w*', ...
     '\w*_Enc\w*_Miniblock51_\w*', '\w*_Probe\w*_Miniblock51_\w*', ...
     '\w*_Enc\w*_Miniblock52_\w*', '\w*_Probe\w*_Miniblock52_\w*', ...
     '\w*_Enc\w*_Miniblock53_\w*', '\w*_Probe\w*_Miniblock53_\w*', ...
     '\w*_Enc\w*_Miniblock54_\w*', '\w*_Probe\w*_Miniblock54_\w*', ...
     '\w*_Enc\w*_Miniblock55_\w*', '\w*_Probe\w*_Miniblock55_\w*', ...
     '\w*_Enc\w*_Miniblock56_\w*', '\w*_Probe\w*_Miniblock56_\w*', ...
     '\w*_Enc\w*_Miniblock57_\w*', '\w*_Probe\w*_Miniblock57_\w*', ...
     '\w*_Enc\w*_Miniblock58_\w*', '\w*_Probe\w*_Miniblock58_\w*', ...
     '\w*_Enc\w*_Miniblock59_\w*', '\w*_Probe\w*_Miniblock59_\w*', ...
     '\w*_Enc\w*_Miniblock60_\w*', '\w*_Probe\w*_Miniblock60_\w*', ...
     '\w*_Enc\w*_Miniblock61_\w*', '\w*_Probe\w*_Miniblock61_\w*', ...
     '\w*_Enc\w*_Miniblock62_\w*', '\w*_Probe\w*_Miniblock62_\w*', ...
     '\w*_Enc\w*_Miniblock63_\w*', '\w*_Probe\w*_Miniblock63_\w*', ...
     '\w*_Enc\w*_Miniblock64_\w*', '\w*_Probe\w*_Miniblock64_\w*',...
     '\w*_Enc\w*_Miniblock65_\w*', '\w*_Probe\w*_Miniblock65_\w*', ...
     '\w*_Enc\w*_Miniblock66_\w*', '\w*_Probe\w*_Miniblock66_\w*', ...
     '\w*_Enc\w*_Miniblock67_\w*', '\w*_Probe\w*_Miniblock67_\w*', ...
     '\w*_Enc\w*_Miniblock68_\w*', '\w*_Probe\w*_Miniblock68_\w*', ...
     '\w*_Enc\w*_Miniblock69_\w*', '\w*_Probe\w*_Miniblock69_\w*', ...
     '\w*_Enc\w*_Miniblock70_\w*', '\w*_Probe\w*_Miniblock70_\w*', ...
     '\w*_Enc\w*_Miniblock71_\w*', '\w*_Probe\w*_Miniblock71_\w*', ...
     '\w*_Enc\w*_Miniblock72_\w*', '\w*_Probe\w*_Miniblock72_\w*', ...
     '\w*_Enc\w*_Miniblock73_\w*', '\w*_Probe\w*_Miniblock73_\w*', ...
     '\w*_Enc\w*_Miniblock74_\w*', '\w*_Probe\w*_Miniblock74_\w*', ...
     '\w*_Enc\w*_Miniblock75_\w*', '\w*_Probe\w*_Miniblock75_\w*', ...
     '\w*_Enc\w*_Miniblock76_\w*', '\w*_Probe\w*_Miniblock76_\w*', ...
     '\w*_Enc\w*_Miniblock77_\w*', '\w*_Probe\w*_Miniblock77_\w*', ...
     '\w*_Enc\w*_Miniblock78_\w*', '\w*_Probe\w*_Miniblock78_\w*', ...
     '\w*_Enc\w*_Miniblock79_\w*', '\w*_Probe\w*_Miniblock79_\w*', ...
     '\w*_Enc\w*_Miniblock80_\w*', '\w*_Probe\w*_Miniblock80_\w*', ...
     '\w*_Enc\w*_Miniblock81_\w*', '\w*_Probe\w*_Miniblock81_\w*', ...
     '\w*_Enc\w*_Miniblock82_\w*', '\w*_Probe\w*_Miniblock82_\w*', ...
     '\w*_Enc\w*_Miniblock83_\w*', '\w*_Probe\w*_Miniblock83_\w*', ...
     '\w*_Enc\w*_Miniblock84_\w*', '\w*_Probe\w*_Miniblock84_\w*', ...
     '\w*_Enc\w*_Miniblock85_\w*', '\w*_Probe\w*_Miniblock85_\w*', ...
     '\w*_Enc\w*_Miniblock86_\w*', '\w*_Probe\w*_Miniblock86_\w*', ...
     '\w*_Enc\w*_Miniblock87_\w*', '\w*_Probe\w*_Miniblock87_\w*', ...
     '\w*_Enc\w*_Miniblock88_\w*', '\w*_Probe\w*_Miniblock88_\w*', ...
     '\w*_Enc\w*_Miniblock89_\w*', '\w*_Probe\w*_Miniblock89_\w*', ...
     '\w*_Enc\w*_Miniblock90_\w*', '\w*_Probe\w*_Miniblock90_\w*', ...
     '\w*_Enc\w*_Miniblock91_\w*', '\w*_Probe\w*_Miniblock91_\w*', ...
     '\w*_Enc\w*_Miniblock92_\w*', '\w*_Probe\w*_Miniblock92_\w*', ...
     '\w*_Enc\w*_Miniblock93_\w*', '\w*_Probe\w*_Miniblock93_\w*', ...
     '\w*_Enc\w*_Miniblock94_\w*', '\w*_Probe\w*_Miniblock94_\w*', ...
     '\w*_Enc\w*_Miniblock95_\w*', '\w*_Probe\w*_Miniblock95_\w*', ...
     '\w*_Enc\w*_Miniblock96_\w*', '\w*_Probe\w*_Miniblock96_\w*', ...
     '\w*_Enc\w*_Miniblock97_\w*', '\w*_Probe\w*_Miniblock97_\w*', ...
     '\w*_Enc\w*_Miniblock98_\w*', '\w*_Probe\w*_Miniblock98_\w*', ...
     '\w*_Enc\w*_Miniblock99_\w*', '\w*_Probe\w*_Miniblock99_\w*', ...
     '\w*_Enc\w*_Miniblock100_\w*','\w*_Probe\w*_Miniblock100_\w*', ...
     '\w*_Enc\w*_Miniblock101_\w*','\w*_Probe\w*_Miniblock101_\w*', ...
     '\w*_Enc\w*_Miniblock102_\w*','\w*_Probe\w*_Miniblock102_\w*', ...
     '\w*_Enc\w*_Miniblock103_\w*','\w*_Probe\w*_Miniblock103_\w*', ...
     '\w*_Enc\w*_Miniblock104_\w*','\w*_Probe\w*_Miniblock104_\w*', ...
     '\w*_Enc\w*_Miniblock105_\w*','\w*_Probe\w*_Miniblock105_\w*', ...
     '\w*_Enc\w*_Miniblock106_\w*','\w*_Probe\w*_Miniblock106_\w*', ...
     '\w*_Enc\w*_Miniblock107_\w*','\w*_Probe\w*_Miniblock107_\w*', ...
     '\w*_Enc\w*_Miniblock108_\w*','\w*_Probe\w*_Miniblock108_\w*', ...
     '\w*_Enc\w*_Miniblock109_\w*','\w*_Probe\w*_Miniblock109_\w*', ...
     '\w*_Enc\w*_Miniblock110_\w*','\w*_Probe\w*_Miniblock110_\w*', ...
     '\w*_Enc\w*_Miniblock111_\w*','\w*_Probe\w*_Miniblock111_\w*', ...
     '\w*_Enc\w*_Miniblock112_\w*','\w*_Probe\w*_Miniblock112_\w*', ...
     '\w*_Enc\w*_Miniblock113_\w*','\w*_Probe\w*_Miniblock113_\w*', ...
     '\w*_Enc\w*_Miniblock114_\w*','\w*_Probe\w*_Miniblock114_\w*', ...
     '\w*_Enc\w*_Miniblock115_\w*','\w*_Probe\w*_Miniblock115_\w*', ...
     '\w*_Enc\w*_Miniblock116_\w*','\w*_Probe\w*_Miniblock116_\w*', ...
     '\w*_Enc\w*_Miniblock117_\w*','\w*_Probe\w*_Miniblock117_\w*', ...
     '\w*_Enc\w*_Miniblock118_\w*','\w*_Probe\w*_Miniblock118_\w*', ...
     '\w*_Enc\w*_Miniblock119_\w*','\w*_Probe\w*_Miniblock119_\w*', ...
     '\w*_Enc\w*_Miniblock120_\w*','\w*_Probe\w*_Miniblock120_\w*', ...
     '\w*_Enc\w*_Miniblock121_\w*','\w*_Probe\w*_Miniblock121_\w*', ...
     '\w*_Enc\w*_Miniblock122_\w*','\w*_Probe\w*_Miniblock122_\w*', ...
     '\w*_Enc\w*_Miniblock123_\w*','\w*_Probe\w*_Miniblock123_\w*', ...
     '\w*_Enc\w*_Miniblock124_\w*','\w*_Probe\w*_Miniblock124_\w*', ...
     '\w*_Enc\w*_Miniblock125_\w*','\w*_Probe\w*_Miniblock125_\w*', ...
     '\w*_Enc\w*_Miniblock126_\w*','\w*_Probe\w*_Miniblock126_\w*', ...
     '\w*_Enc\w*_Miniblock127_\w*','\w*_Probe\w*_Miniblock127_\w*', ...
     '\w*_Enc\w*_Miniblock128_\w*','\w*_Probe\w*_Miniblock128_\w*'},...
     1, 1, 'MiniblockBetaSeriesEncodingVProbe_ModControl')

