% Taku Ito
% 08/18/2016

% This is a general script to import EDATs into MATLAB and produce stim files according to the type of stimulus files you want.
% Originally created to create stimulus files for auditory v visual visual task rule contrasts, i.e., constant/hi-pitch versus vertical/red sensory task rules
addpath('../scripts/');
% Subject numbers - this will need to incrementally edited as more subjects become preprocessed
subjNums = [013 014 016 017 018 021 023 024 025 026 027 028 030 031 032 033 034 035 037 038 039 040 042 043 045 046 047 048 049 050 053 055 057 062 063 066 067 068 069 070 072 074 075 077 081 086 088]; %041 
% excluding subject 041
% Need to create this for ReffuncToAFNI function
subjNumStr = '013 014 016 017 018 021 023 024 025 026 027 028 030 031 032 033 034 035 037 038 039 040 042 043 045 046 047 048 049 050 053 055 057 062 063 066 067 068 069 070 072 074 075 077 081 086 088'; %041
subjNumStr = strread(subjNumStr, '%s', 'delimiter', ' ');

% Import fMRI Behavioral EDAT files
EDATImport = taku_EDATImportBySubj_IndivRITL('_fMRI_CPRO.txt', subjNums);

% Run reference function, converting trial information to TR-by-TR info
reffunc = takuReffunc_ModalityControl_v3(EDATImport, 'modControl');

% Put all subjects into a single vector
reffunc_vector = takuReffuncVector_IndivRITL(reffunc);

%%
% ReffuncToAFNI - create stimulus timingfiles in the current directory
[dmat, dLabels] = ReffuncToAFNI(reffunc_vector, subjNumStr, 8, [1:8], [581 581 581 581 581 581 581 581], .785,...
    {'Miniblock1', ...
     'Miniblock2', ...
     'Miniblock3', ...
     'Miniblock4', ...
     'Miniblock5', ...
     'Miniblock6', ...
     'Miniblock7', ...
     'Miniblock8', ...
     'Miniblock9', ...
     'Miniblock10', ...
     'Miniblock11', ...
     'Miniblock12', ...
     'Miniblock13', ...
     'Miniblock14', ...
     'Miniblock15', ...
     'Miniblock16', ...
     'Miniblock17', ...
     'Miniblock18', ...
     'Miniblock19', ...
     'Miniblock20', ...
     'Miniblock21', ...
     'Miniblock22', ...
     'Miniblock23', ...
     'Miniblock24', ...
     'Miniblock25', ...
     'Miniblock26', ...
     'Miniblock27', ...
     'Miniblock28', ...
     'Miniblock29', ...
     'Miniblock30', ...
     'Miniblock31', ...
     'Miniblock32', ...
     'Miniblock33', ...
     'Miniblock34', ...
     'Miniblock35', ...
     'Miniblock36', ...
     'Miniblock37', ...
     'Miniblock38', ...
     'Miniblock39', ...
     'Miniblock40', ...
     'Miniblock41', ...
     'Miniblock42', ...
     'Miniblock43', ...
     'Miniblock44', ...
     'Miniblock45', ...
     'Miniblock46', ...
     'Miniblock47', ...
     'Miniblock48', ...
     'Miniblock49', ...
     'Miniblock50', ...
     'Miniblock51', ...
     'Miniblock52', ...
     'Miniblock53', ...
     'Miniblock54', ...
     'Miniblock55', ...
     'Miniblock56', ...
     'Miniblock57', ...
     'Miniblock58', ...
     'Miniblock59', ...
     'Miniblock60', ...
     'Miniblock61', ...
     'Miniblock62', ...
     'Miniblock63', ...
     'Miniblock64', ...
     'Miniblock65', ...
     'Miniblock66', ...
     'Miniblock67', ...
     'Miniblock68', ...
     'Miniblock69', ...
     'Miniblock70', ...
     'Miniblock71', ...
     'Miniblock72', ...
     'Miniblock73', ...
     'Miniblock74', ...
     'Miniblock75', ...
     'Miniblock76', ...
     'Miniblock77', ...
     'Miniblock78', ...
     'Miniblock79', ...
     'Miniblock80', ...
     'Miniblock81', ...
     'Miniblock82', ...
     'Miniblock83', ...
     'Miniblock84', ...
     'Miniblock85', ...
     'Miniblock86', ...
     'Miniblock87', ...
     'Miniblock88', ...
     'Miniblock89', ...
     'Miniblock90', ...
     'Miniblock91', ...
     'Miniblock92', ...
     'Miniblock93', ...
     'Miniblock94', ...
     'Miniblock95', ...
     'Miniblock96', ...
     'Miniblock97', ...
     'Miniblock98', ...
     'Miniblock99', ...
     'Miniblock100', ...
     'Miniblock101', ...
     'Miniblock102', ...
     'Miniblock103', ...
     'Miniblock104', ...
     'Miniblock105', ...
     'Miniblock106', ...
     'Miniblock107', ...
     'Miniblock108', ...
     'Miniblock109', ...
     'Miniblock110', ...
     'Miniblock111', ...
     'Miniblock112', ...
     'Miniblock113', ...
     'Miniblock114', ...
     'Miniblock115', ...
     'Miniblock116', ...
     'Miniblock117', ...
     'Miniblock118', ...
     'Miniblock119', ...
     'Miniblock120', ...
     'Miniblock121', ...
     'Miniblock122', ...
     'Miniblock123', ...
     'Miniblock124', ...
     'Miniblock125', ...
     'Miniblock126', ...
     'Miniblock127', ...
     'Miniblock128'},...
    {'\w*_Miniblock1_\w*', ...
     '\w*_Miniblock2_\w*', ...
     '\w*_Miniblock3_\w*', ...
     '\w*_Miniblock4_\w*', ...
     '\w*_Miniblock5_\w*', ...
     '\w*_Miniblock6_\w*', ...
     '\w*_Miniblock7_\w*', ...
     '\w*_Miniblock8_\w*', ...
     '\w*_Miniblock9_\w*', ...
     '\w*_Miniblock10_\w*', ...
     '\w*_Miniblock11_\w*', ...
     '\w*_Miniblock12_\w*', ...
     '\w*_Miniblock13_\w*', ...
     '\w*_Miniblock14_\w*', ...
     '\w*_Miniblock15_\w*', ...
     '\w*_Miniblock16_\w*', ...
     '\w*_Miniblock17_\w*', ...
     '\w*_Miniblock18_\w*', ...
     '\w*_Miniblock19_\w*', ...
     '\w*_Miniblock20_\w*', ...
     '\w*_Miniblock21_\w*', ...
     '\w*_Miniblock22_\w*', ...
     '\w*_Miniblock23_\w*', ...
     '\w*_Miniblock24_\w*', ...
     '\w*_Miniblock25_\w*', ...
     '\w*_Miniblock26_\w*', ...
     '\w*_Miniblock27_\w*', ...
     '\w*_Miniblock28_\w*', ...
     '\w*_Miniblock29_\w*', ...
     '\w*_Miniblock30_\w*', ...
     '\w*_Miniblock31_\w*', ...
     '\w*_Miniblock32_\w*', ...
     '\w*_Miniblock33_\w*', ...
     '\w*_Miniblock34_\w*', ...
     '\w*_Miniblock35_\w*', ...
     '\w*_Miniblock36_\w*', ...
     '\w*_Miniblock37_\w*', ...
     '\w*_Miniblock38_\w*', ...
     '\w*_Miniblock39_\w*', ...
     '\w*_Miniblock40_\w*', ...
     '\w*_Miniblock41_\w*', ...
     '\w*_Miniblock42_\w*', ...
     '\w*_Miniblock43_\w*', ...
     '\w*_Miniblock44_\w*', ...
     '\w*_Miniblock45_\w*', ...
     '\w*_Miniblock46_\w*', ...
     '\w*_Miniblock47_\w*', ...
     '\w*_Miniblock48_\w*', ...
     '\w*_Miniblock49_\w*', ...
     '\w*_Miniblock50_\w*', ...
     '\w*_Miniblock51_\w*', ...
     '\w*_Miniblock52_\w*', ...
     '\w*_Miniblock53_\w*', ...
     '\w*_Miniblock54_\w*', ...
     '\w*_Miniblock55_\w*', ...
     '\w*_Miniblock56_\w*', ...
     '\w*_Miniblock57_\w*', ...
     '\w*_Miniblock58_\w*', ...
     '\w*_Miniblock59_\w*', ...
     '\w*_Miniblock60_\w*', ...
     '\w*_Miniblock61_\w*', ...
     '\w*_Miniblock62_\w*', ...
     '\w*_Miniblock63_\w*', ...
     '\w*_Miniblock64_\w*',...
     '\w*_Miniblock65_\w*', ...
     '\w*_Miniblock66_\w*', ...
     '\w*_Miniblock67_\w*', ...
     '\w*_Miniblock68_\w*', ...
     '\w*_Miniblock69_\w*', ...
     '\w*_Miniblock70_\w*', ...
     '\w*_Miniblock71_\w*', ...
     '\w*_Miniblock72_\w*', ...
     '\w*_Miniblock73_\w*', ...
     '\w*_Miniblock74_\w*', ...
     '\w*_Miniblock75_\w*', ...
     '\w*_Miniblock76_\w*', ...
     '\w*_Miniblock77_\w*', ...
     '\w*_Miniblock78_\w*', ...
     '\w*_Miniblock79_\w*', ...
     '\w*_Miniblock80_\w*', ...
     '\w*_Miniblock81_\w*', ...
     '\w*_Miniblock82_\w*', ...
     '\w*_Miniblock83_\w*', ...
     '\w*_Miniblock84_\w*', ...
     '\w*_Miniblock85_\w*', ...
     '\w*_Miniblock86_\w*', ...
     '\w*_Miniblock87_\w*', ...
     '\w*_Miniblock88_\w*', ...
     '\w*_Miniblock89_\w*', ...
     '\w*_Miniblock90_\w*', ...
     '\w*_Miniblock91_\w*', ...
     '\w*_Miniblock92_\w*', ...
     '\w*_Miniblock93_\w*', ...
     '\w*_Miniblock94_\w*', ...
     '\w*_Miniblock95_\w*', ...
     '\w*_Miniblock96_\w*', ...
     '\w*_Miniblock97_\w*', ...
     '\w*_Miniblock98_\w*', ...
     '\w*_Miniblock99_\w*', ...
     '\w*_Miniblock100_\w*', ...
     '\w*_Miniblock101_\w*', ...
     '\w*_Miniblock102_\w*', ...
     '\w*_Miniblock103_\w*', ...
     '\w*_Miniblock104_\w*', ...
     '\w*_Miniblock105_\w*', ...
     '\w*_Miniblock106_\w*', ...
     '\w*_Miniblock107_\w*', ...
     '\w*_Miniblock108_\w*', ...
     '\w*_Miniblock109_\w*', ...
     '\w*_Miniblock110_\w*', ...
     '\w*_Miniblock111_\w*', ...
     '\w*_Miniblock112_\w*', ...
     '\w*_Miniblock113_\w*', ...
     '\w*_Miniblock114_\w*', ...
     '\w*_Miniblock115_\w*', ...
     '\w*_Miniblock116_\w*', ...
     '\w*_Miniblock117_\w*', ...
     '\w*_Miniblock118_\w*', ...
     '\w*_Miniblock119_\w*', ...
     '\w*_Miniblock120_\w*', ...
     '\w*_Miniblock121_\w*', ...
     '\w*_Miniblock122_\w*', ...
     '\w*_Miniblock123_\w*', ...
     '\w*_Miniblock124_\w*', ...
     '\w*_Miniblock125_\w*', ...
     '\w*_Miniblock126_\w*', ...
     '\w*_Miniblock127_\w*', ...
     '\w*_Miniblock128_\w*'},...
     1, 1, 'MiniblockBetaSeries_ModControl')

