function [designMatrix designMLabels] = ReffuncToAFNI(RefFunc, SubjectArray, NumRunsTotal, RunsToInclude, RunLengths, TRInSecs, CondNames, CondSearchStrings, RegExpr, OutputToFiles, AnalysisName)
%
%This function takes an array of condition labels (reference function) and creates a series of text files (one per stimulus function) for use in AFNI
%
%Created by Michael W. Cole
%http://www.mwcole.net
%mwcole@mwcole.net
%
%
% Examples:
%
%
%FlexHubMeta - INDIV2 dataset:
% subjects='ab13531 ab13570 ab13593 ab13656 ab13681 ab13724 ab13780 ab13794 ab13795 ab14123 ab14137 ab14154 ab14181 ab14195 ab14196 ab14197 ab14233 ab14249 ab14250 ab14251 ab14281 ab14302 ab14303 ab14381 ab14469 ab14470 ab14516 ab14537 ab14538 ab14539 ab14599 ab14600 ab14603 ab14632 ab14649 ab14665 ab14702 ab14713 ab14717 ab14719 ab14763 ab14780 ab14781 ab14782 ab14828 ab14842 ab14845 ab14846 ab14876 ab14944 ab14961 ab14962 ab14963 ab15003 ab15027 ab15028 ab15029 ab15093 ab15095 ab15124 ab15188 ab15197 ab15198 ab15199 ab15251 ab15255 ab15256 ab15311 ab15411 ab15448 ab15504 ab15523 ab15525 ab15526 ab15712 ab15927 ab15944 ab16047 ab16049 ab16078 ab16161 ab16162 ab16207 ab16208';
% subjects=strread(subjects,'%s','delimiter',' ');
% [dmat dmatLabels] = ReffuncToAFNI(concatenate,subjects,...
%     6, [1:6], 149, 2.36, {'Face','Word'},...
%     {'block_start_\w*face\w*','block_start_\w*word\w*'},...
%     1, 1, 'FlexHubMeta_INDIV2_FaceWord');
% [dmat dmatLabels] = ReffuncToAFNI(labels.ab13531,{'ab13531'},...
%     6, [1:6], 149, 2.36, {'Face','Word'},...
%     {'\w*face\w*','\w*word\w*'},...
%     1, 1, 'FlexHubMeta_INDIV2_FaceWord');

%RITL MEGfMRI study - RITLEventTaskFactorPracSep
% [dmat dmatLabels] = ReffuncToAFNI(reffunc_allsubjs_RITLMEGfMRI_EventsOnly,{'701','703','704','705','706','707','708','709','710','711'},...
%     5, [1:5], 218, 2, {'Novel_Logic_JUSTONE','Novel_Logic_SAME','Novel_Logic_SECOND','Novel_Logic_NOTSECOND',...
%     'Novel_Semantic_GREEN','Novel_Semantic_LOUD','Novel_Semantic_SOFT','Novel_Semantic_SWEET',...
%     'Novel_Motor_RINDEX','Novel_Motor_LINDEX','Novel_Motor_RMID','Novel_Motor_LMID',...
%     'Prac_Logic_JUSTONE','Prac_Logic_SAME','Prac_Logic_SECOND','Prac_Logic_NOTSECOND',...
%     'Prac_Semantic_GREEN','Prac_Semantic_LOUD','Prac_Semantic_SOFT','Prac_Semantic_SWEET',...
%     'Prac_Motor_RINDEX','Prac_Motor_LINDEX','Prac_Motor_RMID','Prac_Motor_LMID'},...
%     {'Novel_\w*JUSTONE\w*','Novel\w*SAME\w*','Novel\w*_SECOND\w*','Novel\w*NOTSECOND\w*',...
%     'Novel\w*GREEN\w*','Novel\w*LOUD\w*','Novel\w*SOFT\w*','Novel\w*SWEET\w*',...
%     'Novel\w*RINDEX\w*','Novel\w*LINDEX\w*','Novel\w*RMID\w*','Novel\w*LMID\w*',...
%     'Repeated_\w*JUSTONE\w*','Repeated\w*SAME\w*','Repeated\w*_SECOND\w*','Repeated\w*NOTSECOND\w*',...
%     'Repeated\w*GREEN\w*','Repeated\w*LOUD\w*','Repeated\w*SOFT\w*','Repeated\w*SWEET\w*',...
%     'Repeated\w*RINDEX\w*','Repeated\w*LINDEX\w*','Repeated\w*RMID\w*','Repeated\w*LMID\w*'},...
%     1, 1, 'RITLEventTaskFactorPracSep');
%RITL MEGfMRI study - MotorEventsOnly:
% [dmat dmatLabels] = ReffuncToAFNI(reffunc_allsubjs_RITLMEGfMRI_EventsOnly,{'701','703','704','705','706','707','708','709','710','711'},...
%     5, [1:5], 218, 2, {'MotorEvents'},...
%     {'\w*Probe\w*'},...
%     1, 1, 'MotorEventsOnly');
%RITL MEGfMRI study - TrialTaskFactor:
% [dmat dmatLabels] = ReffuncToAFNI(reffunc_allsubjs_RITLMEGfMRI_EventsOnly,{'701','703','704','705','706','707','708','709','710','711'},...
%     5, [1:5], 218, 2, {'Logic_JUSTONE','Logic_SAME','Logic_SECOND','Logic_NOTSECOND',...
%     'Semantic_GREEN','Semantic_LOUD','Semantic_SOFT','Semantic_SWEET',...
%     'Motor_RINDEX','Motor_LINDEX','Motor_RMID','Motor_LMID'},...
%     {'\w*JUSTONE\w*','\w*SAME\w*','\w*_SECOND\w*','\w*NOTSECOND\w*',...
%     '\w*GREEN\w*','\w*LOUD\w*','\w*SOFT\w*','\w*SWEET\w*',...
%     '\w*RINDEX\w*','\w*LINDEX\w*','\w*RMID\w*','\w*LMID\w*'},...
%     1, 1, 'RITLTrialTaskFactor');
%RITL MEGfMRI study - RITLBlockedTaskFactorPracSep
% [dmat dmatLabels] = ReffuncToAFNI(reffunc_allsubjs_RITLMEGfMRI,{'701','703','704','705','706','707','708','709','710','711'},...
%     5, [1:5], 218, 2, {'Novel_Logic_JUSTONE','Novel_Logic_SAME','Novel_Logic_SECOND','Novel_Logic_NOTSECOND',...
%     'Novel_Semantic_GREEN','Novel_Semantic_LOUD','Novel_Semantic_SOFT','Novel_Semantic_SWEET',...
%     'Novel_Motor_RINDEX','Novel_Motor_LINDEX','Novel_Motor_RMID','Novel_Motor_LMID',...
%     'Prac_Logic_JUSTONE','Prac_Logic_SAME','Prac_Logic_SECOND','Prac_Logic_NOTSECOND',...
%     'Prac_Semantic_GREEN','Prac_Semantic_LOUD','Prac_Semantic_SOFT','Prac_Semantic_SWEET',...
%     'Prac_Motor_RINDEX','Prac_Motor_LINDEX','Prac_Motor_RMID','Prac_Motor_LMID'},...
%     {'Novel_\w*JUSTONE\w*','Novel\w*SAME\w*','Novel\w*_SECOND\w*','Novel\w*NOTSECOND\w*',...
%     'Novel\w*GREEN\w*','Novel\w*LOUD\w*','Novel\w*SOFT\w*','Novel\w*SWEET\w*',...
%     'Novel\w*RINDEX\w*','Novel\w*LINDEX\w*','Novel\w*RMID\w*','Novel\w*LMID\w*',...
%     'Repeated_\w*JUSTONE\w*','Repeated\w*SAME\w*','Repeated\w*_SECOND\w*','Repeated\w*NOTSECOND\w*',...
%     'Repeated\w*GREEN\w*','Repeated\w*LOUD\w*','Repeated\w*SOFT\w*','Repeated\w*SWEET\w*',...
%     'Repeated\w*RINDEX\w*','Repeated\w*LINDEX\w*','Repeated\w*RMID\w*','Repeated\w*LMID\w*'},...
%     1, 1, 'RITLMEGfMRI_BlockedTaskFactorPracSep');
%RITL fMRI study - Blocked64Tasks:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'SAME_SWEET_LMID','SAME_SWEET_LINDEX','SAME_SWEET_RMID','SAME_SWEET_RINDEX','SAME_SOFT_LMID','SAME_SOFT_LINDEX','SAME_SOFT_RMID','SAME_SOFT_RINDEX','SAME_GREEN_LMID','SAME_GREEN_LINDEX','SAME_GREEN_RMID','SAME_GREEN_RINDEX','SAME_LOUD_LMID','SAME_LOUD_LINDEX','SAME_LOUD_RMID','SAME_LOUD_RINDEX','JUSTONE_SWEET_LMID','JUSTONE_SWEET_LINDEX','JUSTONE_SWEET_RMID','JUSTONE_SWEET_RINDEX','JUSTONE_SOFT_LMID','JUSTONE_SOFT_LINDEX','JUSTONE_SOFT_RMID','JUSTONE_SOFT_RINDEX','JUSTONE_GREEN_LMID','JUSTONE_GREEN_LINDEX','JUSTONE_GREEN_RMID','JUSTONE_GREEN_RINDEX','JUSTONE_LOUD_LMID','JUSTONE_LOUD_LINDEX','JUSTONE_LOUD_RMID','JUSTONE_LOUD_RINDEX','SECOND_SWEET_LMID','SECOND_SWEET_LINDEX','SECOND_SWEET_RMID','SECOND_SWEET_RINDEX','SECOND_SOFT_LMID','SECOND_SOFT_LINDEX','SECOND_SOFT_RMID','SECOND_SOFT_RINDEX','SECOND_GREEN_LMID','SECOND_GREEN_LINDEX','SECOND_GREEN_RMID','SECOND_GREEN_RINDEX','SECOND_LOUD_LMID','SECOND_LOUD_LINDEX','SECOND_LOUD_RMID','SECOND_LOUD_RINDEX','NOTSECOND_SWEET_LMID','NOTSECOND_SWEET_LINDEX','NOTSECOND_SWEET_RMID','NOTSECOND_SWEET_RINDEX','NOTSECOND_SOFT_LMID','NOTSECOND_SOFT_LINDEX','NOTSECOND_SOFT_RMID','NOTSECOND_SOFT_RINDEX','NOTSECOND_GREEN_LMID','NOTSECOND_GREEN_LINDEX','NOTSECOND_GREEN_RMID','NOTSECOND_GREEN_RINDEX','NOTSECOND_LOUD_LMID','NOTSECOND_LOUD_LINDEX','NOTSECOND_LOUD_RMID','NOTSECOND_LOUD_RINDEX'},...
%     {'\w*SAME_SWEET_LMID\w*','\w*SAME_SWEET_LINDEX\w*','\w*SAME_SWEET_RMID\w*','\w*SAME_SWEET_RINDEX\w*','\w*SAME_SOFT_LMID\w*','\w*SAME_SOFT_LINDEX\w*','\w*SAME_SOFT_RMID\w*','\w*SAME_SOFT_RINDEX\w*','\w*SAME_GREEN_LMID\w*','\w*SAME_GREEN_LINDEX\w*','\w*SAME_GREEN_RMID\w*','\w*SAME_GREEN_RINDEX\w*','\w*SAME_LOUD_LMID\w*','\w*SAME_LOUD_LINDEX\w*','\w*SAME_LOUD_RMID\w*','\w*SAME_LOUD_RINDEX\w*','\w*JUSTONE_SWEET_LMID\w*','\w*JUSTONE_SWEET_LINDEX\w*','\w*JUSTONE_SWEET_RMID\w*','\w*JUSTONE_SWEET_RINDEX\w*','\w*JUSTONE_SOFT_LMID\w*','\w*JUSTONE_SOFT_LINDEX\w*','\w*JUSTONE_SOFT_RMID\w*','\w*JUSTONE_SOFT_RINDEX\w*','\w*JUSTONE_GREEN_LMID\w*','\w*JUSTONE_GREEN_LINDEX\w*','\w*JUSTONE_GREEN_RMID\w*','\w*JUSTONE_GREEN_RINDEX\w*','\w*JUSTONE_LOUD_LMID\w*','\w*JUSTONE_LOUD_LINDEX\w*','\w*JUSTONE_LOUD_RMID\w*','\w*JUSTONE_LOUD_RINDEX\w*','\w*SECOND_SWEET_LMID\w*','\w*SECOND_SWEET_LINDEX\w*','\w*SECOND_SWEET_RMID\w*','\w*SECOND_SWEET_RINDEX\w*','\w*SECOND_SOFT_LMID\w*','\w*SECOND_SOFT_LINDEX\w*','\w*SECOND_SOFT_RMID\w*','\w*SECOND_SOFT_RINDEX\w*','\w*SECOND_GREEN_LMID\w*','\w*SECOND_GREEN_LINDEX\w*','\w*SECOND_GREEN_RMID\w*','\w*SECOND_GREEN_RINDEX\w*','\w*SECOND_LOUD_LMID\w*','\w*SECOND_LOUD_LINDEX\w*','\w*SECOND_LOUD_RMID\w*','\w*SECOND_LOUD_RINDEX\w*','\w*NOTSECOND_SWEET_LMID\w*','\w*NOTSECOND_SWEET_LINDEX\w*','\w*NOTSECOND_SWEET_RMID\w*','\w*NOTSECOND_SWEET_RINDEX\w*','\w*NOTSECOND_SOFT_LMID\w*','\w*NOTSECOND_SOFT_LINDEX\w*','\w*NOTSECOND_SOFT_RMID\w*','\w*NOTSECOND_SOFT_RINDEX\w*','\w*NOTSECOND_GREEN_LMID\w*','\w*NOTSECOND_GREEN_LINDEX\w*','\w*NOTSECOND_GREEN_RMID\w*','\w*NOTSECOND_GREEN_RINDEX\w*','\w*NOTSECOND_LOUD_LMID\w*','\w*NOTSECOND_LOUD_LINDEX\w*','\w*NOTSECOND_LOUD_RMID\w*','\w*NOTSECOND_LOUD_RINDEX\w*'},...
%     1, 1, 'Blocked64Tasks');
% RITL fMRI study - Event64Tasks:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic_EventsOnly,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'SAME_SWEET_LMID','SAME_SWEET_LINDEX','SAME_SWEET_RMID','SAME_SWEET_RINDEX','SAME_SOFT_LMID','SAME_SOFT_LINDEX','SAME_SOFT_RMID','SAME_SOFT_RINDEX','SAME_GREEN_LMID','SAME_GREEN_LINDEX','SAME_GREEN_RMID','SAME_GREEN_RINDEX','SAME_LOUD_LMID','SAME_LOUD_LINDEX','SAME_LOUD_RMID','SAME_LOUD_RINDEX','JUSTONE_SWEET_LMID','JUSTONE_SWEET_LINDEX','JUSTONE_SWEET_RMID','JUSTONE_SWEET_RINDEX','JUSTONE_SOFT_LMID','JUSTONE_SOFT_LINDEX','JUSTONE_SOFT_RMID','JUSTONE_SOFT_RINDEX','JUSTONE_GREEN_LMID','JUSTONE_GREEN_LINDEX','JUSTONE_GREEN_RMID','JUSTONE_GREEN_RINDEX','JUSTONE_LOUD_LMID','JUSTONE_LOUD_LINDEX','JUSTONE_LOUD_RMID','JUSTONE_LOUD_RINDEX','SECOND_SWEET_LMID','SECOND_SWEET_LINDEX','SECOND_SWEET_RMID','SECOND_SWEET_RINDEX','SECOND_SOFT_LMID','SECOND_SOFT_LINDEX','SECOND_SOFT_RMID','SECOND_SOFT_RINDEX','SECOND_GREEN_LMID','SECOND_GREEN_LINDEX','SECOND_GREEN_RMID','SECOND_GREEN_RINDEX','SECOND_LOUD_LMID','SECOND_LOUD_LINDEX','SECOND_LOUD_RMID','SECOND_LOUD_RINDEX','NOTSECOND_SWEET_LMID','NOTSECOND_SWEET_LINDEX','NOTSECOND_SWEET_RMID','NOTSECOND_SWEET_RINDEX','NOTSECOND_SOFT_LMID','NOTSECOND_SOFT_LINDEX','NOTSECOND_SOFT_RMID','NOTSECOND_SOFT_RINDEX','NOTSECOND_GREEN_LMID','NOTSECOND_GREEN_LINDEX','NOTSECOND_GREEN_RMID','NOTSECOND_GREEN_RINDEX','NOTSECOND_LOUD_LMID','NOTSECOND_LOUD_LINDEX','NOTSECOND_LOUD_RMID','NOTSECOND_LOUD_RINDEX'},...
%     {'\w*_SAME_SWEET_LMID','\w*_SAME_SWEET_LINDEX','\w*_SAME_SWEET_RMID','\w*_SAME_SWEET_RINDEX','\w*_SAME_SOFT_LMID','\w*_SAME_SOFT_LINDEX','\w*_SAME_SOFT_RMID','\w*_SAME_SOFT_RINDEX','\w*_SAME_GREEN_LMID','\w*_SAME_GREEN_LINDEX','\w*_SAME_GREEN_RMID','\w*_SAME_GREEN_RINDEX','\w*_SAME_LOUD_LMID','\w*_SAME_LOUD_LINDEX','\w*_SAME_LOUD_RMID','\w*_SAME_LOUD_RINDEX','\w*_JUSTONE_SWEET_LMID','\w*_JUSTONE_SWEET_LINDEX','\w*_JUSTONE_SWEET_RMID','\w*_JUSTONE_SWEET_RINDEX','\w*_JUSTONE_SOFT_LMID','\w*_JUSTONE_SOFT_LINDEX','\w*_JUSTONE_SOFT_RMID','\w*_JUSTONE_SOFT_RINDEX','\w*_JUSTONE_GREEN_LMID','\w*_JUSTONE_GREEN_LINDEX','\w*_JUSTONE_GREEN_RMID','\w*_JUSTONE_GREEN_RINDEX','\w*_JUSTONE_LOUD_LMID','\w*_JUSTONE_LOUD_LINDEX','\w*_JUSTONE_LOUD_RMID','\w*_JUSTONE_LOUD_RINDEX','\w*_SECOND_SWEET_LMID','\w*_SECOND_SWEET_LINDEX','\w*_SECOND_SWEET_RMID','\w*_SECOND_SWEET_RINDEX','\w*_SECOND_SOFT_LMID','\w*_SECOND_SOFT_LINDEX','\w*_SECOND_SOFT_RMID','\w*_SECOND_SOFT_RINDEX','\w*_SECOND_GREEN_LMID','\w*_SECOND_GREEN_LINDEX','\w*_SECOND_GREEN_RMID','\w*_SECOND_GREEN_RINDEX','\w*_SECOND_LOUD_LMID','\w*_SECOND_LOUD_LINDEX','\w*_SECOND_LOUD_RMID','\w*_SECOND_LOUD_RINDEX','\w*_NOTSECOND_SWEET_LMID','\w*_NOTSECOND_SWEET_LINDEX','\w*_NOTSECOND_SWEET_RMID','\w*_NOTSECOND_SWEET_RINDEX','\w*_NOTSECOND_SOFT_LMID','\w*_NOTSECOND_SOFT_LINDEX','\w*_NOTSECOND_SOFT_RMID','\w*_NOTSECOND_SOFT_RINDEX','\w*_NOTSECOND_GREEN_LMID','\w*_NOTSECOND_GREEN_LINDEX','\w*_NOTSECOND_GREEN_RMID','\w*_NOTSECOND_GREEN_RINDEX','\w*_NOTSECOND_LOUD_LMID','\w*_NOTSECOND_LOUD_LINDEX','\w*_NOTSECOND_LOUD_RMID','\w*_NOTSECOND_LOUD_RINDEX'},...
%     1, 1, 'Event64Tasks');
%RITL fMRI study - RITLEventTaskFactorPracSep
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic_EventsOnly,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'Novel_Logic_JUSTONE','Novel_Logic_SAME','Novel_Logic_SECOND','Novel_Logic_NOTSECOND',...
%     'Novel_Semantic_GREEN','Novel_Semantic_LOUD','Novel_Semantic_SOFT','Novel_Semantic_SWEET',...
%     'Novel_Motor_RINDEX','Novel_Motor_LINDEX','Novel_Motor_RMID','Novel_Motor_LMID',...
%     'Prac_Logic_JUSTONE','Prac_Logic_SAME','Prac_Logic_SECOND','Prac_Logic_NOTSECOND',...
%     'Prac_Semantic_GREEN','Prac_Semantic_LOUD','Prac_Semantic_SOFT','Prac_Semantic_SWEET',...
%     'Prac_Motor_RINDEX','Prac_Motor_LINDEX','Prac_Motor_RMID','Prac_Motor_LMID'},...
%     {'Novel_\w*JUSTONE\w*','Novel\w*SAME\w*','Novel\w*_SECOND\w*','Novel\w*NOTSECOND\w*',...
%     'Novel\w*GREEN\w*','Novel\w*LOUD\w*','Novel\w*SOFT\w*','Novel\w*SWEET\w*',...
%     'Novel\w*RINDEX\w*','Novel\w*LINDEX\w*','Novel\w*RMID\w*','Novel\w*LMID\w*',...
%     'Repeated_\w*JUSTONE\w*','Repeated\w*SAME\w*','Repeated\w*_SECOND\w*','Repeated\w*NOTSECOND\w*',...
%     'Repeated\w*GREEN\w*','Repeated\w*LOUD\w*','Repeated\w*SOFT\w*','Repeated\w*SWEET\w*',...
%     'Repeated\w*RINDEX\w*','Repeated\w*LINDEX\w*','Repeated\w*RMID\w*','Repeated\w*LMID\w*'},...
%     1, 1, 'RITLEventTaskFactorPracSep');
%RITL fMRI study - TrialTaskFactor_PracSep_Logic:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'Novel_Logic_JUSTONE','Novel_Logic_SAME','Novel_Logic_SECOND','Novel_Logic_NOTSECOND',...
%     'Prac_Logic_JUSTONE','Prac_Logic_SAME','Prac_Logic_SECOND','Prac_Logic_NOTSECOND'},...
%     {'Novel_\w*JUSTONE\w*','Novel_\w*SAME\w*','Novel_\w*_SECOND\w*','Novel_\w*NOTSECOND\w*',...
%      'Repeated_\w*JUSTONE\w*','Repeated_\w*SAME\w*','Repeated_\w*_SECOND\w*','Repeated_\w*NOTSECOND\w*'},...
%     1, 1, 'RITLTrialTaskFactor_PracSep_Logic');
%RITL fMRI study - RITLBlockedTaskFactorPracSep
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'Novel_Logic_JUSTONE','Novel_Logic_SAME','Novel_Logic_SECOND','Novel_Logic_NOTSECOND',...
%     'Novel_Semantic_GREEN','Novel_Semantic_LOUD','Novel_Semantic_SOFT','Novel_Semantic_SWEET',...
%     'Novel_Motor_RINDEX','Novel_Motor_LINDEX','Novel_Motor_RMID','Novel_Motor_LMID',...
%     'Prac_Logic_JUSTONE','Prac_Logic_SAME','Prac_Logic_SECOND','Prac_Logic_NOTSECOND',...
%     'Prac_Semantic_GREEN','Prac_Semantic_LOUD','Prac_Semantic_SOFT','Prac_Semantic_SWEET',...
%     'Prac_Motor_RINDEX','Prac_Motor_LINDEX','Prac_Motor_RMID','Prac_Motor_LMID'},...
%     {'Novel_\w*JUSTONE\w*','Novel\w*SAME\w*','Novel\w*_SECOND\w*','Novel\w*NOTSECOND\w*',...
%     'Novel\w*GREEN\w*','Novel\w*LOUD\w*','Novel\w*SOFT\w*','Novel\w*SWEET\w*',...
%     'Novel\w*RINDEX\w*','Novel\w*LINDEX\w*','Novel\w*RMID\w*','Novel\w*LMID\w*',...
%     'Repeated_\w*JUSTONE\w*','Repeated\w*SAME\w*','Repeated\w*_SECOND\w*','Repeated\w*NOTSECOND\w*',...
%     'Repeated\w*GREEN\w*','Repeated\w*LOUD\w*','Repeated\w*SOFT\w*','Repeated\w*SWEET\w*',...
%     'Repeated\w*RINDEX\w*','Repeated\w*LINDEX\w*','Repeated\w*RMID\w*','Repeated\w*LMID\w*'},...
%     1, 1, 'RITLBlockedTaskFactorPracSep');
%RITL fMRI study - TrialTaskFactor:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic_EventsOnly,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'Logic_JUSTONE','Logic_SAME','Logic_SECOND','Logic_NOTSECOND',...
%     'Semantic_GREEN','Semantic_LOUD','Semantic_SOFT','Semantic_SWEET',...
%     'Motor_RINDEX','Motor_LINDEX','Motor_RMID','Motor_LMID'},...
%     {'\w*JUSTONE\w*','\w*SAME\w*','\w*_SECOND\w*','\w*NOTSECOND\w*',...
%     '\w*GREEN\w*','\w*LOUD\w*','\w*SOFT\w*','\w*SWEET\w*',...
%     '\w*RINDEX\w*','\w*LINDEX\w*','\w*RMID\w*','\w*LMID\w*'},...
%     1, 1, 'RITLTrialTaskFactor');
%RITL fMRI study - TrialTaskFactorLongEnc:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic_EventsOnly_LongEnc,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'Logic_JUSTONE','Logic_SAME','Logic_SECOND','Logic_NOTSECOND',...
%     'Semantic_GREEN','Semantic_LOUD','Semantic_SOFT','Semantic_SWEET',...
%     'Motor_RINDEX','Motor_LINDEX','Motor_RMID','Motor_LMID'},...
%     {'\w*JUSTONE\w*','\w*SAME\w*','\w*_SECOND\w*','\w*NOTSECOND\w*',...
%     '\w*GREEN\w*','\w*LOUD\w*','\w*SOFT\w*','\w*SWEET\w*',...
%     '\w*RINDEX\w*','\w*LINDEX\w*','\w*RMID\w*','\w*LMID\w*'},...
%     1, 1, 'RITLTrialTaskFactorLongEnc');
%
%RITL fMRI study - ProbeOnlyTrialTaskFactor:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic_EventsOnly,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'Logic_JUSTONE','Logic_SAME','Logic_SECOND','Logic_NOTSECOND',...
%     'Semantic_GREEN','Semantic_LOUD','Semantic_SOFT','Semantic_SWEET',...
%     'Motor_RINDEX','Motor_LINDEX','Motor_RMID','Motor_LMID'},...
%     {'\w*Probe\w*JUSTONE\w*','\w*Probe\w*SAME\w*','\w*Probe\w*_SECOND\w*','\w*Probe\w*NOTSECOND\w*',...
%     '\w*Probe\w*GREEN\w*','\w*Probe\w*LOUD\w*','\w*Probe\w*SOFT\w*','\w*Probe\w*SWEET\w*',...
%     '\w*Probe\w*RINDEX\w*','\w*Probe\w*LINDEX\w*','\w*Probe\w*RMID\w*','\w*Probe\w*LMID\w*'},...
%     1, 1, 'ProbeOnlyTrialTaskFactor');
%
%RITL fMRI study - MotorEventsOnly:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic_EventsOnly,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, [1:10], 216, 2, {'MotorEvents'},...
%     {'\w*Probe\w*'},...
%     1, 1, 'MotorEventsOnly');
%
%RITL fMRI study - EventProbeSepSplitOddRuns:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, [1 3 5 7 9], 216, 2, {'NovelEnc','NovelProbe1','NovelProbe2','NovelProbe3','PracEnc','PracProbe1','PracProbe2','PracProbe3','ProbeWrong'},{'Novel_Encoding','Novel_Probe1_Correct','Novel_Probe2_Correct','Novel_Probe3_Correct','Repeated_Encoding','Repeated_Probe1_Correct','Repeated_Probe2_Correct','Repeated_Probe3_Correct','Probe\w*Wrong\w*'}, 1, 1, 'RITLEventProbeSepSplitOddRuns');
%
%RITL fMRI study - EventProbeSepSplitEvenRuns:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, [2 4 6 8 10], 216, 2, {'NovelEnc','NovelProbe1','NovelProbe2','NovelProbe3','PracEnc','PracProbe1','PracProbe2','PracProbe3','ProbeWrong'},{'Novel_Encoding','Novel_Probe1_Correct','Novel_Probe2_Correct','Novel_Probe3_Correct','Repeated_Encoding','Repeated_Probe1_Correct','Repeated_Probe2_Correct','Repeated_Probe3_Correct','Probe\w*Wrong\w*'}, 1, 1, 'RITLEventProbeSepSplitEvenRuns');
%
%RITL fMRI study - EventProbeSepSplitByComplexity:
%Altering reffunc:
% refFuncVector_RITL_SimpleComplex=refFuncVector_RITL_MixedBasic;
% refFuncVector_RITL_SimpleComplex=regexprep(refFuncVector_RITL_SimpleComplex,'NOTSECOND','SIMPLE');
% refFuncVector_RITL_SimpleComplex=regexprep(refFuncVector_RITL_SimpleComplex,'SECOND','SIMPLE');
% refFuncVector_RITL_SimpleComplex=regexprep(refFuncVector_RITL_SimpleComplex,'JUSTONE','COMPLEX');
% refFuncVector_RITL_SimpleComplex=regexprep(refFuncVector_RITL_SimpleComplex,'SAME','COMPLEX');
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_SimpleComplex,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, [1:10], 216, 2, {'ComplexNovelEnc','ComplexNovelProbe1','ComplexNovelProbe2','ComplexNovelProbe3','ComplexPracEnc','ComplexPracProbe1','ComplexPracProbe2','ComplexPracProbe3','SimpleNovelEnc','SimpleNovelProbe1','SimpleNovelProbe2','SimpleNovelProbe3','SimplePracEnc','SimplePracProbe1','SimplePracProbe2','SimplePracProbe3','ProbeWrong'},{'Novel_Encoding_COMPLEX','Novel_Probe1_Correct_COMPLEX','Novel_Probe2_Correct_COMPLEX','Novel_Probe3_Correct_COMPLEX','Repeated_Encoding_COMPLEX','Repeated_Probe1_Correct_COMPLEX','Repeated_Probe2_Correct_COMPLEX','Repeated_Probe3_Correct_COMPLEX','Novel_Encoding_SIMPLE','Novel_Probe1_Correct_SIMPLE','Novel_Probe2_Correct_SIMPLE','Novel_Probe3_Correct_SIMPLE','Repeated_Encoding_SIMPLE','Repeated_Probe1_Correct_SIMPLE','Repeated_Probe2_Correct_SIMPLE','Repeated_Probe3_Correct_SIMPLE','Probe\w*Wrong\w*'}, 1, 1, 'RITLEventProbeSepSplitByComplexity');


%**DCTSTudy
%[dmat dmatLabels] = ReffuncToAFNI(AllSubjTrialAnalRefFunc5,{'101','102','103','104','105','106','107','108','109','110','112','113','114','115'}, [12 12 12 12 12 12 12 12 12 12 12 12 12 12], 362, {'Encoding', 'Switch', 'Stay', 'Symbol', 'Set25_Probe_Easy', 'Set25_Probe_Hard', 'Set25_Probe_Match', 'Set75_Probe_Easy', 'Set75_Probe_Hard', 'Set75_Probe_Match', 'RespMap', 'Response'}, [14 14 14 14 14 14 14 14 14 14 14 14], {'Sustained', 'Incorrect'},{{'Encoding', 'DelayF'}, {'Incorrect','Inc_DelayF'}}, 1, [], 1, 'MixedTrial4');
%[dmat dmatLabels] = ReffuncToAFNI(AllSubjRefFunc7,{'101','102','103','104','105','106','107','108','109','110','112','113','114','115'}, [12 12 12 12 12 12 12 12 12 12 12 12 12 12], 362, {'Encoding', 'Switch', 'Stay', 'Symbol', 'Set25_Probe_Easy', 'Set25_Probe_Hard', 'Set25_Probe_Match', 'Set75_Probe_Easy', 'Set75_Probe_Hard', 'Set75_Probe_Match', 'RespMap', 'Response', 'Inc_Set25orHrd_Probe'}, [14 14 14 14 14 14 14 14 14 14 14 14 14], {'Sustained', 'Incorrect'},{{'Encoding', 'DelayF'}, {'Encoding_Inc','Inc_DelayF'}}, 1, [], 1, 'Mixed4_Inc');



%
% Old:
%RITL fMRI study - BlockedBasic:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2, {'NovelBlock','PracBlock'},{'Novel','Repeated'}, 1, 1, 'RITLBlockedBasic');
%
%RITL fMRI study - PracSplit:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic_PracSplit,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2,{'NovelBlock','EarlyPracBlock','LatePracBlock'},{'Novel','Early_Repeated','Late_Repeated'}, 1, 1, 'RITLBlockedPracSplit');
%
%RITL fMRI study - EventBasic:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2, {'NovelEnc','NovelProbe','PracEnc','PracProbe'},{'Novel_Encoding','Novel_Probe','Repeated_Encoding','Repeated_Probe'}, 1, 1, 'RITLEventBasic');
%
%RITL fMRI study - MixedBasic:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2, {'NovelEnc','NovelProbe','PracEnc','PracProbe','ProbeWrong','NovelSust','PracSust'},{'Novel_Encoding','Novel_Probe_Correct','Repeated_Encoding','Repeated_Probe_Correct','Probe_Wrong','Novel','Repeated'}, 1, 1, 'RITLMixedBasic');
%
%RITL_MEG fMRI study - MixedBasic:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncDataStruct_MEGRITLfMRI_MixedBasic_Concat,{'701','703','704','705','706','707','708','709','710','711'}, 5, 218, 2, {'NovelEnc','NovelProbe','PracEnc','PracProbe','ProbeWrong','NovelSust','PracSust'},{'Novel_Encoding','Novel_Probe[123]_Correct','Repeated_Encoding','Repeated_Probe[123]_Correct','Probe[123]_Wrong','Novel','Repeated'}, 1, 1, 'RITLMixedBasic');
%
%RITL fMRI study - MixedProbeSep:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2, {'NovelEnc','NovelProbe1','NovelProbe2','NovelProbe3','PracEnc','PracProbe1','PracProbe2','PracProbe3','ProbeWrong','NovelSust','PracSust'},{'Novel_Encoding','Novel_Probe1_Correct','Novel_Probe2_Correct','Novel_Probe3_Correct','Repeated_Encoding','Repeated_Probe1_Correct','Repeated_Probe2_Correct','Repeated_Probe3_Correct','Probe\w*Wrong\w*','Novel','Repeated'}, 1, 1, 'RITLMixedProbeSep');
%
%
%RITL fMRI study - BlockedTaskFactor
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, 216, 2, {'Novel_Logic_JUSTONE','Novel_Logic_SAME','Novel_Logic_SECOND','Novel_Logic_NOTSECOND',...
%     'Novel_Semantic_GREEN','Novel_Semantic_LOUD','Novel_Semantic_SOFT','Novel_Semantic_SWEET',...
%     'Novel_Motor_RINDEX','Novel_Motor_LINDEX','Novel_Motor_RMID','Novel_Motor_LMID',...
%     'Prac_Logic_JUSTONE','Prac_Logic_SAME','Prac_Logic_SECOND','Prac_Logic_NOTSECOND',...
%     'Prac_Semantic_GREEN','Prac_Semantic_LOUD','Prac_Semantic_SOFT','Prac_Semantic_SWEET',...
%     'Prac_Motor_RINDEX','Prac_Motor_LINDEX','Prac_Motor_RMID','Prac_Motor_LMID'},...
%     {'Novel_\w*JUSTONE\w*','Novel\w*SAME\w*','Novel\w*_SECOND\w*','Novel\w*NOTSECOND\w*',...
%     'Novel\w*GREEN\w*','Novel\w*LOUD\w*','Novel\w*SOFT\w*','Novel\w*SWEET\w*',...
%     'Novel\w*RINDEX\w*','Novel\w*LINDEX\w*','Novel\w*RMID\w*','Novel\w*LMID\w*',...
%     'Repeated_\w*JUSTONE\w*','Repeated\w*SAME\w*','Repeated\w*_SECOND\w*','Repeated\w*NOTSECOND\w*',...
%     'Repeated\w*GREEN\w*','Repeated\w*LOUD\w*','Repeated\w*SOFT\w*','Repeated\w*SWEET\w*',...
%     'Repeated\w*RINDEX\w*','Repeated\w*LINDEX\w*','Repeated\w*RMID\w*','Repeated\w*LMID\w*'},...
%     1, 1, 'RITLBlockedTaskFactor');

%
%RITL fMRI study - MixedTaskFactor:
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2,...
%     {'NovelEncJUSTONE','NovelProbeJUSTONE','PracEncJUSTONE','PracProbeJUSTONE','NovelSustJUSTONE','PracSustJUSTONE',...
%     'NovelEncSAME','NovelProbeSAME','PracEncSAME','PracProbeSAME','NovelSustSAME','PracSustSAME',...
%     'NovelEncSECOND','NovelProbeSECOND','PracEncSECOND','PracProbeSECOND','NovelSustSECOND','PracSustSECOND',...
%     'NovelEncNOTSECOND','NovelProbeNOTSECOND','PracEncNOTSECOND','PracProbeNOTSECOND','NovelSustNOTSECOND','PracSustNOTSECOND',...
%     'ProbeWrong'},{'Novel_Encoding\w*JUSTONE\w*','Novel_Probe_Correct\w*JUSTONE\w*','Repeated_Encoding\w*JUSTONE\w*','Repeated_Probe_Correct\w*JUSTONE\w*','Novel\w*JUSTONE\w*','Repeated\w*JUSTONE\w*',...
%     'Novel_Encoding\w*SAME\w*','Novel_Probe_Correct\w*SAME\w*','Repeated_Encoding\w*SAME\w*','Repeated_Probe_Correct\w*SAME\w*','Novel\w*SAME\w*','Repeated\w*SAME\w*',...
%     'Novel_Encoding\w*_SECOND\w*','Novel_Probe_Correct\w*_SECOND\w*','Repeated_Encoding\w*_SECOND\w*','Repeated_Probe_Correct\w*_SECOND\w*','Novel\w*_SECOND\w*','Repeated\w*_SECOND\w*',...
%     'Novel_Encoding\w*NOTSECOND\w*','Novel_Probe_Correct\w*NOTSECOND\w*','Repeated_Encoding\w*NOTSECOND\w*','Repeated_Probe_Correct\w*NOTSECOND\w*','Novel\w*NOTSECOND\w*','Repeated\w*NOTSECOND\w*',...
%     'Probe_Wrong'}, 1, 1, 'RITLTaskFactorLogic');
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_MixedBasic,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216,2,...
%     {'NovelEncGREEN','NovelProbeGREEN','PracEncGREEN','PracProbeGREEN','NovelSustGREEN','PracSustGREEN',...
%     'NovelEncLOUD','NovelProbeLOUD','PracEncLOUD','PracProbeLOUD','NovelSustLOUD','PracSustLOUD',...
%     'NovelEncSOFT','NovelProbeSOFT','PracEncSOFT','PracProbeSOFT','NovelSustSOFT','PracSustSOFT',...
%     'NovelEncSWEET','NovelProbeSWEET','PracEncSWEET','PracProbeSWEET','NovelSustSWEET','PracSustSWEET',...
%     'ProbeWrong'},{'Novel_Encoding\w*GREEN\w*','Novel_Probe_Correct\w*GREEN\w*','Repeated_Encoding\w*GREEN\w*','Repeated_Probe_Correct\w*GREEN\w*','Novel\w*GREEN\w*','Repeated\w*GREEN\w*',...
%     'Novel_Encoding\w*LOUD\w*','Novel_Probe_Correct\w*LOUD\w*','Repeated_Encoding\w*LOUD\w*','Repeated_Probe_Correct\w*LOUD\w*','Novel\w*LOUD\w*','Repeated\w*LOUD\w*',...
%     'Novel_Encoding\w*SOFT\w*','Novel_Probe_Correct\w*SOFT\w*','Repeated_Encoding\w*SOFT\w*','Repeated_Probe_Correct\w*SOFT\w*','Novel\w*SOFT\w*','Repeated\w*SOFT\w*',...
%     'Novel_Encoding\w*SWEET\w*','Novel_Probe_Correct\w*SWEET\w*','Repeated_Encoding\w*SWEET\w*','Repeated_Probe_Correct\w*SWEET\w*','Novel\w*SWEET\w*','Repeated\w*SWEET\w*',...
%     'Probe_Wrong'}, 1, 1, 'RITLTaskFactorSemantic');
%
%RITL fMRI study - BlockedByBlock:
% [dmat dmatLabels] = ReffuncToAFNI(blockNumberedReffunc,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2,...
%   {'Block1', 'Block2', 'Block3', 'Block4', 'Block5', 'Block6', 'Block7', 'Block8', 'Block9', 'Block10', 'Block11', 'Block12', 'Block13', 'Block14', 'Block15', 'Block16', 'Block17', 'Block18', 'Block19', 'Block20', 'Block21', 'Block22', 'Block23', 'Block24', 'Block25', 'Block26', 'Block27', 'Block28', 'Block29', 'Block30', 'Block31', 'Block32', 'Block33', 'Block34', 'Block35', 'Block36', 'Block37', 'Block38', 'Block39', 'Block40', 'Block41', 'Block42', 'Block43', 'Block44', 'Block45', 'Block46', 'Block47', 'Block48', 'Block49', 'Block50', 'Block51', 'Block52', 'Block53', 'Block54', 'Block55', 'Block56', 'Block57', 'Block58', 'Block59', 'Block60',...
%   'Block61', 'Block62', 'Block63', 'Block64', 'Block65', 'Block66', 'Block67', 'Block68', 'Block69', 'Block70', 'Block71', 'Block72', 'Block73', 'Block74', 'Block75', 'Block76', 'Block77', 'Block78', 'Block79', 'Block80', 'Block81', 'Block82', 'Block83', 'Block84', 'Block85', 'Block86', 'Block87', 'Block88', 'Block89', 'Block90', 'Block91', 'Block92', 'Block93', 'Block94', 'Block95', 'Block96', 'Block97', 'Block98', 'Block99', 'Block100', 'Block101', 'Block102', 'Block103', 'Block104', 'Block105', 'Block106', 'Block107', 'Block108', 'Block109', 'Block110', 'Block111', 'Block112', 'Block113', 'Block114', 'Block115', 'Block116', 'Block117', 'Block118', 'Block119', 'Block120'},...
%   {'Block1', 'Block2', 'Block3', 'Block4', 'Block5', 'Block6', 'Block7', 'Block8', 'Block9', 'Block10', 'Block11', 'Block12', 'Block13', 'Block14', 'Block15', 'Block16', 'Block17', 'Block18', 'Block19', 'Block20', 'Block21', 'Block22', 'Block23', 'Block24', 'Block25', 'Block26', 'Block27', 'Block28', 'Block29', 'Block30', 'Block31', 'Block32', 'Block33', 'Block34', 'Block35', 'Block36', 'Block37', 'Block38', 'Block39', 'Block40', 'Block41', 'Block42', 'Block43', 'Block44', 'Block45', 'Block46', 'Block47', 'Block48', 'Block49', 'Block50', 'Block51', 'Block52', 'Block53', 'Block54', 'Block55', 'Block56', 'Block57', 'Block58', 'Block59', 'Block60',...
%   'Block61', 'Block62', 'Block63', 'Block64', 'Block65', 'Block66', 'Block67', 'Block68', 'Block69', 'Block70', 'Block71', 'Block72', 'Block73', 'Block74', 'Block75', 'Block76', 'Block77', 'Block78', 'Block79', 'Block80', 'Block81', 'Block82', 'Block83', 'Block84', 'Block85', 'Block86', 'Block87', 'Block88', 'Block89', 'Block90', 'Block91', 'Block92', 'Block93', 'Block94', 'Block95', 'Block96', 'Block97', 'Block98', 'Block99', 'Block100', 'Block101', 'Block102', 'Block103', 'Block104', 'Block105', 'Block106', 'Block107', 'Block108', 'Block109', 'Block110', 'Block111', 'Block112', 'Block113', 'Block114', 'Block115', 'Block116', 'Block117', 'Block118', 'Block119', 'Block120'},...
%   0, 1, 'RITLBlockedByBlock');
%
%RITL fMRI study - LogicBlockedTaskFactor
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_NonSwitchUnmarkedTaskBlockLabelsOnly,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, 216, 2, {'PracTask','Novel_Logic_JUSTONE','Novel_Logic_SAME','Novel_Logic_SECOND','Novel_Logic_NOTSECOND'},...
%     {'Repeated_\w*','Novel_\w*JUSTONE\w*','Novel\w*SAME\w*','Novel\w*_SECOND\w*','Novel\w*NOTSECOND\w*'},...
%     1, 1, 'LogicBlockedTaskFactor');
%
%RITL fMRI study - SensoryBlockedTaskFactor
% [dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_NonSwitchUnmarkedTaskBlockLabelsOnly,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'},...
%     10, 216, 2, {'PracTask', 'Novel_Sensory_GREEN','Novel_Sensory_LOUD','Novel_Sensory_SOFT','Novel_Sensory_SWEET'},...
%     {'Repeated_\w*','Novel\w*GREEN\w*','Novel\w*LOUD\w*','Novel\w*SOFT\w*','Novel\w*SWEET\w*'},...
%     1, 1, 'SensoryBlockedTaskFactor');
%
%%RITL fMRI study - TaskDistEventProbeSep:
%[dmat dmatLabels] = ReffuncToAFNI(refFuncVector_RITL_TaskDistance,{'601','602','603','604','605','606','607','608','609','610','611','612','613','614','615'}, 10, 216, 2, {'NovelDist1Enc','NovelDist1Probe1','NovelDist1Probe2','NovelDist1Probe3','NovelDist2Enc','NovelDist2Probe1','NovelDist2Probe2','NovelDist2Probe3','PracEnc','PracProbe1','PracProbe2','PracProbe3','ProbeWrong'},{'Novel_Encoding_Dist1','Novel_Probe1_Correct_Dist1','Novel_Probe2_Correct_Dist1','Novel_Probe3_Correct_Dist1','Novel_Encoding_Dist2','Novel_Probe1_Correct_Dist2','Novel_Probe2_Correct_Dist2','Novel_Probe3_Correct_Dist2','Repeated_Encoding','Repeated_Probe1_Correct','Repeated_Probe2_Correct','Repeated_Probe3_Correct','Probe\w*Wrong\w*'}, 1, 1, 'RITLTaskDistEventProbeSep');
%

%AssocMem study:
%[dmat dmatLabels] = ReffuncToAFNI(AggregateRefFunc, {'401' '402' '403' '404' '405' '406' '407' '408' '409' '410' '412'},10,[1:10], 528, 1, {'Block_StrongPairEnc', 'Block_WeakPairEnc', 'Block_StrongAudVisRet', 'Block_WeakAudVisRet','Block_StrongVisAudRet', 'Block_WeakVisAudRet', 'Block_StrongAuditoryCont', 'Block_WeakAuditoryCont', 'Block_StrongVisualCont', 'Block_WeakVisualCont'},{'BlockCue_StrongPairEncodingProc_start', 'BlockCue_WeakPairEncodingProc_start', 'BlockCue_StrongAudVisRetrievalProc_start', 'BlockCue_WeakAudVisRetrievalProc_start', 'BlockCue_StrongVisAudRetrievalProc_start', 'BlockCue_WeakVisAudRetrievalProc_start', 'BlockCue_StrongAuditoryContProc_start', 'BlockCue_WeakAuditoryContProc_start', 'BlockCue_StrongVisualContProc_start', 'BlockCue_WeakVisualContProc_start'}, 0, 1, 'AssocMemBlocks');
%AssocMemSepBlocks:
%[dmat dmatLabels] = ReffuncToAFNI(AggregateRefFunc, {'401' '402' '403' '404' '405' '406' '407' '408' '409' '410' '412'},10,[1:10], 528, 1, {'Block1', 'Block2', 'Block3', 'Block4', 'Block5', 'Block6', 'Block7', 'Block8', 'Block9', 'Block10', 'Block11', 'Block12', 'Block13', 'Block14', 'Block15', 'Block16', 'Block17', 'Block18', 'Block19', 'Block20', 'Block21', 'Block22', 'Block23', 'Block24', 'Block25', 'Block26', 'Block27', 'Block28', 'Block29', 'Block30', 'Block31', 'Block32', 'Block33', 'Block34', 'Block35', 'Block36', 'Block37', 'Block38', 'Block39', 'Block40', 'Block41', 'Block42', 'Block43', 'Block44', 'Block45', 'Block46', 'Block47', 'Block48', 'Block49', 'Block50', 'Block51', 'Block52', 'Block53', 'Block54', 'Block55', 'Block56', 'Block57', 'Block58', 'Block59', 'Block60',...
%   'Block61', 'Block62', 'Block63', 'Block64', 'Block65', 'Block66', 'Block67', 'Block68', 'Block69', 'Block70', 'Block71', 'Block72', 'Block73', 'Block74', 'Block75', 'Block76', 'Block77', 'Block78', 'Block79', 'Block80'},{'BlockCue1_\w*_start', 'BlockCue2_\w*_start', 'BlockCue3_\w*_start', 'BlockCue4_\w*_start', 'BlockCue5_\w*_start', 'BlockCue6_\w*_start', 'BlockCue7_\w*_start', 'BlockCue8_\w*_start', 'BlockCue9_\w*_start', 'BlockCue10_\w*_start', 'BlockCue11_\w*_start', 'BlockCue12_\w*_start', 'BlockCue13_\w*_start', 'BlockCue14_\w*_start', 'BlockCue15_\w*_start', 'BlockCue16_\w*_start', 'BlockCue17_\w*_start', 'BlockCue18_\w*_start', 'BlockCue19_\w*_start', 'BlockCue20_\w*_start', 'BlockCue21_\w*_start', 'BlockCue22_\w*_start', 'BlockCue23_\w*_start', 'BlockCue24_\w*_start', 'BlockCue25_\w*_start', 'BlockCue26_\w*_start', 'BlockCue27_\w*_start', 'BlockCue28_\w*_start', 'BlockCue29_\w*_start',...
%   'BlockCue30_\w*_start', 'BlockCue31_\w*_start', 'BlockCue32_\w*_start', 'BlockCue33_\w*_start', 'BlockCue34_\w*_start', 'BlockCue35_\w*_start', 'BlockCue36_\w*_start', 'BlockCue37_\w*_start', 'BlockCue38_\w*_start', 'BlockCue39_\w*_start', 'BlockCue40_\w*_start', 'BlockCue41_\w*_start', 'BlockCue42_\w*_start', 'BlockCue43_\w*_start', 'BlockCue44_\w*_start', 'BlockCue45_\w*_start', 'BlockCue46_\w*_start', 'BlockCue47_\w*_start', 'BlockCue48_\w*_start', 'BlockCue49_\w*_start', 'BlockCue50_\w*_start', 'BlockCue51_\w*_start', 'BlockCue52_\w*_start', 'BlockCue53_\w*_start', 'BlockCue54_\w*_start', 'BlockCue55_\w*_start', 'BlockCue56_\w*_start', 'BlockCue57_\w*_start', 'BlockCue58_\w*_start', 'BlockCue59_\w*_start', 'BlockCue60_\w*_start', 'BlockCue61_\w*_start', 'BlockCue62_\w*_start', 'BlockCue63_\w*_start', 'BlockCue64_\w*_start', 'BlockCue65_\w*_start', 'BlockCue66_\w*_start', 'BlockCue67_\w*_start', 'BlockCue68_\w*_start', 'BlockCue69_\w*_start',...
%   'BlockCue70_\w*_start', 'BlockCue71_\w*_start', 'BlockCue72_\w*_start', 'BlockCue73_\w*_start', 'BlockCue74_\w*_start', 'BlockCue75_\w*_start', 'BlockCue76_\w*_start', 'BlockCue77_\w*_start', 'BlockCue78_\w*_start', 'BlockCue79_\w*_start', 'BlockCue80_\w*_start'}, 1, 1, 'AssocMemSepBlocks');
%AssocMemEvents:
%[dmat dmatLabels] = ReffuncToAFNI(AggregateRefFunc, {'401' '402' '403' '404' '405' '406' '407' '408' '409' '410' '412'},10,[1:10], 528, 1, {'StrongPairEnc', 'WeakPairEnc', 'StrongAudVisRet', 'WeakAudVisRet','StrongVisAudRet', 'WeakVisAudRet', 'StrongAuditoryCont', 'WeakAuditoryCont', 'StrongVisualCont', 'WeakVisualCont', 'WrongTrials'},{'Stimulus_StrongPairEncodingProc', 'Stimulus_WeakPairEncodingProc', 'Stimulus_StrongAudVisRetrievalProc_Correct', 'Stimulus_WeakAudVisRetrievalProc_Correct', 'Stimulus_StrongVisAudRetrievalProc_Correct', 'Stimulus_WeakVisAudRetrievalProc_Correct', 'Stimulus_StrongAuditoryContProc_Correct', 'Stimulus_WeakAuditoryContProc_Correct', 'Stimulus_StrongVisualContProc_Correct', 'Stimulus_WeakVisualContProc_Correct', '\w*_Wrong'}, 1, 1, 'AssocMemEvents');
%AssocMemEvents_CombStrength:
%[dmat dmatLabels] = ReffuncToAFNI(AggregateRefFunc, {'401' '402' '403' '404' '405' '406' '407' '408' '409' '410' '412'},10,[1:10], 528, 1, {'BlockCues', 'PairEnc', 'AudVisRet', 'VisAudRet', 'AuditoryCont', 'VisualCont', 'WrongTrials'},{'BlockCue_\w*_start', 'Stimulus_\w*PairEncodingProc', 'Stimulus_\w*AudVisRetrievalProc\w*', 'Stimulus_\w*VisAudRetrievalProc_\w*', 'Stimulus_\w*AuditoryContProc_\w*', 'Stimulus_\w*VisualContProc_\w*', '\w*_Wrong'}, 1, 1, 'AssocMemEvents_CombStrength');
%AssocMemBlocks_CombStrength
%[dmat dmatLabels] = ReffuncToAFNI(AggregateRefFunc, {'401' '402' '403' '404' '405' '406' '407' '408' '409' '410' '412'},10,[1:10], 528, 1, {'Block_PairEnc', 'Block_AudVisRet', 'Block_VisAudRet', 'Block_AuditoryCont', 'Block_VisualCont'},{'PairEncodingProc_start', 'AudVisRetrievalProc_start' 'VisAudRetrievalProc_start', 'AuditoryContProc_start', 'VisualContProc_start'}, 1, 1, 'AssocMemBlocks_CombStrength');

%OLD:
%AssocMem study:
%OLD [dmat dmatLabels] = MixedDesignToFSL(AssocMemAggRefFunc_409, {'409'}, [10], 528, 2, {},[], {'Block_StrongPairEnc', 'Block_WeakPairEnc', 'Block_StrongAudVisRet', 'Block_WeakAudVisRet','Block_StrongVisAudRet', 'Block_WeakVisAudRet', 'Block_StrongAuditoryCont', 'Block_WeakAuditoryCont', 'Block_StrongVisualCont', 'Block_WeakVisualCont'},{{'BlockCue_StrongPairEncodingProc','BlockEnd'}, {'BlockCue_WeakPairEncodingProc','BlockEnd'}, {'BlockCue_StrongAudVisRetrievalProc','BlockEnd'}, {'BlockCue_WeakAudVisRetrievalProc','BlockEnd'}, {'BlockCue_StrongVisAudRetrievalProc','BlockEnd'}, {'BlockCue_WeakVisAudRetrievalProc','BlockEnd'}, {'BlockCue_StrongAuditoryContProc','BlockEnd'}, {'BlockCue_WeakAuditoryContProc','BlockEnd'}, {'BlockCue_StrongVisualContProc','BlockEnd'}, {'BlockCue_WeakVisualContProc','BlockEnd'}}, 1, [], 0, 1, 'AssocMemBlocks');



% Versions:
% 1.0b - First functioning version
% 1.1b - Adding stimtiming file creation functionality
% 1.2b - Changing NumRuns to RunsToInclude (to allow for odd-even splits)
% 1.3b - Changing RunLengths to RunLengthss (to allow for runs of different lengths)
NumRuns=length(RunsToInclude);

numTRsTotal = length(SubjectArray) * sum(RunLengths);
designMatrix = zeros(numTRsTotal, length(CondSearchStrings));

%Iterating through conditions
for condNum = 1:length(CondSearchStrings)

    disp(['condition ' num2str(condNum)])
    condLabel = CondSearchStrings{condNum};
    trCount = 1;
    dmTRCount = 1;

    %Iterating through subjects
    for subjNum = 1:length(SubjectArray)
        subjName = SubjectArray(subjNum);
        disp(['subject ' num2str(subjNum)])

        %Iterating through runs
        for runNum = 1:NumRunsTotal
            
            %Only include this run if in RunsToInclude, otherwise increment TR count
            if isempty(find(RunsToInclude==runNum, 1))
                trCount = trCount + RunLengths(runNum);
            else

                %Iterating through TRs
                for runTR = 1:RunLengths(runNum)
                    %If condLabel matches Reffunc at this TR, add a 1 to the output, otherwise 0
                    %If RegExpr is true, then include partial string matches (based on regular expressions), otherwise only include exact matches
                    if RegExpr
                        %partial match
                        %match = ~isempty(strfind(RefFunc{trCount}, condLabel));
                        match=~isempty(regexp(RefFunc{trCount},condLabel,'once'));
                        %match=find(cellfun('isempty',regExpList)==0);
                    else
                        %exact match
                        match = ~isempty(strmatch(RefFunc{trCount}, condLabel,'exact'));
                    end

                    %Save match result to design matrix
                    designMatrix(dmTRCount, condNum) = match;

                    trCount = trCount + 1;
                    dmTRCount = dmTRCount + 1;

                end
            end
        end
    end
end

dmat = designMatrix;
designMLabels = CondNames;

if(OutputToFiles)

    %Writing stimulus file; for use with -stim_file option in 3ddeconvolve
    for colNum = 1:length(CondSearchStrings)
        trCount = 1;

        for subjCount = 1:length(SubjectArray)
            disp(['Saving AFNI unconvolved stim files (1D file) for subject ' SubjectArray{subjCount}]);

            writeName = [SubjectArray{subjCount} '_stimfile_' AnalysisName '_EV' num2str(colNum) '_' CondNames{colNum} '.1D'];
            disp(['Writing ' writeName ' (used with -stim_file option in 3dDeconvolve)'])
            fidW = fopen(writeName, 'wt');

            for runCount = 1:NumRuns
                %thisDesignMatrix = designMatrix{subjCount}{runCount};

                %Write vector
                for row = trCount:(trCount+RunLengths(runCount)-1)
                    rowString = [num2str(designMatrix(row, colNum), '%6f')];
                    fprintf(fidW, '%s\n',rowString);
                    trCount = trCount + 1;
                end

            end
            fclose(fidW);
            %Writing timing file (stim timing file); for use with -stim_times option in 3ddeconvolve
            disp(['Writing stime_' writeName ' (used with -stim_times option in 3dDeconvolve)'])
            if length(unique(RunLengths)) == 1
                eval(['!/Applications/afni/make_stim_times.py -files ' writeName ' -prefix stime_' writeName ' -tr ' num2str(TRInSecs) ' -nruns ' num2str(NumRuns) ' -nt ' num2str(RunLengths(1))])
            else
                disp('Warning: Run lengths differ, so stime_ files aren''t created')
            end
        end
    end

%     %Writing timing file (t-file); for use with -stim_times option in 3ddeconvolve
%     for colNum = 1:length(CondSearchStrings)
%         trCount = 1;
% 
%         for subjCount = 1:length(SubjectArray)
%             disp(['Saving AFNI stim timing files (1D file; used with -stim_times option in 3ddeconvolve) for subject ' SubjectArray{subjCount}]);
% 
%             writeName = [SubjectArray{subjCount} '_stimfile_' AnalysisName '_EV' num2str(colNum) '_' CondNames{colNum} '_tfile.1D'];
%             disp(['Writing ' writeName])
%             fidW = fopen(writeName, 'wt');
% 
%             for runCount = 1:NumRuns
%                 %thisDesignMatrix = designMatrix{subjCount}{runCount};
% 
%                 %Write vector
%                 for rowNum = trCount:(trCount+RunLengths-1)
%                     rowString = [num2str(designMatrix(row, colNum), '%6.1f')];
%                     if strcmp(rowString,'1')
%                         rowStringOut = num2str(rowNum);
%                         fprintf(fidW, '%s\n',rowStringOut);
%                     end
%                  writeName   trCount = trCount + 1;
%                 end
% 
%             end
%             fclose(fidW);
%         end
%     end
    
    for subjCount = 1:length(SubjectArray)
        writeName = [SubjectArray{subjCount} '_' AnalysisName '_ConcatRef.1D'];
        disp(['Writing ' writeName])
        fidW = fopen(writeName, 'wt');

        %Writing file for -concat option in 3ddevonvolve (removes trends for individual runs)
        lineCount=0;
        for runNum=1:NumRuns
            fprintf(fidW, '%s\n',num2str(lineCount));
            lineCount = lineCount + RunLengths(runNum);
        end

        fclose(fidW);
    end
end



