#!/bin/sh

docker build -t rumpsteak_tool .

# Building the docker image can take several minutes
docker run -ti --name Artifact rumpsteak_tool:latest ./run.sh

# Running the benchmarks can take several minutes
mkdir results
docker cp Artifact:/home/rumpsteak/comparison/data/ results/
docker cp Artifact:/home/rumpsteak/comparison/target/criterion/ results/


./gen_fig_6.sh results/criterion/double_buffering/ fig_6_db.png
./gen_fig_6.sh results/criterion/fft/ fig_6_fft.png
./gen_fig_6.sh results/criterion/stream/ fig_6_stream.png
./gen_fig_7.sh results/data/stream/results.csv 3 fig_7_stream.png
./gen_fig_7.sh results/data/nested_choice/results.csv 3 fig_7_nested_choice.png
./gen_fig_7.sh results/data/ring/results.csv 2 fig_7_ring.png
./gen_fig_7.sh results/data/double_buffering/results.csv 2 fig_7_db.png
