#!/bin/sh

FILE="$1"

if [ -e "$FILE" -a -n "$FILE" ]; then
	for i in $(seq 0 $(expr "$2" - 1)); do
		tail -n +2 "$FILE" | awk "NR%$2==$i" | cut -d "," -f 5,9 > cmd$i.csv
	done

	if [ "$2" -eq 2 ];
	then
		mv cmd0.csv kmc.csv
		mv cmd1.csv rumpsteak.csv
	else
		mv cmd0.csv sound_binary.csv
		mv cmd1.csv rumpsteak.csv
		mv cmd2.csv kmc.csv
	fi

	CMD="set terminal pngcairo\nset output '$3'\nset logscale y 10;\nset ylabel \"Running time (log s)\"\nset xlabel \"n\"\nplot $(for i in *.csv; do
		echo "'$i' with lines, \\"
	done)"
	echo "$CMD" > plot.gnuplot

	gnuplot -p plot.gnuplot
	rm *.csv
else
	echo "failed"
fi
