#!/bin/sh

# $1 path to result folder of a binary
bin_results() {
	for j in $1/*; do
		i="$(basename $j)"
		if [ "$i" != "report" ];
		then
			echo "$i, $( echo "6 k 1000 $i * $(jq '.mean.point_estimate' "$1/$i/new/estimates.json") / p" | dc  )" 
		fi
	done
}


for full_bin in $1/*; do
	bin="$(basename "$full_bin")"
	case $bin in
		"ferrite" | "mpstthree" | "rumpsteak" | "rumpsteak_optimized" | "sesh" | "rustfft")
			echo "$bin"
			bin_results "$full_bin" | sort -n > "$bin".dat
	esac
done



CMD="set terminal pngcairo\nset output '$2'\nset ylabel \"throuput (n/µs)\"\nset xlabel \"n\"\nplot $(for i in *.dat; do
echo "'$i' with lines, \\"
done)"
echo "$CMD" > plot.gnuplot
gnuplot -p plot.gnuplot
rm *.dat plot.gnuplot
