#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Python version: 3.6

import argparse


def args_parser():
    parser = argparse.ArgumentParser()
    # federated arguments
    parser.add_argument('--epochs', type=int, default=10,
                        help="rounds of training")
    # TODO: isn't num_users a duplicate of num_paivs? marked for removal [chiara]
    # parser.add_argument('--num_users', type=int,
    #                    default=100, help="number of PAIVs: K")
    parser.add_argument('--frac', type=float, default=0.1,
                        help="the fraction of clients: C")
    parser.add_argument('--local-ep', type=int, default=5,
                        help="the number of local epochs: E")
    parser.add_argument('--local-bs', type=int, default=10,
                        help="local batch size: B")
    parser.add_argument('--bs', type=int, default=32, help="test batch size")
    parser.add_argument('--lr', type=float, default=0.01, help="learning rate")
    parser.add_argument('--momentum', type=float, default=0.5,
                        help="SGD momentum (default: 0.5)")
    parser.add_argument('--split', type=str, default='user',
                        help="train-test split type, user or sample")
    parser.add_argument('--val-split', type=float, default=0.1,
                        help="train-validation split percentage")

    # TODO: remove the arg below [chiara]
    # parser.add_argument('--num_paivs', type=int,
    #                    default=100, help="number of PAIVs: K")
    # model arguments
    parser.add_argument('--model', type=str, default='mlp', help='model name')
    parser.add_argument('--kernel-num', type=int, default=9,
                        help='number of each kind of kernel')
    parser.add_argument('--kernel-sizes', type=str, default='3,4,5',
                        help='comma-separated kernel size to use for convolution')
    parser.add_argument('--norm', type=str, default='batch-norm',
                        help="batch-norm, layer-norm, or None")
    parser.add_argument('--num-filters', type=int, default=32,
                        help="number of filters for conv nets")
    parser.add_argument('--max-pool', type=str, default='True',
                        help="Whether use max pooling rather than strided convolutions")

    # social graph arguments
    parser.add_argument("--graph-from", metavar="graph_from", dest="graph_from", default="synth", type=str,
                        help="method for graph creation (one of: file, preset, synth)")
    parser.add_argument("--graph-file", metavar="edgelist_filename", dest="edgelist_filename", default="", type=str,
                        help="Name of the file containing the edge list")
    parser.add_argument("--graph-synth-type", metavar="graph_synth_type", dest="graph_synth_type", default="barabasi_albert_graph", type=str,
                        help="Type of synthetic graph to be generated")
    parser.add_argument("--graph-synth-args", metavar="graph_synth_args", dest="graph_synth_args", default="10,3,7", type=str,
                        help="String of comma-separated values to pass to nx, in the order specified in the docs")
    parser.add_argument("--graph-preset", metavar="graph_preset", dest="graph_preset", default="karate_club_graph", type=str,
                        help="Load graph from preset datasets in networkX")

    # other arguments
    parser.add_argument('--dataset', type=str,
                        default='mnist', help="name of dataset")
    parser.add_argument('--noniid', action='store_true',
                        help='whether i.i.d or not')
    parser.add_argument('--num-classes', type=int,
                        default=10, help="number of classes")
    parser.add_argument('--num-channels', type=int, default=3,
                        help="number of channels of imges")
    parser.add_argument('--gpu', type=int, default=0,
                        help="GPU ID, -1 for CPU")
    parser.add_argument('--stopping-rounds', type=int,
                        default=10, help='rounds of early stopping')
    parser.add_argument('--communication-rounds', type=int,
                        default=10, help='rounds of model exchange with friends')

    parser.add_argument('--verbose', action='store_true', help='verbose print')
    parser.add_argument('--seed', type=int, default=42,
                        help='random seed (default: 42)')

    parser.add_argument('--run-fed', action='store_true',
                        help='Enables federated training')
    parser.add_argument('--run-cent', action='store_true',
                        help='Enables centralised training')
    parser.add_argument('--run-dec', action='store_true',
                        help='Enables decentralised training')
    parser.add_argument('--run-all',
                        action='store_true', help='Enables all training styles (decentralised, federated, centralised')

    # output
    parser.add_argument('--outfolder', type=str,
                        default='stats-meeting', help="prefix of folder")

    args = parser.parse_args()
    return args
