from objprint import add_objprint


@add_objprint
class Message:
    def __init__(self, time, source, model):
        self._time = time
        self._source = source
        self._model = model

    @property
    def time(self):
        return self._time

    @time.setter
    def time(self, time):
        self._time = time

    @property
    def source(self):
        return self._source

    @source.setter
    def source(self, source):
        self._source = source

    @property
    def model(self):
        return self._model

    @model.setter
    def model(self, model):
        self._model = model

    def __lt__(self, other):
        # definition of the < operator:  sort first by time of event, then by node_id
        return (self.time < other.time)

    def __iter__(self):
        ''' Returns the Iterator object '''
        return iter([self.time, self.source, self.model])


# class MessageBuffer:
#     def __init__(self):
#         self._msg_buffer = deque()
#
#     def
