import networkx as nx
import matplotlib.pyplot as plt
import random as ra

def is_int(n):
    try:
        float_n = float(n)
        int_n = int(float_n)
    except ValueError:
        return False
    else:
        return float_n == int_n


def is_float(n):
    try:
        float_n = float(n)
    except ValueError:
        return False
    else:
        return True


def conver_to_numeric(num):
    # for num in string_list:
    if is_int(num):
        #print(num, 'can be safely converted to an integer.')
        return int(num)
    elif is_float(num):
        #print(num, 'is a float with non-zero digit(s) in the fractional-part.')
        return float(num)


class SAIGraph:

    def __init__(self, args):
        self._args=args
        # if self._args.edgelist_filename and self._args.graph_type:
        #     print(
        #         "SAIGraph Warning: too many config options. We will use the FILENAME\n")

        ra.seed(args.seed)

        if self._args.graph_from == "file" and self._args.edgelist_filename:
            # load graph from edge list file
            self.sai_graph = nx.read_edgelist(
                self._args.edgelist_filename, nodetype=int, data=(("weight", float),))
            print("SAIGraph: loaded graph from file ", self._args.edgelist_filename)
        elif self._args.graph_from == "synth":
            # generate synthetic graph
            ga = map(conver_to_numeric, self._args.graph_synth_args.split(','))
            self.sai_graph = nx.__getattribute__(self._args.graph_synth_type)(*ga)

            print("SAIGraph: generated synthetic graph of type",
                  self._args.graph_synth_type, "with parameters", self._args.graph_synth_args)

            # TODO: added for debug, remove later on
            # forcing weights to edges
            for e in self.sai_graph.edges():
                self.sai_graph[e[0]][e[1]]['weight'] = ra.uniform(0.01, 3)
        elif self._args.graph_from == "preset":
            # load graph from networkx dataset
            self.sai_graph = nx.__getattribute__(self._args.graph_preset)()
            # forcing weights to edges
            for e in self.sai_graph.edges():
                self.sai_graph[e[0]][e[1]]['weight'] = ra.uniform(0.01, 3)
        else:
            print("SAIGraph Error: no parameter provided, can't create the graph\n")
            exit(1)

        # plot graph
        weights = nx.get_edge_attributes(self.sai_graph, 'weight').values()

        filename = "stats/" + args.outfolder + "/graph.pdf"
        f = plt.figure()
        nx.draw(self.sai_graph, pos=nx.spring_layout(self.sai_graph),
                with_labels=True,
                width=list(weights))
        f.savefig(filename)
