% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_hypercube.R
\name{sp_hypercube}
\alias{sp_hypercube}
\title{Returns the abundance of a species in a grid of environmental variables}
\usage{
sp_hypercube(env, sp, partitions = 3)
}
\arguments{
\item{env}{Vector or matrix of quantitative environmental data}

\item{sp}{A vector of abundance of a species registered in the same 
samples as environmental data}

\item{partitions}{Number of intervals in which to divide the 
range of each variable.}
}
\value{
An object of class ftable with the abundance of a species 
in an grid of environmental variables
}
\description{
Returns the abundance of a species in a grid of environmental variables
}
\examples{

data(soilandfauna)

# Select community (species) data

com <- soilandfauna[,18:60]

# Select environmental data

env <- soilandfauna[,3:17]

# Obtain the presence of the Onychiuridae species in a grid 
# of environmental variables 

sp_hypercube(env[,c("P","OM","N")],com[,"Onychiuridae"],5)

# Obtain the simultaneous presence of the four species in a grid 
# of environmental variables

sp_hypercube(env[,c("P","OM","N")],com[,"Onychiuridae"] *
 com[,"Isotomidae"] * com[,"Eupodoidea"]* com[,"Aporrectodea_rosea"],5)
}
