% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_indicator_species.R
\name{select_indicator_species}
\alias{select_indicator_species}
\title{Select indicator species}
\usage{
select_indicator_species(com, group, alfa = 0.05)
}
\arguments{
\item{com}{matrix or data.frame with species in columns and samples in rows.}

\item{group}{vector of the samples grouping.}

\item{alfa}{significance level used for the test.}
}
\value{
A data.frame with the species that are above
}
\description{
Selection of species that indicate with a given probability of
belonging to an environment.
}
\examples{

data(soilandfauna)
 
# Select community (species) data
com <- soilandfauna[,18:50]

# Select grouping factor
group <- soilandfauna[,1]

select_indicator_species(com,group,0.05)

}
