% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_env_test.R
\name{identify_env_test}
\alias{identify_env_test}
\title{Test the accuracy of the environment identification of a set of samples}
\usage{
identify_env_test(com, group, times = 100, n = 5, alfa = 0.05)
}
\arguments{
\item{com}{The original community used to select indicator species.}

\item{group}{vector of the samples grouping}

\item{times}{to repeat the test}

\item{n}{Subsample size}

\item{alfa}{Significance level used for the test.}
}
\value{
A list with the accuracy of the estimation for each group
}
\description{
This function use
}
\examples{

data(soilandfauna)
 
# Select community (species) data

com <- soilandfauna[,18:60]

# Select grouping factor
group <- soilandfauna[,1]

identify_env_test(com, group)

}
