% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_env.R
\name{identify_env}
\alias{identify_env}
\title{Identify the environment from new samples of community species}
\usage{
identify_env(com, com.to.identify, group, alfa = 0.05)
}
\arguments{
\item{com}{The original community used to select indicator species.}

\item{com.to.identify}{A new sample o group of samples to identify the 
environment that they belong.}

\item{group}{vector of the samples grouping of the origina community.}

\item{alfa}{Significance level used for the test.}
}
\value{
A list with two components: a data.frame with the environment estimation 
value for each group and a vector with the belonging environment estimated. 
If two environments coincides in the max value then returns "NA".
}
\description{
This function use the result of `select_indicator_species` to identify a new 
set of samples of the community
}
\examples{

data(soilandfauna)
 
# Select community (species) data

com <- soilandfauna[,18:60]

# Select a subset of samples belonging to the same environment

subcom <- com[3:10,]

# Select grouping factor

group <- soilandfauna[,1]

identify_env(com, subcom, group)

}
