% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_niche_factor.R
\name{as_niche_factor}
\alias{as_niche_factor}
\title{Converts a vector or matrix of quantitative environmental data as a 
factorized version with a desired numbers of partitions.}
\usage{
as_niche_factor(env, partitions = 3)
}
\arguments{
\item{env}{A matrix or data.frame of quantitative environmental data.}

\item{partitions}{Number of intervals in which to divide the 
range of each variable.}
}
\value{
A data.frame of numeric variables converted to factor
}
\description{
Converts a vector or matrix of quantitative environmental data as a 
factorized version with a desired numbers of partitions.
}
\examples{

data(soilandfauna)

# Select environmental data

env <- soilandfauna[,c("Bd","P","EC")]

as_niche_factor(env)

}
