#!/bin/bash

# command-line arguments:
# 1: run type (1,2, ...)

# parse command-line arguments
RUN_TYPE=$1

RUN_ID="run-001"

# output directory
OUT_DIR="$HOME/projects/systems-consolidation/simulations/sim_rc_p11/$RUN_ID"

# source directory
SOURCE="src"
DIR=$OUT_DIR/$SOURCE

. $DIR/globalvars.sh

# enter run configuration parameters
TIME_FILE="time.txt"

PRINT_TIME="true"

COPY_SOURCE="false"

HAS_SIMULATION="true"
#HAS_SIMULATION="false"

HAS_ANALYSIS="true"
#HAS_ANALYSIS="false"

#TRIALS=( 0 1 2 3 4 5 6 7 8 9 )
TRIALS=( 0 1 2 3 4 )
#TRIALS=( 5 6 7 8 9 )
#TRIALS=( 0 )

# enter analysis parameters
AREAS=hpc,ctx,thl

HAS_RECALL_METRICS=true
HAS_WEIGHT_METRICS=false

HAS_PLOTS=true

HAS_MERGE=false

#PREFIXES_THL_RUN_1=$FILE_PREFIX_BURN
#PREFIXES_THL_RUN_1=$FILE_PREFIX_LEARN
PREFIXES_THL_RUN_1=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CUE
#PREFIXES_THL_RUN_1=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

#PREFIXES_CTX_RUN_1=$FILE_PREFIX_BURN
#PREFIXES_CTX_RUN_1=$FILE_PREFIX_LEARN
PREFIXES_CTX_RUN_1=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CUE
#PREFIXES_CTX_RUN_1=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

#PREFIXES_HPC_RUN_1=$FILE_PREFIX_BURN
#PREFIXES_HPC_RUN_1=$FILE_PREFIX_LEARN
PREFIXES_HPC_RUN_1=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CUE

#PREFIXES_RDT_RUN_1=$FILE_PREFIX_BURN
#PREFIXES_RDT_RUN_1=$FILE_PREFIX_LEARN
PREFIXES_RDT_RUN_1=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CUE
#PREFIXES_RDT_RUN_1=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

PREFIXES_THL_RUN_2_3=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_PROBE,$FILE_PREFIX_CUE
#PREFIXES_THL_RUN_2_3=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_PROBE,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

PREFIXES_CTX_RUN_2_3=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_PROBE,$FILE_PREFIX_CUE
#PREFIXES_CTX_RUN_2_3=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_PROBE,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

PREFIXES_HPC_RUN_2_3=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_PROBE,$FILE_PREFIX_CUE

PREFIXES_RDT_RUN_2_3=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_PROBE,$FILE_PREFIX_CUE
#PREFIXES_RDT_RUN_2_3=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_PROBE,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

#PREFIXES_THL_RUN_5_6=$FILE_PREFIX_CONSOLIDATION
#PREFIXES_THL_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION
PREFIXES_THL_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE
#PREFIXES_THL_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

#PREFIXES_CTX_RUN_5_6=$FILE_PREFIX_CONSOLIDATION
#PREFIXES_CTX_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION
PREFIXES_CTX_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE
#PREFIXES_CTX_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

#PREFIXES_HPC_RUN_5_6=$FILE_PREFIX_CONSOLIDATION
#PREFIXES_HPC_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION
PREFIXES_HPC_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE

#PREFIXES_RDT_RUN_5_6=$FILE_PREFIX_CONSOLIDATION
#PREFIXES_RDT_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION
PREFIXES_RDT_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE
#PREFIXES_RDT_RUN_5_6=$FILE_PREFIX_LEARN,$FILE_PREFIX_BURN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

PREFIXES_THL_RUN_7_8=$FILE_PREFIX_PROBE,$FILE_PREFIX_BURN,$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE
#PREFIXES_THL_RUN_7_8=$FILE_PREFIX_PROBE,$FILE_PREFIX_BURN,$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

PREFIXES_CTX_RUN_7_8=$FILE_PREFIX_PROBE,$FILE_PREFIX_BURN,$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE
#PREFIXES_CTX_RUN_7_8=$FILE_PREFIX_PROBE,$FILE_PREFIX_BURN,$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

PREFIXES_HPC_RUN_7_8=$FILE_PREFIX_PROBE,$FILE_PREFIX_BURN,$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE

PREFIXES_RDT_RUN_7_8=$FILE_PREFIX_PROBE,$FILE_PREFIX_BURN,$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE
#PREFIXES_RDT_RUN_7_8=$FILE_PREFIX_PROBE,$FILE_PREFIX_BURN,$FILE_PREFIX_LEARN,$FILE_PREFIX_CONSOLIDATION,$FILE_PREFIX_CUE,$FILE_PREFIX_CUE_HM

case $RUN_TYPE in
    1)
	PREFIXES_THL=$PREFIXES_THL_RUN_1
	PREFIXES_CTX=$PREFIXES_CTX_RUN_1
	PREFIXES_HPC=$PREFIXES_HPC_RUN_1
	PREFIXES_RDT=$PREFIXES_RDT_RUN_1
	;;
    2 | 3)
	PREFIXES_THL=$PREFIXES_THL_RUN_2_3
	PREFIXES_CTX=$PREFIXES_CTX_RUN_2_3
	PREFIXES_HPC=$PREFIXES_HPC_RUN_2_3
	PREFIXES_RDT=$PREFIXES_RDT_RUN_2_3
	;;
    4)
	# DEPRECATED
	#PREFIXES_THL=$PREFIXES_THL_RUN_4
	#PREFIXES_CTX=$PREFIXES_CTX_RUN_4
	#PREFIXES_HPC=$PREFIXES_HPC_RUN_4
	#PREFIXES_RDT=$PREFIXES_RDT_RUN_4
	;;
    5 | 6)
	PREFIXES_THL=$PREFIXES_THL_RUN_5_6
	PREFIXES_CTX=$PREFIXES_CTX_RUN_5_6
	PREFIXES_HPC=$PREFIXES_HPC_RUN_5_6
	PREFIXES_RDT=$PREFIXES_RDT_RUN_5_6
	;;
    7 | 8)
	PREFIXES_THL=$PREFIXES_THL_RUN_7_8
	PREFIXES_CTX=$PREFIXES_CTX_RUN_7_8
	PREFIXES_HPC=$PREFIXES_HPC_RUN_7_8
	PREFIXES_RDT=$PREFIXES_RDT_RUN_7_8
	;;
esac


# simulate and analyze
if [ $HAS_SIMULATION = true ] || [ $HAS_ANALYSIS = true ]
then
    START_RUNS=`date +%s`
    if [ $PRINT_TIME = true ]
    then
	echo run $RUN_TYPE >> $TIME_FILE
    fi
    for ((idx=0; idx<"${#TRIALS[@]}"; idx++))
    do
	if [ $PRINT_TIME = true ]
	then
	    echo trial ${TRIALS[$idx]}: >> $TIME_FILE
	fi
	#run trial simulation
	if [ $HAS_SIMULATION = true ]
	then
	    START_RUN=`date +%s`
	    case $RUN_TYPE in
		1)
		    $DIR/run_1.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		2)
		    $DIR/run_2.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		3)
		    $DIR/run_3.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		4)
		    $DIR/run_4.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		5)
		    $DIR/run_5.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		6)
		    $DIR/run_6.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		7)
		    $DIR/run_7.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		8)
		    $DIR/run_8.sh ${TRIALS[$idx]} $RUN_TYPE $RUN_ID
		    ;;
		*)
		    echo RUN_TYPE $RUN_TYPE : UNKOWN
		    ;;
	    esac
	    END_RUN=`date +%s`
	    RUNTIME=$((END_RUN-START_RUN))
	    if [ $PRINT_TIME = true ]
	    then
		echo runtime = $RUNTIME seconds >> $TIME_FILE
	    fi
	fi
	# run trial analysis
	if [ $HAS_ANALYSIS = true ] && [ $HAS_MERGE = false ]
	then
	    START_ANA=`date +%s`
	    $DIR/analyze_run.sh $RUN_TYPE ${TRIALS[$idx]} $AREAS $PREFIXES_THL $PREFIXES_CTX $PREFIXES_HPC $PREFIXES_RDT $HAS_RECALL_METRICS $HAS_WEIGHT_METRICS $HAS_PLOTS $RUN_ID
	    END_ANA=`date +%s`
	    ANATIME=$((END_ANA-START_ANA))
	    if [ $PRINT_TIME = true ]
	    then
		echo analysis time: $ANATIME seconds >> $TIME_FILE
	    fi
	fi
    done
    END_RUNS=`date +%s`
    RUNSTIME=$((END_RUNS-START_RUNS))
    if [ $PRINT_TIME = true ]
    then
	echo total runtime = $RUNSTIME seconds >> $TIME_FILE
    fi
fi


# merge output of trials
if [ $HAS_MERGE = true ] && [ "${#TRIALS[@]}" > 1 ]
then
    TRIALS_LIST=${TRIALS[0]}
    for ((idx=1; idx<"${#TRIALS[@]}"; idx++))
    do
	TRIALS_LIST="$TRIALS_LIST,${TRIALS[$idx]}"
    done
    START_MERGE=`date +%s`
    case $RUN_TYPE in
	1 | 2 | 3 | 4 | 5 | 6 | 7 | 8)
	    $DIR/analyze_run.sh $RUN_TYPE $TRIALS_LIST $AREAS $PREFIXES_THL $PREFIXES_CTX $PREFIXES_HPC $PREFIXES_RDT $HAS_RECALL_METRICS $HAS_WEIGHT_METRICS $HAS_PLOTS $RUN_ID
	    ;;
	*)
	    echo RUN_TYPE $RUN_TYPE : UNKOWN
	    ;;
    esac
    END_MERGE=`date +%s`
    MERGETIME=$((END_MERGE-START_MERGE))
    if [ $PRINT_TIME = true ]
    then
	echo merge time: $MERGETIME seconds >> $TIME_FILE
    fi
fi


# copy source code files
if [ $COPY_SOURCE = true ]
then
    $DIR/copy.sh
fi

