#!/bin/bash

RUN_ID="run-001"

# output directory
OUT_DIR="$HOME/projects/systems-consolidation/simulations/sim_rc_p11/$RUN_ID"

# source directory
SOURCE="src"
DIR=$OUT_DIR/$SOURCE

# Create directory if it does not exist
mkdir -p $OUT_DIR

# simulation executables
BIN_FULL="sim_rc_p11"
BIN_HM="sim_rc_p11_hm"

# output file prefix
FILE_PREFIX_BURN="rfb"
FILE_PREFIX_LEARN="rfl"
FILE_PREFIX_CONSOLIDATION="rfc"
FILE_PREFIX_PROBE="rfp"
FILE_PREFIX_CUE="rft"
FILE_PREFIX_HM="hm"

FILE_PREFIX_BURN_HM=$FILE_PREFIX_BURN-$FILE_PREFIX_HM
FILE_PREFIX_LEARN_HM=$FILE_PREFIX_LEARN-$FILE_PREFIX_HM
FILE_PREFIX_CONSOLIDATION_HM=$FILE_PREFIX_CONSOLIDATION-$FILE_PREFIX_HM
FILE_PREFIX_PROBE_HM=$FILE_PREFIX_PROBE-$FILE_PREFIX_HM
FILE_PREFIX_CUE_HM=$FILE_PREFIX_CUE-$FILE_PREFIX_HM

# number of mpi ranks
NP=16

# integration time step (seconds)
INTEGRATION_TIME_STEP="1e-4" # fixed

# pseudo-random number generation

# number of seeds must match number of random trials
# 1 leads to not seeding sys
MASTER_SEED_BURN=( 42 95 9 61 573 6 835 739 70 395 )
MASTER_SEED_LEARN=( 202 128 154 565 544 304 487 227 671 253 )
MASTER_SEED_CONSOLIDATION=( 283 282 988 132 587 975 789 622 98 673 )
MASTER_SEED_PROBE=( 107 605 961 124 20 733 131 13 77 456 )
MASTER_SEED_CUE=( 484 )

# number of seeds must match number of random trials
# 1 leads to not seeding the stimulus group
STIM_SEED_BURN=( 604 424 298 276 312 84 140 681 896 82 )
STIM_SEED_LEARN=( 135 913 507 197 617 973 558 986 243 696 )
STIM_SEED_CONSOLIDATION=( 935 993 350 28 199 967 130 725 591 296 )
STIM_SEED_PROBE=( 942 485 513 181 367 690 897 511 741 914 )
STIM_SEED_CUE=( 845 )

# number of seeds must match number of random trials
# 1 leads to not seeding the background group
BG_THL_SEED_BURN=( 330 160 212 687 891 334 465 909 201 239 )
BG_THL_SEED_LEARN=( 716 493 910 797 520 517 930 431 100 580 )
BG_THL_SEED_CONSOLIDATION=( 542 313 842 675 639 221 162 364 571 949 )
BG_THL_SEED_PROBE=( 694 489 738 417 263 640 816 368 307 499  )
BG_THL_SEED_CUE=( 701 )

# number of seeds must match number of random trials
# 1 leads to not seeding the background group
BG_CTX_SEED_BURN=( 42 95 9 61 573 6 835 739 70 395 )
BG_CTX_SEED_LEARN=( 202 128 154 565 544 304 487 227 671 253 )
BG_CTX_SEED_CONSOLIDATION=( 283 282 988 132 587 975 789 622 98 673 )
BG_CTX_SEED_PROBE=( 107 605 961 124 20 733 131 13 77 456 )
BG_CTX_SEED_CUE=( 484 )

# number of seeds must match number of random trials
# 1 leads to not seeding the background group
BG_HPC_SEED_BURN=( 330 160 212 687 891 334 465 909 201 239 )
BG_HPC_SEED_LEARN=( 716 493 910 797 520 517 930 431 100 580 )
BG_HPC_SEED_CONSOLIDATION=( 542 313 842 675 639 221 162 364 571 949 )
BG_HPC_SEED_PROBE=( 694 489 738 417 263 640 816 368 307 499  )
BG_HPC_SEED_CUE=( 701 )

# number of seeds must match number of random trials
# 1 leads to not seeding the background group
BG_RDT_SEED_BURN=( 604 424 298 276 312 84 140 681 896 82 )
BG_RDT_SEED_LEARN=( 135 913 507 197 617 973 558 986 243 696 )
BG_RDT_SEED_CONSOLIDATION=( 935 993 350 28 199 967 130 725 591 296 )
BG_RDT_SEED_PROBE=( 942 485 513 181 367 690 897 511 741 914 )
BG_RDT_SEED_CUE=( 845 )

# number of seeds must match number of random trials
# 1 leads to not seeding the replay group
REP_SEED_BURN=( 330 160 212 687 891 334 465 909 201 239 )
REP_SEED_LEARN=( 716 493 910 797 520 517 930 431 100 580 )
REP_SEED_CONSOLIDATION=( 542 313 842 675 639 221 162 364 571 949 )
REP_SEED_PROBE=( 694 489 738 417 263 640 816 368 307 499  )
REP_SEED_CUE=( 701 )

# simulation time in biological seconds
SIMTIME_BURN=120

: '
SIMTIME_LEARN_1=60
SIMTIME_LEARN_2=120
SIMTIME_LEARN_3=180
SIMTIME_LEARN_4=240
SIMTIME_LEARN_5=300
SIMTIME_LEARN_6=360
SIMTIME_LEARN_7=420
SIMTIME_LEARN_8=480
SIMTIME_LEARN_9=540
SIMTIME_LEARN_10=600
'

: '
SIMTIME_LEARN_1=300
SIMTIME_LEARN_2=600
SIMTIME_LEARN_3=900
SIMTIME_LEARN_4=1200
SIMTIME_LEARN_5=1500
SIMTIME_LEARN_6=1800
SIMTIME_LEARN_7=2100
SIMTIME_LEARN_8=2400
SIMTIME_LEARN_9=2700
SIMTIME_LEARN_10=3000
SIMTIME_LEARN_11=3300
SIMTIME_LEARN_12=3600
'

: '
SIMTIME_LEARN_1=600
SIMTIME_LEARN_2=1200
SIMTIME_LEARN_3=1800
SIMTIME_LEARN_4=2400
SIMTIME_LEARN_5=3000
SIMTIME_LEARN_6=3600
'

: '
SIMTIME_LEARN_1=1800
SIMTIME_LEARN_2=3600
SIMTIME_LEARN_3=5400
SIMTIME_LEARN_4=7200
SIMTIME_LEARN_5=9000
SIMTIME_LEARN_6=10800
SIMTIME_LEARN_7=12600
SIMTIME_LEARN_8=14400
'

: '
SIMTIME_LEARN_1=3600
SIMTIME_LEARN_2=7200
SIMTIME_LEARN_3=10800
SIMTIME_LEARN_4=14400
SIMTIME_LEARN_5=18000
SIMTIME_LEARN_6=21600
SIMTIME_LEARN_7=25200
SIMTIME_LEARN_8=28800
'

#: '
SIMTIME_LEARN_1=1800
#'


SIMTIME_LEARN_CON_0=1800
SIMTIME_LEARN_CON_1=1800
SIMTIME_LEARN_CON_2=1800
SIMTIME_LEARN_CON_3=1800
SIMTIME_LEARN_CON_4=1800
SIMTIME_LEARN_CON_5=1800
SIMTIME_LEARN_CON_6=1800
SIMTIME_LEARN_CON_7=1800
SIMTIME_LEARN_CON_8=1800
SIMTIME_LEARN_CON_9=1800


: '
SIMTIME_CONSOLIDATION_1=60
'

: '
SIMTIME_CONSOLIDATION_1=120
SIMTIME_CONSOLIDATION_2=240
SIMTIME_CONSOLIDATION_3=360
SIMTIME_CONSOLIDATION_4=480
SIMTIME_CONSOLIDATION_5=600
SIMTIME_CONSOLIDATION_6=720
SIMTIME_CONSOLIDATION_7=840
SIMTIME_CONSOLIDATION_8=960
SIMTIME_CONSOLIDATION_9=1080
SIMTIME_CONSOLIDATION_10=1200
'

: '
SIMTIME_CONSOLIDATION_1=300
SIMTIME_CONSOLIDATION_2=600
SIMTIME_CONSOLIDATION_3=900
SIMTIME_CONSOLIDATION_4=1200
SIMTIME_CONSOLIDATION_5=1500
SIMTIME_CONSOLIDATION_6=1800
SIMTIME_CONSOLIDATION_7=2100
SIMTIME_CONSOLIDATION_8=2400
SIMTIME_CONSOLIDATION_9=2700
SIMTIME_CONSOLIDATION_10=3000
SIMTIME_CONSOLIDATION_11=3300
SIMTIME_CONSOLIDATION_12=3600
'


: '
SIMTIME_CONSOLIDATION_1=600
SIMTIME_CONSOLIDATION_2=1200
SIMTIME_CONSOLIDATION_3=1800
SIMTIME_CONSOLIDATION_4=2400
SIMTIME_CONSOLIDATION_5=3000
SIMTIME_CONSOLIDATION_6=3600
'

: '
SIMTIME_CONSOLIDATION_1=1800
SIMTIME_CONSOLIDATION_2=3600
SIMTIME_CONSOLIDATION_3=5400
SIMTIME_CONSOLIDATION_4=7200
SIMTIME_CONSOLIDATION_5=9000
SIMTIME_CONSOLIDATION_6=10800
SIMTIME_CONSOLIDATION_7=12600
SIMTIME_CONSOLIDATION_8=14400
SIMTIME_CONSOLIDATION_9=16200
SIMTIME_CONSOLIDATION_10=18000
SIMTIME_CONSOLIDATION_11=19800
SIMTIME_CONSOLIDATION_12=21600
'

#: '
SIMTIME_CONSOLIDATION_1=3600
SIMTIME_CONSOLIDATION_2=7200
SIMTIME_CONSOLIDATION_3=10800
SIMTIME_CONSOLIDATION_4=14400
SIMTIME_CONSOLIDATION_5=18000
SIMTIME_CONSOLIDATION_6=21600
SIMTIME_CONSOLIDATION_7=25200
SIMTIME_CONSOLIDATION_8=28800
SIMTIME_CONSOLIDATION_9=32400
SIMTIME_CONSOLIDATION_10=36000
SIMTIME_CONSOLIDATION_11=39600
SIMTIME_CONSOLIDATION_12=43200
SIMTIME_CONSOLIDATION_13=46800
SIMTIME_CONSOLIDATION_14=50400
SIMTIME_CONSOLIDATION_15=54000
SIMTIME_CONSOLIDATION_16=57600
SIMTIME_CONSOLIDATION_17=61200
SIMTIME_CONSOLIDATION_18=64800
SIMTIME_CONSOLIDATION_19=68400
SIMTIME_CONSOLIDATION_20=72000
SIMTIME_CONSOLIDATION_21=75600
SIMTIME_CONSOLIDATION_22=79200
SIMTIME_CONSOLIDATION_23=82800
SIMTIME_CONSOLIDATION_24=86400
#'
: '
SIMTIME_CONSOLIDATION_25=90000
SIMTIME_CONSOLIDATION_26=93600
SIMTIME_CONSOLIDATION_27=97200
SIMTIME_CONSOLIDATION_28=100800
SIMTIME_CONSOLIDATION_29=104400
SIMTIME_CONSOLIDATION_30=108000
SIMTIME_CONSOLIDATION_31=111600
SIMTIME_CONSOLIDATION_32=115200
SIMTIME_CONSOLIDATION_33=118800
SIMTIME_CONSOLIDATION_34=122400
SIMTIME_CONSOLIDATION_35=126000
SIMTIME_CONSOLIDATION_36=129600
SIMTIME_CONSOLIDATION_37=133200
SIMTIME_CONSOLIDATION_38=136800
SIMTIME_CONSOLIDATION_39=140400
SIMTIME_CONSOLIDATION_40=144000
SIMTIME_CONSOLIDATION_41=147600
SIMTIME_CONSOLIDATION_42=151200
SIMTIME_CONSOLIDATION_43=154800
SIMTIME_CONSOLIDATION_44=158400
SIMTIME_CONSOLIDATION_45=162000
SIMTIME_CONSOLIDATION_46=165600
SIMTIME_CONSOLIDATION_47=169200
SIMTIME_CONSOLIDATION_48=172800
'

: '
SIMTIME_CONSOLIDATION_1=14400
SIMTIME_CONSOLIDATION_2=28800
SIMTIME_CONSOLIDATION_3=43200
SIMTIME_CONSOLIDATION_4=57600
SIMTIME_CONSOLIDATION_5=72000
SIMTIME_CONSOLIDATION_6=86400
'

SIMTIME_PROBE=300

SIMTIME_CUE=60

T_STOP_LEARN=( $SIMTIME_LEARN_1 $SIMTIME_LEARN_2 $SIMTIME_LEARN_3 $SIMTIME_LEARN_4 $SIMTIME_LEARN_5 $SIMTIME_LEARN_6 $SIMTIME_LEARN_7 $SIMTIME_LEARN_8 $SIMTIME_LEARN_9 $SIMTIME_LEARN_10 $SIMTIME_LEARN_11 $SIMTIME_LEARN_12 )

T_STOP_LEARN_CON=( $SIMTIME_LEARN_CON_0 $SIMTIME_LEARN_CON_1 $SIMTIME_LEARN_CON_2 $SIMTIME_LEARN_CON_3 $SIMTIME_LEARN_CON_4 $SIMTIME_LEARN_CON_5 $SIMTIME_LEARN_CON_6 $SIMTIME_LEARN_CON_7 $SIMTIME_LEARN_CON_8 $SIMTIME_LEARN_CON_9 )

T_STOP_CONSOLIDATION=( $SIMTIME_CONSOLIDATION_1 $SIMTIME_CONSOLIDATION_2 $SIMTIME_CONSOLIDATION_3 $SIMTIME_CONSOLIDATION_4 $SIMTIME_CONSOLIDATION_5 $SIMTIME_CONSOLIDATION_6 $SIMTIME_CONSOLIDATION_7 $SIMTIME_CONSOLIDATION_8 $SIMTIME_CONSOLIDATION_9 $SIMTIME_CONSOLIDATION_10 $SIMTIME_CONSOLIDATION_11 $SIMTIME_CONSOLIDATION_12 $SIMTIME_CONSOLIDATION_13 $SIMTIME_CONSOLIDATION_14 $SIMTIME_CONSOLIDATION_15 $SIMTIME_CONSOLIDATION_16 $SIMTIME_CONSOLIDATION_17 $SIMTIME_CONSOLIDATION_18 $SIMTIME_CONSOLIDATION_19 $SIMTIME_CONSOLIDATION_20 $SIMTIME_CONSOLIDATION_21 $SIMTIME_CONSOLIDATION_22 $SIMTIME_CONSOLIDATION_23 $SIMTIME_CONSOLIDATION_24 $SIMTIME_CONSOLIDATION_25 $SIMTIME_CONSOLIDATION_26 $SIMTIME_CONSOLIDATION_27 $SIMTIME_CONSOLIDATION_28 $SIMTIME_CONSOLIDATION_29 $SIMTIME_CONSOLIDATION_30 $SIMTIME_CONSOLIDATION_31 $SIMTIME_CONSOLIDATION_32 $SIMTIME_CONSOLIDATION_33 $SIMTIME_CONSOLIDATION_34 $SIMTIME_CONSOLIDATION_35 $SIMTIME_CONSOLIDATION_36 $SIMTIME_CONSOLIDATION_37 $SIMTIME_CONSOLIDATION_38 $SIMTIME_CONSOLIDATION_39 $SIMTIME_CONSOLIDATION_40 $SIMTIME_CONSOLIDATION_41 $SIMTIME_CONSOLIDATION_42 $SIMTIME_CONSOLIDATION_43 $SIMTIME_CONSOLIDATION_44 $SIMTIME_CONSOLIDATION_45 $SIMTIME_CONSOLIDATION_46 $SIMTIME_CONSOLIDATION_47 $SIMTIME_CONSOLIDATION_48 )

# thl network
EXC_SIZE_THL=4096
EXC_INH_THL=4
ETA_THL="1.5e-3"
ETA_THL_CON="1.5e-3"
#ETA_THL_TEST="1.5e-3"
ETA_EXC_INH_THL=50.0
ETA_EXC_INH_THL_CON=50.0
#ETA_EXC_INH_THL_TEST=50.0
ETA_STIM_THL="-1e-3" # ETA < 0 makes synapses static
ETA_STIM_THL_CON="-1e-3"
#ETA_STIM_THL_TEST="-1e-3"
ALPHA_THL=4.0
TAUH_IE_THL="10.0"
KAPPA_THL=10
TAUF_EE_THL="0.6"
TAUD_EE_THL="0.15"
UJUMP_EE_THL="0.2"
TAUH_EE_THL="600.0"
TAUC_EE_THL="1200.0"
BETA_THL="50.0"
TAUF_EE_STIM_THL="0.6"
TAUD_EE_STIM_THL="0.15"
UJUMP_EE_STIM_THL="0.2"
TAUH_EE_STIM_THL="600.0"
TAUC_EE_STIM_THL="1200.0"
BETA_STIM_THL="50.0"
DELTA_THL="0.02"
WEIGHTA_THL="0.0"
WEIGHTC_THL="0.5"
ADAPT1_THL="0.1"
ADAPT2_THL="0.0"
POT_STRENGTH_THL="0.1"
WMAX_EXC_THL="5.0"
WMIN_EXC_THL="0.0"
WMAX_INH_THL="5.0"
WMIN_INH_THL="0.0"
WEE_THL="0.1"
WEI_THL="0.6"
WIE_THL="0.2"
WII_THL="0.2"
WEXT_THL="0.05"
WEXT_EI_THL="0.05"
SPARSENESS_INT_EE_THL="0.05"
SPARSENESS_INT_EI_THL="0.05"
SPARSENESS_INT_II_THL="0.05"
SPARSENESS_INT_IE_THL="0.05"
SPARSENESS_EXT_THL="0.10"
TAUF_EI_THL="0.6"
TAUD_EI_THL="0.2"
UJUMP_EI_THL="0.2"
TAUF_EI_STIM_THL="0.6"
TAUD_EI_STIM_THL="0.2"
UJUMP_EI_STIM_THL="0.2"
TAU_AMPA_E_THL="5e-3"
TAU_GABA_E_THL="10e-3"
TAU_NMDA_E_THL="100e-3"
AMPA_NMDA_E_THL="0.2"
TAU_AMPA_I_THL="5e-3"
TAU_GABA_I_THL="10e-3"
TAU_NMDA_I_THL="100e-3"
AMPA_NMDA_I_THL="0.3"
EXC_RECORD_RANK_THL=1 # needs to be manually checked after simulation if recording neuronal data
INH_RECORD_RANK_THL=1 # needs to be manually checked after simulation if recording neuronal data
#PREFILE_THL=""
#CHI_THL="1.0"

# ctx network
EXC_SIZE_CTX=4096
EXC_INH_CTX=4
ETA_CTX="1e-3"
ETA_CTX_CON="1e-3"
#ETA_CTX_TEST="1e-3"
ETA_EXC_INH_CTX=50.0
ETA_EXC_INH_CTX_CON=50.0
#ETA_EXC_INH_CTX_TEST=50.0
ETA_STIM_CTX="-1e-3"
ETA_STIM_CTX_CON="-1e-3"
#ETA_STIM_CTX_TEST="-1e-3"
ALPHA_CTX=4.0
TAUH_IE_CTX="10.0"
KAPPA_CTX=10
TAUF_EE_CTX="0.6"
TAUD_EE_CTX="0.15"
UJUMP_EE_CTX="0.2"
TAUH_EE_CTX="600.0"
TAUC_EE_CTX="1200.0"
BETA_CTX="50.0"
TAUF_EE_STIM_CTX="0.6"
TAUD_EE_STIM_CTX="0.15"
UJUMP_EE_STIM_CTX="0.2"
TAUH_EE_STIM_CTX="600.0"
TAUC_EE_STIM_CTX="1200.0"
BETA_STIM_CTX="50.0"
DELTA_CTX="0.02"
WEIGHTA_CTX="0.0"
WEIGHTC_CTX="0.5"
ADAPT1_CTX="0.1"
ADAPT2_CTX="0.0"
POT_STRENGTH_CTX="0.1"
WMAX_EXC_CTX="5.0"
WMIN_EXC_CTX="0.0"
WMAX_INH_CTX="5.0"
WMIN_INH_CTX="0.0"
WEE_CTX="0.1"
WEI_CTX="0.6"
WIE_CTX="0.2"
WII_CTX="0.2"
WEXT_CTX="0.05"
WEXT_EI_CTX="0.05"
SPARSENESS_INT_EE_CTX="0.05"
SPARSENESS_INT_EI_CTX="0.05"
SPARSENESS_INT_II_CTX="0.05"
SPARSENESS_INT_IE_CTX="0.05"
SPARSENESS_EXT_CTX="0.10"
TAUF_EI_CTX="0.6"
TAUD_EI_CTX="0.2"
UJUMP_EI_CTX="0.2"
TAUF_EI_STIM_CTX="0.6"
TAUD_EI_STIM_CTX="0.2"
UJUMP_EI_STIM_CTX="0.2"
TAU_AMPA_E_CTX="5e-3"
TAU_GABA_E_CTX="10e-3"
TAU_NMDA_E_CTX="100e-3"
AMPA_NMDA_E_CTX="0.2"
TAU_AMPA_I_CTX="5e-3"
TAU_GABA_I_CTX="10e-3"
TAU_NMDA_I_CTX="100e-3"
AMPA_NMDA_I_CTX="0.3"
EXC_RECORD_RANK_CTX=1 # needs to be manually checked after simulation if recording neuronal data
INH_RECORD_RANK_CTX=1 # needs to be manually checked after simulation if recording neuronal data
#PREFILE_CTX=""
#CHI_CTX="1.0"

# hpc network
EXC_SIZE_HPC=4096
EXC_INH_HPC=4
ETA_HPC="1.5e-3"
ETA_HPC_CON="1.5e-3"
#ETA_HPC_TEST="1.5e-3"
ETA_EXC_INH_HPC=50.0
ETA_EXC_INH_HPC_CON=50.0
#ETA_EXC_INH_HPC_TEST=50.0
ETA_STIM_HPC="1.5e-3"
ETA_STIM_HPC_CON="1.5e-3"
#ETA_STIM_HPC_TEST="1.5e-3"
ALPHA_HPC=4.0
TAUH_IE_HPC="10.0"
KAPPA_HPC=10
TAUF_EE_HPC="0.6"
TAUD_EE_HPC="0.15"
UJUMP_EE_HPC="0.2"
TAUH_EE_HPC="600.0"
TAUC_EE_HPC="1200.0"
BETA_HPC="50.0"
TAUF_EE_STIM_HPC="0.6"
TAUD_EE_STIM_HPC="0.15"
UJUMP_EE_STIM_HPC="0.2"
TAUH_EE_STIM_HPC="600.0"
TAUC_EE_STIM_HPC="10800.0"
BETA_STIM_HPC="30.0"
DELTA_HPC="0.02"
WEIGHTA_HPC="0.0"
WEIGHTC_HPC="0.5"
ADAPT1_HPC="0.1"
ADAPT2_HPC="0.0"
POT_STRENGTH_HPC="0.1"
WMAX_EXC_HPC="5.0"
WMIN_EXC_HPC="0.0"
WMAX_INH_HPC="5.0"
WMIN_INH_HPC="0.0"
WEE_HPC="0.1"
WEI_HPC="0.6"
WIE_HPC="0.2"
WII_HPC="0.2"
WEXT_HPC="0.05"
WEXT_EI_HPC="0.05"
SPARSENESS_INT_EE_HPC="0.05"
SPARSENESS_INT_EI_HPC="0.05"
SPARSENESS_INT_II_HPC="0.05"
SPARSENESS_INT_IE_HPC="0.05"
SPARSENESS_EXT_HPC="0.10"
TAUF_EI_HPC="0.6"
TAUD_EI_HPC="0.2"
UJUMP_EI_HPC="0.2"
TAUF_EI_STIM_HPC="0.6"
TAUD_EI_STIM_HPC="0.2"
UJUMP_EI_STIM_HPC="0.2"
TAU_AMPA_E_HPC="5e-3"
TAU_GABA_E_HPC="10e-3"
TAU_NMDA_E_HPC="100e-3"
AMPA_NMDA_E_HPC="0.2"
TAU_AMPA_I_HPC="5e-3"
TAU_GABA_I_HPC="10e-3"
TAU_NMDA_I_HPC="100e-3"
AMPA_NMDA_I_HPC="0.3"
EXC_RECORD_RANK_HPC=1 # needs to be manually checked after simulation if recording neuronal data
INH_RECORD_RANK_HPC=1 # needs to be manually checked after simulation if recording neuronal data
#PREFILE_HPC=""
#CHI_HPC="1.0"

# rdt network
EXC_SIZE_RDT=4096
EXC_INH_RDT=4
ETA_RDT="1e-3"
ETA_RDT_CON="1e-3"
#ETA_RDT_TEST="1e-3"
ETA_EXC_INH_RDT=50.0
ETA_EXC_INH_RDT_CON=50.0
#ETA_EXC_INH_RDT_TEST=50.0
ETA_STIM_RDT="-1e-3"
ETA_STIM_RDT_CON="-1e-3"
#ETA_STIM_RDT_TEST="-1e-3"
ALPHA_RDT=4.0
TAUH_IE_RDT="10.0"
KAPPA_RDT=10
TAUF_EE_RDT="0.6"
TAUD_EE_RDT="0.15"
UJUMP_EE_RDT="0.2"
TAUH_EE_RDT="600.0"
TAUC_EE_RDT="1200.0"
BETA_RDT="50.0"
TAUF_EE_STIM_RDT="0.6"
TAUD_EE_STIM_RDT="0.15"
UJUMP_EE_STIM_RDT="0.2"
TAUH_EE_STIM_RDT="600.0"
TAUC_EE_STIM_RDT="1200.0"
BETA_STIM_RDT="50.0"
DELTA_RDT="0.02"
WEIGHTA_RDT="0.0"
WEIGHTC_RDT="0.5"
ADAPT1_RDT="0.1"
ADAPT2_RDT="0.0"
POT_STRENGTH_RDT="0.1"
WMAX_EXC_RDT="5.0"
WMIN_EXC_RDT="0.0"
WMAX_INH_RDT="5.0"
WMIN_INH_RDT="0.0"
WEE_RDT="0.1"
WEI_RDT="0.6"
WIE_RDT="0.2"
WII_RDT="0.2"
WEXT_RDT="0.05"
WEXT_EI_RDT="0.05"
SPARSENESS_INT_EE_RDT="0.05"
SPARSENESS_INT_EI_RDT="0.05"
SPARSENESS_INT_II_RDT="0.05"
SPARSENESS_INT_IE_RDT="0.05"
SPARSENESS_EXT_RDT="0.10"
TAUF_EI_RDT="0.6"
TAUD_EI_RDT="0.2"
UJUMP_EI_RDT="0.2"
TAUF_EI_STIM_RDT="0.6"
TAUD_EI_STIM_RDT="0.2"
UJUMP_EI_STIM_RDT="0.2"
TAU_AMPA_E_RDT="5e-3"
TAU_GABA_E_RDT="10e-3"
TAU_NMDA_E_RDT="100e-3"
AMPA_NMDA_E_RDT="0.2"
TAU_AMPA_I_RDT="5e-3"
TAU_GABA_I_RDT="10e-3"
TAU_NMDA_I_RDT="100e-3"
AMPA_NMDA_I_RDT="0.3"
EXC_RECORD_RANK_RDT=1 # needs to be manually checked after simulation if recording neuronal data
INH_RECORD_RANK_RDT=1 # needs to be manually checked after simulation if recording neuronal data
#PREFILE_RDT=""
#CHI_RDT="1.0"

# shared by thl, ctx, hpc, and rdt as they are hard-coded into AIF2Group
U_REST=-0.07
U_EXC=0
U_INH=-0.08

# thl->ctx connection
# used in case thl->ctx is: SPARSE , P11
WEE_THL_CTX="0.15"
WEI_THL_CTX="0.2"
SPARSENESS_THL_CTX="0.05"
# used in case thl->ctx is: P11
ETA_THL_CTX="1e-3"
ETA_THL_CTX_CON="1e-3"
#ETA_THL_CTX_TEST="1e-3"
KAPPA_THL_CTX=10
TAUF_THL_CTX="0.6"
TAUD_THL_CTX="0.15"
UJUMP_THL_CTX="0.2"
TAUH_THL_CTX="600.0"
TAUC_THL_CTX="1200.0"
BETA_THL_CTX="105.0"
DELTA_THL_CTX="0.02"
WEIGHTA_THL_CTX="0.0"
WEIGHTC_THL_CTX="0.5"
POT_STRENGTH_THL_CTX="0.1"
WMAX_THL_CTX="5.0"
WMIN_THL_CTX="0.0"

# ctx->thl connection
# used in case ctx->thl is: SPARSE, STP, P11
WEE_CTX_THL="0.0"
WEI_CTX_THL="0.0"
SPARSENESS_CTX_THL="0.02"
# used in case ctx->thl is: P11
ETA_CTX_THL="-1.25e-3"
ETA_CTX_THL_CON="-1.25e-3"
#ETA_CTX_THL_TEST="-1.25e-3"
KAPPA_CTX_THL=10
TAUF_CTX_THL="0.6"
TAUD_CTX_THL="0.15"
UJUMP_CTX_THL="0.2"
TAUH_CTX_THL="600.0"
TAUC_CTX_THL="1200.0"
BETA_CTX_THL="50.0"
DELTA_CTX_THL="0.02"
WEIGHTA_CTX_THL="0.0"
WEIGHTC_CTX_THL="0.5"
POT_STRENGTH_CTX_THL="0.1"
WMAX_CTX_THL="5.0"
WMIN_CTX_THL="0.0"

# thl->hpc connection
# used in case thl->hpc is: SPARSE , P11
WEE_THL_HPC="0.1"
WEI_THL_HPC="0.1"
SPARSENESS_THL_HPC="0.05"
# used in case thl->hpc is: P11
ETA_THL_HPC="1.5e-3"
ETA_THL_HPC_CON="1.5e-3"
#ETA_THL_HPC_TEST="1.5e-3"
KAPPA_THL_HPC=10
TAUF_THL_HPC="0.6"
TAUD_THL_HPC="0.15"
UJUMP_THL_HPC="0.2"
TAUH_THL_HPC="600.0"
TAUC_THL_HPC="1200.0"
BETA_THL_HPC="50.0"
DELTA_THL_HPC="0.02"
WEIGHTA_THL_HPC="0.0"
WEIGHTC_THL_HPC="0.5"
POT_STRENGTH_THL_HPC="0.1"
WMAX_THL_HPC="1.0"
WMIN_THL_HPC="0.0"

# hpc->thl connection
# used in case hpc->thl is: SPARSE, STP, P11
WEE_HPC_THL="0.1"
WEI_HPC_THL="0.1"
SPARSENESS_HPC_THL="0.02"
# used in case hpc->thl is: P11
ETA_HPC_THL="1.5e-3"
ETA_HPC_THL_CON="1.5e-3"
#ETA_HPC_THL_TEST="1.5e-3"
KAPPA_HPC_THL=10
TAUF_HPC_THL="0.6"
TAUD_HPC_THL="0.15"
UJUMP_HPC_THL="0.2"
TAUH_HPC_THL="600.0"
TAUC_HPC_THL="1200.0"
BETA_HPC_THL="50.0"
DELTA_HPC_THL="0.02"
WEIGHTA_HPC_THL="0.0"
WEIGHTC_HPC_THL="0.5"
POT_STRENGTH_HPC_THL="0.1"
WMAX_HPC_THL="5.0"
WMIN_HPC_THL="0.0"

# ctx->hpc connection
# used in case ctx->hpc is: SPARSE, STP, P11
WEE_CTX_HPC="0.1"
WEI_CTX_HPC="0.1"
SPARSENESS_CTX_HPC="0.10"
# used in case ctx->hpc is: P11
ETA_CTX_HPC="1e-3"
ETA_CTX_HPC_CON="1e-3"
#ETA_CTX_HPC_TEST="1e-3"
KAPPA_CTX_HPC=10
TAUF_CTX_HPC="0.6"
TAUD_CTX_HPC="0.15"
UJUMP_CTX_HPC="0.2"
TAUH_CTX_HPC="600.0"
TAUC_CTX_HPC="1200.0"
BETA_CTX_HPC="50.0"
DELTA_CTX_HPC="0.02"
WEIGHTA_CTX_HPC="0.0"
WEIGHTC_CTX_HPC="0.5"
POT_STRENGTH_CTX_HPC="0.1"
WMAX_CTX_HPC="5.0"
WMIN_CTX_HPC="0.0"

# hpc->ctx connection
# used in case hpc->ctx is: SPARSE , P11
WEE_HPC_CTX="0.1"
WEI_HPC_CTX="0.1"
SPARSENESS_HPC_CTX="0.02"
# used in case hpc->ctx is: P11
ETA_HPC_CTX="1.25e-3"
ETA_HPC_CTX_CON="1.25e-3"
#ETA_HPC_CTX_TEST="1.25e-3"
KAPPA_HPC_CTX=10
TAUF_HPC_CTX="0.6"
TAUD_HPC_CTX="0.15"
UJUMP_HPC_CTX="0.2"
TAUH_HPC_CTX="600.0"
TAUC_HPC_CTX="1200.0"
BETA_HPC_CTX="60.0"
DELTA_HPC_CTX="0.02"
WEIGHTA_HPC_CTX="0.0"
WEIGHTC_HPC_CTX="0.5"
POT_STRENGTH_HPC_CTX="0.1"
WMAX_HPC_CTX="5.0"
WMIN_HPC_CTX="0.0"

# thl->rdt connection
# used in case thl->rdt is: SPARSE, STP, P11
WEE_THL_RDT="0.2"
WEI_THL_RDT="0.2"
SPARSENESS_THL_RDT="0.05"
# used in case thl->rdt is: P11
ETA_THL_RDT="1e-3"
ETA_THL_RDT_CON="1e-3"
#ETA_THL_RDT_TEST="1e-3"
KAPPA_THL_RDT=10
TAUF_THL_RDT="0.6"
TAUD_THL_RDT="0.15"
UJUMP_THL_RDT="0.2"
TAUH_THL_RDT="600.0"
TAUC_THL_RDT="1200.0"
BETA_THL_RDT="85.0"
DELTA_THL_RDT="0.02"
WEIGHTA_THL_RDT="0.0"
WEIGHTC_THL_RDT="0.5"
POT_STRENGTH_THL_RDT="0.1"
WMAX_THL_RDT="5.0"
WMIN_THL_RDT="0.0"

# rdt->thl connection
# used in case rdt->thl is: SPARSE, STP, P11
WEE_RDT_THL="0.05"
WEI_RDT_THL="0.05"
SPARSENESS_RDT_THL="0.01"
# used in case rdt->thl is: P11
ETA_RDT_THL="1e-3"
ETA_RDT_THL_CON="1e-3"
#ETA_RDT_THL_TEST="1e-3"
KAPPA_RDT_THL=10
TAUF_RDT_THL="0.6"
TAUD_RDT_THL="0.15"
UJUMP_RDT_THL="0.2"
TAUH_RDT_THL="600.0"
TAUC_RDT_THL="1200.0"
BETA_RDT_THL="105.0"
DELTA_RDT_THL="0.02"
WEIGHTA_RDT_THL="0.0"
WEIGHTC_RDT_THL="0.5"
POT_STRENGTH_RDT_THL="0.1"
WMAX_RDT_THL="5.0"
WMIN_RDT_THL="0.0"

# ctx->rdt connection
# used in case ctx->rdt is: SPARSE, STP, P11
WEE_CTX_RDT="0.05"
WEI_CTX_RDT="0.05"
SPARSENESS_CTX_RDT="0.01"
# used in case ctx->rdt is: P11
ETA_CTX_RDT="1e-3"
ETA_CTX_RDT_CON="1e-3"
#ETA_CTX_RDT_TEST="1e-3"
KAPPA_CTX_RDT=10
TAUF_CTX_RDT="0.6"
TAUD_CTX_RDT="0.15"
UJUMP_CTX_RDT="0.2"
TAUH_CTX_RDT="600.0"
TAUC_CTX_RDT="1200.0"
BETA_CTX_RDT="50.0"
DELTA_CTX_RDT="0.02"
WEIGHTA_CTX_RDT="0.0"
WEIGHTC_CTX_RDT="0.5"
POT_STRENGTH_CTX_RDT="0.1"
WMAX_CTX_RDT="5.0"
WMIN_CTX_RDT="0.0"

# rdt->ctx connection
# used in case rdt->ctx is: SPARSE, STP, P11
WEE_RDT_CTX="0.05"
WEI_RDT_CTX="0.05"
SPARSENESS_RDT_CTX="0.01"
# used in case rdt->ctx is: P11
ETA_RDT_CTX="1e-3"
ETA_RDT_CTX_CON="1e-3"
#ETA_RDT_CTX_TEST="1e-3"
KAPPA_RDT_CTX=10
TAUF_RDT_CTX="0.6"
TAUD_RDT_CTX="0.15"
UJUMP_RDT_CTX="0.2"
TAUH_RDT_CTX="600.0"
TAUC_RDT_CTX="1200.0"
BETA_RDT_CTX="50.0"
DELTA_RDT_CTX="0.02"
WEIGHTA_RDT_CTX="0.0"
WEIGHTC_RDT_CTX="0.5"
POT_STRENGTH_RDT_CTX="0.1"
WMAX_RDT_CTX="5.0"
WMIN_RDT_CTX="0.0"

# hpc->rdt connection
# used in case hpc->rdt is: SPARSE, STP, P11
WEE_HPC_RDT="0.05"
WEI_HPC_RDT="0.2"
SPARSENESS_HPC_RDT="0.05"
# used in case hpc->rdt is: P11
ETA_HPC_RDT="1.5e-3"
ETA_HPC_RDT_CON="1.5e-3"
#ETA_HPC_RDT_TEST="1.5e-3"
KAPPA_HPC_RDT=10
TAUF_HPC_RDT="0.6"
TAUD_HPC_RDT="0.15"
UJUMP_HPC_RDT="0.2"
TAUH_HPC_RDT="600.0"
TAUC_HPC_RDT="10800.0"
BETA_HPC_RDT="30.0"
DELTA_HPC_RDT="0.02"
WEIGHTA_HPC_RDT="0.0"
WEIGHTC_HPC_RDT="0.5"
POT_STRENGTH_HPC_RDT="0.1"
WMAX_HPC_RDT="5.0"
WMIN_HPC_RDT="0.0"

# rdt->hpc connection
# used in case rdt->hpc is: SPARSE, STP, P11
WEE_RDT_HPC="0.05"
WEI_RDT_HPC="0.2"
SPARSENESS_RDT_HPC="0.05"
# used in case rdt->hpc is: P11
ETA_RDT_HPC="1.5e-3"
ETA_RDT_HPC_CON="1.5e-3"
#ETA_RDT_HPC_TEST="1.5e-3"
KAPPA_RDT_HPC=10
TAUF_RDT_HPC="0.6"
TAUD_RDT_HPC="0.15"
UJUMP_RDT_HPC="0.2"
TAUH_RDT_HPC="600.0"
TAUC_RDT_HPC="10800.0"
BETA_RDT_HPC="30.0"
DELTA_RDT_HPC="0.02"
WEIGHTA_RDT_HPC="0.0"
WEIGHTC_RDT_HPC="0.5"
POT_STRENGTH_RDT_HPC="0.1"
WMAX_RDT_HPC="5.0"
WMIN_RDT_HPC="0.0"

# background input
BGRATE_THL="0.0"
BGRATE_THL_CON="0.0"
SPARSENESS_BG_THL="0.10"
W_BG_THL="1.0"
W_BG_EI_THL="1.0"
XI_BG_THL="0.0"
XI_EI_BG_THL="0.0"

BGRATE_CTX="0.0"
BGRATE_CTX_CON="1.0"
SPARSENESS_BG_CTX="0.10"
W_BG_CTX="1.0"
W_BG_EI_CTX="1.0"
XI_BG_CTX="0.2"
XI_EI_BG_CTX="0.0"

BGRATE_HPC="0.0"
BGRATE_HPC_CON="1.0"
SPARSENESS_BG_HPC="0.10"
W_BG_HPC="1.0"
W_BG_EI_HPC="1.0"
XI_BG_HPC="0.2"
XI_EI_BG_HPC="0.0"

BGRATE_RDT="0.0"
BGRATE_RDT_CON="0.0" # 1.0 0.5
SPARSENESS_BG_RDT="0.10"
W_BG_RDT="1.0"
W_BG_EI_RDT="1.0"
XI_BG_RDT="0.0" # 0.2
XI_EI_BG_RDT="0.0"


# replay
SIZE_REP=4096
NB_NEURONS_STIM_REP=1024 # number of neurons in the replay population for a single stimulus

# add a separe parameter for each brain region
NB_NEURON_CONS_STIM_REP=0.10 # connection probability from a replay pattern to the respective
                             # cell assembly

BGRATE_REP="0.0"
BGRATE_REP_CON="0.0"
ON_REP="1.0"
OFF_REP="2.0"
SCALE_REP="25"

SPARSENESS_REP_THL="0.10"
W_REP_THL="1.0"
XI_REP_THL="0.0"
XI_EI_REP_THL="0.0"

SPARSENESS_REP_CTX="0.10"
W_REP_CTX="1.0"
XI_REP_CTX="0.0"
XI_EI_REP_CTX="0.0"

SPARSENESS_REP_HPC="0.10"
W_REP_HPC="1.0"
XI_REP_HPC="0.0"
XI_EI_REP_HPC="0.0"

SPARSENESS_REP_RDT="0.10"
W_REP_RDT="1.0"
XI_REP_RDT="0.0"
XI_EI_REP_RDT="0.0"

# input stimulus
ON_LEARN="1.0"
OFF_LEARN="2.0"
ON_PROBE="1.0"
OFF_PROBE="2.0"
ON_CUE="2.0"
OFF_CUE="2.0"
SCALE_LEARN="25"
SCALE_PROBE="25"
SCALE_CUE="25"
BGRATE="5.0"
BGRATE_CON="0.0"
PREFERRED="-1" # -1 indicates absence of preferred stimulus

#STIM="rand_4_a.pat" # random non-overlapping stimuli
#STIM="rand_pat_f.pat" # random overlapping stimuli
STIM="bar_a.pat"

#STIM_CUE="rand_4_a_cues_rand_50.pat"
#STIM_CUE="rand_pat_f-rand_cue-50.pat"
STIM_CUE="bar_a-bar_cue-50.pat"

DATA="data"
STIMFILE=$DIR/$DATA/$STIM
STIMFILE_CUE=$DIR/$DATA/$STIM_CUE

#PRIME_ONTIME="1.0"
#PRIME_OFFTIME="0.2"
#PRIME_DURATION="200.0"

# receptive fields
#rf_discsR8.mtx
#rf_discsR8_v1.mtx
#rf_discsR1_no-overlap_random-pattern.mtx
#rf_discsR1_no-overlap_match-pattern.mtx
#rf_discsR4_v1.mtx

RECFILE_STIM_THL="$DIR/$DATA/rf_discsR4_v1.mtx"
XI_STIM_THL="2.00"

#RECFILE_STIM_CTX="$DIR/$DATA/rf_discsR8.mtx"
#XI_STIM_CTX="0.50"

RECFILE_STIM_HPC="$DIR/$DATA/rf_discsR8.mtx"
XI_STIM_HPC="0.50"

#RECFILE_THL_CTX="$DIR/$DATA/rf_discsR4_v1.mtx"
#XI_THL_CTX="2.0"

#RECFILE_CTX_THL="$DIR/$DATA/rf_discsR8.mtx"
#XI_CTX_THL="0.5"

#RECFILE_THL_HPC="$DIR/$DATA/rf_discsR4_v1.mtx"
#XI_THL_HPC="2.0"

#RECFILE_HPC_THL="$DIR/$DATA/rf_discsR8.mtx"
#XI_HPC_THL="0.0"

#RECFILE_CTX_HPC="$DIR/$DATA/rf_discsR8.mtx"
#XI_CTX_HPC="0.5"

#RECFILE_HPC_CTX="$DIR/$DATA/rf_discsR4_v1.mtx"
#XI_HPC_CTX="2.0"

# monitor previously identified neuron groups
#MONFILE_CTX="$DIR/$DATA/rf1.pat"
#MONFILE_CTX="rf1-rate.pat.ctx"
#PREMONFILE_CTX=""
#MONFILE_HPC="$DIR/$DATA/rf1.pat"
#PREMONFILE_HPC=""
#MONFILE_THL="$DIR/$DATA/rf1.pat"
#PREMONFILE_THL=""
