suppressPackageStartupMessages({
  library(phylopomp)
  library(tidyverse)
  library(magrittr)
  library(broom)
  library(doParallel)
  library(doRNG)
})

options(digits=3)
png(filename="sirws3-%02d.png",res=100)

theme_set(theme_bw())

chk <- Sys.getenv("_R_CHECK_LIMIT_CORES_", "")
if (nzchar(chk) && chk == "TRUE") {
  ## use 2 cores in CRAN/Travis/AppVeyor
  registerDoParallel(2)
} else {
  ## use all cores in devtools::test()
  registerDoParallel()
}
registerDoRNG(1234166095)

expand_grid(
  Beta=4,
  gamma=1,
  psi=1,
  I0=1,
  S0=c(1,2),
  R0=0,
  rep=1:2000
) -> pars

foreach (par=iter(pars,"row")) %dopar% {
  library(phylopomp)
  library(tidyverse)
  par %$%
    playSIRwS(
      Beta=Beta,gamma=gamma,psi=psi,
      S0=S0,I0=I0,R0=0,t0=0,times=100,
      tree=FALSE
    ) |>
    getInfo() -> x
  bind_cols(par,x$cumhaz)
} |>
  bind_rows() |>
  filter(!is.na(Lambda)) |>
  mutate(p=exp(-Lambda)) |>
  arrange(Beta,gamma,psi,S0,I0,rep,time) -> dat

stopifnot(
  `ties in KS test`=dat |>
    count(p) |>
    filter(n>1) |>
    nrow()==0
)

dat |>
  group_by(S0) |>
  do(tidy(ks.test(x=.$p,y=punif))) |>
  select(p.value) -> pval
pval

dat |>
  ggplot(aes(x=p,group=S0,color=as.factor(S0)))+
  geom_abline(slope=1)+
  stat_ecdf()+
  annotate("text",x=0.2,y=0.8+c(0,-0.1),
    label=sprintf("P==%3.2f",pval$p.value),parse=TRUE)+
  coord_equal()+
  labs(x=expression(italic(p)),y=expression(italic(F(p))))+
  expand_limits(x=c(0,1),y=c(0,1))

dev.off()
