% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirws.R
\name{sirws}
\alias{sirws}
\alias{playSIRwS}
\alias{SIRwS}
\alias{sir_pomp}
\title{SIR with sampling simulator.}
\usage{
playSIRwS(
  data = NULL,
  Beta,
  gamma,
  psi,
  S0,
  I0,
  R0,
  t0 = 0,
  times,
  tree = FALSE,
  ill = FALSE
)

sir_pomp(data, Beta, gamma, psi, S0, I0, R0, t0 = 0)
}
\arguments{
\item{data}{data frame containing the genealogy in the format returned by \code{\link{newick2df}}.}

\item{Beta}{transmission rate.}

\item{gamma}{recovery rate.}

\item{psi}{sampling rate.}

\item{S0}{initial size of susceptible population.}

\item{I0}{initial size of infected population.}

\item{R0}{initial size of recovered population.}

\item{t0}{initial time}

\item{times}{times at which output is requested.}

\item{tree}{logical; represent the genealogical tree in Newick format?}

\item{ill}{logical; return an illustration?}
}
\value{
A \code{tibble} with \code{state} attribute.
}
\description{
Run the simulator.
}
\details{
\code{sir_pomp} constructs a \pkg{pomp} object containing a given set of data and a SIR model.
}
\examples{
playSIRwS(Beta=2,gamma=1,psi=2,S0=1000,I0=5,R0=0,times=0:5,t0=0,tree=TRUE) -> x
playSIRwS(x,times=6:10,psi=1,tree=TRUE) -> x
plot(x)

playSIRwS(Beta=3,gamma=1,psi=2,S0=10,I0=5,R0=0,times=0:5,t0=-1,tree=TRUE) -> x
plot(x,points=TRUE)

y <- getInfo(x)
plot(y,points=TRUE)

library(ggplot2)
y$lineages |>
  ggplot(aes(x=time,y=lineages))+
  geom_step()
}
\seealso{
Other Genealogy processes: 
\code{\link{lbdp}},
\code{\link{leventhal}},
\code{\link{moran}},
\code{\link{sirs}}
}
\concept{Genealogy processes}
