% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirs.R
\name{sirs}
\alias{sirs}
\alias{playSIRS}
\alias{SIRS}
\alias{sirs_pomp}
\title{SIRS with sampling simulator.}
\usage{
playSIRS(
  data = NULL,
  Beta,
  gamma,
  psi,
  Delta,
  S0,
  I0,
  R0,
  t0 = 0,
  times,
  tree = FALSE,
  ill = FALSE
)

sirs_pomp(data, Beta, gamma, psi, Delta, S0, I0, R0, t0 = 0)
}
\arguments{
\item{data}{data frame containing the genealogy in the format returned by \code{\link{newick2df}}.}

\item{Beta}{transmission rate.}

\item{gamma}{recovery rate.}

\item{psi}{sampling rate.}

\item{Delta}{waning rate of immunity.}

\item{S0}{initial size of susceptible population.}

\item{I0}{initial size of infected population.}

\item{R0}{initial size of recovered population.}

\item{t0}{initial time}

\item{times}{times at which output is requested.}

\item{tree}{logical; represent the genealogical tree in Newick format?}

\item{ill}{logical; return an illustration?}
}
\value{
A \code{tibble} with \code{state} attribute.
}
\description{
Run the simulator.
}
\details{
\code{sirs_pomp} constructs a \pkg{pomp} object containing a given set of data and a SIR model.
}
\seealso{
Other Genealogy processes: 
\code{\link{lbdp}},
\code{\link{leventhal}},
\code{\link{moran}},
\code{\link{sirws}}
}
\concept{Genealogy processes}
