% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newick2df.R
\name{newick2df}
\alias{newick2df}
\title{Convert a tree in Newick format to data frame}
\usage{
newick2df(tree, time = NA, root_time = 0)
}
\arguments{
\item{tree}{tree data in Newick format.}

\item{time}{time of the genealogy.}

\item{root_time}{time of the root.}
}
\value{
A data frame suitable for use as \code{pomp} input, containing three columns:
\describe{
  \item{time}{numeric; time of the genealogy event.}
  \item{lineages}{integer; the value of the lineage-count function at the specified time.
    Note that this function is right-continuous with left limits, and constant on the inter-event intervals.
  }
  \item{code}{integer; a code describing the nature of the event.
    1 indicates a coalescence;
    0 indicates a dead sample;
   -1 indicates a live sample;
    2 indicates the root.
  }
}
}
\description{
Convert a genealogical tree in Newick format to a data frame suitable for use with \pkg{pomp}.
}
\details{
If \code{time} is furnished, it is assumed that the absence of samples between the latest leaf and \code{time} is informative.

Invisible nodes (labeled 'X_' for any X) are dropped.
}
\examples{
playSIRwS(Beta=2,gamma=1,psi=2,S0=100,I0=2,R0=0,times=c(0,5),t0=0,tree=TRUE) -> x
y <- getInfo(x)
newick2df(y$tree) -> z

# compare to y$lineages
y$lineages |>
  all.equal(tail(z,-1)[,1:2],tolerance=1e-5)
}
