---
layout: lesson
---

The best way to learn how to program is to do something useful, so this
introduction to [MATLAB](https://en.wikipedia.org/wiki/MATLAB) is built around a common scientific task: data analysis.
Our real goal isn't to teach you MATLAB, but to teach you the basic concepts
that all programming depends on. We use MATLAB in our lessons because:

1. we have to use *something* for examples;
2. it's well-documented;
3. it has a large (and growing) user base among scientists in academia and industry; and
4. it has a large library of packages available for performing diverse tasks.

But the two most important things are to use whatever language your colleagues
are using, so that you can share your work with them easily, and to use that
language *well*.

> ## GNU Octave
>
> [GNU Octave](http://www.gnu.org/software/octave/) is a free and open-source alternative
> to MATLAB which shares its syntax ([see more about compatibility](http://en.wikipedia.org/wiki/GNU_Octave#MATLAB_compatibility)).
> Thus, if you don't have access to MATLAB, you can easily set up Octave
> on your computer and still work through the lesson.
{: .callout}

> ## Prerequisites
>
> To begin tackling this lesson, you will need to:
>
> * Understand the concepts of files and directories, and the concept of a "working directory".
> * Know how to start up MATLAB, and access the *command window* (which generally has a `>>` prompt).
> * Know how to create, edit and save text files.
{: .prereq}
