# DESCRIPTION DU JEU DE DONNÉES

*VERSION FRANÇAISE [ENGLISH VERSION BELOW]*

---

- Par un "corpus", on entend un ensemble des documents liés par une problématique ou un sujet d'étude commun.
- Par un "jeu de données", on entend un ensemble des documents, vue alors comme des données, d'un corpus.
- La différence entre un "corpus" et un "jeu de données" consiste dans la perspective à travers laquelle chaque élément de l'ensemble est abordé. Dans la perspective "historique", chaque élément est un document ; dans la perspective "informatique", chaque élément est une donnée.

---

## Information générale

### Intitulé du jeu des données

CartulR. Répertoire des cartulaires médiévaux et modernes

### Auteur(s) du jeu des données (affiliation)

- Bertrand, Paul (IRHT, Université catholique de Louvain)

### Date de la première mise en ligne (des données)

2021-03-12 (YYYY-DD-MM)

### Contributeur(s) (affiliation, rôle)

- de Valence, Maylis (Project member)
- Bourlet, Caroline (Project member)
- Quérol, Stella (Project member)
- Corvasier, Louise (Project member)
- Dufossé, Colette (Project member)
- Baron, Marlène Hélias (Project member)
- Jacob, Christophe (Project member)
- Porte, Guillaume (Project member)

### Financement(s)

### Description et présentation du corpus et du jeu des données

Le répertoire électronique de sources « CartulR » consiste en une base de données évolutive (et donc dans l’état actuel relativement incomplète voire lacunaire), dédiée aux cartulaires manuscrits. L’aire couverte au géographique : principalement la France et la Belgique ; au chronologique : de la naissance du genre au Moyen Âge à la fin de l’Ancien Régime, soit du IXe au XVIIIe s.

Le cartulaire est un recueil de copies de chartes médiévales et/ou modernes : sous la forme d’un codex, ce registre contient donc à la suite des copies d’actes dont les originaux sont souvent aujourd’hui perdus. La valeur de ces recueils est donc essentielle : ce sont là parmi les premières sources des historiens.

---

## Données

### Langues

#### Langues des données

 - Latin, Français

### Formats et logiciels

#### Formats des données (FAIR I1)

 - JSON

#### Logiciels utilisés (nom, version, système d’exploitation) (FAIR I1)

N'importe quel éditeur de texte capable de lire le format JSON.

#### Motivation des choix des formats et des logiciels (FAIR I1)

La plateforme TELMA où est hébergé le corpus "CartulR" propose deux types d'exports des données, en XML et en JSON. Aucun de ces deux formats d'export ne possède pas un schéma ou un modèle de données défini. Le format JSON a été dès lors choisi un format pour lequel il a été le plus simple de mettre en place un schéma de données (voir le dossier "documentation" qui accompagne ce dépôt.) 

### Provenance

#### Provenance et historique des données (FAIR R.1.2)

Le fichier JSON de données présentes dans ce dépôt est le résultat d'export depuis la [plateforme TELMA](https://telma-repertoires.irht.cnrs.fr/cartulr/page/presentation).

Voir également l'historique du projet: [historique du projet](https://telma-repertoires.irht.cnrs.fr/cartulr/page/historique)

### Standard et documentation

#### Standards et conventions utilisées pour les données (FAIR R1.3)

[JavaScript Object Notation (JSON)](https://www.json.org/json-fr.html)

#### Renvoi vers documentation / vocabulaire utilisés (FAIR I2)

Les données JSON ont été encodé selon le schéma JSON pérsonnalisé disponible dans le dossier "documentation" de ce dépôt.

Le standard de schéma JSON utilisé est le [Draft 2020-12](https://json-schema.org/draft/2020-12/schema).

[La documentation de schéma JSON Draft 2020-12](https://json-schema.org/draft/2020-12/json-schema-core.html).

### Droits et licences

#### Droit d'accès et licence des données (FAIR R1.1)

- Open Access

- Licence CC BY-NC-ND 4.0

### Données liées

#### Données liées (FAIR I3)

Aucune donnée liée.

---

# DATASET DESCRIPTION

*ENGLISH VERSION [VERSION FRANÇAISE PLUS HAUT]*

---

- By a "corpus", we mean a set of documents linked by a common problem or subject of study.
- By a "dataset", we mean a set of documents, seen then as data, of a given corpus.
- The difference between a "corpus" and a "dataset" is in the point of view through which each element of the set is approached. From the "historical" point of view, each element is a document; from the "digital" one, each element is a data. 

---

## General Information

### Title of the dataset

CartulR. Répertoire des cartulaires médiévaux et modernes

### Author(s) of the dataset (affiliation)

- Bertrand, Paul (IRHT, Université catholique de Louvain)

### Date of the first upload (of dataset)

2021-03-12 (YYYY-DD-MM)

### Contributor(s) (affiliation, role)

- de Valence, Maylis (Project member)
- Bourlet, Caroline (Project member)
- Quérol, Stella (Project member)
- Corvasier, Louise (Project member)
- Dufossé, Colette (Project member)
- Baron, Marlène Hélias (Project member)
- Jacob, Christophe (Project member)
- Porte, Guillaume (Project member)

### Funding(s)

### Description and presentation of the corpus and data

Le répertoire électronique de sources « CartulR » consiste en une base de données évolutive (et donc dans l’état actuel relativement incomplète voire lacunaire), dédiée aux cartulaires manuscrits. L’aire couverte au géographique : principalement la France et la Belgique ; au chronologique : de la naissance du genre au Moyen Âge à la fin de l’Ancien Régime, soit du IXe au XVIIIe s.

Le cartulaire est un recueil de copies de chartes médiévales et/ou modernes : sous la forme d’un codex, ce registre contient donc à la suite des copies d’actes dont les originaux sont souvent aujourd’hui perdus. La valeur de ces recueils est donc essentielle : ce sont là parmi les premières sources des historiens.

---

## Data

### Languages

#### Data languages

 - Latin, French

### Formats and software

#### Data formats (FAIR I1)

 - JSON

#### Software used (name, version, operating system) (FAIR I1)

Any text editor able to read the JSON files. 

#### Motivation behind of formats and software choices (FAIR I1)

The TELMA platform where the corpus "CartulR" is hosted offers two types of data exports, in XML and JSON formats. Neither of these two export formats has a defined schema or data model. The JSON format was chosen as a format with the easiest data schema set up procedures (for JSON schema see the folder "documentation" in root of this upload).

### Origin

#### Provenance and history of data (FAIR R.1.2)

The JSON data file in this repository is the result of exporting from the [TELMA platform](https://telma-repertoires.irht.cnrs.fr/cartulr/page/presentation).

Also see history of the project: [history of the project](https://telma-repertoires.irht.cnrs.fr/cartulr/page/historique)

### Standard and documentation

#### Standards and conventions used for data (FAIR R1.3)

[JavaScript Object Notation (JSON)](https://www.json.org/json-en.html)

#### Reference to used documentation and vocabulary (FAIR I2)

The JSON data has been encoded according to the custom JSON schema available in the "documentation" folder of this upload.

Le standard de schéma JSON utilisé est le [Draft 2020-12](https://json-schema.org/draft/2020-12/schema).

[La documentation de schéma JSON Draft 2020-12](https://json-schema.org/draft/2020-12/json-schema-core.html).

### Rights and licences

#### Right of access and data usage license (FAIR R1.1)

- Open Access

- Licence CC BY-NC-ND 4.0

### Linked data

#### Linked data (FAIR I3)

No linked data.
