---
layout: lesson
---

Introduction to R for non-programmers using gapminder data.

The goal of this lesson is to teach novice programmers to write modular code
and best practices for using R for data analysis. R is commonly used in many
scientific disciplines for statistical analysis and its array of third-party
packages. We find that many scientists who come to Software Carpentry workshops
use R and want to learn more. The emphasis of these materials is to give
attendees a strong foundation in the fundamentals of R, and to teach best
practices for scientific computing: breaking down analyses into modular units,
task automation, and encapsulation.

Note that this workshop will focus on teaching the fundamentals of the
programming language R, and will not teach statistical analysis.

A variety of third party packages are used throughout this workshop. These
are not necessarily the best, nor are they comprehensive, but they are
packages we find useful, and have been chosen primarily for their
usability.

> ## Prerequisites
>
> Understand that computers store data and instructions (programs, scripts etc.) in files.
> Files are organised in directories (folders).
> Know how to access files not in the working directory by specifying the path.
{: .prereq}
