---
pretty_name: Reuters-21578 Text Categorization Collection
languages:
- en
paperswithcode_id: reuters-21578
---

# Dataset Card for "reuters21578"

## Table of Contents
- [Dataset Description](#dataset-description)
  - [Dataset Summary](#dataset-summary)
  - [Supported Tasks and Leaderboards](#supported-tasks-and-leaderboards)
  - [Languages](#languages)
- [Dataset Structure](#dataset-structure)
  - [Data Instances](#data-instances)
  - [Data Fields](#data-fields)
  - [Data Splits](#data-splits)
- [Dataset Creation](#dataset-creation)
  - [Curation Rationale](#curation-rationale)
  - [Source Data](#source-data)
  - [Annotations](#annotations)
  - [Personal and Sensitive Information](#personal-and-sensitive-information)
- [Considerations for Using the Data](#considerations-for-using-the-data)
  - [Social Impact of Dataset](#social-impact-of-dataset)
  - [Discussion of Biases](#discussion-of-biases)
  - [Other Known Limitations](#other-known-limitations)
- [Additional Information](#additional-information)
  - [Dataset Curators](#dataset-curators)
  - [Licensing Information](#licensing-information)
  - [Citation Information](#citation-information)
  - [Contributions](#contributions)

## Dataset Description

- **Homepage:** [https://kdd.ics.uci.edu/databases/reuters21578/reuters21578.html](https://kdd.ics.uci.edu/databases/reuters21578/reuters21578.html)
- **Repository:** [More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)
- **Paper:** [More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)
- **Point of Contact:** [More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)
- **Size of downloaded dataset files:** 23.32 MB
- **Size of the generated dataset:** 49.80 MB
- **Total amount of disk used:** 73.12 MB

### Dataset Summary

The Reuters-21578 dataset  is one of the most widely used data collections for text
categorization research. It is collected from the Reuters financial newswire service in 1987.

### Supported Tasks and Leaderboards

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Languages

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

## Dataset Structure

We show detailed information for up to 5 configurations of the dataset.

### Data Instances

#### ModApte

- **Size of downloaded dataset files:** 7.77 MB
- **Size of the generated dataset:** 12.45 MB
- **Total amount of disk used:** 20.23 MB

An example of 'train' looks as follows.
```
This example was too long and was cropped:

{
    "cgis_split": "\"TRAINING-SET\"",
    "date": "19-MAR-1987 06:17:22.36",
    "exchanges": [],
    "lewis_split": "\"TRAIN\"",
    "new_id": "\"7001\"",
    "old_id": "\"11914\"",
    "orgs": [],
    "people": [],
    "places": ["australia"],
    "text": "\"Media group John Fairfax Ltd &lt;FFXA.S>\\nsaid that its flat first half net profit partly reflected the\\nimpact of changes in t...",
    "title": "FAIRFAX SAYS HIGHER TAX HITS FIRST HALF EARNINGS",
    "topics": ["earn"]
}
```

#### ModHayes

- **Size of downloaded dataset files:** 7.77 MB
- **Size of the generated dataset:** 18.87 MB
- **Total amount of disk used:** 26.64 MB

An example of 'train' looks as follows.
```
This example was too long and was cropped:

{
    "cgis_split": "\"TRAINING-SET\"",
    "date": "19-OCT-1987 23:49:31.45",
    "exchanges": [],
    "lewis_split": "\"TEST\"",
    "new_id": "\"20001\"",
    "old_id": "\"20596\"",
    "orgs": [],
    "people": [],
    "places": ["japan", "usa"],
    "text": "\"If the dollar goes the way of Wall Street,\\nJapanese will finally move out of dollar investments in a\\nserious way, Japan inves...",
    "title": "IF DOLLAR FOLLOWS WALL STREET JAPANESE WILL DIVEST",
    "topics": ["money-fx"]
}
```

#### ModLewis

- **Size of downloaded dataset files:** 7.77 MB
- **Size of the generated dataset:** 18.48 MB
- **Total amount of disk used:** 26.26 MB

An example of 'train' looks as follows.
```
This example was too long and was cropped:

{
    "cgis_split": "\"TRAINING-SET\"",
    "date": "19-MAR-1987 06:17:22.36",
    "exchanges": [],
    "lewis_split": "\"TRAIN\"",
    "new_id": "\"7001\"",
    "old_id": "\"11914\"",
    "orgs": [],
    "people": [],
    "places": ["australia"],
    "text": "\"Media group John Fairfax Ltd &lt;FFXA.S>\\nsaid that its flat first half net profit partly reflected the\\nimpact of changes in t...",
    "title": "FAIRFAX SAYS HIGHER TAX HITS FIRST HALF EARNINGS",
    "topics": ["earn"]
}
```

### Data Fields

The data fields are the same among all splits.

#### ModApte
- `text`: a `string` feature.
- `topics`: a `list` of `string` features.
- `lewis_split`: a `string` feature.
- `cgis_split`: a `string` feature.
- `old_id`: a `string` feature.
- `new_id`: a `string` feature.
- `places`: a `list` of `string` features.
- `people`: a `list` of `string` features.
- `orgs`: a `list` of `string` features.
- `exchanges`: a `list` of `string` features.
- `date`: a `string` feature.
- `title`: a `string` feature.

#### ModHayes
- `text`: a `string` feature.
- `topics`: a `list` of `string` features.
- `lewis_split`: a `string` feature.
- `cgis_split`: a `string` feature.
- `old_id`: a `string` feature.
- `new_id`: a `string` feature.
- `places`: a `list` of `string` features.
- `people`: a `list` of `string` features.
- `orgs`: a `list` of `string` features.
- `exchanges`: a `list` of `string` features.
- `date`: a `string` feature.
- `title`: a `string` feature.

#### ModLewis
- `text`: a `string` feature.
- `topics`: a `list` of `string` features.
- `lewis_split`: a `string` feature.
- `cgis_split`: a `string` feature.
- `old_id`: a `string` feature.
- `new_id`: a `string` feature.
- `places`: a `list` of `string` features.
- `people`: a `list` of `string` features.
- `orgs`: a `list` of `string` features.
- `exchanges`: a `list` of `string` features.
- `date`: a `string` feature.
- `title`: a `string` feature.

### Data Splits

#### ModApte

|       |train|unused|test|
|-------|----:|-----:|---:|
|ModApte| 8762|   720|3009|

#### ModHayes

|        |train|test|
|--------|----:|---:|
|ModHayes|18323| 720|

#### ModLewis

|        |train|unused|test|
|--------|----:|-----:|---:|
|ModLewis|12449|   720|5458|

## Dataset Creation

### Curation Rationale

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Source Data

#### Initial Data Collection and Normalization

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

#### Who are the source language producers?

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Annotations

#### Annotation process

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

#### Who are the annotators?

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Personal and Sensitive Information

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

## Considerations for Using the Data

### Social Impact of Dataset

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Discussion of Biases

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Other Known Limitations

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

## Additional Information

### Dataset Curators

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Licensing Information

[More Information Needed](https://github.com/huggingface/datasets/blob/master/CONTRIBUTING.md#how-to-contribute-to-the-dataset-cards)

### Citation Information

```
@article{APTE94,
author = {Chidanand Apt{'{e}} and Fred Damerau and Sholom M. Weiss},
title = {Automated Learning of Decision Rules for Text Categorization},
journal = {ACM Transactions on Information Systems},
year = {1994},
note = {To appear.}
}

@inproceedings{APTE94b,
author = {Chidanand Apt{'{e}} and Fred Damerau and Sholom M. Weiss},
title = {Toward Language Independent Automated Learning of Text Categorization Models},
booktitle = {sigir94},
year = {1994},
note = {To appear.}
}

@inproceedings{HAYES8},
author = {Philip J. Hayes and Peggy M. Anderson and Irene B. Nirenburg and
Linda M. Schmandt},
title = {{TCS}: A Shell for Content-Based Text Categorization},
booktitle = {IEEE Conference on Artificial Intelligence Applications},
year = {1990}
}

@inproceedings{HAYES90b,
author = {Philip J. Hayes and Steven P. Weinstein},
title = {{CONSTRUE/TIS:} A System for Content-Based Indexing of a
Database of News Stories},
booktitle = {Second Annual Conference on Innovative Applications of
Artificial Intelligence},
year = {1990}
}

@incollection{HAYES92 ,
author = {Philip J. Hayes},
title = {Intelligent High-Volume Text Processing using Shallow,
Domain-Specific Techniques},
booktitle = {Text-Based Intelligent Systems},
publisher = {Lawrence Erlbaum},
address =  {Hillsdale, NJ},
year = {1992},
editor = {Paul S. Jacobs}
}

@inproceedings{LEWIS91c ,
author = {David D. Lewis},
title = {Evaluating Text Categorization},
booktitle = {Proceedings of Speech and Natural Language Workshop},
year = {1991},
month = {feb},
organization = {Defense Advanced Research Projects Agency},
publisher = {Morgan Kaufmann},
pages = {312--318}

}

@phdthesis{LEWIS91d,
author = {David Dolan Lewis},
title = {Representation and Learning in Information Retrieval},
school = {Computer Science Dept.; Univ. of Massachusetts; Amherst, MA 01003},
year = 1992},
note = {Technical Report 91--93.}
}

@inproceedings{LEWIS91e,
author = {David D. Lewis},
title = {Data Extraction as Text Categorization: An Experiment with
the {MUC-3} Corpus},
booktitle = {Proceedings of the Third Message Understanding Evaluation
and Conference},
year = {1991},
month = {may},
organization = {Defense Advanced Research Projects Agency},
publisher = {Morgan Kaufmann},
address = {Los Altos, CA}

}

@inproceedings{LEWIS92b,
author = {David D. Lewis},
title = {An Evaluation of Phrasal and Clustered Representations on a Text
Categorization Task},
booktitle = {Fifteenth Annual International ACM SIGIR Conference on
Research and Development in Information Retrieval},
year = {1992},
pages = {37--50}
}

@inproceedings{LEWIS92d ,
author = {David D. Lewis and Richard M. Tong},
title = {Text Filtering in {MUC-3} and {MUC-4}},
booktitle = {Proceedings of the Fourth Message Understanding Conference ({MUC-4})},
year = {1992},
month = {jun},
organization = {Defense Advanced Research Projects Agency},
publisher = {Morgan Kaufmann},
address = {Los Altos, CA}
}

@inproceedings{LEWIS92e,
author = {David D. Lewis},
title = {Feature Selection and Feature Extraction for Text Categorization},
booktitle = {Proceedings of Speech and Natural Language Workshop},
year = {1992},
month = {feb} ,
organization = {Defense Advanced Research Projects Agency},
publisher = {Morgan Kaufmann},
pages = {212--217}
}

@inproceedings{LEWIS94b,
author = {David D. Lewis and Marc Ringuette},
title = {A Comparison of Two Learning Algorithms for Text Categorization},
booktitle = {Symposium on Document Analysis and Information Retrieval},
year = {1994},
organization = {ISRI; Univ. of Nevada, Las Vegas},
address = {Las Vegas, NV},
month = {apr},
pages = {81--93}
}

@article{LEWIS94d,
author = {David D. Lewis and Philip J. Hayes},
title = {Guest Editorial},
journal = {ACM Transactions on Information Systems},
year = {1994},
volume  = {12},
number  = {3},
pages = {231},
month = {jul}
}

@article{SPARCKJONES76,
author = {K. {Sparck Jones} and  C. J. {van Rijsbergen}},
title =  {Information Retrieval Test Collections},
journal = {Journal of Documentation},
year = {1976},
volume = {32},
number = {1},
pages = {59--75}
}

@book{WEISS91,
author = {Sholom M. Weiss and Casimir A. Kulikowski},
title = {Computer Systems That Learn},
publisher = {Morgan Kaufmann},
year = {1991},
address = {San Mateo, CA}
}

```


### Contributions

Thanks to [@jplu](https://github.com/jplu), [@jbragg](https://github.com/jbragg), [@thomwolf](https://github.com/thomwolf), [@mariamabarham](https://github.com/mariamabarham), [@lhoestq](https://github.com/lhoestq) for adding this dataset.