# Changes in netdiffuseR version 1.16.7 (2016-07-07)

## Bug fixes

* Fixed bug in `struct_equiv`: When `groupvar` was a list (dynamic attr), the
  function returned error.
  
* Fixed bug in `rewire_graph.array`: Returned error when `algorithm="swap"`

* Fixed bug in `rewire_graph`: The option `copy.first` was not been applied correctly.

* In `hist.diffnet_struct_test`: `...` now passed to `hist.default`.

* Fixed bug on `egonet_attrs`: The matrix method was returning with error.

## New features and changes

* `plot_infectsuscept` includes 2D kernel smoother via `MASS::kde2d`.

* `infection`, `susceptibility` and `threshold` now report `NA` for non-adopters
  or excluded variables.
  
* `egonets_attrs` now has new argument: `self.attrs` allows including ego's attributes
  as part of the outcome so it can be used by the user.
  
* `plot_diffnet` now uses `igraph::plot.igraph` for plotting instead

* `threshold` gains a new argument: `lags` now users can define threshold as
  exposure `lags` time periods prior to the time of adoption. By default is 0
  so its exposure at the time of adoption.
  

## New functions

* New method `c.diffnet_struct_test`: A wrapper of `boot:::c.boot`.

* `diffusionMap` computes the required matrix to be used with
  `image`-like functions mapping a vertex covariate given a graph structure.
  
* `n_rewires`: computes a suggested number of rewires per step in order to attain
  unbiased graph samples.
  
* `diffnetLapply`: Apply throught periods on diffnet objects.

* Several new methods for the class `diffnet`. Now users can apply `str`,
  `dimnames` (so `colnames` and `rownames`), `t`, `&`, `|`, `dim` and `%*%`.
  
* `drawColorKey`: Handy function to draw a color key in the current plot.

* `classify_adopters`: As in Valente (1995), depending on time of adoption, adopters
  are classified as early adopters, early  majority, late majority, and laggards.
  The function introduces a new class and has methods for `ftable` and `plot`.
  
* `rescale_vertex_igraph`: Helper function to fix the size of vertex when calling
  `plot.igraph` so that the size is proportional to the x-axis.


# Changes in netdiffuseR version 1.16.5 (2016-05-02)

## Bug fixes

* Bug fixed on `edgelist_to_adjmat`: Counting number of vertices is now done
  right after `recode`. (Reported by Tom)

* Fixed bug in `diffnet.attrs(..., as.df=TRUE)`. ids were wrongly retrieved.

* Fixed bugs for `rgraph_ba_cpp`: Degree of new vertices was not changing apropiately.
  This only was an issue when `m>1`.
  
* Fixed bugs for the `as_diffnet` method for arrays.
  
* Fixed bugs in `rewire_graph`. Indexing of the jth component (when rewiring) was
  not been made correctly (now it does). Also, when rewiring, the new endpoints
  were truncated to n-1 (now fixed).
  
* Fixed bugs for `as_diffnet`: When a dynamic graph was passed with slices names
  different from the time periods, the slices names were kept. Now these are
  replaced by `meta$pers`.


## New features and changes

* Support for `int64_t` in `RcppArmadillo` now allows for creating/reading
  adjacency matrices with more than 4 billion elements (big graphs).

* In `edgelist_to_adjmat` `use.incomplete` has been replaced by `keep.isolated`
  which makes more sense for naming. Incomplete cases on `times` or `weights` are
  still ignored (as these cannot be processed by the c++ 'engine'). (Reported by Tom)
  
* In `edgelist_to_adjmat` `times` has been replaced by `t0` and `t1`. So now
  the user can import graphs with spells.
  
* Added new elements to the `diffnet_struct_test` class: `p.value`, `t0`,
  `mean_t`, and `R`. All these were available before either to be computed
  or retrieved from the `boot` list at the class.
  
* New argument for `threshold`. Now, by default, threshold levels are not computed
  for adopters in the first time period as this can be a biased estimate. If
  the user wants to compute such, he/she can set `include_censored=TRUE`.
  
* Attributes in diffnet objects are now stored as data frames (instead of
  matrices). This affects the function `diffnet.attrs`, and `egonet_attrs` as
  these use attributes directly. (Requested by Tom)

* New features for the `rewire_graph` function. In particular, `p` can now be
  a vector of length `T`, so each slice can have different rewiring prob., and
  the new option `copy.first` which allows to recycle the first rewired slice
  (see details).
  
* New features for the `exposure` function. When `graph` is of class diffnet, 
  the function accepts `attrs` equal to the name of some the graph's attributes.
  Also, `alt.graph` can be specified as `se`, which will be replaced by the
  inverse of the structural equivalence. When `valued=FALSE` the function will
  switch it to `TRUE` and warn the user.
  
* New argument for `struct_equiv` and `exposure`, `groupvar`. This new option
  provides a convenient way of calculating structural equivalence and
  exposure clusterized by group. Specially useful when there are different
  communities in a graph. See examples in the manual.
  
* `as_diffnet` now has an internal function, `check_as_diffnet_attrs`, to check
  input attributes dimensions and coerce them into proper class/structure. Valid
  attributes are now documented in the function's manual.
  
* New arguments for `edges_coords`: `dev` and `ran` allow including device +
  margins aspec ratio and plotting area y/x limits for improved aspect ratio
  computation.

* New internal function `edges_arrow`: Computes the coordinates of a 4 points
  polygon allowing to draw pretty arrows considering aspec ratio of device,
  margins and y/x.

* Geodesic distances are now computed using `igraph::distances` instead of
  `sna::geodist` as it is more flexible and faster.
  
* New arguments for `plot_threshold`: `vertex.sides`, `vertex.lab.cex`, `vertex.lab.adj`,
  `vertex.lab.col`, `vertex.rot`, `jitter.factor`, and `jitter.amount` to give
  more control.
  
* New internal function `vertex_coords`: Creates polygons of any given number of
  sides considering aspec ratio of both x/y and device.
  
* New features for `rdiffnet`. `seed.graph` can be either a function that generates
  a random graph, a character string (as before) indicating the class of graph
  to generate, or any other class of graph (either static or dynamic) as specified
  in `netdiffuseR-graphs`. `seed.nodes` can now be a vector with indices pointing
  to the initial adopters.
  
* The rewiring algorithm for `rgraph_ws` has been replaced with a `rewire_ws` which
  has been implemented as it was presented in Watts and Strogatz (1998).

## New functions

* New function: `survey_to_diffnet`. This function allows importing network
  nomination data (in survey fashion) of both types, cross-section and panel
  formats (static network only varying adoption, or dynamic network varying
  attributes and network structure simultaneously).
  
* New function: `edgelist_to_diffnet`. Similar to `survey_to_diffnet`, this
  function reads diffusion networks from an adjacency matrix and a vertex
  attributes data frame. Both the attributes and the edgelist can be static
  or dynamic.

* New method: `as.array.diffnet`.

* New functions: `read_pajek` and `read_ucinet`. Still on development.

* New functions: `nvertices` and `nedges` return the number of vertices and
  edges that a graph has. This can be applied to any class of graph accepted
  by the package.

* New indexing methods via `[[.diffnet`, `[[<-.diffnet`, for network attributes
  and `[.diffnet` and `[<-.diffnet` for adjacency matrix. The function
  `diffnet.attrs<-` will be deprecated for the next CRAN release. The function
  `diffnet.subset.slices` is now not exported (internal use), so the user
  needs to use the `[.diffnet` method instead.

* New concatenating method `c.diffnet` for diffnet objects. This method allows
  'adding up' diffnet objects.

* New print method for `diffnet_se`, objects returned by `struct_equiv`.

* New function `diffnet_to_igraph`.

* New rewiring algorithm, `rewire_swap` implements the edge-switch algorithm in
  an efficient way. This preserves degree sequences.


# Changes in netdiffuseR version 1.16.2 (2016-02-18)

* First CRAN version.



