nHidden=3
source('funk.R')
dataset='dataset_XV_1971-1990' # 'dataset_XV' #
dataset_full='dataset_full'

# Get data and results from cross-validation experiment ----
load(file.path(dataset,'data','dataset.RData'))
load(file.path(dataset,'data','validation.RData'))
dir0=file.path(getwd(),dataset)
HCIdir=paste0(file.path(dir0,'runs','HCI'),1:nHidden)
varnames=sort(as.character(unique(dat$var)))
load(file.path(HCIdir[nHidden],'uniPred.RData'))
load(file.path(HCIdir[nHidden],'model.RData'))
load(file.path(dataset,'mcmc.RData'))

# Gauged sites but ungauged decade for Pd----
obs=data.frame(var=as.character(dat_C_V$var),site=dat_C_V$site,year=dat_C_V$year,
               tstep=dat_C_V$year-period[1]+1,value=dat_C_V$value)
fullPred=matchPreds(dataset,dataset_full,varnames,doValidSites=F)
uniFull=fullPred$uni;uniIDFull=fullPred$uniID
varname='Pd'
diagn=getXVDiagnostics(varname,obs,uni,uniID,uniFull,uniIDFull)
# plot
g1=plotOvp(diagn$ovp,varname)+labs(title='A')+ theme(plot.title=element_text(size=18)) 
g2=plotPit(diagn$pit)+labs(title='B')+theme(plot.title=element_text(size=18)) 
g3=plotSharp(diagn$sharp)+labs(title='C')+theme(plot.title=element_text(size=18)) 
# save
f=file.path(dir0,'XVdiag1.pdf')
pdf(file=f,width=10, height=4,useDingbats=F)
g=grid.arrange(grobs=list(g1,g2,g3),layout_matrix=matrix(c(1,1,1,1,2,3),2,3))
dev.off()

# Ungauged sites----
obs=data.frame(var=as.character(dat_V$var),site=dat_V$site,year=dat_V$year,
               tstep=dat_V$year-period[1]+1,value=dat_V$value)
obs=obs[obs$year %in% period,] # remove out-of-period years 
estimate=aggregateHCIestimates()
ovp=c();pit=c();sharp=c()
fullPred=matchPreds(dataset,dataset_full,varnames,doValidSites=T)
uniFull=fullPred$uni;uniIDFull=fullPred$uniID
for(varname in varnames){
  space=get(paste0('space',substr(varname,1,1),'_XV'))
  K=krig(estimate,space,varname)
  foo=generateUniPred_XV(varname,mod,mcmcHCI,K$mean,K$var)
  uni=foo$uni
  uniID=cbind(foo$uniID,var=varname)
  o=obs[obs$var==varname,]
  diagn=getXVDiagnostics(varname,o,uni,uniID,uniFull,uniIDFull)
  ovp=rbind(ovp,diagn$ovp)
  pit=rbind(pit,diagn$pit)
  sharp=rbind(sharp,diagn$sharp)
}
# plot
varname='Pd';DF=ovp[ovp$var==varname,]
g1=plotOvp(DF,varname)+labs(title='A')+ theme(plot.title=element_text(size=18))
g2=plotPit(pit)+labs(title='B')+ theme(plot.title=element_text(size=18))
g3=plotSharp(sharp)+labs(title='C')+ theme(plot.title=element_text(size=18))
# save
f=file.path(dir0,'XVdiag2.pdf')
pdf(file=f,width=12, height=4,useDingbats=F)
g=grid.arrange(grobs=list(g1,g2,g3),layout_matrix=matrix(c(1,1,2,3),2,2))
dev.off()

# Tasmania ----
TasP=which(spaceP_XV$V$lat < -40)
TasQ=which(spaceQ_XV$V$lat < -40)
TasT=which(spaceT_XV$V$lat < -40)
# Obs vs. pred
DF=ovp[ovp$var=='Pd' & ovp$site %in% TasP,]
g1=plotOvp(DF,'Pd')+labs(title='A')+ theme(plot.title=element_text(size=18))
# PIT : need to recompute frequencies
mask= (pit$var=='Pd' & pit$site %in% TasP) | (pit$var=='Qd' & pit$site %in% TasQ) |
  (pit$var=='Tn' & pit$site %in% TasT) | (pit$var=='Tx' & pit$site %in% TasT) 
foo=pit[mask,]
for(d in unique(foo$dataset)){
  for(v in unique(foo$var)){
    mask = (foo$dataset==d & foo$var==v)
    foo$freq[mask]=(rank(foo$PIT[mask])-0.5)/sum(mask)
  }
}
g2=plotPit(foo)+labs(title='B')+ theme(plot.title=element_text(size=18))
# Sharpness: need to hack Pd to have more than 1 site so that the violin displays a line
mask= (sharp$var=='Pd' & sharp$site %in% TasP) | (sharp$var=='Qd' & sharp$site %in% TasQ) |
  (sharp$var=='Tn' & sharp$site %in% TasT) | (sharp$var=='Tx' & sharp$site %in% TasT) 
foo=sharp[mask,] 
hacked=foo[foo$var=='Pd',] # this will be duplicated
foo=rbind(foo,hacked,hacked)# duplicate so that violin draws a line rather than nothing
g3=plotSharp(foo)+labs(title='C')+ theme(plot.title=element_text(size=18))
# save
f=file.path(dir0,'XVdiag2_Tasmania.pdf')
pdf(file=f,width=12, height=4,useDingbats=F)
g=grid.arrange(grobs=list(g1,g2,g3),layout_matrix=matrix(c(1,1,2,3),2,2))
dev.off()


