doAll=F
dataset='dataset_full' # 'dataset_XV' # 'dataset_XV_1971-1990' # 
nHidden=3

# load functions, data and define basic stuff
source('funk.R')
load(file.path(dataset,'data','dataset.RData'))
dir0=file.path(getwd(),dataset)
HCIdir=paste0(file.path(dir0,'runs','HCI'),1:nHidden)
SCIdir=file.path(dir0,'runs','SCI')
varnames=sort(as.character(unique(dat$var)))

# Analyze all MCMC ----
if(F | doAll){
  for(dir in c(HCIdir,SCIdir)){
    foo=analyseMCMC(dir,doTrace=FALSE)
    mcmc=foo$mcmc
    GR=foo$GR
    save(GR,file=file.path(dir,'GR.RData'))
    save(mcmc,file=file.path(dir,'mcmc.RData'))
  }
}

# save MCMC as RData (including merging stepwise results for HCI model) ----
if(F | doAll){
  # SCI - just read
  mcmcSCI=analyseMCMC(SCIdir,readOnly=TRUE)
  agg=c()
  # HCI - read and aggregate steps from the stepwise inference
  for(i in seq(length(HCIdir),1,-1)){ # start from the last HCI
    mcmc=analyseMCMC(HCIdir[i],readOnly=TRUE)
    # Do not add columns that are already there
    indx=which(!(names(mcmc) %in% agg))
    foo=mcmc[,indx]
    if(i==length(HCIdir)){mcmcHCI=foo} else {mcmcHCI=cbind(mcmcHCI,foo)}
    agg=c(agg,names(mcmc)) # apdate list of already-present columns
  }
  save(mcmcSCI,mcmcHCI,file=file.path(dir0,'mcmc.RData'))
}

# Plot a few selected MCMC traces ----
if(F | doAll){
  nchain=length(list.files(HCIdir[1],pattern='chain'))
  load(file.path(dir0,'mcmc.RData'))
  chain=rep(1:nchain,each=NROW(mcmcHCI)/nchain)
  iter=rep(1:(NROW(mcmcHCI)/nchain),nchain)
  DF=data.frame();set.seed(12345)
  # select examples of 'poor' convergence, GR around 1.2
  cols0=c('tau1_10','Qd_m3_m') 
  # remove taui_m and taui_s, which are fixed
  ix=which(!(names(mcmcHCI) %in% c(cols0,paste0('tau',1:3,'_m'),paste0('tau',1:3,'_s'))))
  # randomly sample columns
  cols=c(cols0,sort(names(mcmcHCI)[sample(ix,50-2)]))
  for(i in 1:length(cols)){
    DF=rbind(DF,data.frame(iteration=iter,value=mcmcHCI[[cols[i]]],chain=factor(chain),par=cols[[i]]))
  }
  g=ggplot(DF,aes(iteration,value,group=chain))+geom_line(aes(color=chain),alpha=0.7)
  g=g+scale_color_brewer(palette='Set1')+theme_bw()
  g=g+theme(legend.position='none',panel.grid=element_blank())
  g=g+facet_wrap(vars(par),scales='free_y',ncol=5)
  f=file.path(dir0,'fewTraces.pdf')
  pdf(file=f,width=8,height=10,useDingbats=FALSE)
  print(g)
  dev.off()
}

# Plot data availability ----
if(F | doAll){
  colors=RColorBrewer::brewer.pal(3,'Set1') # colors associated with each network
  g1=mapNetwork(list(spaceT,spaceP,spaceQ),colors)
  g2=plotAvailability(dat[dat$year %in% period,])
  #save
  f=file.path(dir0,'Dataset.pdf')
  pdf(file=f,width=6,height=4,useDingbats=FALSE)
  grid.arrange(grobs=c(g1,list(g2)),layout_matrix=rbind(1:3,rep(4,3)))
  dev.off()
}

# Plot HCIs and their effect ----
if(F | doAll){
  g=plotHCIs(file.path(dir0,'runs'))
  # HCIs
  f=file.path(dir0,'HCIs.pdf')
  pdf(file=f,width=6,height=6,useDingbats=FALSE)
  print(g)
  dev.off()
  # HCI and SCI effects
  g=plotHCIsEffects(version=1,limits=c(0.049,0.604,0.47,0.19))
  f=file.path(dir0,'Effects.pdf')
  pdf(file=f,width=8,height=2*length(varnames),useDingbats=FALSE)
  grid.arrange(grobs=g,nrow=length(varnames))
  dev.off()
}

# Properties of HCIs and SCIs ----
if(F | doAll){
  H=getCIs(isHidden=TRUE);S=getCIs(isHidden=FALSE);both=cbind(H,S)
  cor(both)
  for(i in 1:NCOL(both)){
    if(i==1 | i==NCOL(H)+1){
      nr=ifelse(i==1,NCOL(H),NCOL(S))
      X11(width=15);par(mfrow=c(nr,5))
    }
    z=both[,i]
    foo=sens.slope(z)
    tr=((1:NROW(z))-0.5*NROW(z))*foo$estimates
    main=paste0('trend:',round(foo$estimates,2),' (pval:',round(foo$p.value,2),')')
    plot(z,type='l',main=main);lines(tr)
    acf(z,main='raw time series',ci=0.95)
    acf(z-tr,main='detrended time series',ci=0.95)
    spectrum(z,method = 'ar')
    spectrum(z-tr,method = 'ar')
  }
}

# Generate univariate predictions ----
if(F | doAll){
  for(f in c(HCIdir[length(HCIdir)],SCIdir)){
    load(file.path(f,'model.RData'))
    uni=c();uniID=c()
    for(varname in varnames){
      #foo=generateUniPred(varname,mod)
      if(f==SCIdir){mcmc=mcmcSCI} else {mcmc=mcmcHCI}
      foo=generateUniPred2(varname,mod,mcmc)
      uni=rbind(uni,foo$uni)
      uniID=rbind(uniID,cbind(foo$uniID,var=varname))
    }
    save(uni,uniID,file=file.path(f,'uniPred.RData'))
  }
}

# Properties of univariate predictions ----
if(F | doAll){
  myOrder=c('ALL','Qd','Pd','Tx','Tn')
  gs=vector(mode='list',length=4)
  for(f in c(HCIdir[length(HCIdir)],SCIdir)){
    isHidden=(f!=SCIdir)
    # load univariate predictions and compute variance explained
    load(file.path(f,'uniPred.RData'))
    vx=varExplained(uni,uniID,varOrder=myOrder,title=ifelse(isHidden,'HCI','SCI'))
    # load model, retrieve observations and compute p-values
    load(file.path(f,'model.RData'))
    site=apply(mod$dataset$iDim[c('ispaceP','ispaceQ','ispaceT')],1,sum)
    if(isHidden){tstep=mod$dataset$iDim$itime} else {tstep=mod$dataset$X$jtime}
    obs=cbind(value=mod$dataset$Y,var=mod$dataset$var,site=site,tstep=tstep)
    pit=PITvalues(obs,uni,uniID,varOrder=myOrder,title=ifelse(isHidden,'HCI','SCI'))
    # plots 
    gs[[ifelse(isHidden,1,2)]]=vx$g
    gs[[ifelse(isHidden,3,4)]]=pit$g
  }
  f=file.path(dir0,'PIT.pdf')
  pdf(file=f,width=12, height=8,useDingbats=F)
  gridExtra::grid.arrange(grobs=gs,nrow=1)
  dev.off()
}

# Plot univariate and bivariate plots ----
if(dataset=='dataset_full') {
  fewSites=data.frame(var=c('Qd','Pd','Pd','Tx','Tn'), # variable name
                      site=c(233,54,56,23,23), # site index
                      mini=c(0,0.75,0.75,0,0), # minimum value in plots
                      maxi=c(1,1,1,8,8), # maximum value in plots
                      stringsAsFactors=FALSE)
} else { #Different sites in cross-validation since some of the above have been left out
  fewSites=data.frame(var=c('Qd','Pd','Pd','Tx','Tn'), # variable name
                      site=c(153,36,37,14,14), # site index
                      mini=c(0,0.75,0.75,0,0), # minimum value in plots
                      maxi=c(1,1,1,8,8), # maximum value in plots
                      stringsAsFactors=FALSE)
}
nfew=NROW(fewSites)
if(F | doAll){
  for(folder in c(HCIdir[length(HCIdir)],SCIdir)){
    isHidden=(folder!=SCIdir)
    lbl=ifelse(isHidden,'HCI','SCI')
    clr=ifelse(isHidden,'red','blue')
    load(file.path(folder,'model.RData'))
    load(file.path(folder,'uniPred.RData'))
    res=plotFewSites(fewSites,mod,uni,uniID,fill=clr)
    # save plots
    f=file.path(dir0,paste0('fewSitesUnivariate_',lbl,'.pdf'))
    pdf(file=f,width=8, height=2*length(res$univariate),useDingbats=F)
    gridExtra::grid.arrange(grobs=res$univariate,ncol=1)
    dev.off()
    f=file.path(dir0,paste0('fewSitesBivariate_',lbl,'.pdf'))
    pdf(file=f,width=3*(nfew-1), height=3*ceiling(length(res$bivariate)/(nfew-1)),useDingbats=F)
    gridExtra::grid.arrange(grobs=res$bivariate,ncol=nfew-1)
    dev.off()
  }
}

# Conditional/join plots ----
if(F | doAll){
  # load model and univariate predictions
  for(folder in c(HCIdir[length(HCIdir)],SCIdir)){
    load(file.path(folder,'model.RData'))
    load(file.path(folder,'uniPred.RData'))
    if(folder==SCIdir){uniSCI=uni} else {uniHCI=uni}
  }
  gs=vector(mode='list',length=3)
  # Pd54-Pd56
  vars=fewSites$var[c(2,3)];sites=fewSites$site[c(2,3)]
  gs[[1]]=conditionalPlot(mod,uniHCI,uniSCI,uniID,
                          varnames=vars,sites=sites,
                          count=function(z,s1,s2){mean(s1>z & s2>z)},
                          x=seq(0.7,1,length.out=100),xl='x',
                          yl=paste0('Pr[Pd',sites[1],'>x , Pd',sites[2],'>x]'))
  # Qd233-Pd56
  vars=fewSites$var[c(1,3)];sites=fewSites$site[c(1,3)]
  gs[[2]]=conditionalPlot(mod,uniHCI,uniSCI,uniID,
                          varnames=vars,sites=sites,
                          count=function(z,s1,s2){mean(s1>0 & s2>z)/mean(s2>z)},
                          x=seq(0.7,1,length.out=100),xl='x',
                          yl=paste0('Pr[Qd',sites[1],'>0 | Pd',sites[2],'>x]'))
  # Tn23-Pd56
  vars=fewSites$var[c(5,3)];sites=fewSites$site[c(5,3)]
  gs[[3]]=conditionalPlot(mod,uniHCI,uniSCI,uniID,
                          varnames=vars,sites=sites,
                          count=function(z,s1,s2){mean(s1>2 & s2>z)/mean(s2>z)},
                          x=seq(0.7,1,length.out=100),xl='x',
                          yl=paste0('Pr[Tn',sites[1],'>2 | Pd',sites[2],'>x]'))
  # save
  f=file.path(dir0,'Conditionals.pdf')
  pdf(file=f,width=9, height=3,useDingbats=F)
  gridExtra::grid.arrange(grobs=gs,ncol=3)
  dev.off()
}

# FOOTS plots (Fraction Of Over-Threshold Stations) ----
if(F | doAll){
  nsimMax=Inf # 10 # use 10 for quick try
  # load model and univariate predictions
  for(folder in c(HCIdir[length(HCIdir)],SCIdir)){
    load(file.path(folder,'model.RData'))
    load(file.path(folder,'uniPred.RData'))
    if(folder==SCIdir){uniSCI=uni} else {uniHCI=uni}
  }
  gs=vector(mode='list',length=3)
  gs[[1]]=FOOTSplot(mod,uniHCI,uniSCI,uniID,prob=0.5,nsimMax=nsimMax)
  gs[[2]]=FOOTSplot(mod,uniHCI,uniSCI,uniID,prob=0.75,nsimMax=nsimMax)
  gs[[3]]=FOOTSplot(mod,uniHCI,uniSCI,uniID,prob=0.9,nsimMax=nsimMax)
  
  # save
  f=file.path(dir0,'FOOTS.pdf')
  pdf(file=f,width=9, height=9,useDingbats=F)
  gridExtra::grid.arrange(grobs=gs,nrow=3)
  dev.off()
}

# Map intercepts ----
if(F | doAll){
  gs=plotLambda0()
  # save
  f=file.path(dir0,'lambda0.pdf')
  pdf(file=f,width=8, height=12,useDingbats=F)
  gridExtra::grid.arrange(grobs=gs,ncol=2)
  dev.off()
}
