# Define case study --
dataset= 'dataset_full' # 'dataset_XV_1971-1990' # 
isHidden=T # Hidden or Standard climate indices?
kHidden=7 # index of Hidden component
# MCMC options --
Nchain=4
Nsim=120000
stopAdapt=round(Nsim/2);Nslim=round(Nsim/10000);
minMR=0.05;maxMR=0.2;downMult=0.7;upMult=1.3
jumpFile='JUMPS.txt';moveRateFile='MOVERATES.txt'

# load functions and data
source('funk.R')
load(file.path(dataset,'data','dataset.RData'))
varnames=sort(as.character(unique(dat$var)))

#***************************************************************************----
# PART I: ASSEMBLE DATA ----
# Restrict to analyzed period ----
mask0= dat$year %in% period
nY=sum(mask0)
# Predictand: Y & var ----
Y=data.frame(value=dat$value[mask0])
variable=data.frame(var=dat$var[mask0])
# Index dimensions: iDim ----
iDim=data.frame(itime=dat$year[mask0]-period[1]+1, # time step index
                ispaceQ=dat$site[mask0], # Q station index
                ispaceP=dat$site[mask0], # P station index
                ispaceT=dat$site[mask0]) # T station index
iDim$ispaceQ[dat$what[mask0]!='Q']=0 # set Q station index to 0 if analyzed variable is not Q
iDim$ispaceP[dat$what[mask0]!='P']=0 # set P station index to 0 if analyzed variable is not P
iDim$ispaceT[dat$what[mask0]!='T']=0 # set T station index to 0 if analyzed variable is not T
# Predictor: X ----
if(isHidden){
  if(kHidden>1){ # Stepwise strategy: at least one HCI to be treated as a covariate
    k=0
    for (i in 1:(kHidden-1)){
      # Names of components relative to ith HCI that are going to be treated as fixed 
      cnames=getStepwiseComponents(varnames,i)
      # open result with ith HCI and load estimate
      wk0=file.path(getwd(),dataset,'runs',paste0('HCI',i))
      load(file.path(wk0,'postmax.RData'))
      for(j in 1:length(cnames)){
        k=k+1
        nom=cnames[j]
        var=strsplit(nom,'_')[[1]][1] # Q, T or P
        # get relevant columns in estimate
        mask=grepl(paste0(nom,'_'),names(estimate),fixed=T) 
        foo=estimate[mask]
        if(var==paste0('tau',i)){ # HCI
          colX=foo[iDim$itime]
        } else { # HCI effects 
          colX=rep(0,nY)
          indx=which(variable$var==var)
          col=paste0('ispace',substr(var,1,1)) # name of relevant column in iDim
          kdim=iDim[[col]] # indices
          colX[indx]=foo[kdim[indx]] # covariate values
        }
        if(k==1){X=data.frame(as.numeric(colX))} else {X=cbind(X,as.numeric(colX))}
        names(X)[k] <- nom
      }
    }
  } else {
    X=NULL
  }
} else {
  # Associate the relevant SCI values to each row of Y
  X=data.frame(NINO=NINO$value[NINO$year %in% period][iDim$itime],
               DMI=DMI$value[DMI$year %in% period][iDim$itime],
               SAM=SAM$value[SAM$year %in% period][iDim$itime],
               jtime=iDim$itime)
  # Center and scale all SCIs for comparability with HCIs
  z=NINO$value[NINO$year %in% period]
  X$NINO=(X$NINO-mean(z))/sd(z)
  z=DMI$value[DMI$year %in% period]
  X$DMI=(X$DMI-mean(z))/sd(z)
  z=SAM$value[SAM$year %in% period]
  X$SAM=(X$SAM-mean(z))/sd(z)
}
# Censoring ----
cType <- rep(0,NROW(Y)) # no censoring by default
cType[variable$var %in% c('Qd','Pd') & Y$value == 0] = -1 # zeros are treated as left-censored values
cType[variable$var %in% c('Qd','Pd') & Y$value == 1] = 1 # ones are treated as right-censored values

#***************************************************************************----
# PART II: BUILD MODEL ----
formula <- c();parentDist <- c();
plist <- c();parlist <- c() # lists of processes and parameters of the model
# dataset and dimensions ----
d <- dataset(Y=Y,var=variable,iDim=iDim,X=X,cType=cType)
tDim <- dimension(name='time',coord=data.frame(year=period),d=distance('Euclidean'))
sDim=list(Q=dimension(name='spaceQ',coord=spaceQ[c('lon','lat')],d=distance('Haversine')),
          P=dimension(name='spaceP',coord=spaceP[c('lon','lat')],d=distance('Haversine')),
          T=dimension(name='spaceT',coord=spaceT[c('lon','lat')],d=distance('Haversine')))
# SCI or HCI ----
if(!isHidden){
  nCI=3
  names(d$X)[1:nCI] <- paste0('tau',1:nCI)
} else {
  nCI=kHidden
  nom=paste0('tau',kHidden)
  tau <- process(name=nom,dim=tDim,constraint=2,iScalarPar=c(1,2),dist='Gaussian_IID',
                 par=list(
                   parameter(name=paste0(nom,'_m'),init=0,priorDist='FIX'),
                   parameter(name=paste0(nom,'_sd'),init=1,priorDist='FIX')))
  plist <- c(plist,list(tau))
}
# Spatial processes ----
for(i in 1:length(varnames)){
  foo <- getModelComponents(varnames[i],sDim[[substr(varnames[i],1,1)]],nCI=nCI)
  parentDist <- c(parentDist,foo$parentDist)
  formula <- c(formula,foo$formula)
  for (j in 1:length(foo$plist)){
    # Stepwise inference: if the name of a process is also the name of 
    # a column in X, it means that it is treated as a known covariate.
    # Otherwise, it is inferred and should be addes to the list of processes
    nom=foo$plist[[j]]$name
    if(!(nom %in% names(X))){
      plist <- c(plist,list(foo$plist[[j]]))
    }
  }
  if(!is.null(foo$parlist)){
    for (j in 1:length(foo$parlist)){
      parlist <- c(parlist,list(foo$parlist[[j]]))
    }
  }
}
# model ----
mod <- model(dataset=d,parentDist=parentDist,varName=varnames,
             par=parlist,process=plist,formula=formula)
mcmcOptions=mcmc(Nsim=Nsim,stopAdapt=stopAdapt,Nslim=Nslim,
                 minMR=minMR,maxMR=maxMR,downMult=downMult,upMult=upMult,
                 jumpFileName=jumpFile,moveRateFileName=moveRateFile)
wk=file.path(getwd(),dataset,'runs',paste0(ifelse(isHidden,paste0('HCI',kHidden),'SCI')))
for(i in 1:Nchain){
  # write config files
  STooDs(model=mod,workspace=file.path(wk,paste0('chain',i)),
         run=FALSE,mcmcOptions=mcmcOptions)
}
# save model and covariates ----
save(mod,file=file.path(wk,'model.RData'))
if(!isHidden) {save(X,file=file.path(wk,'X.RData'))}
#***************************************************************************----
