! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Auxiliary Routines File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Util.f90
! Time                 : Tue Nov  2 10:18:18 2021
! Working directory    : /home/matthias/MAFOR_GIT/mafor/src/CAABA/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Util

  USE messy_mecca_kpp_Parameters
  IMPLICIT NONE

CONTAINS



! User INLINED Utility Functions

! from xmecca:
SUBROUTINE initialize_indexarrays
  USE messy_mecca_kpp_global     ! ind_XYZ_a(:) arrays
  USE messy_mecca_kpp_parameters ! ind_XYZ_a## scalars
  IMPLICIT NONE
  ! from aerosol.awk:
  ind_O2_a(01)        = ind_O2_a01
  ind_O3_a(01)        = ind_O3_a01
  ind_OH_a(01)        = ind_OH_a01
  ind_HO2_a(01)       = ind_HO2_a01
  ind_H2O_a(01)       = ind_H2O_a01
  ind_H2O2_a(01)      = ind_H2O2_a01
  ind_NH3_a(01)       = ind_NH3_a01
  ind_NO_a(01)        = ind_NO_a01
  ind_NO2_a(01)       = ind_NO2_a01
  ind_NO3_a(01)       = ind_NO3_a01
  ind_HONO_a(01)      = ind_HONO_a01
  ind_HNO3_a(01)      = ind_HNO3_a01
  ind_HNO4_a(01)      = ind_HNO4_a01
  ind_CH3OH_a(01)     = ind_CH3OH_a01
  ind_HCOOH_a(01)     = ind_HCOOH_a01
  ind_HCHO_a(01)      = ind_HCHO_a01
  ind_CH3O2_a(01)     = ind_CH3O2_a01
  ind_CH3OOH_a(01)    = ind_CH3OOH_a01
  ind_CO2_a(01)       = ind_CO2_a01
  ind_CH3CO2H_a(01)   = ind_CH3CO2H_a01
  ind_PAN_a(01)       = ind_PAN_a01
  ind_CH3CHO_a(01)    = ind_CH3CHO_a01
  ind_CH3COCH3_a(01)  = ind_CH3COCH3_a01
  ind_Cl_a(01)        = ind_Cl_a01
  ind_Cl2_a(01)       = ind_Cl2_a01
  ind_HCl_a(01)       = ind_HCl_a01
  ind_HOCl_a(01)      = ind_HOCl_a01
  ind_Br_a(01)        = ind_Br_a01
  ind_Br2_a(01)       = ind_Br2_a01
  ind_HBr_a(01)       = ind_HBr_a01
  ind_HOBr_a(01)      = ind_HOBr_a01
  ind_BrCl_a(01)      = ind_BrCl_a01
  ind_I2_a(01)        = ind_I2_a01
  ind_IO_a(01)        = ind_IO_a01
  ind_HOI_a(01)       = ind_HOI_a01
  ind_ICl_a(01)       = ind_ICl_a01
  ind_IBr_a(01)       = ind_IBr_a01
  ind_SO2_a(01)       = ind_SO2_a01
  ind_H2SO4_a(01)     = ind_H2SO4_a01
  ind_DMS_a(01)       = ind_DMS_a01
  ind_DMSO_a(01)      = ind_DMSO_a01
  ind_Hg_a(01)        = ind_Hg_a01
  ind_HgO_a(01)       = ind_HgO_a01
  ind_HgOHOH_a(01)    = ind_HgOHOH_a01
  ind_HgOHCl_a(01)    = ind_HgOHCl_a01
  ind_HgCl2_a(01)     = ind_HgCl2_a01
  ind_HgBr2_a(01)     = ind_HgBr2_a01
  ind_HgSO3_a(01)     = ind_HgSO3_a01
  ind_ClHgBr_a(01)    = ind_ClHgBr_a01
  ind_BrHgOBr_a(01)   = ind_BrHgOBr_a01
  ind_ClHgOBr_a(01)   = ind_ClHgOBr_a01
  ind_FeOH3_a(01)     = ind_FeOH3_a01
  ind_FeCl3_a(01)     = ind_FeCl3_a01
  ind_FeF3_a(01)      = ind_FeF3_a01
  ind_O2m_a(01)       = ind_O2m_a01
  ind_OHm_a(01)       = ind_OHm_a01
  ind_HO2m_a(01)      = ind_HO2m_a01
  ind_O2mm_a(01)      = ind_O2mm_a01
  ind_Hp_a(01)        = ind_Hp_a01
  ind_NH4p_a(01)      = ind_NH4p_a01
  ind_NO2m_a(01)      = ind_NO2m_a01
  ind_NO3m_a(01)      = ind_NO3m_a01
  ind_NO4m_a(01)      = ind_NO4m_a01
  ind_CO3m_a(01)      = ind_CO3m_a01
  ind_HCOOm_a(01)     = ind_HCOOm_a01
  ind_HCO3m_a(01)     = ind_HCO3m_a01
  ind_CH3COOm_a(01)   = ind_CH3COOm_a01
  ind_Clm_a(01)       = ind_Clm_a01
  ind_Cl2m_a(01)      = ind_Cl2m_a01
  ind_ClOm_a(01)      = ind_ClOm_a01
  ind_ClOHm_a(01)     = ind_ClOHm_a01
  ind_Brm_a(01)       = ind_Brm_a01
  ind_Br2m_a(01)      = ind_Br2m_a01
  ind_BrOm_a(01)      = ind_BrOm_a01
  ind_BrOHm_a(01)     = ind_BrOHm_a01
  ind_BrCl2m_a(01)    = ind_BrCl2m_a01
  ind_Br2Clm_a(01)    = ind_Br2Clm_a01
  ind_Im_a(01)        = ind_Im_a01
  ind_IO2m_a(01)      = ind_IO2m_a01
  ind_IO3m_a(01)      = ind_IO3m_a01
  ind_ICl2m_a(01)     = ind_ICl2m_a01
  ind_IBr2m_a(01)     = ind_IBr2m_a01
  ind_SO3m_a(01)      = ind_SO3m_a01
  ind_SO3mm_a(01)     = ind_SO3mm_a01
  ind_SO4m_a(01)      = ind_SO4m_a01
  ind_SO4mm_a(01)     = ind_SO4mm_a01
  ind_SO5m_a(01)      = ind_SO5m_a01
  ind_HSO3m_a(01)     = ind_HSO3m_a01
  ind_HSO4m_a(01)     = ind_HSO4m_a01
  ind_HSO5m_a(01)     = ind_HSO5m_a01
  ind_CH3SO3m_a(01)   = ind_CH3SO3m_a01
  ind_CH2OHSO3m_a(01) = ind_CH2OHSO3m_a01
  ind_Hgp_a(01)       = ind_Hgp_a01
  ind_Hgpp_a(01)      = ind_Hgpp_a01
  ind_HgOHp_a(01)     = ind_HgOHp_a01
  ind_HgClp_a(01)     = ind_HgClp_a01
  ind_HgBrp_a(01)     = ind_HgBrp_a01
  ind_HgSO32mm_a(01)  = ind_HgSO32mm_a01
  ind_Fepp_a(01)      = ind_Fepp_a01
  ind_FeOpp_a(01)     = ind_FeOpp_a01
  ind_FeOHp_a(01)     = ind_FeOHp_a01
  ind_FeOH2p_a(01)    = ind_FeOH2p_a01
  ind_FeClp_a(01)     = ind_FeClp_a01
  ind_Feppp_a(01)     = ind_Feppp_a01
  ind_FeHOpp_a(01)    = ind_FeHOpp_a01
  ind_FeHO2pp_a(01)   = ind_FeHO2pp_a01
  ind_FeOHpp_a(01)    = ind_FeOHpp_a01
  ind_FeOH4m_a(01)    = ind_FeOH4m_a01
  ind_FeOHHO2p_a(01)  = ind_FeOHHO2p_a01
  ind_FeClpp_a(01)    = ind_FeClpp_a01
  ind_FeCl2p_a(01)    = ind_FeCl2p_a01
  ind_FeBrpp_a(01)    = ind_FeBrpp_a01
  ind_FeBr2p_a(01)    = ind_FeBr2p_a01
  ind_FeFpp_a(01)     = ind_FeFpp_a01
  ind_FeF2p_a(01)     = ind_FeF2p_a01
  ind_FeSO3p_a(01)    = ind_FeSO3p_a01
  ind_FeSO4p_a(01)    = ind_FeSO4p_a01
  ind_FeSO42m_a(01)   = ind_FeSO42m_a01
  ind_FeOH2Fepppp_a(01) = ind_FeOH2Fepppp_a01
  ind_D1O_a(01)       = ind_D1O_a01
  ind_Nap_a(01)       = ind_Nap_a01
  ind_N2O3_a(01)      = ind_N2O3_a01
  ind_N2O4_a(01)      = ind_N2O4_a01
  ind_CH2O2H2_a(01)   = ind_CH2O2H2_a01
  ind_MMA_a(01)       = ind_MMA_a01
  ind_NH2CH2_a(01)    = ind_NH2CH2_a01
  ind_HNCO_a(01)      = ind_HNCO_a01
  ind_H2NCHO_a(01)    = ind_H2NCHO_a01
  ind_MMNNO2_a(01)    = ind_MMNNO2_a01
  ind_OXALAC_a(01)    = ind_OXALAC_a01
  ind_HCOCO2H_a(01)   = ind_HCOCO2H_a01
  ind_HOCH2CHO_a(01)  = ind_HOCH2CHO_a01
  ind_HOCH2CO2H_a(01) = ind_HOCH2CO2H_a01
  ind_CH3CO3_a(01)    = ind_CH3CO3_a01
  ind_GLYOX_a(01)     = ind_GLYOX_a01
  ind_DMA_a(01)       = ind_DMA_a01
  ind_MEA_a(01)       = ind_MEA_a01
  ind_MEANNO_a(01)    = ind_MEANNO_a01
  ind_MEANNO2_a(01)   = ind_MEANNO2_a01
  ind_NDMA_a(01)      = ind_NDMA_a01
  ind_DMNNO2_a(01)    = ind_DMNNO2_a01
  ind_CH3NHCH2_a(01)  = ind_CH3NHCH2_a01
  ind_CH3NHNHCH3_a(01) = ind_CH3NHNHCH3_a01
  ind_NH2C2H4NH2_a(01) = ind_NH2C2H4NH2_a01
  ind_NH2CH2CHOH_a(01) = ind_NH2CH2CHOH_a01
  ind_H2NCOCH2OH_a(01) = ind_H2NCOCH2OH_a01
  ind_CH3NHCHO_a(01)  = ind_CH3NHCHO_a01
  ind_CH3NCO_a(01)    = ind_CH3NCO_a01
  ind_MGLYOX_a(01)    = ind_MGLYOX_a01
  ind_MGLYOAC_a(01)   = ind_MGLYOAC_a01
  ind_DOC_a(01)       = ind_DOC_a01
  ind_DOCO_a(01)      = ind_DOCO_a01
  ind_TMA_a(01)       = ind_TMA_a01
  ind_DMNCH2_a(01)    = ind_DMNCH2_a01
  ind_DMNCHO_a(01)    = ind_DMNCHO_a01
  ind_MALONAC_a(01)   = ind_MALONAC_a01
  ind_DEA_a(01)       = ind_DEA_a01
  ind_NDELA_a(01)     = ind_NDELA_a01
  ind_DEANNO2_a(01)   = ind_DEANNO2_a01
  ind_DEAN_a(01)      = ind_DEAN_a01
  ind_SUCCAC_a(01)    = ind_SUCCAC_a01
  ind_GLUTARAC_a(01)  = ind_GLUTARAC_a01
  ind_TEA_a(01)       = ind_TEA_a01
  ind_DENCH2CHOH_a(01) = ind_DENCH2CHOH_a01
  ind_ADIPAC_a(01)    = ind_ADIPAC_a01
  ind_MMAp_a(01)      = ind_MMAp_a01
  ind_MMNp_a(01)      = ind_MMNp_a01
  ind_NH2CH2p_a(01)   = ind_NH2CH2p_a01
  ind_NH3CH2p_a(01)   = ind_NH3CH2p_a01
  ind_NCOm_a(01)      = ind_NCOm_a01
  ind_HC2O4m_a(01)    = ind_HC2O4m_a01
  ind_C2O4mm_a(01)    = ind_C2O4mm_a01
  ind_HCOCOOm_a(01)   = ind_HCOCOOm_a01
  ind_MEAp_a(01)      = ind_MEAp_a01
  ind_DMAp_a(01)      = ind_DMAp_a01
  ind_DMNp_a(01)      = ind_DMNp_a01
  ind_CH3NHCH2p_a(01) = ind_CH3NHCH2p_a01
  ind_CH3NH2CH2p_a(01) = ind_CH3NH2CH2p_a01
  ind_MENp_a(01)      = ind_MENp_a01
  ind_NH3CH2CHOHp_a(01) = ind_NH3CH2CHOHp_a01
  ind_CH3COCOOm_a(01) = ind_CH3COCOOm_a01
  ind_TMAp_a(01)      = ind_TMAp_a01
  ind_TMNp_a(01)      = ind_TMNp_a01
  ind_DMNCH2p_a(01)   = ind_DMNCH2p_a01
  ind_DMNHCH2p_a(01)  = ind_DMNHCH2p_a01
  ind_DEAp_a(01)      = ind_DEAp_a01
  ind_DENp_a(01)      = ind_DENp_a01
  ind_DENHp_a(01)     = ind_DENHp_a01
  ind_C2H5C2O4m_a(01) = ind_C2H5C2O4m_a01
  ind_C2H4C2O4mm_a(01) = ind_C2H4C2O4mm_a01
  ind_TEAp_a(01)      = ind_TEAp_a01
  ind_TENp_a(01)      = ind_TENp_a01
  ind_DENIMp_a(01)    = ind_DENIMp_a01
  ind_TENHp_a(01)     = ind_TENHp_a01
END SUBROUTINE initialize_indexarrays

! End INLINED Utility Functions

! Utility Functions from KPP_HOME/util/util
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! UTIL - Utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ****************************************************************
!                            
! InitSaveData - Opens the data file for writing
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE messy_mecca_kpp_Parameters

      open(10, file='messy_mecca_kpp.dat')

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!                            
! SaveData - Write LOOKAT species in the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE messy_mecca_kpp_Global
      USE messy_mecca_kpp_Monitor

      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)
999   FORMAT(E24.16,100(1X,E24.16))

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!                            
! CloseSaveData - Close the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE messy_mecca_kpp_Parameters

      CLOSE(10)

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!                            
! GenerateMatlab - Generates MATLAB file to load the data file 
!   Parameters : 
!                It will have a character string to prefix each 
!                species name with.                                                 
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE messy_mecca_kpp_Parameters
      USE messy_mecca_kpp_Global
      USE messy_mecca_kpp_Monitor

      
      CHARACTER(LEN=8) PREFIX 
      INTEGER i

      open(20, file='messy_mecca_kpp.m')
      write(20,*) 'load messy_mecca_kpp.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = messy_mecca_kpp;')
      write(20,*) 'clear messy_mecca_kpp;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do
      
      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


! ****************************************************************
!                            
! tag2num - convert equation tags to kpp reaction number
!   Arguments :
!      id        - string with the equation tag
!
! ****************************************************************

ELEMENTAL INTEGER FUNCTION tag2num ( id )

  USE messy_mecca_kpp_Monitor, ONLY: EQN_TAGS

  CHARACTER(LEN=*), INTENT(IN) :: id
  INTEGER i

  tag2num = 0 ! mz_rs_20050115
  DO i = 1, SIZE(EQN_TAGS)
    IF (TRIM(EQN_TAGS(i)) == TRIM(id)) THEN
      tag2num = i ! mz_rs_20050115
      EXIT
    ENDIF
  END DO

END FUNCTION tag2num

! End of tag2num function
! ****************************************************************

! End Utility Functions from KPP_HOME/util/util
! End of UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_user2kpp - function to copy concentrations from USER to KPP
!   Arguments :
!      V_USER    - Concentration of variable species in USER's order
!      V         - Concentrations of variable species (local)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_user2kpp ( V_USER, V )

! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)
! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)

  V(789) = V_USER(1)
  V(885) = V_USER(2)
  V(906) = V_USER(3)
  V(247) = V_USER(4)
  V(294) = V_USER(5)
  V(927) = V_USER(6)
  V(924) = V_USER(7)
  V(899) = V_USER(8)
  V(843) = V_USER(9)
  V(142) = V_USER(10)
  V(833) = V_USER(13)
  V(7) = V_USER(14)
  V(929) = V_USER(15)
  V(919) = V_USER(16)
  V(921) = V_USER(17)
  V(445) = V_USER(18)
  V(807) = V_USER(19)
  V(878) = V_USER(20)
  V(511) = V_USER(21)
  V(666) = V_USER(22)
  V(667) = V_USER(23)
  V(311) = V_USER(24)
  V(512) = V_USER(25)
  V(234) = V_USER(26)
  V(8) = V_USER(27)
  V(877) = V_USER(28)
  V(521) = V_USER(29)
  V(863) = V_USER(30)
  V(891) = V_USER(31)
  V(915) = V_USER(32)
  V(746) = V_USER(33)
  V(804) = V_USER(34)
  V(575) = V_USER(35)
  V(900) = V_USER(36)
  V(903) = V_USER(37)
  V(901) = V_USER(38)
  V(778) = V_USER(39)
  V(173) = V_USER(40)
  V(648) = V_USER(41)
  V(668) = V_USER(42)
  V(486) = V_USER(43)
  V(553) = V_USER(44)
  V(235) = V_USER(45)
  V(670) = V_USER(46)
  V(487) = V_USER(47)
  V(104) = V_USER(48)
  V(9) = V_USER(49)
  V(407) = V_USER(50)
  V(834) = V_USER(51)
  V(773) = V_USER(52)
  V(244) = V_USER(53)
  V(381) = V_USER(54)
  V(237) = V_USER(55)
  V(559) = V_USER(56)
  V(625) = V_USER(57)
  V(880) = V_USER(58)
  V(747) = V_USER(59)
  V(593) = V_USER(60)
  V(872) = V_USER(61)
  V(431) = V_USER(62)
  V(817) = V_USER(63)
  V(302) = V_USER(64)
  V(166) = V_USER(65)
  V(881) = V_USER(66)
  V(860) = V_USER(67)
  V(763) = V_USER(68)
  V(799) = V_USER(69)
  V(832) = V_USER(70)
  V(589) = V_USER(71)
  V(289) = V_USER(72)
  V(873) = V_USER(73)
  V(887) = V_USER(74)
  V(739) = V_USER(75)
  V(693) = V_USER(76)
  V(859) = V_USER(77)
  V(440) = V_USER(78)
  V(525) = V_USER(79)
  V(793) = V_USER(80)
  V(453) = V_USER(81)
  V(802) = V_USER(82)
  V(335) = V_USER(83)
  V(466) = V_USER(84)
  V(362) = V_USER(85)
  V(469) = V_USER(86)
  V(623) = V_USER(87)
  V(471) = V_USER(88)
  V(498) = V_USER(89)
  V(777) = V_USER(90)
  V(563) = V_USER(91)
  V(159) = V_USER(92)
  V(527) = V_USER(93)
  V(528) = V_USER(94)
  V(842) = V_USER(95)
  V(672) = V_USER(96)
  V(780) = V_USER(97)
  V(225) = V_USER(98)
  V(760) = V_USER(99)
  V(380) = V_USER(100)
  V(673) = V_USER(101)
  V(844) = V_USER(102)
  V(71) = V_USER(103)
  V(439) = V_USER(104)
  V(848) = V_USER(105)
  V(782) = V_USER(106)
  V(827) = V_USER(107)
  V(686) = V_USER(108)
  V(406) = V_USER(109)
  V(835) = V_USER(110)
  V(733) = V_USER(111)
  V(230) = V_USER(112)
  V(815) = V_USER(113)
  V(175) = V_USER(114)
  V(562) = V_USER(115)
  V(105) = V_USER(116)
  V(639) = V_USER(117)
  V(182) = V_USER(118)
  V(731) = V_USER(119)
  V(485) = V_USER(120)
  V(601) = V_USER(121)
  V(650) = V_USER(122)
  V(719) = V_USER(123)
  V(409) = V_USER(124)
  V(609) = V_USER(125)
  V(347) = V_USER(126)
  V(152) = V_USER(127)
  V(874) = V_USER(128)
  V(581) = V_USER(129)
  V(357) = V_USER(130)
  V(240) = V_USER(131)
  V(208) = V_USER(132)
  V(560) = V_USER(133)
  V(743) = V_USER(134)
  V(375) = V_USER(135)
  V(744) = V_USER(136)
  V(296) = V_USER(137)
  V(72) = V_USER(138)
  V(378) = V_USER(139)
  V(379) = V_USER(140)
  V(504) = V_USER(141)
  V(303) = V_USER(142)
  V(106) = V_USER(143)
  V(681) = V_USER(144)
  V(480) = V_USER(145)
  V(308) = V_USER(146)
  V(574) = V_USER(147)
  V(426) = V_USER(148)
  V(373) = V_USER(149)
  V(61) = V_USER(150)
  V(756) = V_USER(151)
  V(403) = V_USER(152)
  V(483) = V_USER(153)
  V(624) = V_USER(154)
  V(145) = V_USER(155)
  V(774) = V_USER(156)
  V(467) = V_USER(157)
  V(210) = V_USER(158)
  V(669) = V_USER(159)
  V(217) = V_USER(160)
  V(779) = V_USER(161)
  V(290) = V_USER(162)
  V(455) = V_USER(163)
  V(295) = V_USER(164)
  V(583) = V_USER(165)
  V(738) = V_USER(166)
  V(569) = V_USER(167)
  V(706) = V_USER(168)
  V(107) = V_USER(169)
  V(73) = V_USER(170)
  V(571) = V_USER(171)
  V(757) = V_USER(172)
  V(683) = V_USER(173)
  V(858) = V_USER(174)
  V(310) = V_USER(175)
  V(788) = V_USER(176)
  V(484) = V_USER(177)
  V(814) = V_USER(178)
  V(769) = V_USER(179)
  V(74) = V_USER(180)
  V(704) = V_USER(181)
  V(541) = V_USER(182)
  V(513) = V_USER(183)
  V(556) = V_USER(184)
  V(516) = V_USER(185)
  V(713) = V_USER(186)
  V(727) = V_USER(187)
  V(599) = V_USER(188)
  V(319) = V_USER(189)
  V(75) = V_USER(190)
  V(428) = V_USER(191)
  V(328) = V_USER(192)
  V(715) = V_USER(193)
  V(657) = V_USER(194)
  V(389) = V_USER(195)
  V(816) = V_USER(196)
  V(262) = V_USER(197)
  V(572) = V_USER(198)
  V(345) = V_USER(199)
  V(775) = V_USER(200)
  V(266) = V_USER(201)
  V(826) = V_USER(202)
  V(522) = V_USER(203)
  V(821) = V_USER(204)
  V(270) = V_USER(205)
  V(649) = V_USER(206)
  V(819) = V_USER(207)
  V(514) = V_USER(208)
  V(621) = V_USER(209)
  V(174) = V_USER(210)
  V(809) = V_USER(211)
  V(62) = V_USER(212)
  V(363) = V_USER(213)
  V(745) = V_USER(214)
  V(495) = V_USER(215)
  V(424) = V_USER(216)
  V(108) = V_USER(217)
  V(558) = V_USER(218)
  V(752) = V_USER(219)
  V(286) = V_USER(220)
  V(607) = V_USER(221)
  V(109) = V_USER(222)
  V(110) = V_USER(223)
  V(729) = V_USER(224)
  V(176) = V_USER(225)
  V(758) = V_USER(226)
  V(177) = V_USER(227)
  V(542) = V_USER(228)
  V(477) = V_USER(229)
  V(761) = V_USER(230)
  V(301) = V_USER(231)
  V(688) = V_USER(232)
  V(478) = V_USER(233)
  V(805) = V_USER(234)
  V(785) = V_USER(235)
  V(637) = V_USER(236)
  V(482) = V_USER(237)
  V(111) = V_USER(238)
  V(312) = V_USER(239)
  V(736) = V_USER(240)
  V(377) = V_USER(241)
  V(343) = V_USER(242)
  V(346) = V_USER(243)
  V(356) = V_USER(244)
  V(275) = V_USER(245)
  V(543) = V_USER(246)
  V(475) = V_USER(247)
  V(629) = V_USER(248)
  V(434) = V_USER(249)
  V(435) = V_USER(250)
  V(383) = V_USER(251)
  V(376) = V_USER(252)
  V(565) = V_USER(253)
  V(451) = V_USER(254)
  V(441) = V_USER(255)
  V(530) = V_USER(256)
  V(680) = V_USER(257)
  V(417) = V_USER(258)
  V(671) = V_USER(259)
  V(493) = V_USER(260)
  V(850) = V_USER(261)
  V(619) = V_USER(262)
  V(750) = V_USER(263)
  V(539) = V_USER(264)
  V(408) = V_USER(265)
  V(414) = V_USER(266)
  V(603) = V_USER(267)
  V(535) = V_USER(268)
  V(112) = V_USER(269)
  V(770) = V_USER(270)
  V(611) = V_USER(271)
  V(632) = V_USER(272)
  V(524) = V_USER(273)
  V(354) = V_USER(274)
  V(869) = V_USER(275)
  V(490) = V_USER(276)
  V(248) = V_USER(277)
  V(492) = V_USER(278)
  V(178) = V_USER(279)
  V(146) = V_USER(280)
  V(533) = V_USER(281)
  V(361) = V_USER(282)
  V(554) = V_USER(283)
  V(179) = V_USER(284)
  V(600) = V_USER(285)
  V(249) = V_USER(286)
  V(790) = V_USER(287)
  V(787) = V_USER(288)
  V(180) = V_USER(289)
  V(803) = V_USER(290)
  V(675) = V_USER(291)
  V(703) = V_USER(292)
  V(76) = V_USER(293)
  V(868) = V_USER(294)
  V(856) = V_USER(295)
  V(540) = V_USER(296)
  V(812) = V_USER(297)
  V(474) = V_USER(298)
  V(754) = V_USER(299)
  V(181) = V_USER(300)
  V(866) = V_USER(301)
  V(236) = V_USER(302)
  V(808) = V_USER(303)
  V(854) = V_USER(304)
  V(113) = V_USER(305)
  V(836) = V_USER(306)
  V(612) = V_USER(307)
  V(459) = V_USER(308)
  V(147) = V_USER(309)
  V(656) = V_USER(310)
  V(660) = V_USER(311)
  V(734) = V_USER(312)
  V(183) = V_USER(313)
  V(114) = V_USER(314)
  V(662) = V_USER(315)
  V(115) = V_USER(316)
  V(702) = V_USER(317)
  V(470) = V_USER(318)
  V(798) = V_USER(319)
  V(633) = V_USER(320)
  V(476) = V_USER(321)
  V(116) = V_USER(322)
  V(701) = V_USER(323)
  V(318) = V_USER(324)
  V(822) = V_USER(325)
  V(628) = V_USER(326)
  V(437) = V_USER(327)
  V(481) = V_USER(328)
  V(117) = V_USER(329)
  V(644) = V_USER(330)
  V(184) = V_USER(331)
  V(568) = V_USER(332)
  V(772) = V_USER(333)
  V(250) = V_USER(334)
  V(148) = V_USER(335)
  V(251) = V_USER(336)
  V(320) = V_USER(337)
  V(321) = V_USER(338)
  V(322) = V_USER(339)
  V(797) = V_USER(340)
  V(413) = V_USER(341)
  V(499) = V_USER(342)
  V(810) = V_USER(343)
  V(646) = V_USER(344)
  V(252) = V_USER(345)
  V(323) = V_USER(346)
  V(537) = V_USER(347)
  V(185) = V_USER(348)
  V(77) = V_USER(349)
  V(324) = V_USER(350)
  V(325) = V_USER(351)
  V(326) = V_USER(352)
  V(532) = V_USER(353)
  V(555) = V_USER(354)
  V(253) = V_USER(355)
  V(714) = V_USER(356)
  V(489) = V_USER(357)
  V(254) = V_USER(358)
  V(818) = V_USER(359)
  V(861) = V_USER(360)
  V(118) = V_USER(361)
  V(820) = V_USER(362)
  V(255) = V_USER(363)
  V(256) = V_USER(364)
  V(149) = V_USER(365)
  V(448) = V_USER(366)
  V(837) = V_USER(367)
  V(865) = V_USER(368)
  V(150) = V_USER(369)
  V(395) = V_USER(370)
  V(730) = V_USER(371)
  V(711) = V_USER(372)
  V(526) = V_USER(373)
  V(452) = V_USER(374)
  V(694) = V_USER(375)
  V(870) = V_USER(376)
  V(867) = V_USER(377)
  V(622) = V_USER(378)
  V(862) = V_USER(379)
  V(676) = V_USER(380)
  V(186) = V_USER(381)
  V(630) = V_USER(382)
  V(433) = V_USER(383)
  V(712) = V_USER(384)
  V(529) = V_USER(385)
  V(327) = V_USER(386)
  V(187) = V_USER(387)
  V(551) = V_USER(388)
  V(329) = V_USER(389)
  V(661) = V_USER(390)
  V(510) = V_USER(391)
  V(257) = V_USER(392)
  V(330) = V_USER(393)
  V(690) = V_USER(394)
  V(331) = V_USER(395)
  V(332) = V_USER(396)
  V(188) = V_USER(397)
  V(721) = V_USER(398)
  V(189) = V_USER(399)
  V(728) = V_USER(400)
  V(497) = V_USER(401)
  V(741) = V_USER(402)
  V(258) = V_USER(403)
  V(626) = V_USER(404)
  V(259) = V_USER(405)
  V(641) = V_USER(406)
  V(333) = V_USER(407)
  V(151) = V_USER(408)
  V(692) = V_USER(409)
  V(334) = V_USER(410)
  V(523) = V_USER(411)
  V(766) = V_USER(412)
  V(724) = V_USER(413)
  V(260) = V_USER(414)
  V(732) = V_USER(415)
  V(664) = V_USER(416)
  V(190) = V_USER(417)
  V(580) = V_USER(418)
  V(63) = V_USER(419)
  V(78) = V_USER(420)
  V(557) = V_USER(421)
  V(446) = V_USER(422)
  V(119) = V_USER(423)
  V(742) = V_USER(424)
  V(579) = V_USER(425)
  V(410) = V_USER(426)
  V(411) = V_USER(427)
  V(412) = V_USER(428)
  V(496) = V_USER(429)
  V(336) = V_USER(430)
  V(337) = V_USER(431)
  V(338) = V_USER(432)
  V(767) = V_USER(433)
  V(596) = V_USER(434)
  V(339) = V_USER(435)
  V(582) = V_USER(436)
  V(631) = V_USER(437)
  V(261) = V_USER(438)
  V(390) = V_USER(439)
  V(652) = V_USER(440)
  V(340) = V_USER(441)
  V(64) = V_USER(442)
  V(636) = V_USER(443)
  V(415) = V_USER(444)
  V(658) = V_USER(445)
  V(341) = V_USER(446)
  V(585) = V_USER(447)
  V(708) = V_USER(448)
  V(191) = V_USER(449)
  V(665) = V_USER(450)
  V(342) = V_USER(451)
  V(192) = V_USER(452)
  V(534) = V_USER(453)
  V(263) = V_USER(454)
  V(587) = V_USER(455)
  V(264) = V_USER(456)
  V(640) = V_USER(457)
  V(265) = V_USER(458)
  V(577) = V_USER(459)
  V(749) = V_USER(460)
  V(120) = V_USER(461)
  V(50) = V_USER(462)
  V(391) = V_USER(463)
  V(46) = V_USER(464)
  V(655) = V_USER(465)
  V(617) = V_USER(466)
  V(344) = V_USER(467)
  V(509) = V_USER(468)
  V(193) = V_USER(469)
  V(735) = V_USER(470)
  V(194) = V_USER(471)
  V(564) = V_USER(472)
  V(616) = V_USER(473)
  V(398) = V_USER(474)
  V(416) = V_USER(475)
  V(578) = V_USER(476)
  V(643) = V_USER(477)
  V(195) = V_USER(478)
  V(642) = V_USER(479)
  V(645) = V_USER(480)
  V(196) = V_USER(481)
  V(238) = V_USER(482)
  V(79) = V_USER(483)
  V(613) = V_USER(484)
  V(508) = V_USER(485)
  V(121) = V_USER(486)
  V(716) = V_USER(487)
  V(573) = V_USER(488)
  V(348) = V_USER(489)
  V(197) = V_USER(490)
  V(726) = V_USER(491)
  V(198) = V_USER(492)
  V(762) = V_USER(493)
  V(488) = V_USER(494)
  V(684) = V_USER(495)
  V(267) = V_USER(496)
  V(550) = V_USER(497)
  V(122) = V_USER(498)
  V(349) = V_USER(499)
  V(350) = V_USER(500)
  V(268) = V_USER(501)
  V(765) = V_USER(502)
  V(590) = V_USER(503)
  V(351) = V_USER(504)
  V(748) = V_USER(505)
  V(594) = V_USER(506)
  V(352) = V_USER(507)
  V(65) = V_USER(508)
  V(353) = V_USER(509)
  V(597) = V_USER(510)
  V(584) = V_USER(511)
  V(707) = V_USER(512)
  V(199) = V_USER(513)
  V(615) = V_USER(514)
  V(468) = V_USER(515)
  V(638) = V_USER(516)
  V(418) = V_USER(517)
  V(618) = V_USER(518)
  V(269) = V_USER(519)
  V(419) = V_USER(520)
  V(586) = V_USER(521)
  V(420) = V_USER(522)
  V(355) = V_USER(523)
  V(764) = V_USER(524)
  V(552) = V_USER(525)
  V(725) = V_USER(526)
  V(200) = V_USER(527)
  V(602) = V_USER(528)
  V(271) = V_USER(529)
  V(392) = V_USER(530)
  V(447) = V_USER(531)
  V(201) = V_USER(532)
  V(491) = V_USER(533)
  V(272) = V_USER(534)
  V(567) = V_USER(535)
  V(273) = V_USER(536)
  V(709) = V_USER(537)
  V(274) = V_USER(538)
  V(699) = V_USER(539)
  V(202) = V_USER(540)
  V(239) = V_USER(541)
  V(123) = V_USER(542)
  V(588) = V_USER(543)
  V(124) = V_USER(544)
  V(125) = V_USER(545)
  V(393) = V_USER(546)
  V(740) = V_USER(547)
  V(595) = V_USER(548)
  V(358) = V_USER(549)
  V(421) = V_USER(550)
  V(359) = V_USER(551)
  V(360) = V_USER(552)
  V(203) = V_USER(553)
  V(598) = V_USER(554)
  V(126) = V_USER(555)
  V(394) = V_USER(556)
  V(781) = V_USER(557)
  V(204) = V_USER(558)
  V(606) = V_USER(559)
  V(205) = V_USER(560)
  V(276) = V_USER(561)
  V(846) = V_USER(562)
  V(277) = V_USER(563)
  V(847) = V_USER(564)
  V(278) = V_USER(565)
  V(449) = V_USER(566)
  V(206) = V_USER(567)
  V(494) = V_USER(568)
  V(279) = V_USER(569)
  V(80) = V_USER(570)
  V(700) = V_USER(571)
  V(81) = V_USER(572)
  V(536) = V_USER(573)
  V(784) = V_USER(574)
  V(840) = V_USER(575)
  V(207) = V_USER(576)
  V(127) = V_USER(577)
  V(364) = V_USER(578)
  V(422) = V_USER(579)
  V(209) = V_USER(580)
  V(423) = V_USER(581)
  V(313) = V_USER(582)
  V(786) = V_USER(583)
  V(811) = V_USER(584)
  V(717) = V_USER(585)
  V(698) = V_USER(586)
  V(365) = V_USER(587)
  V(677) = V_USER(588)
  V(576) = V_USER(589)
  V(280) = V_USER(590)
  V(153) = V_USER(591)
  V(674) = V_USER(592)
  V(366) = V_USER(593)
  V(759) = V_USER(594)
  V(647) = V_USER(595)
  V(718) = V_USER(596)
  V(211) = V_USER(597)
  V(82) = V_USER(598)
  V(450) = V_USER(599)
  V(212) = V_USER(600)
  V(853) = V_USER(601)
  V(538) = V_USER(602)
  V(213) = V_USER(603)
  V(214) = V_USER(604)
  V(314) = V_USER(605)
  V(515) = V_USER(606)
  V(281) = V_USER(607)
  V(710) = V_USER(608)
  V(697) = V_USER(609)
  V(396) = V_USER(610)
  V(367) = V_USER(611)
  V(368) = V_USER(612)
  V(369) = V_USER(613)
  V(282) = V_USER(614)
  V(283) = V_USER(615)
  V(284) = V_USER(616)
  V(635) = V_USER(617)
  V(370) = V_USER(618)
  V(604) = V_USER(619)
  V(285) = V_USER(620)
  V(678) = V_USER(621)
  V(371) = V_USER(622)
  V(397) = V_USER(623)
  V(66) = V_USER(638)
  V(914) = V_USER(643)
  V(154) = V_USER(644)
  V(51) = V_USER(645)
  V(83) = V_USER(646)
  V(605) = V_USER(647)
  V(876) = V_USER(648)
  V(824) = V_USER(649)
  V(215) = V_USER(650)
  V(84) = V_USER(651)
  V(85) = V_USER(670)
  V(1) = V_USER(671)
  V(2) = V_USER(672)
  V(128) = V_USER(673)
  V(372) = V_USER(674)
  V(52) = V_USER(675)
  V(517) = V_USER(676)
  V(879) = V_USER(677)
  V(849) = V_USER(678)
  V(3) = V_USER(679)
  V(216) = V_USER(681)
  V(155) = V_USER(682)
  V(591) = V_USER(683)
  V(894) = V_USER(684)
  V(10) = V_USER(685)
  V(592) = V_USER(686)
  V(831) = V_USER(687)
  V(687) = V_USER(688)
  V(287) = V_USER(689)
  V(783) = V_USER(690)
  V(561) = V_USER(691)
  V(425) = V_USER(692)
  V(916) = V_USER(698)
  V(156) = V_USER(699)
  V(11) = V_USER(700)
  V(839) = V_USER(886)
  V(838) = V_USER(887)
  V(12) = V_USER(888)
  V(144) = V_USER(889)
  V(143) = V_USER(890)
  V(13) = V_USER(891)
  V(53) = V_USER(892)
  V(55) = V_USER(893)
  V(54) = V_USER(894)
  V(218) = V_USER(895)
  V(86) = V_USER(896)
  V(608) = V_USER(897)
  V(723) = V_USER(898)
  V(288) = V_USER(899)
  V(399) = V_USER(900)
  V(472) = V_USER(901)
  V(67) = V_USER(902)
  V(14) = V_USER(903)
  V(68) = V_USER(904)
  V(400) = V_USER(905)
  V(427) = V_USER(906)
  V(157) = V_USER(907)
  V(794) = V_USER(908)
  V(500) = V_USER(909)
  V(401) = V_USER(910)
  V(795) = V_USER(911)
  V(219) = V_USER(912)
  V(291) = V_USER(913)
  V(220) = V_USER(914)
  V(221) = V_USER(915)
  V(292) = V_USER(916)
  V(15) = V_USER(917)
  V(222) = V_USER(918)
  V(932) = V_USER(919)
  V(751) = V_USER(920)
  V(796) = V_USER(921)
  V(374) = V_USER(922)
  V(501) = V_USER(923)
  V(454) = V_USER(924)
  V(103) = V_USER(925)
  V(16) = V_USER(926)
  V(17) = V_USER(927)
  V(908) = V_USER(928)
  V(473) = V_USER(929)
  V(158) = V_USER(930)
  V(627) = V_USER(931)
  V(223) = V_USER(932)
      
END SUBROUTINE Shuffle_user2kpp

! End of Shuffle_user2kpp function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_kpp2user - function to restore concentrations from KPP to USER
!   Arguments :
!      V         - Concentrations of variable species (local)
!      V_USER    - Concentration of variable species in USER's order
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_kpp2user ( V, V_USER )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)

  V_USER(1) = V(789)
  V_USER(2) = V(885)
  V_USER(3) = V(906)
  V_USER(4) = V(247)
  V_USER(5) = V(294)
  V_USER(6) = V(927)
  V_USER(7) = V(924)
  V_USER(8) = V(899)
  V_USER(9) = V(843)
  V_USER(10) = V(142)
  V_USER(13) = V(833)
  V_USER(14) = V(7)
  V_USER(15) = V(929)
  V_USER(16) = V(919)
  V_USER(17) = V(921)
  V_USER(18) = V(445)
  V_USER(19) = V(807)
  V_USER(20) = V(878)
  V_USER(21) = V(511)
  V_USER(22) = V(666)
  V_USER(23) = V(667)
  V_USER(24) = V(311)
  V_USER(25) = V(512)
  V_USER(26) = V(234)
  V_USER(27) = V(8)
  V_USER(28) = V(877)
  V_USER(29) = V(521)
  V_USER(30) = V(863)
  V_USER(31) = V(891)
  V_USER(32) = V(915)
  V_USER(33) = V(746)
  V_USER(34) = V(804)
  V_USER(35) = V(575)
  V_USER(36) = V(900)
  V_USER(37) = V(903)
  V_USER(38) = V(901)
  V_USER(39) = V(778)
  V_USER(40) = V(173)
  V_USER(41) = V(648)
  V_USER(42) = V(668)
  V_USER(43) = V(486)
  V_USER(44) = V(553)
  V_USER(45) = V(235)
  V_USER(46) = V(670)
  V_USER(47) = V(487)
  V_USER(48) = V(104)
  V_USER(49) = V(9)
  V_USER(50) = V(407)
  V_USER(51) = V(834)
  V_USER(52) = V(773)
  V_USER(53) = V(244)
  V_USER(54) = V(381)
  V_USER(55) = V(237)
  V_USER(56) = V(559)
  V_USER(57) = V(625)
  V_USER(58) = V(880)
  V_USER(59) = V(747)
  V_USER(60) = V(593)
  V_USER(61) = V(872)
  V_USER(62) = V(431)
  V_USER(63) = V(817)
  V_USER(64) = V(302)
  V_USER(65) = V(166)
  V_USER(66) = V(881)
  V_USER(67) = V(860)
  V_USER(68) = V(763)
  V_USER(69) = V(799)
  V_USER(70) = V(832)
  V_USER(71) = V(589)
  V_USER(72) = V(289)
  V_USER(73) = V(873)
  V_USER(74) = V(887)
  V_USER(75) = V(739)
  V_USER(76) = V(693)
  V_USER(77) = V(859)
  V_USER(78) = V(440)
  V_USER(79) = V(525)
  V_USER(80) = V(793)
  V_USER(81) = V(453)
  V_USER(82) = V(802)
  V_USER(83) = V(335)
  V_USER(84) = V(466)
  V_USER(85) = V(362)
  V_USER(86) = V(469)
  V_USER(87) = V(623)
  V_USER(88) = V(471)
  V_USER(89) = V(498)
  V_USER(90) = V(777)
  V_USER(91) = V(563)
  V_USER(92) = V(159)
  V_USER(93) = V(527)
  V_USER(94) = V(528)
  V_USER(95) = V(842)
  V_USER(96) = V(672)
  V_USER(97) = V(780)
  V_USER(98) = V(225)
  V_USER(99) = V(760)
  V_USER(100) = V(380)
  V_USER(101) = V(673)
  V_USER(102) = V(844)
  V_USER(103) = V(71)
  V_USER(104) = V(439)
  V_USER(105) = V(848)
  V_USER(106) = V(782)
  V_USER(107) = V(827)
  V_USER(108) = V(686)
  V_USER(109) = V(406)
  V_USER(110) = V(835)
  V_USER(111) = V(733)
  V_USER(112) = V(230)
  V_USER(113) = V(815)
  V_USER(114) = V(175)
  V_USER(115) = V(562)
  V_USER(116) = V(105)
  V_USER(117) = V(639)
  V_USER(118) = V(182)
  V_USER(119) = V(731)
  V_USER(120) = V(485)
  V_USER(121) = V(601)
  V_USER(122) = V(650)
  V_USER(123) = V(719)
  V_USER(124) = V(409)
  V_USER(125) = V(609)
  V_USER(126) = V(347)
  V_USER(127) = V(152)
  V_USER(128) = V(874)
  V_USER(129) = V(581)
  V_USER(130) = V(357)
  V_USER(131) = V(240)
  V_USER(132) = V(208)
  V_USER(133) = V(560)
  V_USER(134) = V(743)
  V_USER(135) = V(375)
  V_USER(136) = V(744)
  V_USER(137) = V(296)
  V_USER(138) = V(72)
  V_USER(139) = V(378)
  V_USER(140) = V(379)
  V_USER(141) = V(504)
  V_USER(142) = V(303)
  V_USER(143) = V(106)
  V_USER(144) = V(681)
  V_USER(145) = V(480)
  V_USER(146) = V(308)
  V_USER(147) = V(574)
  V_USER(148) = V(426)
  V_USER(149) = V(373)
  V_USER(150) = V(61)
  V_USER(151) = V(756)
  V_USER(152) = V(403)
  V_USER(153) = V(483)
  V_USER(154) = V(624)
  V_USER(155) = V(145)
  V_USER(156) = V(774)
  V_USER(157) = V(467)
  V_USER(158) = V(210)
  V_USER(159) = V(669)
  V_USER(160) = V(217)
  V_USER(161) = V(779)
  V_USER(162) = V(290)
  V_USER(163) = V(455)
  V_USER(164) = V(295)
  V_USER(165) = V(583)
  V_USER(166) = V(738)
  V_USER(167) = V(569)
  V_USER(168) = V(706)
  V_USER(169) = V(107)
  V_USER(170) = V(73)
  V_USER(171) = V(571)
  V_USER(172) = V(757)
  V_USER(173) = V(683)
  V_USER(174) = V(858)
  V_USER(175) = V(310)
  V_USER(176) = V(788)
  V_USER(177) = V(484)
  V_USER(178) = V(814)
  V_USER(179) = V(769)
  V_USER(180) = V(74)
  V_USER(181) = V(704)
  V_USER(182) = V(541)
  V_USER(183) = V(513)
  V_USER(184) = V(556)
  V_USER(185) = V(516)
  V_USER(186) = V(713)
  V_USER(187) = V(727)
  V_USER(188) = V(599)
  V_USER(189) = V(319)
  V_USER(190) = V(75)
  V_USER(191) = V(428)
  V_USER(192) = V(328)
  V_USER(193) = V(715)
  V_USER(194) = V(657)
  V_USER(195) = V(389)
  V_USER(196) = V(816)
  V_USER(197) = V(262)
  V_USER(198) = V(572)
  V_USER(199) = V(345)
  V_USER(200) = V(775)
  V_USER(201) = V(266)
  V_USER(202) = V(826)
  V_USER(203) = V(522)
  V_USER(204) = V(821)
  V_USER(205) = V(270)
  V_USER(206) = V(649)
  V_USER(207) = V(819)
  V_USER(208) = V(514)
  V_USER(209) = V(621)
  V_USER(210) = V(174)
  V_USER(211) = V(809)
  V_USER(212) = V(62)
  V_USER(213) = V(363)
  V_USER(214) = V(745)
  V_USER(215) = V(495)
  V_USER(216) = V(424)
  V_USER(217) = V(108)
  V_USER(218) = V(558)
  V_USER(219) = V(752)
  V_USER(220) = V(286)
  V_USER(221) = V(607)
  V_USER(222) = V(109)
  V_USER(223) = V(110)
  V_USER(224) = V(729)
  V_USER(225) = V(176)
  V_USER(226) = V(758)
  V_USER(227) = V(177)
  V_USER(228) = V(542)
  V_USER(229) = V(477)
  V_USER(230) = V(761)
  V_USER(231) = V(301)
  V_USER(232) = V(688)
  V_USER(233) = V(478)
  V_USER(234) = V(805)
  V_USER(235) = V(785)
  V_USER(236) = V(637)
  V_USER(237) = V(482)
  V_USER(238) = V(111)
  V_USER(239) = V(312)
  V_USER(240) = V(736)
  V_USER(241) = V(377)
  V_USER(242) = V(343)
  V_USER(243) = V(346)
  V_USER(244) = V(356)
  V_USER(245) = V(275)
  V_USER(246) = V(543)
  V_USER(247) = V(475)
  V_USER(248) = V(629)
  V_USER(249) = V(434)
  V_USER(250) = V(435)
  V_USER(251) = V(383)
  V_USER(252) = V(376)
  V_USER(253) = V(565)
  V_USER(254) = V(451)
  V_USER(255) = V(441)
  V_USER(256) = V(530)
  V_USER(257) = V(680)
  V_USER(258) = V(417)
  V_USER(259) = V(671)
  V_USER(260) = V(493)
  V_USER(261) = V(850)
  V_USER(262) = V(619)
  V_USER(263) = V(750)
  V_USER(264) = V(539)
  V_USER(265) = V(408)
  V_USER(266) = V(414)
  V_USER(267) = V(603)
  V_USER(268) = V(535)
  V_USER(269) = V(112)
  V_USER(270) = V(770)
  V_USER(271) = V(611)
  V_USER(272) = V(632)
  V_USER(273) = V(524)
  V_USER(274) = V(354)
  V_USER(275) = V(869)
  V_USER(276) = V(490)
  V_USER(277) = V(248)
  V_USER(278) = V(492)
  V_USER(279) = V(178)
  V_USER(280) = V(146)
  V_USER(281) = V(533)
  V_USER(282) = V(361)
  V_USER(283) = V(554)
  V_USER(284) = V(179)
  V_USER(285) = V(600)
  V_USER(286) = V(249)
  V_USER(287) = V(790)
  V_USER(288) = V(787)
  V_USER(289) = V(180)
  V_USER(290) = V(803)
  V_USER(291) = V(675)
  V_USER(292) = V(703)
  V_USER(293) = V(76)
  V_USER(294) = V(868)
  V_USER(295) = V(856)
  V_USER(296) = V(540)
  V_USER(297) = V(812)
  V_USER(298) = V(474)
  V_USER(299) = V(754)
  V_USER(300) = V(181)
  V_USER(301) = V(866)
  V_USER(302) = V(236)
  V_USER(303) = V(808)
  V_USER(304) = V(854)
  V_USER(305) = V(113)
  V_USER(306) = V(836)
  V_USER(307) = V(612)
  V_USER(308) = V(459)
  V_USER(309) = V(147)
  V_USER(310) = V(656)
  V_USER(311) = V(660)
  V_USER(312) = V(734)
  V_USER(313) = V(183)
  V_USER(314) = V(114)
  V_USER(315) = V(662)
  V_USER(316) = V(115)
  V_USER(317) = V(702)
  V_USER(318) = V(470)
  V_USER(319) = V(798)
  V_USER(320) = V(633)
  V_USER(321) = V(476)
  V_USER(322) = V(116)
  V_USER(323) = V(701)
  V_USER(324) = V(318)
  V_USER(325) = V(822)
  V_USER(326) = V(628)
  V_USER(327) = V(437)
  V_USER(328) = V(481)
  V_USER(329) = V(117)
  V_USER(330) = V(644)
  V_USER(331) = V(184)
  V_USER(332) = V(568)
  V_USER(333) = V(772)
  V_USER(334) = V(250)
  V_USER(335) = V(148)
  V_USER(336) = V(251)
  V_USER(337) = V(320)
  V_USER(338) = V(321)
  V_USER(339) = V(322)
  V_USER(340) = V(797)
  V_USER(341) = V(413)
  V_USER(342) = V(499)
  V_USER(343) = V(810)
  V_USER(344) = V(646)
  V_USER(345) = V(252)
  V_USER(346) = V(323)
  V_USER(347) = V(537)
  V_USER(348) = V(185)
  V_USER(349) = V(77)
  V_USER(350) = V(324)
  V_USER(351) = V(325)
  V_USER(352) = V(326)
  V_USER(353) = V(532)
  V_USER(354) = V(555)
  V_USER(355) = V(253)
  V_USER(356) = V(714)
  V_USER(357) = V(489)
  V_USER(358) = V(254)
  V_USER(359) = V(818)
  V_USER(360) = V(861)
  V_USER(361) = V(118)
  V_USER(362) = V(820)
  V_USER(363) = V(255)
  V_USER(364) = V(256)
  V_USER(365) = V(149)
  V_USER(366) = V(448)
  V_USER(367) = V(837)
  V_USER(368) = V(865)
  V_USER(369) = V(150)
  V_USER(370) = V(395)
  V_USER(371) = V(730)
  V_USER(372) = V(711)
  V_USER(373) = V(526)
  V_USER(374) = V(452)
  V_USER(375) = V(694)
  V_USER(376) = V(870)
  V_USER(377) = V(867)
  V_USER(378) = V(622)
  V_USER(379) = V(862)
  V_USER(380) = V(676)
  V_USER(381) = V(186)
  V_USER(382) = V(630)
  V_USER(383) = V(433)
  V_USER(384) = V(712)
  V_USER(385) = V(529)
  V_USER(386) = V(327)
  V_USER(387) = V(187)
  V_USER(388) = V(551)
  V_USER(389) = V(329)
  V_USER(390) = V(661)
  V_USER(391) = V(510)
  V_USER(392) = V(257)
  V_USER(393) = V(330)
  V_USER(394) = V(690)
  V_USER(395) = V(331)
  V_USER(396) = V(332)
  V_USER(397) = V(188)
  V_USER(398) = V(721)
  V_USER(399) = V(189)
  V_USER(400) = V(728)
  V_USER(401) = V(497)
  V_USER(402) = V(741)
  V_USER(403) = V(258)
  V_USER(404) = V(626)
  V_USER(405) = V(259)
  V_USER(406) = V(641)
  V_USER(407) = V(333)
  V_USER(408) = V(151)
  V_USER(409) = V(692)
  V_USER(410) = V(334)
  V_USER(411) = V(523)
  V_USER(412) = V(766)
  V_USER(413) = V(724)
  V_USER(414) = V(260)
  V_USER(415) = V(732)
  V_USER(416) = V(664)
  V_USER(417) = V(190)
  V_USER(418) = V(580)
  V_USER(419) = V(63)
  V_USER(420) = V(78)
  V_USER(421) = V(557)
  V_USER(422) = V(446)
  V_USER(423) = V(119)
  V_USER(424) = V(742)
  V_USER(425) = V(579)
  V_USER(426) = V(410)
  V_USER(427) = V(411)
  V_USER(428) = V(412)
  V_USER(429) = V(496)
  V_USER(430) = V(336)
  V_USER(431) = V(337)
  V_USER(432) = V(338)
  V_USER(433) = V(767)
  V_USER(434) = V(596)
  V_USER(435) = V(339)
  V_USER(436) = V(582)
  V_USER(437) = V(631)
  V_USER(438) = V(261)
  V_USER(439) = V(390)
  V_USER(440) = V(652)
  V_USER(441) = V(340)
  V_USER(442) = V(64)
  V_USER(443) = V(636)
  V_USER(444) = V(415)
  V_USER(445) = V(658)
  V_USER(446) = V(341)
  V_USER(447) = V(585)
  V_USER(448) = V(708)
  V_USER(449) = V(191)
  V_USER(450) = V(665)
  V_USER(451) = V(342)
  V_USER(452) = V(192)
  V_USER(453) = V(534)
  V_USER(454) = V(263)
  V_USER(455) = V(587)
  V_USER(456) = V(264)
  V_USER(457) = V(640)
  V_USER(458) = V(265)
  V_USER(459) = V(577)
  V_USER(460) = V(749)
  V_USER(461) = V(120)
  V_USER(462) = V(50)
  V_USER(463) = V(391)
  V_USER(464) = V(46)
  V_USER(465) = V(655)
  V_USER(466) = V(617)
  V_USER(467) = V(344)
  V_USER(468) = V(509)
  V_USER(469) = V(193)
  V_USER(470) = V(735)
  V_USER(471) = V(194)
  V_USER(472) = V(564)
  V_USER(473) = V(616)
  V_USER(474) = V(398)
  V_USER(475) = V(416)
  V_USER(476) = V(578)
  V_USER(477) = V(643)
  V_USER(478) = V(195)
  V_USER(479) = V(642)
  V_USER(480) = V(645)
  V_USER(481) = V(196)
  V_USER(482) = V(238)
  V_USER(483) = V(79)
  V_USER(484) = V(613)
  V_USER(485) = V(508)
  V_USER(486) = V(121)
  V_USER(487) = V(716)
  V_USER(488) = V(573)
  V_USER(489) = V(348)
  V_USER(490) = V(197)
  V_USER(491) = V(726)
  V_USER(492) = V(198)
  V_USER(493) = V(762)
  V_USER(494) = V(488)
  V_USER(495) = V(684)
  V_USER(496) = V(267)
  V_USER(497) = V(550)
  V_USER(498) = V(122)
  V_USER(499) = V(349)
  V_USER(500) = V(350)
  V_USER(501) = V(268)
  V_USER(502) = V(765)
  V_USER(503) = V(590)
  V_USER(504) = V(351)
  V_USER(505) = V(748)
  V_USER(506) = V(594)
  V_USER(507) = V(352)
  V_USER(508) = V(65)
  V_USER(509) = V(353)
  V_USER(510) = V(597)
  V_USER(511) = V(584)
  V_USER(512) = V(707)
  V_USER(513) = V(199)
  V_USER(514) = V(615)
  V_USER(515) = V(468)
  V_USER(516) = V(638)
  V_USER(517) = V(418)
  V_USER(518) = V(618)
  V_USER(519) = V(269)
  V_USER(520) = V(419)
  V_USER(521) = V(586)
  V_USER(522) = V(420)
  V_USER(523) = V(355)
  V_USER(524) = V(764)
  V_USER(525) = V(552)
  V_USER(526) = V(725)
  V_USER(527) = V(200)
  V_USER(528) = V(602)
  V_USER(529) = V(271)
  V_USER(530) = V(392)
  V_USER(531) = V(447)
  V_USER(532) = V(201)
  V_USER(533) = V(491)
  V_USER(534) = V(272)
  V_USER(535) = V(567)
  V_USER(536) = V(273)
  V_USER(537) = V(709)
  V_USER(538) = V(274)
  V_USER(539) = V(699)
  V_USER(540) = V(202)
  V_USER(541) = V(239)
  V_USER(542) = V(123)
  V_USER(543) = V(588)
  V_USER(544) = V(124)
  V_USER(545) = V(125)
  V_USER(546) = V(393)
  V_USER(547) = V(740)
  V_USER(548) = V(595)
  V_USER(549) = V(358)
  V_USER(550) = V(421)
  V_USER(551) = V(359)
  V_USER(552) = V(360)
  V_USER(553) = V(203)
  V_USER(554) = V(598)
  V_USER(555) = V(126)
  V_USER(556) = V(394)
  V_USER(557) = V(781)
  V_USER(558) = V(204)
  V_USER(559) = V(606)
  V_USER(560) = V(205)
  V_USER(561) = V(276)
  V_USER(562) = V(846)
  V_USER(563) = V(277)
  V_USER(564) = V(847)
  V_USER(565) = V(278)
  V_USER(566) = V(449)
  V_USER(567) = V(206)
  V_USER(568) = V(494)
  V_USER(569) = V(279)
  V_USER(570) = V(80)
  V_USER(571) = V(700)
  V_USER(572) = V(81)
  V_USER(573) = V(536)
  V_USER(574) = V(784)
  V_USER(575) = V(840)
  V_USER(576) = V(207)
  V_USER(577) = V(127)
  V_USER(578) = V(364)
  V_USER(579) = V(422)
  V_USER(580) = V(209)
  V_USER(581) = V(423)
  V_USER(582) = V(313)
  V_USER(583) = V(786)
  V_USER(584) = V(811)
  V_USER(585) = V(717)
  V_USER(586) = V(698)
  V_USER(587) = V(365)
  V_USER(588) = V(677)
  V_USER(589) = V(576)
  V_USER(590) = V(280)
  V_USER(591) = V(153)
  V_USER(592) = V(674)
  V_USER(593) = V(366)
  V_USER(594) = V(759)
  V_USER(595) = V(647)
  V_USER(596) = V(718)
  V_USER(597) = V(211)
  V_USER(598) = V(82)
  V_USER(599) = V(450)
  V_USER(600) = V(212)
  V_USER(601) = V(853)
  V_USER(602) = V(538)
  V_USER(603) = V(213)
  V_USER(604) = V(214)
  V_USER(605) = V(314)
  V_USER(606) = V(515)
  V_USER(607) = V(281)
  V_USER(608) = V(710)
  V_USER(609) = V(697)
  V_USER(610) = V(396)
  V_USER(611) = V(367)
  V_USER(612) = V(368)
  V_USER(613) = V(369)
  V_USER(614) = V(282)
  V_USER(615) = V(283)
  V_USER(616) = V(284)
  V_USER(617) = V(635)
  V_USER(618) = V(370)
  V_USER(619) = V(604)
  V_USER(620) = V(285)
  V_USER(621) = V(678)
  V_USER(622) = V(371)
  V_USER(623) = V(397)
  V_USER(638) = V(66)
  V_USER(643) = V(914)
  V_USER(644) = V(154)
  V_USER(645) = V(51)
  V_USER(646) = V(83)
  V_USER(647) = V(605)
  V_USER(648) = V(876)
  V_USER(649) = V(824)
  V_USER(650) = V(215)
  V_USER(651) = V(84)
  V_USER(670) = V(85)
  V_USER(671) = V(1)
  V_USER(672) = V(2)
  V_USER(673) = V(128)
  V_USER(674) = V(372)
  V_USER(675) = V(52)
  V_USER(676) = V(517)
  V_USER(677) = V(879)
  V_USER(678) = V(849)
  V_USER(679) = V(3)
  V_USER(681) = V(216)
  V_USER(682) = V(155)
  V_USER(683) = V(591)
  V_USER(684) = V(894)
  V_USER(685) = V(10)
  V_USER(686) = V(592)
  V_USER(687) = V(831)
  V_USER(688) = V(687)
  V_USER(689) = V(287)
  V_USER(690) = V(783)
  V_USER(691) = V(561)
  V_USER(692) = V(425)
  V_USER(698) = V(916)
  V_USER(699) = V(156)
  V_USER(700) = V(11)
  V_USER(886) = V(839)
  V_USER(887) = V(838)
  V_USER(888) = V(12)
  V_USER(889) = V(144)
  V_USER(890) = V(143)
  V_USER(891) = V(13)
  V_USER(892) = V(53)
  V_USER(893) = V(55)
  V_USER(894) = V(54)
  V_USER(895) = V(218)
  V_USER(896) = V(86)
  V_USER(897) = V(608)
  V_USER(898) = V(723)
  V_USER(899) = V(288)
  V_USER(900) = V(399)
  V_USER(901) = V(472)
  V_USER(902) = V(67)
  V_USER(903) = V(14)
  V_USER(904) = V(68)
  V_USER(905) = V(400)
  V_USER(906) = V(427)
  V_USER(907) = V(157)
  V_USER(908) = V(794)
  V_USER(909) = V(500)
  V_USER(910) = V(401)
  V_USER(911) = V(795)
  V_USER(912) = V(219)
  V_USER(913) = V(291)
  V_USER(914) = V(220)
  V_USER(915) = V(221)
  V_USER(916) = V(292)
  V_USER(917) = V(15)
  V_USER(918) = V(222)
  V_USER(919) = V(932)
  V_USER(920) = V(751)
  V_USER(921) = V(796)
  V_USER(922) = V(374)
  V_USER(923) = V(501)
  V_USER(924) = V(454)
  V_USER(925) = V(103)
  V_USER(926) = V(16)
  V_USER(927) = V(17)
  V_USER(928) = V(908)
  V_USER(929) = V(473)
  V_USER(930) = V(158)
  V_USER(931) = V(627)
  V_USER(932) = V(223)
      
END SUBROUTINE Shuffle_kpp2user

! End of Shuffle_kpp2user function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! GetMass - compute total mass of selected atoms
!   Arguments :
!      CL        - Concentration of all species (local)
!      Mass      - value of mass balance
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE GetMass ( CL, Mass )

! CL - Concentration of all species (local)
  REAL(kind=dp) :: CL(NSPEC)
! Mass - value of mass balance
  REAL(kind=dp) :: Mass(1)

      
END SUBROUTINE GetMass

! End of GetMass function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Util

