! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Rates.f90
! Time                 : Tue Nov  2 10:18:18 2021
! Working directory    : /home/matthias/MAFOR_GIT/mafor/src/CAABA/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Rates

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_Global
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
      REAL A0,B0,C0      
      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
   END FUNCTION ARR        

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
      REAL A0,B0           
      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )              
   END FUNCTION ARR2          

   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
      REAL A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3            
      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
      K3 = K3*CFACTOR*1.0E6_dp
      EP2 = K0 + K3/(1.0_dp+K3/K2 )
   END FUNCTION EP2

   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2) 
      REAL A1, C1, A2, C2
      REAL(kind=dp) K1, K2      
      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
   END FUNCTION EP3 

   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
      REAL A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1     
      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
      K0 = K0*CFACTOR*1.0E6_dp
      K1 = K0/K1
      FALL = (K0/(1.0_dp+K1))*   &
           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
   END FUNCTION FALL

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


  ELEMENTAL REAL(dp) FUNCTION k_SIV_H2O2 (k_298,tdep,cHp,temp)
    ! special rate function for S(IV) + H2O2
    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(dp), INTENT(IN) :: cHp   ! c(H+)
    REAL(dp), INTENT(IN) :: temp  ! temperature
    INTRINSIC :: EXP
    k_SIV_H2O2 = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) &
      * cHp / (cHp+0.1_dp)
  END FUNCTION k_SIV_H2O2
  ELEMENTAL REAL(dp) FUNCTION k_3rd_iupac(temp,cair,k0_300K,n,kinf_300K,m,fc)
    ! IUPAC three body reaction formula (iupac.pole-ether.fr)
    INTRINSIC :: LOG10
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL,     INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL,     INTENT(IN) :: n         ! exponent for low pressure limit
    REAL,     INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL,     INTENT(IN) :: m         ! exponent for high pressure limit
    REAL,     INTENT(IN) :: fc        ! broadening factor (e.g. 0.45 or 0.6...)
    REAL                 :: nu        ! N
    REAL                 :: zt_help, k0_T, kinf_T, k_ratio
    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    nu      = 0.75-1.27*LOG10(fc)
    k_3rd_iupac = k0_T/(1._dp+k_ratio)* &
      fc**(1._dp/(1._dp+(LOG10(k_ratio)/nu)**2))
  END FUNCTION k_3rd_iupac
  ELEMENTAL REAL(dp) FUNCTION alpha_AN(n,ro2type,bcarb,gcarb,abic,temp,cair)
  ! Alkyl nitrate yields dependent on T and P according to
  ! Arey. ref3202 and Teng, ref3189
    INTRINSIC :: LOG10
    INTEGER,  INTENT(IN) :: n         ! number of heavy atoms (C, O, N) except the O atom of beta-carbonyls
    INTEGER,  INTENT(IN) :: ro2type   ! 1, 2 or 3 for primary, secondary and tertiary RO2
    INTEGER,  INTENT(IN) :: bcarb     ! 1 for beta-carbonyl group, 0 for none
    INTEGER,  INTENT(IN) :: gcarb     ! 1 for gamma-carbonyl group, 0 for none
    INTEGER,  INTENT(IN) :: abic      ! 1 for bicyclic peroxy from aromatics, 0 for none
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), PARAMETER  :: alpha=2.E-22, beta=1.0, Yinf_298K=0.43, F=0.41, m0=0., minf=8.0
    REAL(dp)             :: m           ! factor for primary, secondary and tertiary RO2
    REAL(dp)             :: bcf,gcf,abf ! reduction factors for the presence of beta-carbonyl and gamma-carbonyl group and a bicyclic peroxy from aromatics
    REAL(dp)             :: Y0_298K, Y0_298K_tp, Yinf_298K_t, zeta, k_ratio
    m = 1. ! According to Teng, ref3189
    IF (bcarb .EQ. 1) THEN
      bcf = 0.19 ! derived from Praske, ref3190: alpha_AN = 0.03 for the secondary HMKO2 relative to alpha_AN for 6C RO2 (0.16)
    ELSE IF (bcarb .EQ. 0) THEN
      bcf = 1.
    ELSE
      bcf = 1.
    ENDIF
    IF (gcarb .EQ. 1) THEN
      gcf = 0.44 ! derived from Praske, ref3190: alpha_AN = 0.07 for the primary HMKO2 relative to alpha_AN for 6C RO2 (0.16)
    ELSE IF (gcarb .EQ. 0) THEN
      gcf = 1.
    ELSE
      gcf = 1.
    ENDIF
    IF (abic .EQ. 1) THEN
      abf = 0.24 ! ratio of AN-yield for toluene (Elrod et al., ref3180), 5.5 0x0p+0t 200 torr, and this SAR for linear alkyl RO2 with 9 heavy atoms, 23.3%
    ELSE IF (abic .EQ. 0) THEN
      abf = 1.
    ENDIF
    Y0_298K     = alpha*EXP(beta*n)
    Y0_298K_tp  = Y0_298K * cair * (temp/298)**(-m0)
    Yinf_298K_t = Yinf_298K * (temp/298)**(-minf)
    zeta        = 1/(1+LOG10(Y0_298K_tp/Yinf_298K_t)**2)
    k_ratio     = (Y0_298K_tp/(1+Y0_298K_tp/Yinf_298K_t))*F**zeta
    alpha_AN    = k_ratio/(1+k_ratio) * m * bcf * gcf * abf
  END FUNCTION alpha_AN
  ELEMENTAL REAL(dp) FUNCTION k_limited (k3rd,cHp)
    ! diffusion limitation caps 3rd order rate coefficients
    REAL(dp), INTENT(IN) :: k3rd  ! 3rd order rate coefficient
    REAL(dp), INTENT(IN) :: cHp   ! c(H+)
    REAL(dp), PARAMETER  :: DiffLimit = 1E10 ! diffusion limitation [M-1s-1]
    INTRINSIC :: EXP
    k_limited = 1._dp / ( 1._dp/k3rd + cHp/DiffLimit)
  END FUNCTION k_limited
  ELEMENTAL REAL(dp) FUNCTION k_N2_O(temp,temp_ion)
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: temp_ion  ! ion temperature [K]
    REAL                 :: temp_mean
    temp_mean = (temp_ion + temp)/2
    k_N2_O = 1.4E-10*(300./temp_mean)**0.44
  END FUNCTION k_N2_O
  ELEMENTAL REAL(dp) FUNCTION k_Op_O2(temp,temp_ion)
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: temp_ion  ! ion temperature [K]
    REAL(dp)             :: temp_mean
    temp_mean  = 0.667*temp_ion + 0.333*temp
    k_Op_O2  = 2.82E-11 - 7.74E-12*(temp_mean/300.) + &
      1.073E-12*(temp_mean/300.)**2 - 5.17E-14*(temp_mean/300.)**3 + &
      9.65E-16*(temp_mean/300.)**4
  END FUNCTION k_Op_O2
  ELEMENTAL REAL(dp) FUNCTION k_Op_N2(temp,temp_ion)
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: temp_ion  ! ion temperature [K]
    REAL(dp)             :: temp_mean
    temp_mean = 0.6363*temp_ion + 0.3637*temp
    k_Op_N2 = 1.533E-12 - 5.92E-13*(temp_mean/300.) + 8.6E-14*(temp_mean/300.)**2
  END FUNCTION k_Op_N2

! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE messy_mecca_kpp_Parameters
      !USE messy_mecca_kpp_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


  USE messy_main_constants_mem ! atm2Pa, N_A, R_gas
  USE messy_cmn_photol_mem     ! IP_MAX, ip_*, jname
  ! end of USE statements

  ! start of executable statements
  ! define some rate constants here if the expressions are too long
  ! for kpp or if they are used more than once
  ! --------------------------------------------------------------------------
  ! only for maforchem, see maforchem.rpl:
  !MSK: GENERIC RATE CONSTANTS
  k_RO_O2      = 9.5E-15                ! MCM, 2001
  k_DEC        = 1.0E+06                ! MCM, 1997
  !MSK: AMINE RELATED RATE CONSTANTS
  k_MEA_OH     = 3.58E-11               ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010
  k_H2NCHO_OH  = 4.0E-12                ! Barnes et al., CPC 2010
  k_MMI_OH     = 1.0E-12                ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010
  k_AAC_OH     = 4.83E-11               ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010
  k_OXA_OH     = 1.47E-11               ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010 
  k_HAC_OH     = 4.59E-12               ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010   
  k_NITRAMA_OH = 1.48E-11               ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010
  k_MMA_OH     = 8.0E-12*EXP(230./temp) ! k_T Atkinson 1978,Carl+Crowley 1998
  k_DMA_OH     = 2.89E-11*EXP(245./temp)! k_T Atkinson 1978
  k_TMA_OH     = 1.6E-11*EXP(250./temp) ! k_T Atkinson 1978,Carl+Crowley 1998
  k_DEA_OH     = 9.27E-11               ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010
  k_TEA_OH     = 1.11E-10               ! EPI Suite 4.0, Heimsted+Harju,p.c. 2010
  k_AMP_OH     = 2.8E-11                ! Harris and Pitts 1983
  k_AMP_NO3    = 5.9E-14                ! Carter 2008
  !MSK: DMS RELATED RATE CONSTANTS (EL CID) 
  k_CH3SO2_O3  = 6.3E-13
  k_CH3SO3_HO2 = 5.E-11
  k_DMS_Cl     = 3.3E-10
  k_DMSO2_OH   = 1.5E-13
  ! k_CH3SO2_dec = 10.
  k_CH3SO3_dec = 1.2E-3
  k_MSIA_OH    = 9.0E-11
  k_DMSO_OH    = 6.15E-12*EXP(800./temp)
  k_B1         = 8.46E-13*EXP(944./temp)
  k_B2         = 1.60E-14*EXP(1628./temp)
  k_DMSO_OH_B1 = k_DMSO_OH*(k_B1/(k_B1+k_B2))
  k_DMSO_OH_B2 = k_DMSO_OH*(k_B2/(k_B1+k_B2))
  ! end of maforchem block
  ! --------------------------------------------------------------------------
   RO2 = 0.
  ! AMINE RO2
  IF (ind_MMAO2>0)                RO2 = RO2 + C(ind_MMAO2)
  IF (ind_MEABO2>0)               RO2 = RO2 + C(ind_MEABO2)
  IF (ind_DMAO2>0)                RO2 = RO2 + C(ind_DMAO2)
  IF (ind_TMAO2>0)                RO2 = RO2 + C(ind_TMAO2)
  IF (ind_DMCNH2CO3>0)            RO2 = RO2 + C(ind_DMCNH2CO3)
  IF (ind_DMCOONH2>0)             RO2 = RO2 + C(ind_DMCOONH2)
  IF (ind_CHEXO2>0)               RO2 = RO2 + C(ind_CHEXO2)

  ! start of executable statements
  ! define some rate constants here if the expressions are too long
  ! for kpp or if they are used more than once
  ! --------------------------------------------------------------------------
  ! inorganic and C1 chemistry:
  k_HO2_HO2    = (3.0E-13*EXP(460./temp)+2.1E-33*EXP(920./temp)*cair)* &
                 (1.+1.4E-21*EXP(2200./temp)*C(ind_H2O))
  k_NO3_NO2    = k_3rd(temp,cair,2.4E-30,3.0,1.6E-12,-0.1,0.6)
  k_NO2_HO2    = k_3rd(temp,cair,1.9E-31,3.4,4.0E-12,0.3,0.6)
  k_HNO3_OH    = 1.32E-14*EXP(527./temp) + 1./ & ! "All data" in Tab. 1 of ref3325
                 ( 1./(7.39E-32*EXP(453./temp)*cair) + &
                 1./(9.73E-17*EXP(1910./temp)) ) ! 15 % (Pozzer, pers. comm.)
  k_CH3OOH_OH  = 5.3E-12*EXP(190./temp)
  k_CH3CO2H_OH = 4.0E-14*EXP(850./temp)
  k_ClO_ClO    = k_3rd(temp,cair,1.9E-32,3.6,3.7E-12,1.6,0.6)
  k_BrO_NO2    = k_3rd_iupac(temp,cair,4.7E-31,3.1,1.8E-11,0.0,0.4)
  ! JPL: k_BrO_NO2   = k_3rd(temp,cair,5.2E-31,3.2,6.9E-12,2.9,0.6)
  k_I_NO2      = k_3rd_iupac(temp,cair,3.0E-31,1.0,6.6E-11,0.0,0.63)
  ! for numerical reasons, the expression is multiplied by 1e30/1e30
  k_DMS_OH     = 1.E-9*EXP(5820./temp)*C(ind_O2)/ &
                 (1.E30+5.*EXP(6280./temp)*C(ind_O2))
  k_CH2OO_SO2  = 3.66E-11 ! average of 3.9E-11 + 3.42E-11
  k_O3s = (1.7E-12*EXP(-940./temp)) * C(ind_OH) &  ! <G2104>
        + (1.E-14*EXP(-490./temp)) * C(ind_HO2) &  ! <G2107>
        + jx(ip_O1D) * 2.2E-10 * C(ind_H2O) &      !
        / ( 3.2E-11*EXP(70./temp)*C(ind_O2)   &
           + 1.8E-11*EXP(110./temp)*C(ind_N2) &
           + 2.2E-10*C(ind_H2O) )
  ! new methane chemistry:
  ! branching ratio for methyl nitrate according to Butkovskaya et al.,
  ! (ref3177) but reduced according to Flocke et al. (ref3164)
  ! fit of data according to Lindemann-Hinshelwood scheme by J. Crowley
  ! http://iupac.pole-ether.fr/datasheets/pdf/ROO_1_CH3O2_NO.pdf
  beta_null_CH3NO3 = 0.00295 + 5.15E-22*cair*(temp/298)**7.4
  beta_inf_CH3NO3  = 0.022
  beta_CH3NO3      = (beta_null_CH3NO3 * beta_inf_CH3NO3) /&
                     (beta_null_CH3NO3 + beta_inf_CH3NO3) / 10.
  k_NO2_CH3O2      = k_3rd(temp,cair,1.0E-30,4.8,7.2E-12,2.1,0.6)
  k_C6H5O2_NO2     = k_NO2_CH3O2 ! Consistent with ref3167 that set 1E-12 as lower limit at 298 K and 1 bar.
  k_CH2OO_NO2          = 4.25E-12 ! average of 7.E-12 and 1.5E-12
  ! branching ratio for ethylnitrate formation according to Butkovskaya ref3170
  ! ratio transformed from beta = k1b/k1a to beta_C2H5NO3 = (1-(1+beta)^(-1))
  beta_C2H5NO3    = (1-1/(1+1.E-2*(3.88e-3*cair/2.46e19*760.+.365)*(1+1500.*(1/temp -1/298.))))
  ! --------------------------------------------------------------------------
  ! only for mim1, see mim1.rpl:
  ! op_kg_20110805+ for HO2 + NO -> HNO3 (butkovskaya_*.rpl)
  alpha_NO_HO2 = C(ind_H2O)*6.6E-27*temp*EXP(3700./temp)
  beta_NO_HO2  = MAX(((530./temp)+(press*4.8004E-6)-1.73)*0.01,0._dp)
  k0_NO_HO2    = 3.5E-12*EXP(250./temp)
  ! without humidity correction
  k2d_NO_HO2   = (beta_NO_HO2*k0_NO_HO2)/(1.+beta_NO_HO2)
  k1d_NO_HO2   = k0_NO_HO2 - k2d_NO_HO2
  ! with humidity correction
  k2w_NO_HO2   = (beta_NO_HO2*k0_NO_HO2*(1.+42.*alpha_NO_HO2))/ &
                 ((1.+alpha_NO_HO2)*(1.+beta_NO_HO2))
  k1w_NO_HO2   = k0_NO_HO2 - k2w_NO_HO2
  ! op_kg_20110805-
  k_PrO2_HO2   = 1.9E-13*EXP(1300./temp)
  k_PrO2_NO    = 2.7E-12*EXP(360./temp)
  k_PrO2_CH3O2 = 9.46E-14*EXP(431./temp)
  G7402a_yield = 0.8/1.1 ! 0.8+/-0.2
  ! end of mim1 block
  ! --------------------------------------------------------------------------
  k_CH3CO3_NO2 = k_3rd(temp,cair,9.7E-29,5.6,9.3E-12,1.5,0.6)
  k_PAN_M      = k_CH3CO3_NO2/(9.0E-29*EXP(14000./temp))
  ! rate coefficients from the MCM:
  KRO2NO  = 2.54E-12*EXP(360./temp)
  KRO2HO2(:) = 2.91E-13*EXP(1300./temp)*(1.-EXP(-0.245*REAL(nC(:),dp))) ! ref1630
  KAPNO   = 8.10E-12*EXP(270./temp)  ! CH3CO3 + NO
  KRO2NO3 = 2.30E-12 ! ref2419
  KNO3AL  = 1.4E-12*EXP(-1900./temp)
  ! updated rate constant for the RCO3+HO2 reactions
  ! (GroC, PhD Thesis, ref3195)
  ! except CH3CO3+HO2 that is taken from GroC ref3156
  KAPHO2  = 5.20E-13*EXP(980./temp)*1.865 ! at 298K k(hoch2co3 + ho2) = 2.6(+-0.4)E-11 scaled with IUPAC T-dependent expression
  ! Rate constants for the permutation reaction formalism
  ! calculated as in the permutation reaction formalism of MCM
  ! k_RO2 = 2.*(KRO2self*k_CH3O2)^0.5
  ! k_RO2self are taken from IUPAC recommendations unless noted otherwise
  k_CH3O2     = 1.03E-13*EXP(365./temp) ! CH3O2 + CH3O2 (IUPAC)
  ! Acyl peroxy radicals
  k_RO2RCO3   = 2.*2.E-12*EXP(500./temp) ! K17 for the CH3CO3 + CH3O2 reaction directly taken from ref. 1759. Old MCM value 1.00E-11 at 298 K.
  ! Alkyl radicals (unsubstituted, > C3)
  k_RO2pRO2   = 2.*(1.E-12*k_CH3O2)**(.5)                      ! Model compound (CH3)2CHCH2O2 (isobutyl, ref3210). Old MCM value 1.30E-12 at 298 K.
  k_RO2sRO2   = 2.*(1.6E-12*EXP(-2200./temp)*k_CH3O2)**(.5)! Model compound i-C3H7O2 (ref3175). Old MCM value 2.50E-13 at 298 K.
  k_RO2tRO2   = 2.*3.8E-13*EXP(-1430./temp)                ! Model reaction t-C4H9O2 + CH3O2. Old MCM value 6.70E-15 at 298 K.
  ! Alkyl radical with either O or Cl in beta
  k_RO2pORO2  = 2.*7.5E-13*EXP(500./temp)                      ! Model reaction CH3COCH2O2 + CH3O2 (ref3175). Old MCM value 2.00E-12
  k_RO2sORO2  = 2.*(7.7E-15*EXP(1330./temp)*k_CH3O2)**(.5) ! Model compound CH3CH(OH)CH(O2)CH3 (ref3175). Old MCM value 8.80E-13 at 298 K.
  k_RO2tORO2  = 2.*(4.7E-13*EXP(-1420./temp)*k_CH3O2)**(.5)    ! Model compound (CH3)2C(OH)CO2(CH3)2 (ref3175). Old MCM value 9.20E-14 at 298 K.
  ! Allyl- and beta-hydroxy alkyl radicals
  k_RO2LISOPACO2 = 2.*((2.8E-12+3.9E-12)/2.*k_CH3O2)**(.5)  ! Model compound ISOPAO2 and ISOPCO2. Old MCM value 2.0E-12 at 298 K. K15 average from MCM ref. 2419
  k_RO2ISOPBO2   = 2.*(6.9E-14*k_CH3O2)**(.5)                  ! Model compound ISOPBO2. Old MCM value 8.0E-13 at 298 K. K15 from MCM ref. 2419
  k_RO2ISOPDO2   = 2.*(4.8E-12*k_CH3O2)**(.5)                  ! Model compound ISOPDO2. Old MCM value 8.0E-13 at 298 K. K15 from MCM ref. 2419
  ! T-dependent H-abstraction group rate constants
  k_p          = 4.49E-18*temp*temp*EXP(-320./temp) ! Kwok and Atkinson, ref3194
  k_s          = 4.50E-18*temp*temp*EXP(253./temp)  ! Kwok and Atkinson, ref3194
  k_t          = 2.12E-18*temp*temp*EXP(696./temp)  ! Kwok and Atkinson, ref3194
  k_rohro      = 2.1E-18*temp*temp*EXP(-85./temp)   ! Kwok and Atkinson, ref3194
  k_roohro     = 0.6*k_CH3OOH_OH
  k_co2h       = 0.7*k_CH3CO2H_OH
  ! T-dependent OH-addition rate constants
  k_adp        = 4.5E-12*(temp/300.)**(-0.85)                        ! 1/2 k(OH + C2H4), high pressure limit IUPAC as in Peeters et al. 2007
  k_ads        = 0.25*(1.1E-11*EXP(485./temp)+1.0E-11*EXP(553./temp)) ! 1/2 * k_av(OH + cis/trans 2-butene) as in Peeters et al. 2007
  k_adt        = 1.922E-11*EXP(450./temp) - k_ads                    ! k(OH + 2-methyl-2-butene) - k_ads
  KHSB         = 1.52E11*EXP(-9512./temp)*1. ! 1,5-H-shift Peeters et al(2009) 0.003533 s-1 at 303K
  KHSD         = 6.08E10*EXP(-8893./temp)*1. ! 1,5-H-shift Peeters et al(2009) 0.0109 s-1 at 303K
  ! 1,6-H-shift for ZISOPAO2 and ZISOPCO2
  K16HSZ14     = 2.28E9 * exp(-6764/temp) * 0.28 ! 0.07035 s-1 at 295K ! as in SI Taraborrelli et al., Nat. Geosc. 2012
  K16HSZ41     = 1.23E9 * exp(-6186/temp) * 0.28 ! 0.2692 s-1 at 295K
  K16HS        = (K16HSZ14*K16HSZ41)**(.5)
  K15HSDHB     = 5.                             ! 1,5-H-shift assisted by double H-bonding after Peeters and MC<ller(2010)
  ! 1,4-H-shift involving an aldehydic hydrogen
  K14HSAL = 2.9E7*exp(-5297/temp) ! Crounse ref3331 barrier 19 kcal/mol => ~ 0.5 s-1 at 295K
  !K14HSAL      = 2.9E7*exp(-1*(5297+705)/temp) ! CCSD(T)/aug-Schartz4(DT)//M05-2X/6-311G(d,p)) yields a barrier of 20.39 (L. Vereecken 2013) => ~ 0.04 s-1 at 295K
  K15HS24VYNAL = K16HSZ14 * exp(-3500/(1.987*temp)) ! adding 3.5 kcal to the barrier of 1,6-H-shift as from SAR by L. Vereecken
  K15HS42VYNAL = K16HSZ41 * exp(-3500/(1.987*temp))
  KHYDEC       = 6.e14*exp(-16000./(1.98588*temp)) ! in cal Ea from Nguyen et al(2009) A from Baulch et al(2005)
  ! Rate constants for the formic acid production via vinyl alcohol. Also used for some bigger and saturated aldehydes.
  k_CH2CHOH_OH_HCOOH = 4.3E-11 ! ref3179
  k_CH2CHOH_OH_ALD   = 2.4E-11 ! ref3179
  k_CH2CHOH_HCOOH    = 4.67E-26*temp**3.286*EXP(4509./(1.987*temp)) ! ref3162
  k_ALD_HCOOH        = 1.17E-19*temp**1.209*EXP(-556./(1.987*temp)) ! ref3162
  j_IC3H7NO3   = 3.7*jx(ip_PAN)
  j_ACETOL     = 0.65*0.11*jx(ip_CHOH)
  j_HPALD      = (jx(IP_CH3OOH)+ jx(ip_MACR)/(2.*1.95E-3)) ! mcm.leeds.ac.uk/MCM/parameters/photolysis.htt
  j_KETENE     = jx(ip_MVK)/0.004
  ! MSK: RO2=0 commented because of RO2 defined in gas_mafor.eqn
  ! RO2 = 0.
  IF (ind_LISOPACO2>0)            RO2 = RO2 + C(ind_LISOPACO2)
  IF (ind_LDISOPACO2>0)           RO2 = RO2 + C(ind_LDISOPACO2)
  IF (ind_ISOPBO2>0)              RO2 = RO2 + C(ind_ISOPBO2)
  IF (ind_ISOPDO2>0)              RO2 = RO2 + C(ind_ISOPDO2)
  IF (ind_LISOPEFO2>0)            RO2 = RO2 + C(ind_LISOPEFO2)
  IF (ind_NISOPO2>0)              RO2 = RO2 + C(ind_NISOPO2)
  IF (ind_LHC4ACCO3>0)            RO2 = RO2 + C(ind_LHC4ACCO3)
  IF (ind_LC578O2>0)              RO2 = RO2 + C(ind_LC578O2)
  IF (ind_C59O2>0)                RO2 = RO2 + C(ind_C59O2)
  IF (ind_LNISO3>0)               RO2 = RO2 + C(ind_LNISO3)
  IF (ind_CH3O2>0)                RO2 = RO2 + C(ind_CH3O2)
  IF (ind_HOCH2O2>0)              RO2 = RO2 + C(ind_HOCH2O2)
  IF (ind_CH3CO3>0)               RO2 = RO2 + C(ind_CH3CO3)
  IF (ind_C2H5O2>0)               RO2 = RO2 + C(ind_C2H5O2)
  IF (ind_HOCH2CO3>0)             RO2 = RO2 + C(ind_HOCH2CO3)
  IF (ind_HYPROPO2>0)             RO2 = RO2 + C(ind_HYPROPO2)
  IF (ind_LBUT1ENO2>0)            RO2 = RO2 + C(ind_LBUT1ENO2)
  IF (ind_BUT2OLO2>0)             RO2 = RO2 + C(ind_BUT2OLO2)
  IF (ind_HCOCO3>0)               RO2 = RO2 + C(ind_HCOCO3)
  IF (ind_CO2H3CO3>0)             RO2 = RO2 + C(ind_CO2H3CO3)
  IF (ind_LHMVKABO2>0)            RO2 = RO2 + C(ind_LHMVKABO2)
  IF (ind_MACO3>0)                RO2 = RO2 + C(ind_MACO3)
  IF (ind_MACRO2>0)               RO2 = RO2 + C(ind_MACRO2)
  IF (ind_PRONO3BO2>0)            RO2 = RO2 + C(ind_PRONO3BO2)
  IF (ind_HOCH2CH2O2>0)           RO2 = RO2 + C(ind_HOCH2CH2O2)
  IF (ind_CH3COCH2O2>0)           RO2 = RO2 + C(ind_CH3COCH2O2)
  IF (ind_IC3H7O2>0)              RO2 = RO2 + C(ind_IC3H7O2)
  IF (ind_NC3H7O2>0)              RO2 = RO2 + C(ind_NC3H7O2)
  IF (ind_LC4H9O2>0)              RO2 = RO2 + C(ind_LC4H9O2)
  IF (ind_TC4H9O2>0)              RO2 = RO2 + C(ind_TC4H9O2)
  IF (ind_LMEKO2>0)               RO2 = RO2 + C(ind_LMEKO2)
  IF (ind_HCOCH2O2>0)             RO2 = RO2 + C(ind_HCOCH2O2)
  IF (ind_EZCH3CO2CHCHO>0)        RO2 = RO2 + C(ind_EZCH3CO2CHCHO)
  IF (ind_EZCHOCCH3CHO2>0)        RO2 = RO2 + C(ind_EZCHOCCH3CHO2)
  IF (ind_CH3COCHO2CHO>0)         RO2 = RO2 + C(ind_CH3COCHO2CHO)
  IF (ind_HCOCO2CH3CHO>0)         RO2 = RO2 + C(ind_HCOCO2CH3CHO)
  IF (ind_C1ODC3O2C4OOH>0)        RO2 = RO2 + C(ind_C1ODC3O2C4OOH)
  IF (ind_C1OOHC2O2C4OD>0)        RO2 = RO2 + C(ind_C1OOHC2O2C4OD)
  IF (ind_C1ODC2O2C4OD>0)         RO2 = RO2 + C(ind_C1ODC2O2C4OD)
  IF (ind_ISOPBDNO3O2>0)          RO2 = RO2 + C(ind_ISOPBDNO3O2)
  IF (ind_LISOPACNO3O2>0)         RO2 = RO2 + C(ind_LISOPACNO3O2)
  IF (ind_DB1O2>0)                RO2 = RO2 + C(ind_DB1O2)
  IF (ind_DB2O2>0)                RO2 = RO2 + C(ind_DB2O2)
  IF (ind_LME3FURANO2>0)          RO2 = RO2 + C(ind_LME3FURANO2)
  IF (ind_NO3CH2CO3>0)            RO2 = RO2 + C(ind_NO3CH2CO3)
  IF (ind_CH3COCO3>0)             RO2 = RO2 + C(ind_CH3COCO3)
  IF (ind_LZCO3C23DBCOD>0)        RO2 = RO2 + C(ind_LZCO3C23DBCOD)
  IF (ind_IBUTOLBO2>0)            RO2 = RO2 + C(ind_IBUTOLBO2)
  IF (ind_IPRCO3>0)               RO2 = RO2 + C(ind_IPRCO3)
  IF (ind_IC4H9O2>0)              RO2 = RO2 + C(ind_IC4H9O2)
  ! MBO-related
  IF (ind_LMBOABO2>0)             RO2 = RO2 + C(ind_LMBOABO2)
  IF (ind_IPRHOCO3>0)             RO2 = RO2 + C(ind_IPRHOCO3)
  IF (ind_LNMBOABO2>0)            RO2 = RO2 + C(ind_LNMBOABO2)
  IF (ind_NC4OHCO3>0)             RO2 = RO2 + C(ind_NC4OHCO3)
  ! APINENE-related:
  IF (ind_LAPINABO2>0)            RO2 = RO2 + C(ind_LAPINABO2)
  IF (ind_C96O2>0)                RO2 = RO2 + C(ind_C96O2)
  IF (ind_C97O2>0)                RO2 = RO2 + C(ind_C97O2)
  IF (ind_C98O2>0)                RO2 = RO2 + C(ind_C98O2)
  IF (ind_C85O2>0)                RO2 = RO2 + C(ind_C85O2)
  IF (ind_C86O2>0)                RO2 = RO2 + C(ind_C86O2)
  IF (ind_PINALO2>0)              RO2 = RO2 + C(ind_PINALO2)
  IF (ind_C96CO3>0)               RO2 = RO2 + C(ind_C96CO3)
  IF (ind_C89CO3>0)               RO2 = RO2 + C(ind_C89CO3)
  IF (ind_C85CO3>0)               RO2 = RO2 + C(ind_C85CO3)
  IF (ind_OHMENTHEN6ONEO2>0)      RO2 = RO2 + C(ind_OHMENTHEN6ONEO2)
  IF (ind_C511O2>0)               RO2 = RO2 + C(ind_C511O2)
  IF (ind_C106O2>0)               RO2 = RO2 + C(ind_C106O2)
  IF (ind_CO235C6CO3>0)           RO2 = RO2 + C(ind_CO235C6CO3)
  IF (ind_CHOC3COCO3>0)           RO2 = RO2 + C(ind_CHOC3COCO3)
  IF (ind_CO235C6O2>0)            RO2 = RO2 + C(ind_CO235C6O2)
  IF (ind_C716O2>0)               RO2 = RO2 + C(ind_C716O2)
  IF (ind_C614O2>0)               RO2 = RO2 + C(ind_C614O2)
  IF (ind_HCOCH2CO3>0)            RO2 = RO2 + C(ind_HCOCH2CO3)
  IF (ind_BIACETO2>0)             RO2 = RO2 + C(ind_BIACETO2)
  IF (ind_CO23C4CO3>0)            RO2 = RO2 + C(ind_CO23C4CO3)
  IF (ind_C109O2>0)               RO2 = RO2 + C(ind_C109O2)
  IF (ind_C811CO3>0)              RO2 = RO2 + C(ind_C811CO3)
  IF (ind_C89O2>0)                RO2 = RO2 + C(ind_C89O2)
  IF (ind_C812O2>0)               RO2 = RO2 + C(ind_C812O2)
  IF (ind_C813O2>0)               RO2 = RO2 + C(ind_C813O2)
  IF (ind_C721CO3>0)              RO2 = RO2 + C(ind_C721CO3)
  IF (ind_C721O2>0)               RO2 = RO2 + C(ind_C721O2)
  IF (ind_C722O2>0)               RO2 = RO2 + C(ind_C722O2)
  IF (ind_C44O2>0)                RO2 = RO2 + C(ind_C44O2)
  IF (ind_C512O2>0)               RO2 = RO2 + C(ind_C512O2)
  IF (ind_C513O2>0)               RO2 = RO2 + C(ind_C513O2)
  IF (ind_CHOC3COO2>0)            RO2 = RO2 + C(ind_CHOC3COO2)
  IF (ind_C312COCO3>0)            RO2 = RO2 + C(ind_C312COCO3)
  IF (ind_HOC2H4CO3>0)            RO2 = RO2 + C(ind_HOC2H4CO3)
  IF (ind_LNAPINABO2>0)           RO2 = RO2 + C(ind_LNAPINABO2)
  IF (ind_C810O2>0)               RO2 = RO2 + C(ind_C810O2)
  IF (ind_C514O2>0)               RO2 = RO2 + C(ind_C514O2)
  IF (ind_CHOCOCH2O2>0)           RO2 = RO2 + C(ind_CHOCOCH2O2)
  ! BPINENE-related:
  IF (ind_ROO6R1O2>0)             RO2 = RO2 + C(ind_ROO6R1O2)
  IF (ind_ROO6R3O2>0)             RO2 = RO2 + C(ind_ROO6R3O2)
  IF (ind_RO6R1O2>0)              RO2 = RO2 + C(ind_RO6R1O2)
  IF (ind_RO6R3O2>0)              RO2 = RO2 + C(ind_RO6R3O2)
  IF (ind_BPINAO2>0)              RO2 = RO2 + C(ind_BPINAO2)
  IF (ind_C8BCO2>0)               RO2 = RO2 + C(ind_C8BCO2)
  IF (ind_NOPINDO2>0)             RO2 = RO2 + C(ind_NOPINDO2)
  IF (ind_LNBPINABO2>0)           RO2 = RO2 + C(ind_LNBPINABO2)
  ! aromatics-related:
  IF (ind_BZBIPERO2>0)            RO2 = RO2 + C(ind_BZBIPERO2)
  IF (ind_C6H5CH2O2>0)            RO2 = RO2 + C(ind_C6H5CH2O2)
  IF (ind_TLBIPERO2>0)            RO2 = RO2 + C(ind_TLBIPERO2)
  IF (ind_BZEMUCCO3>0)            RO2 = RO2 + C(ind_BZEMUCCO3)
  IF (ind_BZEMUCO2>0)             RO2 = RO2 + C(ind_BZEMUCO2)
  IF (ind_C5DIALO2>0)             RO2 = RO2 + C(ind_C5DIALO2)
  IF (ind_NPHENO2>0)              RO2 = RO2 + C(ind_NPHENO2)
  IF (ind_PHENO2>0)               RO2 = RO2 + C(ind_PHENO2)
  IF (ind_CRESO2>0)               RO2 = RO2 + C(ind_CRESO2)
  IF (ind_NCRESO2>0)              RO2 = RO2 + C(ind_NCRESO2)
  IF (ind_TLEMUCCO3>0)            RO2 = RO2 + C(ind_TLEMUCCO3)
  IF (ind_TLEMUCO2>0)             RO2 = RO2 + C(ind_TLEMUCO2)
  IF (ind_C615CO2O2>0)            RO2 = RO2 + C(ind_C615CO2O2)
  IF (ind_MALDIALCO3>0)           RO2 = RO2 + C(ind_MALDIALCO3)
  IF (ind_EPXDLCO3>0)             RO2 = RO2 + C(ind_EPXDLCO3)
  IF (ind_C3DIALO2>0)             RO2 = RO2 + C(ind_C3DIALO2)
  IF (ind_MALDIALO2>0)            RO2 = RO2 + C(ind_MALDIALO2)
  IF (ind_C6H5O2>0)               RO2 = RO2 + C(ind_C6H5O2)
  IF (ind_C6H5CO3>0)              RO2 = RO2 + C(ind_C6H5CO3)
  IF (ind_OXYL1O2>0)              RO2 = RO2 + C(ind_OXYL1O2)
  IF (ind_C5CO14O2>0)             RO2 = RO2 + C(ind_C5CO14O2)
  IF (ind_NBZFUO2>0)              RO2 = RO2 + C(ind_NBZFUO2)
  IF (ind_BZFUO2>0)               RO2 = RO2 + C(ind_BZFUO2)
  IF (ind_HCOCOHCO3>0)            RO2 = RO2 + C(ind_HCOCOHCO3)
  IF (ind_CATEC1O2>0)             RO2 = RO2 + C(ind_CATEC1O2)
  IF (ind_MCATEC1O2>0)            RO2 = RO2 + C(ind_MCATEC1O2)
  IF (ind_C5DICARBO2>0)           RO2 = RO2 + C(ind_C5DICARBO2)
  IF (ind_NTLFUO2>0)              RO2 = RO2 + C(ind_NTLFUO2)
  IF (ind_TLFUO2>0)               RO2 = RO2 + C(ind_TLFUO2)
  IF (ind_NPHEN1O2>0)             RO2 = RO2 + C(ind_NPHEN1O2)
  IF (ind_NNCATECO2>0)            RO2 = RO2 + C(ind_NNCATECO2)
  IF (ind_NCATECO2>0)             RO2 = RO2 + C(ind_NCATECO2)
  IF (ind_NBZQO2>0)               RO2 = RO2 + C(ind_NBZQO2)
  IF (ind_PBZQO2>0)               RO2 = RO2 + C(ind_PBZQO2)
  IF (ind_NPTLQO2>0)              RO2 = RO2 + C(ind_NPTLQO2)
  IF (ind_PTLQO2>0)               RO2 = RO2 + C(ind_PTLQO2)
  IF (ind_NCRES1O2>0)             RO2 = RO2 + C(ind_NCRES1O2)
  IF (ind_MNNCATECO2>0)           RO2 = RO2 + C(ind_MNNCATECO2)
  IF (ind_MNCATECO2>0)            RO2 = RO2 + C(ind_MNCATECO2)
  IF (ind_MECOACETO2>0)           RO2 = RO2 + C(ind_MECOACETO2)
  IF (ind_CO2H3CO3>0)             RO2 = RO2 + C(ind_CO2H3CO3)
  IF (ind_MALANHYO2>0)            RO2 = RO2 + C(ind_MALANHYO2)
  IF (ind_NDNPHENO2>0)            RO2 = RO2 + C(ind_NDNPHENO2)
  IF (ind_DNPHENO2>0)             RO2 = RO2 + C(ind_DNPHENO2)
  IF (ind_NDNCRESO2>0)            RO2 = RO2 + C(ind_NDNCRESO2)
  IF (ind_DNCRESO2>0)             RO2 = RO2 + C(ind_DNCRESO2)
  IF (ind_C5CO2OHCO3>0)           RO2 = RO2 + C(ind_C5CO2OHCO3)
  IF (ind_C6CO2OHCO3>0)           RO2 = RO2 + C(ind_C6CO2OHCO3)
  IF (ind_MMALANHYO2>0)           RO2 = RO2 + C(ind_MMALANHYO2)
  IF (ind_ACCOMECO3>0)            RO2 = RO2 + C(ind_ACCOMECO3)
  IF (ind_C4CO2DBCO3>0)           RO2 = RO2 + C(ind_C4CO2DBCO3)
  IF (ind_C5CO2DBCO3>0)           RO2 = RO2 + C(ind_C5CO2DBCO3)
  IF (ind_NSTYRENO2>0)            RO2 = RO2 + C(ind_NSTYRENO2)
  IF (ind_STYRENO2>0)             RO2 = RO2 + C(ind_STYRENO2)
  ! pseudo first order rate constants    ! occurence
  k1_RO2RCO3      = RO2 * k_RO2RCO3      ! 51
  k1_RO2pRO2      = RO2 * k_RO2pRO2      ! 5
  k1_RO2sRO2      = RO2 * k_RO2sRO2      ! 11+1
  k1_RO2tRO2      = RO2 * k_RO2tRO2      ! 13+1
  k1_RO2pORO2     = RO2 * k_RO2pORO2     ! 11+2
  k1_RO2sORO2     = RO2 * k_RO2sORO2     ! 33+2
  k1_RO2tORO2     = RO2 * k_RO2tORO2     ! 17
  k1_RO2LISOPACO2 = RO2 * k_RO2LISOPACO2 ! 3
  k1_RO2ISOPBO2   = RO2 * k_RO2ISOPBO2   ! 1
  k1_RO2ISOPDO2   = RO2 * k_RO2ISOPDO2   ! 13

! End INLINED RCONST

  RCONST(1) = (3.3E-11*EXP(55./temp))
  RCONST(2) = (6.0E-34*((temp/300.)**(-2.4))*cair)
  RCONST(3) = (k_3rd(temp,cair,4.4E-32,1.3,7.5E-11,-0.2,0.6))
  RCONST(4) = (1.7E-12*EXP(-940./temp))
  RCONST(5) = (2.8E-12*EXP(-1800./temp))
  RCONST(6) = (1.E-14*EXP(-490./temp))
  RCONST(7) = (4.8E-11*EXP(250./temp))
  RCONST(8) = (k_HO2_HO2)
  RCONST(9) = (1.63E-10*EXP(60./temp))
! RCONST(10) = constant rate coefficient
  RCONST(11) = (6.521E-26*temp*EXP(1851.09/temp)*EXP(-5.10485E-3*temp))
! RCONST(12) = constant rate coefficient
  RCONST(13) = (2.15E-11*EXP(110./temp))
  RCONST(14) = (3.0E-12*EXP(-1500./temp))
  RCONST(15) = (1.2E-13*EXP(-2450./temp))
  RCONST(16) = (1.5E-11*EXP(170./temp))
  RCONST(17) = (k_NO3_NO2)
  RCONST(18) = (k_NO3_NO2/(5.8E-27*EXP(10840./temp)))
  RCONST(19) = (k_3rd(temp,cair,7.0E-31,2.6,3.6E-11,0.1,0.6))
  RCONST(20) = (3.3E-12*EXP(270./temp))
  RCONST(21) = (k_3rd(temp,cair,1.8E-30,3.0,2.8E-11,0.,0.6))
  RCONST(22) = (k_NO2_HO2)
! RCONST(23) = constant rate coefficient
  RCONST(24) = (1.8E-11*EXP(-390./temp))
  RCONST(25) = (k_HNO3_OH)
  RCONST(26) = (k_NO2_HO2/(2.1E-27*EXP(10900./temp)))
  RCONST(27) = (1.3E-12*EXP(380./temp))
  RCONST(28) = (1.7E-12*EXP(-710./temp))
  RCONST(29) = (4.3E-12*EXP(-930./temp))
  RCONST(30) = (4.8E-07*EXP(-628./temp)*temp**(-1.32))
  RCONST(31) = (9.4E-09*EXP(-356./temp)*temp**(-1.12))
  RCONST(32) = (1.92E-12*((temp/298.)**(-1.5)))
  RCONST(33) = (1.41E-11*((temp/298.)**(-1.5)))
  RCONST(34) = (1.2E-11*((temp/298.)**(-2.0)))
  RCONST(35) = (0.8E-11*((temp/298.)**(-2.0)))
! RCONST(36) = constant rate coefficient
! RCONST(37) = constant rate coefficient
  RCONST(38) = (8.0E-11*EXP(-500./temp))
  RCONST(39) = (1.66E-12*EXP(-1500./temp))
  RCONST(40) = (1.0E-12*EXP(-1000./temp))
! RCONST(41) = constant rate coefficient
  RCONST(42) = (4.13E-11*EXP(-2138./temp))
  RCONST(43) = (3.65E-14*EXP(-4600./temp))
  RCONST(44) = (1.85E-20*EXP(2.82*LOG(temp)-987./temp))
  RCONST(45) = (6.38E-18*(temp**2)*EXP(144./temp))
  RCONST(46) = (3.8E-13*EXP(780./temp)/(1.+1./498.*EXP(1160./temp)))
  RCONST(47) = (3.8E-13*EXP(780./temp)/(1.+498.*EXP(-1160./temp)))
  RCONST(48) = (2.3E-12*EXP(360./temp)*(1.-beta_CH3NO3))
  RCONST(49) = (2.3E-12*EXP(360./temp)*beta_CH3NO3)
! RCONST(50) = constant rate coefficient
  RCONST(51) = (7.4E-13*EXP(-520./temp)*RO2*2.)
  RCONST(52) = ((k_CH3O2-7.4E-13*EXP(-520./temp))*RO2*2.)
  RCONST(53) = (k_CH3OOH_OH)
  RCONST(54) = (9.52E-18*EXP(2.03*LOG(temp)+636./temp))
  RCONST(55) = (3.4E-13*EXP(-1900./temp))
  RCONST(56) = ((1.57E-13+cair*3.54E-33))
  RCONST(57) = (2.94E-14*exp(786./temp)+9.85E-13*EXP(-1036./temp))
  RCONST(58) = (k_NO2_CH3O2)
  RCONST(59) = (k_NO2_CH3O2/(9.5E-29*EXP(11234./temp)))
! RCONST(60) = constant rate coefficient
  RCONST(61) = (4.0E-13*EXP(-845./temp))
  RCONST(62) = (1.3E-14*exp(-663./temp)*c(ind_O2))
  RCONST(63) = (k_3rd_iupac(temp,cair,8.1E-29,4.5,2.1E-11,0.,0.44))
  RCONST(64) = (9.6E-12*EXP(-1150./temp))
  RCONST(65) = (k_3rd_iupac(temp,cair,2.6E-29,2.8,3.3E-11,0.6,REAL(EXP(-temp/900.),SP)))
  RCONST(66) = (2.3E-12*(temp/300.)**0.7)
  RCONST(67) = (2.9E-16*exp(-1000./temp))
  RCONST(68) = (1.E-10*exp(-1764./temp))
  RCONST(69) = (9.7E-15*EXP(625./temp))
  RCONST(70) = (2.4E12*EXP(-7000./temp))
  RCONST(71) = (5.6E-15*EXP(2300./temp))
  RCONST(72) = (0.7275*2.3E-12*EXP(360./temp))
! RCONST(73) = constant rate coefficient
  RCONST(74) = ((k_CH3O2*5.5E-12)**0.5*RO2*2.)
  RCONST(75) = ((k_CH3O2*5.7E-14*EXP(750./temp))**0.5*RO2*2.)
  RCONST(76) = (k_roohro)
  RCONST(77) = (k_rohro+k_s*f_sooh*f_soh)
  RCONST(78) = (2.*k_rohro+k_s*f_soh*f_soh)
! RCONST(79) = constant rate coefficient
  RCONST(80) = (1.124E+14*EXP(-10000/temp))
  RCONST(81) = (k_CH2OO_NO2*3.6E-6)
! RCONST(82) = constant rate coefficient
! RCONST(83) = constant rate coefficient
  RCONST(84) = (k_CH2OO_NO2)
! RCONST(85) = constant rate coefficient
! RCONST(86) = constant rate coefficient
! RCONST(87) = constant rate coefficient
! RCONST(88) = constant rate coefficient
! RCONST(89) = constant rate coefficient
! RCONST(90) = constant rate coefficient
! RCONST(91) = constant rate coefficient
! RCONST(92) = constant rate coefficient
  RCONST(93) = (k_NO2_CH3O2)
  RCONST(94) = (k_NO2_CH3O2/(9.5E-29*EXP(11234./temp)))
  RCONST(95) = (9.50E-13*EXP(-650./temp)*f_soh)
  RCONST(96) = (k_3rd_iupac(temp,cair,7.0E-31,3.,1.8E-12,-1.1,0.33))
  RCONST(97) = (5.1E-12*exp(-210./temp))
! RCONST(98) = constant rate coefficient
! RCONST(99) = constant rate coefficient
! RCONST(100) = constant rate coefficient
! RCONST(101) = constant rate coefficient
  RCONST(102) = (3.4E-11*EXP(-1600./temp))
  RCONST(103) = (KDEC)
  RCONST(104) = (k_3rd(temp,cair,4.28E-33,1.0,REAL(4.25E-13*EXP(-1150./temp),SP),1.0,0.8))
  RCONST(105) = (1.08E-10*EXP(105./temp)*0.15*EXP(200/temp))
  RCONST(106) = (1.08E-10*EXP(105./temp)*0.68/2.)
  RCONST(107) = (1.08E-10*EXP(105./temp)*(1.-(0.68/2.+0.15*EXP(200/temp))))
  RCONST(108) = (1.0E-11*EXP(-4000./temp))
  RCONST(109) = (1.2E-11*EXP(210./temp)*0.75)
  RCONST(110) = (1.2E-11*EXP(210./temp)*0.25)
! RCONST(111) = constant rate coefficient
  RCONST(112) = (1.49E-17*temp*temp*EXP(-499./temp))
  RCONST(113) = (9.1E-15*EXP(-2580./temp))
  RCONST(114) = (k_3rd_iupac(temp,cair,8.6E-29,3.1,9.E-12,0.85,0.48))
  RCONST(115) = (7.5E-13*EXP(700./temp))
  RCONST(116) = (2.55E-12*EXP(380./temp)*(1.-beta_C2H5NO3))
  RCONST(117) = (2.55E-12*EXP(380./temp)*beta_C2H5NO3)
! RCONST(118) = constant rate coefficient
  RCONST(119) = (2.*(7.6E-14*k_CH3O2)**(.5)*RO2)
  RCONST(120) = (k_roohro)
  RCONST(121) = (k_s*f_sooh)
  RCONST(122) = (4.4E-12*EXP(365./temp)*0.95)
  RCONST(123) = (4.4E-12*EXP(365./temp)*0.05)
  RCONST(124) = (KNO3AL)
  RCONST(125) = (k_CH3CO2H_OH)
  RCONST(126) = (5.20E-13*EXP(980./temp)*1.507*0.61)
  RCONST(127) = (5.20E-13*EXP(980./temp)*1.507*0.23)
  RCONST(128) = (5.20E-13*EXP(980./temp)*1.507*0.16)
  RCONST(129) = (8.1E-12*EXP(270./temp))
  RCONST(130) = (k_CH3CO3_NO2)
! RCONST(131) = constant rate coefficient
  RCONST(132) = (k1_RO2RCO3*0.9)
  RCONST(133) = (k1_RO2RCO3*0.1)
  RCONST(134) = (k_roohro)
! RCONST(135) = constant rate coefficient
  RCONST(136) = (k_PAN_M)
  RCONST(137) = (k_3rd(temp,cair,5.5e-30,0.0,8.3e-13,-2.,0.6)*0.71)
  RCONST(138) = (k_3rd(temp,cair,5.5e-30,0.0,8.3e-13,-2.,0.6)*0.29)
  RCONST(139) = (8.00E-12*0.80)
  RCONST(140) = (8.00E-12*0.20)
  RCONST(141) = (5.1E-12*(1.-1./(1+1.85E-18*cair)))
  RCONST(142) = (5.1E-12*1./(1+1.85E-18*cair))
  RCONST(143) = (KDEC)
  RCONST(144) = (KNO3AL)
  RCONST(145) = (k1_RO2RCO3*0.9)
  RCONST(146) = (k1_RO2RCO3*0.1)
  RCONST(147) = (KAPHO2*rco3_oh)
  RCONST(148) = (KAPHO2*rco3_ooh)
  RCONST(149) = (KAPHO2*rco3_o3)
  RCONST(150) = (KAPNO)
  RCONST(151) = (k_CH3CO3_NO2)
  RCONST(152) = (KRO2NO3*1.74)
  RCONST(153) = (k_co2h+k_s*f_soh*f_co2h)
  RCONST(154) = (k_roohro)
  RCONST(155) = (k_s*f_soh*f_co2h)
  RCONST(156) = (k_PAN_M)
  RCONST(157) = (k_s*f_soh*f_cpan+k_rohro)
  RCONST(158) = (3.1E-12*EXP(340./temp))
  RCONST(159) = (KNO3AL)
  RCONST(160) = (7.E11*EXP(-3160./temp)+5.E-12*c(ind_O2))
  RCONST(161) = (5.E-12*c(ind_O2)*3.2*exp(-550./temp))
  RCONST(162) = (5.E-12*c(ind_O2)*(1.-3.2*exp(-550./temp)))
  RCONST(163) = (k1_RO2RCO3*0.9)
  RCONST(164) = (k1_RO2RCO3*0.1)
  RCONST(165) = (KAPHO2)
  RCONST(166) = (KAPNO)
  RCONST(167) = (KRO2NO3*1.74)
  RCONST(168) = (k_CH3CO3_NO2)
  RCONST(169) = (k_co2h+k_t*f_o*f_co2h)
  RCONST(170) = (k_roohro)
  RCONST(171) = (k_t*f_o*f_co2h)
  RCONST(172) = (2.*(7.8E-14*EXP(1000./temp)*k_CH3O2)**(.5)*RO2)
  RCONST(173) = (KRO2NO*(1.-alpha_AN(3,1,0,0,0,temp,cair)))
  RCONST(174) = (KRO2NO*alpha_AN(3,1,0,0,0,temp,cair))
  RCONST(175) = (1.53E-13*EXP(1300./temp)*(1.-rchohch2o2_oh))
  RCONST(176) = (1.53E-13*EXP(1300./temp)*rchohch2o2_oh)
  RCONST(177) = (k_s*(f_soh*f_ch2ono2+f_ono2*f_pch2oh)+k_rohro)
  RCONST(178) = (k_roohro)
  RCONST(179) = (k_s*f_sooh*f_pch2oh)
  RCONST(180) = (k_s*f_soh*f_pch2oh+k_rohro)
  RCONST(181) = (6.00E-14*EXP(-550./temp)*C(ind_O2))
  RCONST(182) = (9.50E13*EXP(-5988./temp))
  RCONST(183) = (2*k_s*f_soh*f_pch2oh+2*k_rohro)
  RCONST(184) = (k1_RO2pORO2)
  RCONST(185) = (KRO2HO2(2)*rcoch2o2_ooh)
  RCONST(186) = (KRO2HO2(2)*rcoch2o2_oh)
  RCONST(187) = (KRO2NO*(1.-alpha_AN(3,1,1,0,0,temp,cair)))
  RCONST(188) = (KRO2NO*alpha_AN(3,1,1,0,0,temp,cair))
  RCONST(189) = (KRO2NO3)
  RCONST(190) = (k_roohro)
  RCONST(191) = (0.8*8.E-12)
  RCONST(192) = (k_s*f_sooh*f_cho)
  RCONST(193) = (KNO3AL)
  RCONST(194) = (KAPNO)
  RCONST(195) = (KRO2NO3*1.74)
  RCONST(196) = (KAPHO2*rco3_oh)
  RCONST(197) = (KAPHO2*rco3_ooh)
  RCONST(198) = (KAPHO2*rco3_o3)
  RCONST(199) = (k1_RO2RCO3*0.9)
  RCONST(200) = (k1_RO2RCO3*0.1)
  RCONST(201) = (2.*k_roohro)
  RCONST(202) = (k_s*f_sooh*f_co2h)
  RCONST(203) = (k_s*f_sooh*f_co2h+k_co2h)
  RCONST(204) = (2.8E-12*exp(510./temp))
  RCONST(205) = ((k_t*f_tooh*f_toh+k_rohro))
  RCONST(206) = (k_roohro)
  RCONST(207) = (3.46E12*EXP(-12500./(1.98*temp)))
  RCONST(208) = (3.46E12*EXP(-12500./(1.98*temp))/(6.34E26*EXP(-14700./(1.98*temp))))
  RCONST(209) = (5.6E-15*EXP(2300./temp))
  RCONST(210) = (k1_RO2sORO2)
  RCONST(211) = (KRO2NO)
  RCONST(212) = (6.7E-13*EXP(-395./temp))
  RCONST(213) = (k_s*f_ch2ono2*f_cho)
  RCONST(214) = (k_t*f_o*f_ch2ono2*3.)
  RCONST(215) = (KAPHO2)
  RCONST(216) = (KAPNO)
  RCONST(217) = (k_CH3CO3_NO2)
  RCONST(218) = (k1_RO2RCO3)
  RCONST(219) = (k_PAN_M)
  RCONST(220) = (k_3rd_iupac(temp,cair,1.3E-29,6.2,8.8E-12,0.0,0.31))
  RCONST(221) = (k_3rd_iupac(temp,cair,REAL(4.8E-4*EXP(-9285./temp),SP),0.0,REAL(8.8E15*EXP(-10440./temp),SP),0.0,0.31))
  RCONST(222) = (9.50E-13*EXP(-650./temp))
  RCONST(223) = (5.1E-12*(1.-1./(1.+9.4E-18*cair)))
  RCONST(224) = (5.1E-12*1./(1.+9.4E-18*cair))
  RCONST(225) = (3.0E-12*EXP(20./temp))
  RCONST(226) = (8.1E-13*EXP(-1080./temp)*0.40)
  RCONST(227) = (8.1E-13*EXP(-1080./temp)*(1.-0.40))
  RCONST(228) = (2.54E-10*EXP(-24./temp)*0.0269*EXP(137./temp))
  RCONST(229) = (2.54E-10*EXP(-24./temp)*0.16)
  RCONST(230) = (2.54E-10*EXP(-24./temp)*(1.-(0.16+0.0269*EXP(137./temp))))
  RCONST(231) = (KRO2NO)
  RCONST(232) = (KRO2HO2(2))
  RCONST(233) = (k_CH2CHOH_OH_HCOOH)
  RCONST(234) = (k_CH2CHOH_OH_ALD)
  RCONST(235) = (k_CH2CHOH_HCOOH)
  RCONST(236) = (k_ALD_HCOOH)
  RCONST(237) = (k_s)
  RCONST(238) = (2.*k_p)
  RCONST(239) = (5.5E-15*EXP(-1880./temp)*.57)
  RCONST(240) = (5.5E-15*EXP(-1880./temp)*.43)
  RCONST(241) = (k_3rd_iupac(temp,cair,8.6E-27,3.5,3.E-11,1.,0.5))
  RCONST(242) = (4.6E-13*EXP(-1155./temp))
  RCONST(243) = (1.9E-13*EXP(1300./temp))
  RCONST(244) = (2.7E-12*EXP(360./temp)*(1.-alpha_AN(3,2,0,0,0,temp,cair)))
  RCONST(245) = (2.7E-12*EXP(360./temp)*alpha_AN(3,2,0,0,0,temp,cair))
  RCONST(246) = (2.*(1.6E-12*EXP(-2200./temp)*k_CH3O2)**(.5)*RO2)
  RCONST(247) = (k_roohro)
  RCONST(248) = (k_t*f_tooh)
  RCONST(249) = (1.9E-13*EXP(1300./temp))
  RCONST(250) = (2.7E-12*EXP(360./temp)*(1.-alpha_AN(3,1,0,0,0,temp,cair)))
  RCONST(251) = (2.7E-12*EXP(360./temp)*alpha_AN(3,1,0,0,0,temp,cair))
  RCONST(252) = (2.*(k_CH3O2*3.E-13)**(.5)*RO2)
  RCONST(253) = ((8.8E-12*EXP(-1320./temp)+1.7E-14*EXP(423./temp)))
  RCONST(254) = (8.6E-13*EXP(700./temp)*rcoch2o2_ooh)
  RCONST(255) = (8.6E-13*EXP(700./temp)*rcoch2o2_oh)
  RCONST(256) = (2.9E-12*EXP(300./temp)*(1.-alpha_AN(4,1,1,0,0,temp,cair)))
  RCONST(257) = (2.9E-12*EXP(300./temp)*alpha_AN(4,1,1,0,0,temp,cair))
  RCONST(258) = (k1_RO2pORO2)
  RCONST(259) = (k_roohro)
  RCONST(260) = (k_s*f_sooh*f_co)
  RCONST(261) = (1.6E-12*EXP(305./temp))
  RCONST(262) = (1.9E-12*EXP(575./temp))
  RCONST(263) = (6.2E-13*EXP(-230./temp))
  RCONST(264) = (KRO2NO3)
  RCONST(265) = (k1_RO2sORO2)
  RCONST(266) = (KRO2HO2(3)*(1.-rchohch2o2_oh))
  RCONST(267) = (KRO2HO2(3)*rchohch2o2_oh)
  RCONST(268) = (KRO2NO*(1.-alpha_AN(4,1,0,0,0,temp,cair)))
  RCONST(269) = (KRO2NO*alpha_AN(4,1,0,0,0,temp,cair))
  RCONST(270) = (KRO2NO3)
  RCONST(271) = (k_roohro)
  RCONST(272) = ((k_s*f_soh*f_pch2oh+k_t*f_tooh*f_pch2oh))
  RCONST(273) = (KRO2HO2(3))
  RCONST(274) = (KRO2NO)
  RCONST(275) = (KRO2NO3)
  RCONST(276) = (k_roohro)
  RCONST(277) = (k_t*f_tooh*f_ch2ono2)
  RCONST(278) = (KNO3AL*2.4)
  RCONST(279) = ((k_s*f_co*f_ono2+k_p*f_co))
  RCONST(280) = ((1.9E-12*EXP(575./temp)+k_s*f_soh*f_co))
  RCONST(281) = (KNO3AL*2.4)
  RCONST(282) = (4.9E-14*EXP(276./temp))
  RCONST(283) = (k1_RO2pORO2)
  RCONST(284) = (KRO2NO)
  RCONST(285) = (KRO2HO2(3)*rcoch2o2_ooh)
  RCONST(286) = (KRO2HO2(3)*rcoch2o2_oh)
  RCONST(287) = (KRO2NO3)
  RCONST(288) = (k_t*f_co*f_o)
  RCONST(289) = (k_s*f_sooh*f_co)
  RCONST(290) = (k_roohro)
  RCONST(291) = (KNO3AL*2.4)
  RCONST(292) = (k1_RO2pORO2)
  RCONST(293) = (KRO2HO2(3)*rcoch2o2_ooh)
  RCONST(294) = (KRO2HO2(3)*rcoch2o2_oh)
  RCONST(295) = (KRO2NO)
  RCONST(296) = (k_s*f_sooh*f_co)
  RCONST(297) = (k_roohro)
  RCONST(298) = (1.60E-12*EXP(305./temp))
! RCONST(299) = constant rate coefficient
  RCONST(300) = (k_t*f_ono2*f_pch2oh+k_s*f_soh*f_ch2ono2)
  RCONST(301) = (2.3E-12*EXP(300./temp))
  RCONST(302) = (1.9E16*EXP(-10830./temp))
  RCONST(303) = (9.50E-13*EXP(-650./temp)*f_co)
  RCONST(304) = (k_roohro)
  RCONST(305) = (k_s*f_sooh)
  RCONST(306) = (k_s*f_pch2oh)
  RCONST(307) = (4.9E-12*EXP(405./temp))
! RCONST(308) = constant rate coefficient
  RCONST(309) = (k1_RO2RCO3*0.9)
  RCONST(310) = (k1_RO2RCO3*0.1)
  RCONST(311) = (KAPHO2*rco3_oh)
  RCONST(312) = (KAPHO2*rco3_ooh)
  RCONST(313) = (KAPHO2*rco3_o3)
  RCONST(314) = (KAPNO)
  RCONST(315) = (k_CH3CO3_NO2)
  RCONST(316) = (k_PAN_M)
  RCONST(317) = (k_co2h+k_p+k_s*f_co2h)
  RCONST(318) = (k_roohro)
  RCONST(319) = (k_s*f_co2h+k_p)
  RCONST(320) = (k_s*f_cpan+k_p)
  RCONST(321) = (k_roohro)
  RCONST(322) = (KAPHO2*rco3_oh)
  RCONST(323) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(324) = (KAPNO)
  RCONST(325) = (k_CH3CO3_NO2)
  RCONST(326) = (KRO2NO3*1.74)
  RCONST(327) = (k1_RO2RCO3)
  RCONST(328) = (2.*k_t*f_co*f_o)
  RCONST(329) = (2.6E-12*EXP(200./temp))
  RCONST(330) = (4.6E-12*EXP(70./temp)*(k_s*f_soh/(k_p+k_s*f_pch2oh+k_s*f_soh)))
  RCONST(331) = (4.6E-12*EXP(70./temp)*((k_p+k_s*f_pch2oh)/(k_p+k_s*f_pch2oh+k_s*f_soh)))
  RCONST(332) = (k_CH2CHOH_OH_HCOOH)
  RCONST(333) = (k_CH2CHOH_HCOOH)
  RCONST(334) = (k_ALD_HCOOH)
  RCONST(335) = (k_s*f_sooh*f_co+k_roohro)
! RCONST(336) = constant rate coefficient
  RCONST(337) = (2.*KNO3AL*2.4)
  RCONST(338) = (k1_RO2RCO3*0.9)
  RCONST(339) = (k1_RO2RCO3*0.1)
  RCONST(340) = (KAPNO)
  RCONST(341) = (k_CH3CO3_NO2)
  RCONST(342) = (KAPHO2*rco3_ooh)
  RCONST(343) = (KAPHO2*rco3_o3)
  RCONST(344) = (KAPHO2*rco3_oh)
  RCONST(345) = (k_PAN_M)
! RCONST(346) = constant rate coefficient
! RCONST(347) = constant rate coefficient
  RCONST(348) = (k1_RO2RCO3*0.9)
  RCONST(349) = (k1_RO2RCO3*0.1)
  RCONST(350) = (KAPNO)
  RCONST(351) = (KAPHO2*rco3_ooh)
  RCONST(352) = (KAPHO2*rco3_oh)
  RCONST(353) = (KAPHO2*rco3_o3)
  RCONST(354) = (k_CH3CO3_NO2)
! RCONST(355) = constant rate coefficient
! RCONST(356) = constant rate coefficient
  RCONST(357) = (k_PAN_M)
! RCONST(358) = constant rate coefficient
! RCONST(359) = constant rate coefficient
! RCONST(360) = constant rate coefficient
  RCONST(361) = (KRO2HO2(3)*(rco3_ooh+rco3_o3))
  RCONST(362) = (KRO2HO2(3)*rco3_oh)
  RCONST(363) = (KRO2NO)
  RCONST(364) = (KRO2NO3)
  RCONST(365) = (k1_RO2sORO2)
  RCONST(366) = (KAPHO2*rco3_oh)
  RCONST(367) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(368) = (KAPNO)
  RCONST(369) = (k_CH3CO3_NO2)
  RCONST(370) = (KRO2NO3*1.74)
  RCONST(371) = (k1_RO2RCO3)
! RCONST(372) = constant rate coefficient
! RCONST(373) = constant rate coefficient
  RCONST(374) = (k_PAN_M)
! RCONST(375) = constant rate coefficient
! RCONST(376) = constant rate coefficient
  RCONST(377) = (2.03E-17*temp*temp*EXP(78./temp))
  RCONST(378) = ((k1_RO2pRO2*0.1273+k1_RO2sRO2*0.8727)*0.1273)
  RCONST(379) = ((k1_RO2pRO2*0.1273+k1_RO2sRO2*0.8727)*0.8727)
  RCONST(380) = (KRO2HO2(4))
  RCONST(381) = (KRO2NO*(1.-(0.1273*alpha_AN(4,1,0,0,0,temp,cair)+0.8727*alpha_AN(4,2,0,0,0,temp,cair)))*0.1273)
  RCONST(382) = (KRO2NO*(1.-(0.1273*alpha_AN(4,1,0,0,0,temp,cair)+0.8727*alpha_AN(4,2,0,0,0,temp,cair)))*0.8727)
  RCONST(383) = (KRO2NO*(0.1273*alpha_AN(4,1,0,0,0,temp,cair)+0.8727*alpha_AN(4,2,0,0,0,temp,cair)))
  RCONST(384) = (KRO2NO3*0.1273)
  RCONST(385) = (KRO2NO3*0.8727)
  RCONST(386) = (k_roohro)
  RCONST(387) = (k_s*f_tooh*f_alk*(k_p/(k_p+k_s)))
  RCONST(388) = (k_t*f_tooh*f_alk*(k_s/(k_p+k_s)))
  RCONST(389) = (1.17E-17*temp*temp*EXP(213./temp)*k_t/(3.*k_p+k_t))
  RCONST(390) = (1.17E-17*temp*temp*EXP(213./temp)*3.*k_p/(3.*k_p+k_t))
  RCONST(391) = (k1_RO2tRO2)
  RCONST(392) = (KRO2HO2(4))
  RCONST(393) = (KRO2NO*(1.-alpha_AN(4,3,0,0,0,temp,cair)))
  RCONST(394) = (KRO2NO*alpha_AN(4,3,0,0,0,temp,cair))
  RCONST(395) = (k_roohro)
  RCONST(396) = (3.*k_p*f_tch2oh)
  RCONST(397) = (3.*k_p*f_ch2ono2)
  RCONST(398) = (k1_RO2sRO2)
  RCONST(399) = (KRO2HO2(4))
  RCONST(400) = (KRO2NO*(1.-alpha_AN(4,2,0,0,0,temp,cair)))
  RCONST(401) = (KRO2NO*alpha_AN(4,2,0,0,0,temp,cair))
  RCONST(402) = (k_roohro)
  RCONST(403) = (k_s*f_sooh+2.*k_s+k_t*f_pch2oh)
  RCONST(404) = (k_s*f_ono2+2.*k_p+k_t*f_ch2ono2)
  RCONST(405) = (8.5E-16*EXP(-1520./temp))
  RCONST(406) = (2.6E-12*EXP(610./temp))
  RCONST(407) = (1.5E-12*EXP(-90./temp))
  RCONST(408) = (KRO2HO2(4))
  RCONST(409) = (KRO2NO*(1.-(.62*alpha_AN(4,2,1,0,0,temp,cair)+.38*alpha_AN(4,1,0,1,0,temp,cair))))
  RCONST(410) = (KRO2NO*(.62*alpha_AN(4,2,1,0,0,temp,cair)+.38*alpha_AN(4,1,0,1,0,temp,cair)))
  RCONST(411) = (k_roohro)
  RCONST(412) = ((.62*k_t*f_tooh*f_co+.38*k_s*f_sooh))
  RCONST(413) = ((k_t*f_ono2*f_alk+k_p*f_alk+k_s*f_ch2ono2+k_p)*(k_s/(k_p+k_s)))
  RCONST(414) = ((k_p+k_s*(1+f_ch2ono2+f_ono2)*f_alk)*(k_p/(k_p+k_s)))
! RCONST(415) = constant rate coefficient
  RCONST(416) = (k_PAN_M)
  RCONST(417) = ((.62*k1_RO2sORO2+.38*k1_RO2pORO2))
  RCONST(418) = (8.E-12*EXP(380./temp))
  RCONST(419) = (1.36E-15*EXP(-2112./temp))
  RCONST(420) = (KNO3AL*2.0)
  RCONST(421) = (k1_RO2RCO3*0.9)
  RCONST(422) = (k1_RO2RCO3*0.1)
  RCONST(423) = (KAPHO2*rco3_oh)
  RCONST(424) = (KAPHO2*rco3_ooh)
  RCONST(425) = (KAPHO2*rco3_o3)
  RCONST(426) = (8.70E-12*EXP(290./temp))
  RCONST(427) = (k_CH3CO3_NO2)
  RCONST(428) = (KRO2NO3*1.74)
  RCONST(429) = (k1_RO2tORO2)
  RCONST(430) = (KRO2HO2(4)*rcoch2o2_oh)
  RCONST(431) = (KRO2HO2(4)*rcoch2o2_ooh)
  RCONST(432) = (KRO2NO*(1.-alpha_AN(6,3,1,0,0,temp,cair)))
  RCONST(433) = (KRO2NO*alpha_AN(6,3,1,0,0,temp,cair))
  RCONST(434) = (KRO2NO3)
  RCONST(435) = (k_roohro)
  RCONST(436) = (k_t*f_o*f_tch2oh*f_alk)
  RCONST(437) = ((k_s*f_soh*f_pch2oh+k_rohro))
  RCONST(438) = (k_t*f_o*f_tch2oh*f_alk)
  RCONST(439) = (KDEC)
  RCONST(440) = (((k_adt+k_adp)*a_co2h+k_co2h))
  RCONST(441) = ((k_adt+k_adp)*a_co2h)
  RCONST(442) = (k_roohro)
  RCONST(443) = ((.12*k1_RO2pORO2+.88*k1_RO2sORO2))
  RCONST(444) = (KRO2HO2(4)*.88*rcoch2o2_oh)
  RCONST(445) = (KRO2HO2(4)*(.12+.88*rcoch2o2_ooh))
  RCONST(446) = (KRO2NO*(1.-(.12*alpha_AN(6,1,0,1,0,temp,cair)+.88*alpha_AN(6,2,1,0,0,temp,cair))))
  RCONST(447) = (KRO2NO*(.12*alpha_AN(6,1,0,1,0,temp,cair)+.88*alpha_AN(6,2,1,0,0,temp,cair)))
  RCONST(448) = (KRO2NO3)
  RCONST(449) = (k_roohro)
  RCONST(450) = ((.12*k_s*f_sooh*f_pch2oh+.88*k_t*f_tooh*f_pch2oh*f_co))
  RCONST(451) = (k_t*f_o*f_alk)
  RCONST(452) = (k_t*f_co*f_toh*f_cho)
  RCONST(453) = (KNO3AL*4.0)
  RCONST(454) = (k1_RO2RCO3)
  RCONST(455) = (KAPHO2*rco3_oh)
  RCONST(456) = (KAPHO2*rco3_o3)
  RCONST(457) = (KAPHO2*rco3_ooh)
  RCONST(458) = (KAPNO)
  RCONST(459) = (KRO2NO3*1.74)
  RCONST(460) = (k_roohro)
  RCONST(461) = ((k_t*f_co2h*f_co*f_toh))
  RCONST(462) = (k_t*f_co2h*f_co*f_toh+k_co2h)
  RCONST(463) = (k_t*f_toh*f_alk*f_co)
  RCONST(464) = (k_s*f_soh*f_alk)
  RCONST(465) = (KDEC)
  RCONST(466) = (KHSD)
  RCONST(467) = (KHSB)
  RCONST(468) = (k_s*f_sooh*f_ch2ono2+k_rohro)
  RCONST(469) = (k_t*f_ono2*f_co*f_pch2oh)
  RCONST(470) = (k_t*f_o*f_ch2ono2)
  RCONST(471) = (k_rohro+k_s*f_sooh*f_ch2ono2)
  RCONST(472) = (K14HSAL)
  RCONST(473) = (K15HS24VYNAL)
  RCONST(474) = (KRO2HO2(4))
  RCONST(475) = (KRO2NO)
  RCONST(476) = (kRO2NO3)
  RCONST(477) = (k1_RO2sORO2)
  RCONST(478) = (K15HS24VYNAL)
  RCONST(479) = (KRO2NO)
  RCONST(480) = (KRO2HO2(4))
  RCONST(481) = (KRO2NO3)
  RCONST(482) = (k1_RO2pORO2)
  RCONST(483) = (KHYDEC)
  RCONST(484) = (KHYDEC)
  RCONST(485) = (KRO2NO)
  RCONST(486) = (KRO2NO3)
  RCONST(487) = (KRO2HO2(4))
  RCONST(488) = (k1_RO2sORO2)
  RCONST(489) = (k1_RO2tORO2)
  RCONST(490) = (KRO2NO)
  RCONST(491) = (KRO2HO2(4))
  RCONST(492) = (KRO2NO3)
  RCONST(493) = (1E-10*a_cho)
  RCONST(494) = (7.6E-11*a_coch3)
  RCONST(495) = (.62*(k_p*(f_co+f_ch2ono2))+.38*(k_s*f_ch2ono2*f_co))
  RCONST(496) = (9.4E-12*EXP(505./temp))
  RCONST(497) = (2.7E-15*EXP(-1630./temp)*0.33)
  RCONST(498) = (2.7E-15*EXP(-1630./temp)*0.67)
! RCONST(499) = constant rate coefficient
  RCONST(500) = (k1_RO2tORO2)
  RCONST(501) = (KRO2HO2(4)*rcoch2o2_ooh)
  RCONST(502) = (KRO2HO2(4)*rcoch2o2_oh)
  RCONST(503) = (KRO2NO*(1.-alpha_AN(5,3,0,0,0,temp,cair)))
  RCONST(504) = (KRO2NO*alpha_AN(5,3,0,0,0,temp,cair))
  RCONST(505) = (KRO2NO3)
  RCONST(506) = (k_roohro)
  RCONST(507) = (k_s*f_sooh*f_pch2oh)
  RCONST(508) = (3.*k_p)
  RCONST(509) = (6.6E-12*EXP(465./temp))
  RCONST(510) = (3.35E-15*EXP(-1745./temp)*.57)
  RCONST(511) = (3.35E-15*EXP(-1745./temp)*.43)
  RCONST(512) = (3.2E-13*EXP(-950./temp))
  RCONST(513) = (k1_RO2sORO2)
  RCONST(514) = (KRO2HO2(4)*rcoch2o2_ooh)
  RCONST(515) = (KRO2HO2(4)*rcoch2o2_oh)
  RCONST(516) = (KRO2NO*(1.-alpha_AN(5,2,0,0,0,temp,cair)))
  RCONST(517) = (KRO2NO*alpha_AN(5,2,0,0,0,temp,cair))
  RCONST(518) = (KRO2NO3)
  RCONST(519) = (k_roohro)
  RCONST(520) = (k_t*f_tooh*f_pch2oh)
  RCONST(521) = (k_s*f_soh*f_ch2ono2)
  RCONST(522) = (1.1E-11*EXP(485./temp))
  RCONST(523) = (3.2E-15*EXP(-965./temp))
! RCONST(524) = constant rate coefficient
  RCONST(525) = (1.0E-11*EXP(553./temp))
  RCONST(526) = (6.6E-15*EXP(-1060./temp))
  RCONST(527) = (1.78E-12*EXP(-530./temp)+1.28E-14*EXP(570./temp))
  RCONST(528) = (k1_RO2sORO2)
  RCONST(529) = (KRO2HO2(4)*rcoch2o2_ooh)
  RCONST(530) = (KRO2HO2(4)*rcoch2o2_oh)
  RCONST(531) = (KRO2NO*(1.-alpha_AN(5,2,0,0,0,temp,cair)))
  RCONST(532) = (KRO2NO*alpha_AN(5,2,0,0,0,temp,cair))
  RCONST(533) = (KRO2NO3)
  RCONST(534) = (k_roohro)
  RCONST(535) = (k_t*f_toh*f_pch2oh)
  RCONST(536) = (k_t*f_tooh*f_pch2oh)
  RCONST(537) = (k_t*f_toh*f_ch2ono2)
  RCONST(538) = (k_t*f_toh*f_co)
  RCONST(539) = (6.8E-12*EXP(410./temp))
  RCONST(540) = (1.67E-12*EXP(-1460./temp))
  RCONST(541) = (k1_RO2RCO3)
  RCONST(542) = (KAPHO2*rco3_ooh)
  RCONST(543) = (KAPHO2*(1-rco3_ooh))
  RCONST(544) = (k_CH3CO3_NO2)
  RCONST(545) = (KAPNO)
  RCONST(546) = (k_roohro)
  RCONST(547) = (k_s*f_co2h)
  RCONST(548) = (k_PAN_M)
  RCONST(549) = (k_s*f_cpan)
  RCONST(550) = (k_CH2CHOH_OH_HCOOH)
  RCONST(551) = (k_CH2CHOH_HCOOH)
  RCONST(552) = (k_ALD_HCOOH)
  RCONST(553) = (k_CH2CHOH_OH_HCOOH)
  RCONST(554) = (k_CH2CHOH_HCOOH)
  RCONST(555) = (k_ALD_HCOOH)
! RCONST(556) = constant rate coefficient
  RCONST(557) = (k_CH2CHOH_HCOOH)
  RCONST(558) = (k_ALD_HCOOH)
! RCONST(559) = constant rate coefficient
  RCONST(560) = (k_CH2CHOH_HCOOH)
  RCONST(561) = (k_ALD_HCOOH)
  RCONST(562) = (k_t*f_o*f_alk+k_s*f_cho*f_co)
  RCONST(563) = (KNO3AL*4.0)
  RCONST(564) = (2.*k_t*f_o*f_alk+k_t*f_cho*f_cho)
  RCONST(565) = (2.*KNO3AL*4.0)
  RCONST(566) = (k1_RO2pORO2)
  RCONST(567) = (KRO2HO2(4))
  RCONST(568) = (KRO2NO)
  RCONST(569) = (k_s*f_co*f_sooh)
  RCONST(570) = (k_roohro)
  RCONST(571) = (KRO2HO2(4))
  RCONST(572) = (KRO2NO)
  RCONST(573) = (k1_RO2sORO2)
! RCONST(574) = constant rate coefficient
  RCONST(575) = (k1_RO2pORO2)
  RCONST(576) = (KRO2HO2(4))
  RCONST(577) = (KRO2NO)
! RCONST(578) = constant rate coefficient
! RCONST(579) = constant rate coefficient
  RCONST(580) = (2.*KNO3AL*4.0)
  RCONST(581) = (k1_RO2RCO3)
  RCONST(582) = (KAPHO2*rco3_ooh)
  RCONST(583) = (KAPHO2*(1-rco3_ooh))
  RCONST(584) = (k_CH3CO3_NO2)
  RCONST(585) = (KAPNO)
! RCONST(586) = constant rate coefficient
  RCONST(587) = (k_PAN_M)
! RCONST(588) = constant rate coefficient
  RCONST(589) = (8.4E-13*EXP(830./temp))
  RCONST(590) = (KNO3AL*4.0)
! RCONST(591) = constant rate coefficient
  RCONST(592) = (KAPHO2*rco3_oh)
  RCONST(593) = (KAPHO2*rco3_o3)
  RCONST(594) = (KAPHO2*rco3_ooh)
  RCONST(595) = (KAPNO)
  RCONST(596) = (k_CH3CO3_NO2)
  RCONST(597) = (KRO2NO3*1.74)
  RCONST(598) = (k1_RO2RCO3*0.7)
  RCONST(599) = (k1_RO2RCO3*0.3)
! RCONST(600) = constant rate coefficient
! RCONST(601) = constant rate coefficient
  RCONST(602) = (K_PAN_M)
! RCONST(603) = constant rate coefficient
  RCONST(604) = (1.60E-17*C(ind_H2O)*(0.08+0.15))
  RCONST(605) = (1.60E-17*C(ind_H2O)*0.77)
! RCONST(606) = constant rate coefficient
! RCONST(607) = constant rate coefficient
! RCONST(608) = constant rate coefficient
! RCONST(609) = constant rate coefficient
! RCONST(610) = constant rate coefficient
  RCONST(611) = (k_roohro)
  RCONST(612) = (k_roohro)
! RCONST(613) = constant rate coefficient
! RCONST(614) = constant rate coefficient
! RCONST(615) = constant rate coefficient
  RCONST(616) = (KAPHO2*rco3_o3)
  RCONST(617) = (KAPHO2*rco3_ooh)
  RCONST(618) = (KAPHO2*rco3_oh)
  RCONST(619) = (KAPNO)
  RCONST(620) = (k_CH3CO3_NO2)
  RCONST(621) = (KRO2NO3*1.74)
  RCONST(622) = (k1_RO2RCO3)
! RCONST(623) = constant rate coefficient
! RCONST(624) = constant rate coefficient
! RCONST(625) = constant rate coefficient
! RCONST(626) = constant rate coefficient
! RCONST(627) = constant rate coefficient
! RCONST(628) = constant rate coefficient
  RCONST(629) = (KAPHO2*rco3_oh)
  RCONST(630) = (KAPHO2*rco3_o3)
  RCONST(631) = (KAPHO2*rco3_ooh)
  RCONST(632) = (KAPNO)
  RCONST(633) = (k_CH3CO3_NO2)
  RCONST(634) = (KRO2NO3*1.74)
  RCONST(635) = (k1_RO2RCO3)
! RCONST(636) = constant rate coefficient
  RCONST(637) = (2*KNO3AL*2.0)
! RCONST(638) = constant rate coefficient
! RCONST(639) = constant rate coefficient
! RCONST(640) = constant rate coefficient
! RCONST(641) = constant rate coefficient
  RCONST(642) = (k_PAN_M)
  RCONST(643) = (KRO2HO2(4)*(1-rcoch2o2_oh-rchohch2o2_oh))
  RCONST(644) = (KRO2HO2(4)*(rcoch2o2_oh+rchohch2o2_oh))
  RCONST(645) = (KRO2NO)
  RCONST(646) = (KRO2NO3)
  RCONST(647) = (k1_RO2sORO2)
! RCONST(648) = constant rate coefficient
! RCONST(649) = constant rate coefficient
  RCONST(650) = (KRO2HO2(4)*(1-rcoch2o2_oh))
  RCONST(651) = (KRO2HO2(4)*rcoch2o2_oh)
  RCONST(652) = (KRO2NO)
  RCONST(653) = (KRO2NO3)
  RCONST(654) = (k1_RO2sORO2)
! RCONST(655) = constant rate coefficient
  RCONST(656) = (2*KNO3AL*4.0)
! RCONST(657) = constant rate coefficient
  RCONST(658) = (KRO2HO2(4)*(1-rcoch2o2_oh))
  RCONST(659) = (KRO2HO2(4)*rcoch2o2_oh)
  RCONST(660) = (KRO2NO)
  RCONST(661) = (KRO2NO3)
  RCONST(662) = (k1_RO2pORO2)
  RCONST(663) = (KNO3AL*8.0)
! RCONST(664) = constant rate coefficient
! RCONST(665) = constant rate coefficient
  RCONST(666) = (KRO2HO2(4)*(1-rcoch2o2_oh-rchohch2o2_oh))
  RCONST(667) = (KRO2HO2(4)*(rcoch2o2_oh+rchohch2o2_oh))
  RCONST(668) = (KRO2NO)
  RCONST(669) = (KRO2NO3)
  RCONST(670) = (k1_RO2sORO2)
! RCONST(671) = constant rate coefficient
  RCONST(672) = (KRO2HO2(4)*(1-rcoch2o2_oh-rchohch2o2_oh))
  RCONST(673) = (KRO2HO2(4)*(rcoch2o2_oh+rchohch2o2_oh))
  RCONST(674) = (KRO2NO)
  RCONST(675) = (KRO2NO3)
  RCONST(676) = (k1_RO2sORO2)
! RCONST(677) = constant rate coefficient
  RCONST(678) = (k_PAN_M)
! RCONST(679) = constant rate coefficient
  RCONST(680) = (1.03E-14*EXP(-1995./temp))
  RCONST(681) = (2.7E-11*EXP(390./temp))
  RCONST(682) = (3.0E-12*EXP(-450./temp))
! RCONST(683) = constant rate coefficient
! RCONST(684) = constant rate coefficient
! RCONST(685) = constant rate coefficient
! RCONST(686) = constant rate coefficient
  RCONST(687) = (3.1E12*exp(-7900./temp)*.6+7.8E13*exp(-8600./temp)*.4)
  RCONST(688) = (3.7E14*exp(-9570./temp)+4.2E14*exp(-9970./temp))
  RCONST(689) = (5.65E12*exp(-8410./temp)*.42+1.4E14*exp(-9110./temp)*.58)
  RCONST(690) = (5.0E14*exp(-10120./temp)+8.25E14*exp(-10220/temp))
  RCONST(691) = (K16HSZ14*2./3.*(1-fhpal))
  RCONST(692) = (K16HSZ14*(2./3.*fhpal+1./3.))
  RCONST(693) = (k16HSZ41*2./3.*(1-fhpal))
  RCONST(694) = (k16HSZ41*(2./3.*fhpal+1./3.))
  RCONST(695) = (k1_RO2LISOPACO2)
  RCONST(696) = (KRO2HO2(5))
  RCONST(697) = (KRO2NO*(1.-alpha_AN(6,1,0,0,0,temp,cair)))
  RCONST(698) = (KRO2NO*alpha_AN(6,1,0,0,0,temp,cair))
  RCONST(699) = (KRO2NO3)
  RCONST(700) = (k1_RO2LISOPACO2)
  RCONST(701) = (KRO2HO2(5))
  RCONST(702) = (KRO2NO*(1.-alpha_AN(6,1,0,0,0,temp,cair)))
  RCONST(703) = (KRO2NO*alpha_AN(6,1,0,0,0,temp,cair))
  RCONST(704) = (KRO2NO3)
  RCONST(705) = (k_roohro)
  RCONST(706) = (k_s*f_allyl*f_soh)
  RCONST(707) = ((k_s*f_sooh*f_allyl+k_rohro))
  RCONST(708) = ((k_adt+k_ads)*a_ch2oh*a_ch2ooh)
  RCONST(709) = ((k_adt+k_ads)*a_ch2oh*a_ch2oh+k_s*f_soh*f_allyl+k_rohro)
  RCONST(710) = ((k_adt+k_ads)*a_ch2ono2*a_ch2oh)
  RCONST(711) = (k1_RO2ISOPBO2)
  RCONST(712) = (KRO2HO2(5)*(1.-rchohch2o2_oh))
  RCONST(713) = (KRO2HO2(5)*rchohch2o2_oh)
  RCONST(714) = (KRO2NO*(1.-alpha_AN(6,3,0,0,0,temp,cair)))
  RCONST(715) = (KRO2NO*alpha_AN(6,3,0,0,0,temp,cair))
  RCONST(716) = (KRO2NO3)
  RCONST(717) = ((k_ads+k_adp)*a_ch2ooh)
  RCONST(718) = (k_roohro)
  RCONST(719) = (k_rohro+k_s*f_alk*f_soh)
! RCONST(720) = constant rate coefficient
  RCONST(721) = (k_s*f_alk*f_soh+(k_adp+k_ads)*a_ch2oh)
  RCONST(722) = ((k_adt+k_adp)*f_ch2ono2)
  RCONST(723) = (k1_RO2ISOPDO2)
  RCONST(724) = (KRO2HO2(5)*(1.-rchohch2o2_oh))
  RCONST(725) = (KRO2HO2(5)*rchohch2o2_oh)
  RCONST(726) = (KRO2NO*(1.-alpha_AN(6,2,0,0,0,temp,cair)))
  RCONST(727) = (KRO2NO*alpha_AN(6,2,0,0,0,temp,cair))
  RCONST(728) = (KRO2NO3)
  RCONST(729) = ((k_adt+k_adp)*a_ch2ooh)
  RCONST(730) = (k_roohro)
  RCONST(731) = (k_t*f_tooh*f_allyl*f_pch2oh)
  RCONST(732) = (k_s*f_pch2oh*f_soh)
! RCONST(733) = constant rate coefficient
  RCONST(734) = (2.*k_rohro+(k_t*f_toh*f_allyl+k_s*f_soh)*f_pch2oh+(k_adt+k_adp)*a_ch2oh)
  RCONST(735) = ((k_adp+k_ads)*a_ch2ono2)
  RCONST(736) = (k1_RO2LISOPACO2)
  RCONST(737) = (KRO2HO2(5))
  RCONST(738) = (KRO2NO)
  RCONST(739) = (KRO2NO3)
! RCONST(740) = constant rate coefficient
  RCONST(741) = ((k_adt+k_ads)*a_cho*a_ch2ono2)
! RCONST(742) = constant rate coefficient
  RCONST(743) = (KNO3AL*4.25)
  RCONST(744) = (0.5*KRO2HO2(5)+0.5*KAPHO2)
  RCONST(745) = (0.5*KAPNO+0.5*KRO2NO)
  RCONST(746) = (KRO2NO3*1.37)
! RCONST(747) = constant rate coefficient
  RCONST(748) = ((k_adtertprim+k_ads)*a_cho*a_ch2oh)
  RCONST(749) = (k_t*f_o)
  RCONST(750) = (k_s*f_soh*f_allyl)
! RCONST(751) = constant rate coefficient
  RCONST(752) = (KNO3AL*4.25)
  RCONST(753) = (k1_RO2tORO2)
  RCONST(754) = (KRO2HO2(5)*rcoch2o2_oh)
  RCONST(755) = (KRO2HO2(5)*rcoch2o2_ooh)
  RCONST(756) = (KRO2NO)
  RCONST(757) = (KRO2NO3)
  RCONST(758) = (KHSB)
  RCONST(759) = (k_roohro)
  RCONST(760) = (k_t*f_o*f_tch2oh*f_alk+k_t*f_toh*f_pch2oh*f_pch2oh+k_s*f_soh*f_pch2oh)
  RCONST(761) = (k1_RO2RCO3*0.9)
  RCONST(762) = (k1_RO2RCO3*0.1)
  RCONST(763) = (KAPHO2*rco3_oh)
  RCONST(764) = (KAPHO2*rco3_ooh)
  RCONST(765) = (KAPHO2*rco3_o3)
  RCONST(766) = (KAPNO)
  RCONST(767) = (k_CH3CO3_NO2)
  RCONST(768) = (KRO2NO3*1.74)
! RCONST(769) = constant rate coefficient
! RCONST(770) = constant rate coefficient
  RCONST(771) = (k_PAN_M)
! RCONST(772) = constant rate coefficient
! RCONST(773) = constant rate coefficient
  RCONST(774) = (7.51E-16*EXP(-1521./temp))
  RCONST(775) = (k1_RO2tORO2)
  RCONST(776) = (KRO2HO2(5)*rcoch2o2_oh)
  RCONST(777) = (KRO2HO2(5)*rcoch2o2_ooh)
  RCONST(778) = (KRO2NO)
  RCONST(779) = (KRO2NO3)
! RCONST(780) = constant rate coefficient
  RCONST(781) = (5.78E-11*EXP(-400./temp)*(1.52/3.+0.98*2./3.)/1.51)
  RCONST(782) = (KHSB)
  RCONST(783) = (KHSD)
  RCONST(784) = (k_adt*a_cho*a_ch2ooh)
  RCONST(785) = (k_ads*a_cho*a_ch2ooh)
  RCONST(786) = (k_t*f_o*f_alk+k_roohro)
  RCONST(787) = (k_s*f_sooh*f_allyl)
! RCONST(788) = constant rate coefficient
  RCONST(789) = (k1_RO2tORO2)
  RCONST(790) = (KRO2NO)
  RCONST(791) = (KRO2HO2(5)*rcoch2o2_ooh)
  RCONST(792) = (KRO2HO2(5)*rcoch2o2_oh)
  RCONST(793) = (KHSB)
  RCONST(794) = (K15HSDHB)
  RCONST(795) = (2.*k_s*f_sooh*f_tch2oh)
  RCONST(796) = (k_t*f_toh*f_pch2oh*f_pch2oh)
  RCONST(797) = (k_roohro)
  RCONST(798) = (k_t*f_o*f_tch2oh+k_t*f_toh*f_toh*f_cho)
  RCONST(799) = (k1_RO2sORO2)
  RCONST(800) = (KRO2NO)
  RCONST(801) = (KRO2HO2(5))
  RCONST(802) = (KHSD)
  RCONST(803) = (K15HSDHB)
  RCONST(804) = (K16HS)
  RCONST(805) = ((k_adt+k_ads)*a_cho*a_cho)
  RCONST(806) = (2*k_t*f_o*f_alk)
  RCONST(807) = (KNO3AL*4.25*2.)
  RCONST(808) = (KRO2HO2(5)*rcoch2o2_oh)
  RCONST(809) = (KRO2HO2(5)*rcoch2o2_ooh)
  RCONST(810) = (KRO2NO)
  RCONST(811) = (k1_RO2tORO2)
  RCONST(812) = ((2.*k_t*f_o*f_tch2oh*f_alk+k_t*f_toh*f_cho*f_pch2oh)*.5)
  RCONST(813) = ((2.*k_t*f_o*f_tch2oh*f_alk+k_t*f_toh*f_cho*f_pch2oh)*.5)
  RCONST(814) = (KRO2NO)
  RCONST(815) = (k1_RO2tORO2+KRO2HO2(5)*c(ind_HO2))
  RCONST(816) = (KRO2NO)
  RCONST(817) = (k1_RO2sORO2+KRO2HO2(5)*c(ind_HO2))
! RCONST(818) = constant rate coefficient
  RCONST(819) = (k1_RO2sORO2)
  RCONST(820) = (KRO2HO2(5)*(1.-rchohch2o2_oh))
  RCONST(821) = (KRO2HO2(5)*rchohch2o2_oh)
  RCONST(822) = (KRO2NO*(1.-alpha_AN(7,2,0,0,0,temp,cair)))
  RCONST(823) = (KRO2NO*alpha_AN(7,2,0,0,0,temp,cair))
  RCONST(824) = (KRO2NO3)
! RCONST(825) = constant rate coefficient
  RCONST(826) = (KDEC*0.72)
  RCONST(827) = (KDEC*0.28)
  RCONST(828) = (k1_RO2sORO2)
  RCONST(829) = (KRO2HO2(5)*(1.-rchohch2o2_oh))
  RCONST(830) = (KRO2HO2(5)*rchohch2o2_oh)
  RCONST(831) = (KRO2NO)
  RCONST(832) = (KRO2NO3)
  RCONST(833) = (K14HSAL)
  RCONST(834) = (k_roohro)
  RCONST(835) = (k_adt)
  RCONST(836) = (4.67E-26*temp**3.286*EXP(4509./(1.987*temp)))
  RCONST(837) = (k_adt)
  RCONST(838) = (k_roohro)
! RCONST(839) = constant rate coefficient
  RCONST(840) = (k_adt*a_cho*a_co2h)
  RCONST(841) = (k_ads*a_cho*a_co2h)
  RCONST(842) = (k1_RO2pORO2)
  RCONST(843) = (KRO2NO*(1.-alpha_AN(6,1,0,0,0,temp,cair)))
  RCONST(844) = (KRO2NO*alpha_AN(6,1,0,0,0,temp,cair))
  RCONST(845) = (KRO2HO2(5)*(1.-rchohch2o2_oh))
  RCONST(846) = (KRO2HO2(5)*rchohch2o2_oh)
  RCONST(847) = (KRO2NO3)
  RCONST(848) = (0.7143*KHSD+.2857*KHSB)
  RCONST(849) = (KDEC)
  RCONST(850) = (KDEC*0.37)
  RCONST(851) = (KDEC*(1.-0.37))
  RCONST(852) = (KDEC*0.37)
  RCONST(853) = (KDEC*(1.-0.37))
  RCONST(854) = (3.2E-11*EXP(310./temp))
! RCONST(855) = constant rate coefficient
  RCONST(856) = (k1_RO2sORO2)
  RCONST(857) = (KRO2NO)
  RCONST(858) = (KRO2HO2(5))
  RCONST(859) = (k1_RO2RCO3)
  RCONST(860) = (KAPHO2*rco3_oh)
  RCONST(861) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(862) = (KAPNO)
  RCONST(863) = (k_CH3CO3_NO2)
  RCONST(864) = (KRO2NO3*1.74)
  RCONST(865) = (k_PAN_M)
! RCONST(866) = constant rate coefficient
  RCONST(867) = (k1_RO2sORO2)
  RCONST(868) = (KRO2NO)
  RCONST(869) = (KRO2HO2(5)*rcoch2o2_ooh)
  RCONST(870) = (KRO2HO2(5)*rcoch2o2_oh)
! RCONST(871) = constant rate coefficient
! RCONST(872) = constant rate coefficient
  RCONST(873) = (KNO3AL*5.5)
  RCONST(874) = (k1_RO2RCO3)
  RCONST(875) = (KAPNO)
  RCONST(876) = (k_CH3CO3_NO2)
  RCONST(877) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(878) = (KAPHO2*rco3_oh)
  RCONST(879) = (k_PAN_M)
! RCONST(880) = constant rate coefficient
  RCONST(881) = (k1_RO2pRO2)
  RCONST(882) = (KRO2HO2(5))
  RCONST(883) = (KRO2NO)
! RCONST(884) = constant rate coefficient
  RCONST(885) = (k1_RO2sORO2)
  RCONST(886) = (KRO2NO)
  RCONST(887) = (KRO2HO2(5)*rcoch2o2_ooh)
  RCONST(888) = (KRO2HO2(5)*rcoch2o2_oh)
! RCONST(889) = constant rate coefficient
  RCONST(890) = (2.*KNO3AL*5.5)
! RCONST(891) = constant rate coefficient
  RCONST(892) = (k1_RO2RCO3)
  RCONST(893) = (KAPHO2)
  RCONST(894) = (k_CH3CO3_NO2)
  RCONST(895) = (KAPNO)
! RCONST(896) = constant rate coefficient
  RCONST(897) = (KRO2HO2(5))
  RCONST(898) = (KRO2NO*(1.-alpha_AN(7,2,0,1,0,temp,cair)))
  RCONST(899) = (KRO2NO*alpha_AN(7,2,0,1,0,temp,cair))
  RCONST(900) = (KRO2NO3)
  RCONST(901) = (k1_RO2sRO2)
! RCONST(902) = constant rate coefficient
! RCONST(903) = constant rate coefficient
! RCONST(904) = constant rate coefficient
  RCONST(905) = (k_PAN_M)
! RCONST(906) = constant rate coefficient
  RCONST(907) = (8.1E-12*EXP(610./TEMP))
  RCONST(908) = (1.0E-17*0.57)
  RCONST(909) = (1.0E-17*0.43)
  RCONST(910) = (4.6E-14*EXP(-400./TEMP))
  RCONST(911) = (KRO2HO2(5))
  RCONST(912) = (KRO2NO*(.67*alpha_AN(7,2,0,0,0,temp,cair)+.33*alpha_AN(7,1,0,0,0,temp,cair)))
  RCONST(913) = (KRO2NO*(1.-(.67*alpha_AN(7,2,0,0,0,temp,cair)+.33*alpha_AN(7,1,0,0,0,temp,cair)))*.67)
  RCONST(914) = (KRO2NO*(1.-(.67*alpha_AN(7,2,0,0,0,temp,cair)+.33*alpha_AN(7,1,0,0,0,temp,cair)))*.33)
  RCONST(915) = (k1_RO2sORO2*.67)
  RCONST(916) = (k1_RO2pORO2*.33)
  RCONST(917) = (0.67*2.93E-11+.33*2.05E-12)
  RCONST(918) = (k_roohro)
  RCONST(919) = (0.67*1.75E-12+.33*2.69E-12)
! RCONST(920) = constant rate coefficient
! RCONST(921) = constant rate coefficient
  RCONST(922) = (KRO2HO2(5))
  RCONST(923) = (KRO2NO)
  RCONST(924) = (KRO2NO3)
  RCONST(925) = (k1_RO2sORO2)
  RCONST(926) = (0.65*4.89E-12+.35*2.52E-12)
  RCONST(927) = (k_roohro)
! RCONST(928) = constant rate coefficient
  RCONST(929) = (KAPHO2*rco3_oh)
  RCONST(930) = (KAPHO2*(rco3_o3+rco3_ooh))
  RCONST(931) = (KAPNO)
  RCONST(932) = (k_CH3CO3_NO2)
  RCONST(933) = (KRO2NO3*1.74)
  RCONST(934) = (k1_RO2RCO3)
! RCONST(935) = constant rate coefficient
! RCONST(936) = constant rate coefficient
  RCONST(937) = (K_PAN_M)
! RCONST(938) = constant rate coefficient
  RCONST(939) = (k_roohro)
  RCONST(940) = (KNO3AL*5.5)
! RCONST(941) = constant rate coefficient
  RCONST(942) = (KRO2HO2(5)*(1-rcoch2o2_oh))
  RCONST(943) = (KRO2HO2(5)*rcoch2o2_oh)
  RCONST(944) = (KRO2NO)
  RCONST(945) = (KRO2NO3)
  RCONST(946) = (k1_RO2tORO2)
! RCONST(947) = constant rate coefficient
! RCONST(948) = constant rate coefficient
  RCONST(949) = (k_PAN_M)
! RCONST(950) = constant rate coefficient
  RCONST(951) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(952) = (KAPHO2*rco3_oh)
  RCONST(953) = (KAPNO)
  RCONST(954) = (k_CH3CO3_NO2)
  RCONST(955) = (KRO2NO3*1.74)
  RCONST(956) = (k1_RO2RCO3)
! RCONST(957) = constant rate coefficient
  RCONST(958) = (KRO2HO2(5)*(1-rcoch2o2_oh-rchohch2o2_oh))
  RCONST(959) = (KRO2HO2(5)*(rcoch2o2_oh+rchohch2o2_oh))
  RCONST(960) = (KRO2NO)
  RCONST(961) = (KRO2NO3)
  RCONST(962) = (k1_RO2tORO2)
! RCONST(963) = constant rate coefficient
  RCONST(964) = (k_PAN_M)
  RCONST(965) = (KAPHO2*rco3_oh)
  RCONST(966) = (KAPHO2*rco3_o3)
  RCONST(967) = (KAPHO2*rco3_ooh)
  RCONST(968) = (KAPNO)
  RCONST(969) = (k_CH3CO3_NO2)
  RCONST(970) = (KRO2NO3*1.74)
  RCONST(971) = (k1_RO2RCO3)
! RCONST(972) = constant rate coefficient
  RCONST(973) = (KNO3AL*2.75)
! RCONST(974) = constant rate coefficient
! RCONST(975) = constant rate coefficient
! RCONST(976) = constant rate coefficient
! RCONST(977) = constant rate coefficient
! RCONST(978) = constant rate coefficient
! RCONST(979) = constant rate coefficient
  RCONST(980) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(981) = (KAPHO2*rco3_oh)
  RCONST(982) = (KAPNO)
  RCONST(983) = (k_CH3CO3_NO2)
  RCONST(984) = (KRO2NO3*1.74)
  RCONST(985) = (k1_RO2RCO3)
! RCONST(986) = constant rate coefficient
  RCONST(987) = (KNO3AL*5.5)
! RCONST(988) = constant rate coefficient
! RCONST(989) = constant rate coefficient
! RCONST(990) = constant rate coefficient
  RCONST(991) = (k_roohro)
! RCONST(992) = constant rate coefficient
! RCONST(993) = constant rate coefficient
! RCONST(994) = constant rate coefficient
  RCONST(995) = (k_PAN_M)
  RCONST(996) = (KRO2HO2(5)*(1-rcoch2o2_oh-rchohch2o2_oh))
  RCONST(997) = (KRO2HO2(5)*(rcoch2o2_oh+rchohch2o2_oh))
  RCONST(998) = (KRO2NO)
  RCONST(999) = (KRO2NO3)
  RCONST(1000) = (k1_RO2tORO2)
! RCONST(1001) = constant rate coefficient
! RCONST(1002) = constant rate coefficient
! RCONST(1003) = constant rate coefficient
  RCONST(1004) = (KRO2HO2(5)*(1-rcoch2o2_oh))
  RCONST(1005) = (KRO2HO2(5)*rcoch2o2_oh)
  RCONST(1006) = (KRO2NO)
  RCONST(1007) = (KRO2NO3)
  RCONST(1008) = (k1_RO2sORO2)
  RCONST(1009) = (KRO2HO2(5)*(rco3_ooh+rco3_o3))
  RCONST(1010) = (KRO2HO2(5)*rco3_oh)
  RCONST(1011) = (KRO2NO)
  RCONST(1012) = (KRO2NO3)
  RCONST(1013) = (k1_RO2sORO2)
  RCONST(1014) = (KRO2HO2(6)*rcoch2o2_ooh)
  RCONST(1015) = (KRO2HO2(6)*rcoch2o2_oh)
  RCONST(1016) = (KRO2NO)
  RCONST(1017) = (k1_RO2pORO2)
! RCONST(1018) = constant rate coefficient
  RCONST(1019) = (k1_RO2sORO2)
  RCONST(1020) = (KRO2NO*(1.-alpha_AN(9,2,0,1,0,temp,cair)))
  RCONST(1021) = (KRO2NO*alpha_AN(9,2,0,1,0,temp,cair))
  RCONST(1022) = (KRO2HO2(6)*(1.-rchohch2o2_oh))
  RCONST(1023) = (KRO2HO2(6)*rchohch2o2_oh)
! RCONST(1024) = constant rate coefficient
! RCONST(1025) = constant rate coefficient
! RCONST(1026) = constant rate coefficient
! RCONST(1027) = constant rate coefficient
  RCONST(1028) = (KNO3AL*5.5)
! RCONST(1029) = constant rate coefficient
! RCONST(1030) = constant rate coefficient
! RCONST(1031) = constant rate coefficient
  RCONST(1032) = (k_roohro)
  RCONST(1033) = (KRO2HO2(6)*(1.-rcoch2o2_oh))
  RCONST(1034) = (KRO2HO2(6)*rcoch2o2_oh)
  RCONST(1035) = (KRO2NO)
  RCONST(1036) = (KRO2NO3)
  RCONST(1037) = (k1_RO2sORO2)
! RCONST(1038) = constant rate coefficient
  RCONST(1039) = (k_PAN_M)
! RCONST(1040) = constant rate coefficient
! RCONST(1041) = constant rate coefficient
! RCONST(1042) = constant rate coefficient
  RCONST(1043) = (KRO2HO2(6)*(1-rchohch2o2_oh))
  RCONST(1044) = (KRO2HO2(6)*rchohch2o2_oh)
  RCONST(1045) = (KRO2NO)
  RCONST(1046) = (KRO2NO3)
  RCONST(1047) = (k1_RO2ISOPDO2)
! RCONST(1048) = constant rate coefficient
! RCONST(1049) = constant rate coefficient
! RCONST(1050) = constant rate coefficient
! RCONST(1051) = constant rate coefficient
! RCONST(1052) = constant rate coefficient
! RCONST(1053) = constant rate coefficient
! RCONST(1054) = constant rate coefficient
  RCONST(1055) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(1056) = (KAPHO2*rco3_oh)
  RCONST(1057) = (KAPNO)
  RCONST(1058) = (k_CH3CO3_NO2)
  RCONST(1059) = (KRO2NO3*1.74)
  RCONST(1060) = (k1_RO2RCO3)
  RCONST(1061) = (2*KNO3AL*2.75)
! RCONST(1062) = constant rate coefficient
! RCONST(1063) = constant rate coefficient
  RCONST(1064) = (KRO2HO2(6)*(1-rchohch2o2_oh))
  RCONST(1065) = (KRO2HO2(6)*rchohch2o2_oh)
  RCONST(1066) = (KRO2NO)
  RCONST(1067) = (KRO2NO3)
  RCONST(1068) = (k1_RO2ISOPDO2)
! RCONST(1069) = constant rate coefficient
  RCONST(1070) = (KRO2HO2(6)*(1-rchohch2o2_oh))
  RCONST(1071) = (KRO2HO2(6)*rchohch2o2_oh)
  RCONST(1072) = (KRO2NO)
  RCONST(1073) = (KRO2NO3)
  RCONST(1074) = (k1_RO2ISOPDO2)
  RCONST(1075) = (2.3E-12*EXP(-190/TEMP))
! RCONST(1076) = constant rate coefficient
  RCONST(1077) = (k_PAN_M)
  RCONST(1078) = (k_C6H5O_NO2)
  RCONST(1079) = (k_C6H5O_O3)
! RCONST(1080) = constant rate coefficient
  RCONST(1081) = (KRO2HO2(6)*(1-rchohch2o2_oh))
  RCONST(1082) = (KRO2HO2(6)*rchohch2o2_oh)
  RCONST(1083) = (KRO2NO)
  RCONST(1084) = (KRO2NO3)
  RCONST(1085) = (k1_RO2ISOPDO2)
! RCONST(1086) = constant rate coefficient
  RCONST(1087) = (k_roohro)
  RCONST(1088) = (k_C6H5O_NO2)
  RCONST(1089) = (k_C6H5O_O3)
! RCONST(1090) = constant rate coefficient
! RCONST(1091) = constant rate coefficient
! RCONST(1092) = constant rate coefficient
  RCONST(1093) = (4.7E-13*EXP(1220/TEMP))
! RCONST(1094) = constant rate coefficient
! RCONST(1095) = constant rate coefficient
  RCONST(1096) = (KRO2HO2(6)*(1-rchohch2o2_oh))
  RCONST(1097) = (KRO2HO2(6)*rchohch2o2_oh)
  RCONST(1098) = (KRO2NO)
  RCONST(1099) = (KRO2NO3)
  RCONST(1100) = (k1_RO2ISOPDO2)
! RCONST(1101) = constant rate coefficient
  RCONST(1102) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(1103) = (KAPHO2*rco3_oh)
  RCONST(1104) = (KAPNO)
  RCONST(1105) = (k_CH3CO3_NO2)
  RCONST(1106) = (KRO2NO3*1.74)
  RCONST(1107) = (k1_RO2RCO3)
  RCONST(1108) = (KRO2HO2(6))
  RCONST(1109) = (KRO2NO)
  RCONST(1110) = (k_C6H5O2_NO2)
  RCONST(1111) = (KRO2NO3)
  RCONST(1112) = (k1_RO2sRO2)
! RCONST(1113) = constant rate coefficient
  RCONST(1114) = (k_C6H5O_NO2)
  RCONST(1115) = (k_C6H5O_O3)
  RCONST(1116) = (k_roohro)
! RCONST(1117) = constant rate coefficient
  RCONST(1118) = (KRO2HO2(6)*(1-rchohch2o2_oh-rcoch2o2_oh))
  RCONST(1119) = (KRO2HO2(6)*(rchohch2o2_oh+rcoch2o2_oh))
  RCONST(1120) = (KRO2NO)
  RCONST(1121) = (KRO2NO3)
  RCONST(1122) = (k1_RO2sORO2)
! RCONST(1123) = constant rate coefficient
  RCONST(1124) = (KRO2HO2(6)*(1-rchohch2o2_oh))
  RCONST(1125) = (KRO2HO2(6)*rchohch2o2_oh)
  RCONST(1126) = (KRO2NO)
  RCONST(1127) = (KRO2NO3)
  RCONST(1128) = (k1_RO2ISOPDO2)
! RCONST(1129) = constant rate coefficient
  RCONST(1130) = (KRO2HO2(6))
  RCONST(1131) = (KRO2HO2(6))
  RCONST(1132) = (KRO2NO*alpha_AN(10,2,0,1,0,temp,cair))
  RCONST(1133) = (KRO2NO*(1.-alpha_AN(10,2,0,1,0,temp,cair)))
  RCONST(1134) = (KRO2NO3)
  RCONST(1135) = (k1_RO2sORO2)
! RCONST(1136) = constant rate coefficient
  RCONST(1137) = (k_PAN_M)
! RCONST(1138) = constant rate coefficient
  RCONST(1139) = (k_roohro)
! RCONST(1140) = constant rate coefficient
  RCONST(1141) = (KRO2HO2(6)*(1-rcoch2o2_oh))
  RCONST(1142) = (KRO2HO2(6)*rcoch2o2_oh)
  RCONST(1143) = (KRO2NO)
  RCONST(1144) = (KRO2NO3)
  RCONST(1145) = (k1_RO2sORO2)
  RCONST(1146) = (k_roohro)
  RCONST(1147) = (KRO2HO2(6))
  RCONST(1148) = (KRO2NO)
  RCONST(1149) = (K_C6H5O2_NO2)
  RCONST(1150) = (KRO2NO3)
  RCONST(1151) = (k1_RO2sORO2)
! RCONST(1152) = constant rate coefficient
! RCONST(1153) = constant rate coefficient
! RCONST(1154) = constant rate coefficient
  RCONST(1155) = (KAPHO2*rco3_o3)
  RCONST(1156) = (KAPHO2*rco3_ooh)
  RCONST(1157) = (KAPHO2*rco3_oh)
  RCONST(1158) = (KAPNO)
  RCONST(1159) = (k_CH3CO3_NO2)
  RCONST(1160) = (KRO2NO3*1.74)
  RCONST(1161) = (k1_RO2RCO3)
  RCONST(1162) = (KRO2HO2(6))
  RCONST(1163) = (KRO2NO)
  RCONST(1164) = (K_C6H5O2_NO2)
  RCONST(1165) = (KRO2NO3)
  RCONST(1166) = (k1_RO2sRO2)
! RCONST(1167) = constant rate coefficient
  RCONST(1168) = (KRO2HO2(6)*(1.-rbipero2_oh))
  RCONST(1169) = (KRO2HO2(6)*rbipero2_oh)
  RCONST(1170) = (KRO2NO*alpha_AN(9,2,0,0,1,temp,cair))
  RCONST(1171) = (KRO2NO*(1.-alpha_AN(9,2,0,0,1,temp,cair)))
  RCONST(1172) = (KRO2NO3)
  RCONST(1173) = (k1_RO2sORO2)
  RCONST(1174) = (KNO3AL*5.5)
! RCONST(1175) = constant rate coefficient
  RCONST(1176) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(1177) = (KAPHO2*rco3_oh)
  RCONST(1178) = (KAPNO)
  RCONST(1179) = (k_CH3CO3_NO2)
  RCONST(1180) = (k1_RO2RCO3)
! RCONST(1181) = constant rate coefficient
! RCONST(1182) = constant rate coefficient
  RCONST(1183) = (k_PAN_M)
  RCONST(1184) = (KRO2HO2(7)*rcoch2o2_ooh)
  RCONST(1185) = (KRO2HO2(7)*rcoch2o2_oh)
  RCONST(1186) = (KRO2NO)
  RCONST(1187) = (k1_RO2sORO2)
! RCONST(1188) = constant rate coefficient
  RCONST(1189) = (KRO2HO2(7))
  RCONST(1190) = (KRO2NO)
  RCONST(1191) = (k1_RO2pRO2)
! RCONST(1192) = constant rate coefficient
  RCONST(1193) = (KRO2HO2(7))
  RCONST(1194) = (KRO2NO)
  RCONST(1195) = (k1_RO2tRO2)
! RCONST(1196) = constant rate coefficient
  RCONST(1197) = (5.68E10*EXP(-8745./TEMP))
  RCONST(1198) = (KRO2NO)
  RCONST(1199) = (KRO2HO2(7))
  RCONST(1200) = (k1_RO2sRO2)
  RCONST(1201) = (5.7E10*EXP(-2949./TEMP))
  RCONST(1202) = (9.17E10*EXP(-8706./TEMP))
  RCONST(1203) = (1.8E-12*EXP(340/TEMP))
  RCONST(1204) = (1.5E-13*EXP(1310/TEMP))
  RCONST(1205) = (KRO2NO*alpha_AN(7,1,0,0,0,temp,cair))
  RCONST(1206) = (KRO2NO*(1.-alpha_AN(7,1,0,0,0,temp,cair)))
  RCONST(1207) = (KRO2NO3)
  RCONST(1208) = (2.*(k_CH3O2*2.4E-14*EXP(1620./TEMP))**0.5*RO2)
! RCONST(1209) = constant rate coefficient
! RCONST(1210) = constant rate coefficient
  RCONST(1211) = (KRO2HO2(7)*(1.-rbipero2_oh))
  RCONST(1212) = (KRO2HO2(7)*rbipero2_oh)
  RCONST(1213) = (KRO2NO*(1.-alpha_AN(11,2,0,0,1,temp,cair)))
  RCONST(1214) = (KRO2NO*alpha_AN(11,2,0,0,1,temp,cair))
  RCONST(1215) = (KRO2NO3)
  RCONST(1216) = (k1_RO2sORO2)
  RCONST(1217) = (KNO3AL*2.75)
! RCONST(1218) = constant rate coefficient
! RCONST(1219) = constant rate coefficient
! RCONST(1220) = constant rate coefficient
! RCONST(1221) = constant rate coefficient
! RCONST(1222) = constant rate coefficient
  RCONST(1223) = (5.9E-12*EXP(225/TEMP))
  RCONST(1224) = (KRO2HO2(7)*(1-rchohch2o2_oh))
  RCONST(1225) = (KRO2HO2(7)*rchohch2o2_oh)
  RCONST(1226) = (KRO2NO)
  RCONST(1227) = (KRO2NO3)
  RCONST(1228) = (k1_RO2ISOPDO2)
  RCONST(1229) = (KRO2HO2(7)*(1-rchohch2o2_oh))
  RCONST(1230) = (KRO2HO2(7)*rchohch2o2_oh)
  RCONST(1231) = (KRO2NO)
  RCONST(1232) = (KRO2NO3)
  RCONST(1233) = (k1_RO2ISOPDO2)
  RCONST(1234) = (k_C6H5O_NO2)
  RCONST(1235) = (k_C6H5O_O3)
  RCONST(1236) = (1.7E-10*1.0)
! RCONST(1237) = constant rate coefficient
  RCONST(1238) = (2.0E-10*1.0)
! RCONST(1239) = constant rate coefficient
! RCONST(1240) = constant rate coefficient
! RCONST(1241) = constant rate coefficient
  RCONST(1242) = (KAPHO2*rco3_oh)
  RCONST(1243) = (KAPHO2*rco3_o3)
  RCONST(1244) = (KAPHO2*rco3_ooh)
  RCONST(1245) = (KAPNO)
  RCONST(1246) = (k_CH3CO3_NO2)
  RCONST(1247) = (KRO2NO3*1.74)
  RCONST(1248) = (k1_RO2RCO3)
  RCONST(1249) = (KRO2HO2(7)*(1-rchohch2o2_oh-rcoch2o2_oh))
  RCONST(1250) = (KRO2HO2(7)*(rchohch2o2_oh+rcoch2o2_oh))
  RCONST(1251) = (KRO2NO*alpha_AN(11,2,1,0,0,temp,cair))
  RCONST(1252) = (KRO2NO*(1.-alpha_AN(11,2,1,0,0,temp,cair)))
  RCONST(1253) = (KRO2NO3)
  RCONST(1254) = (k1_RO2sORO2)
  RCONST(1255) = (1.1E-11*EXP(364./temp)*0.65)
  RCONST(1256) = (1.1E-11*EXP(364./temp)*0.20)
  RCONST(1257) = (1.1E-11*EXP(364./temp)*0.15)
  RCONST(1258) = (KAPNO)
  RCONST(1259) = (k_CH3CO3_NO2)
  RCONST(1260) = (KRO2NO3*1.74)
  RCONST(1261) = (k1_RO2RCO3)
! RCONST(1262) = constant rate coefficient
! RCONST(1263) = constant rate coefficient
  RCONST(1264) = (3.13E-13*1.0)
! RCONST(1265) = constant rate coefficient
  RCONST(1266) = (KRO2HO2(7))
  RCONST(1267) = (KRO2NO)
  RCONST(1268) = (K_C6H5O2_NO2)
  RCONST(1269) = (KRO2NO3)
  RCONST(1270) = (k1_RO2sRO2)
  RCONST(1271) = (k_C6H5O_NO2)
  RCONST(1272) = (k_C6H5O_O3)
! RCONST(1273) = constant rate coefficient
! RCONST(1274) = constant rate coefficient
! RCONST(1275) = constant rate coefficient
  RCONST(1276) = (k_PAN_M)
! RCONST(1277) = constant rate coefficient
! RCONST(1278) = constant rate coefficient
! RCONST(1279) = constant rate coefficient
! RCONST(1280) = constant rate coefficient
! RCONST(1281) = constant rate coefficient
! RCONST(1282) = constant rate coefficient
  RCONST(1283) = (k_PAN_M*0.67)
! RCONST(1284) = constant rate coefficient
! RCONST(1285) = constant rate coefficient
  RCONST(1286) = (k_C6H5O_NO2)
  RCONST(1287) = (k_C6H5O_O3)
! RCONST(1288) = constant rate coefficient
! RCONST(1289) = constant rate coefficient
! RCONST(1290) = constant rate coefficient
  RCONST(1291) = (KRO2HO2(7))
  RCONST(1292) = (KRO2NO)
  RCONST(1293) = (K_C6H5O2_NO2)
  RCONST(1294) = (KRO2NO3)
  RCONST(1295) = (k1_RO2sORO2)
  RCONST(1296) = (KRO2HO2(7)*(1-rcoch2o2_oh))
  RCONST(1297) = (KRO2HO2(7)*rcoch2o2_oh)
  RCONST(1298) = (KRO2NO)
  RCONST(1299) = (KRO2NO3)
  RCONST(1300) = (k1_RO2sORO2)
  RCONST(1301) = (KRO2HO2(7)*(1-rchohch2o2_oh-rcoch2o2_oh))
  RCONST(1302) = (KRO2HO2(7)*(rchohch2o2_oh+rcoch2o2_oh))
  RCONST(1303) = (KRO2NO)
  RCONST(1304) = (KRO2NO3)
  RCONST(1305) = (k1_RO2sORO2)
! RCONST(1306) = constant rate coefficient
! RCONST(1307) = constant rate coefficient
  RCONST(1308) = (KRO2HO2(7))
  RCONST(1309) = (KRO2NO)
  RCONST(1310) = (K_C6H5O2_NO2)
  RCONST(1311) = (KRO2NO3)
  RCONST(1312) = (k1_RO2sRO2)
  RCONST(1313) = (KRO2HO2(7)*(1-rchohch2o2_oh))
  RCONST(1314) = (KRO2HO2(7)*rchohch2o2_oh)
  RCONST(1315) = (KRO2NO)
  RCONST(1316) = (KRO2NO3)
  RCONST(1317) = (k1_RO2ISOPDO2)
  RCONST(1318) = (KRO2HO2(7)*(1-rchohch2o2_oh))
  RCONST(1319) = (KRO2HO2(7)*rchohch2o2_oh)
  RCONST(1320) = (KRO2NO)
  RCONST(1321) = (KRO2NO3)
  RCONST(1322) = (k1_RO2ISOPDO2)
! RCONST(1323) = constant rate coefficient
! RCONST(1324) = constant rate coefficient
! RCONST(1325) = constant rate coefficient
! RCONST(1326) = constant rate coefficient
  RCONST(1327) = (KRO2HO2(7)*(1-rchohch2o2_oh))
  RCONST(1328) = (KRO2HO2(7)*rchohch2o2_oh)
  RCONST(1329) = (KRO2NO)
  RCONST(1330) = (KRO2NO3)
  RCONST(1331) = (k1_RO2ISOPDO2)
  RCONST(1332) = (KRO2HO2(7)*(1-rchohch2o2_oh))
  RCONST(1333) = (KRO2HO2(7)*rchohch2o2_oh)
  RCONST(1334) = (KRO2NO)
  RCONST(1335) = (KRO2NO3)
  RCONST(1336) = (k1_RO2ISOPDO2)
! RCONST(1337) = constant rate coefficient
  RCONST(1338) = (k_roohro)
  RCONST(1339) = (k_roohro)
! RCONST(1340) = constant rate coefficient
  RCONST(1341) = (KAPHO2*rco3_oh)
  RCONST(1342) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(1343) = (KAPNO)
  RCONST(1344) = (k_CH3CO3_NO2)
  RCONST(1345) = (KRO2NO3*1.74)
  RCONST(1346) = (k1_RO2RCO3)
  RCONST(1347) = (k_roohro)
  RCONST(1348) = (k_roohro)
! RCONST(1349) = constant rate coefficient
! RCONST(1350) = constant rate coefficient
  RCONST(1351) = (k_PAN_M)
  RCONST(1352) = (k1_RO2tRO2)
  RCONST(1353) = (KRO2HO2(8))
  RCONST(1354) = (KRO2NO)
! RCONST(1355) = constant rate coefficient
  RCONST(1356) = (k1_RO2tRO2)
  RCONST(1357) = (KRO2NO)
  RCONST(1358) = (KRO2HO2(8))
! RCONST(1359) = constant rate coefficient
  RCONST(1360) = (k1_RO2pRO2)
  RCONST(1361) = (KRO2HO2(8))
  RCONST(1362) = (KRO2NO)
  RCONST(1363) = (k1_RO2tORO2)
  RCONST(1364) = (KRO2NO)
  RCONST(1365) = (KRO2HO2(8))
! RCONST(1366) = constant rate coefficient
  RCONST(1367) = (k1_RO2tRO2)
  RCONST(1368) = (KRO2NO)
  RCONST(1369) = (KRO2HO2(8))
! RCONST(1370) = constant rate coefficient
  RCONST(1371) = (KNO3AL*8.5)
! RCONST(1372) = constant rate coefficient
  RCONST(1373) = (KAPHO2*rco3_ooh)
  RCONST(1374) = (KAPHO2*rco3_oh)
  RCONST(1375) = (KAPHO2*rco3_o3)
  RCONST(1376) = (KAPNO)
  RCONST(1377) = (k_CH3CO3_NO2)
  RCONST(1378) = (KRO2NO3*1.74)
  RCONST(1379) = (k1_RO2RCO3*0.9)
  RCONST(1380) = (k1_RO2RCO3*0.1)
! RCONST(1381) = constant rate coefficient
! RCONST(1382) = constant rate coefficient
! RCONST(1383) = constant rate coefficient
  RCONST(1384) = (k_PAN_M)
! RCONST(1385) = constant rate coefficient
  RCONST(1386) = (KRO2HO2(8))
  RCONST(1387) = (KRO2NO*(1.-alpha_AN(8,2,0,0,0,temp,cair)))
  RCONST(1388) = (KRO2NO*alpha_AN(8,2,0,0,0,temp,cair))
  RCONST(1389) = (k1_RO2sRO2)
! RCONST(1390) = constant rate coefficient
! RCONST(1391) = constant rate coefficient
! RCONST(1392) = constant rate coefficient
  RCONST(1393) = (KRO2HO2(8))
  RCONST(1394) = (KRO2NO*(1.-alpha_AN(7,2,0,0,0,temp,cair)))
  RCONST(1395) = (KRO2NO*alpha_AN(7,2,0,0,0,temp,cair))
  RCONST(1396) = (KRO2NO3)
  RCONST(1397) = (k1_RO2tRO2)
! RCONST(1398) = constant rate coefficient
! RCONST(1399) = constant rate coefficient
  RCONST(1400) = (KRO2HO2(8))
  RCONST(1401) = (KRO2NO*(1.-alpha_AN(10,3,0,0,0,temp,cair)))
  RCONST(1402) = (KRO2NO*alpha_AN(10,3,0,0,0,temp,cair))
  RCONST(1403) = (KRO2NO3)
  RCONST(1404) = (k1_RO2tRO2)
! RCONST(1405) = constant rate coefficient
! RCONST(1406) = constant rate coefficient
! RCONST(1407) = constant rate coefficient
! RCONST(1408) = constant rate coefficient
! RCONST(1409) = constant rate coefficient
! RCONST(1410) = constant rate coefficient
! RCONST(1411) = constant rate coefficient
! RCONST(1412) = constant rate coefficient
! RCONST(1413) = constant rate coefficient
! RCONST(1414) = constant rate coefficient
! RCONST(1415) = constant rate coefficient
! RCONST(1416) = constant rate coefficient
  RCONST(1417) = (KRO2HO2(8))
  RCONST(1418) = (KRO2NO)
  RCONST(1419) = (KRO2NO3)
  RCONST(1420) = (k1_RO2sRO2)
! RCONST(1421) = constant rate coefficient
  RCONST(1422) = (KRO2HO2(8)*(1-rchohch2o2_oh))
  RCONST(1423) = (KRO2HO2(8)*rchohch2o2_oh)
  RCONST(1424) = (KRO2NO)
  RCONST(1425) = (KRO2NO3)
  RCONST(1426) = (k1_RO2sRO2)
! RCONST(1427) = constant rate coefficient
  RCONST(1428) = (k1_RO2pRO2)
  RCONST(1429) = (KRO2HO2(9))
  RCONST(1430) = (KRO2NO*(1.-alpha_AN(10,1,0,0,0,temp,cair)))
  RCONST(1431) = (KRO2NO*alpha_AN(10,1,0,0,0,temp,cair))
! RCONST(1432) = constant rate coefficient
  RCONST(1433) = (k_roohro)
! RCONST(1434) = constant rate coefficient
  RCONST(1435) = (k1_RO2tRO2)
  RCONST(1436) = (KRO2NO)
  RCONST(1437) = (KRO2HO2(9)*rcoch2o2_ooh)
  RCONST(1438) = (KRO2HO2(9)*rcoch2o2_oh)
! RCONST(1439) = constant rate coefficient
  RCONST(1440) = (k1_RO2tRO2)
  RCONST(1441) = (KRO2NO*(1.-alpha_AN(12,3,0,0,0,temp,cair)))
  RCONST(1442) = (KRO2NO*alpha_AN(12,3,0,0,0,temp,cair))
  RCONST(1443) = (KRO2HO2(9))
! RCONST(1444) = constant rate coefficient
! RCONST(1445) = constant rate coefficient
  RCONST(1446) = (KNO3AL*8.5)
  RCONST(1447) = (k1_RO2RCO3)
  RCONST(1448) = (KAPNO)
  RCONST(1449) = (k_CH3CO3_NO2)
  RCONST(1450) = (KAPHO2*(rco3_ooh+rco3_o3))
  RCONST(1451) = (KAPHO2*rco3_oh)
  RCONST(1452) = (k_PAN_M)
! RCONST(1453) = constant rate coefficient
! RCONST(1454) = constant rate coefficient
  RCONST(1455) = (k1_RO2RCO3*0.9)
  RCONST(1456) = (k1_RO2RCO3*0.1)
  RCONST(1457) = (KAPHO2*rco3_ooh)
  RCONST(1458) = (KAPHO2*rco3_o3)
  RCONST(1459) = (KAPHO2*rco3_oh)
  RCONST(1460) = (k_CH3CO3_NO2)
  RCONST(1461) = (KAPNO)
! RCONST(1462) = constant rate coefficient
! RCONST(1463) = constant rate coefficient
  RCONST(1464) = (k_PAN_M)
! RCONST(1465) = constant rate coefficient
  RCONST(1466) = (k1_RO2RCO3*0.9)
  RCONST(1467) = (k1_RO2RCO3*0.1)
  RCONST(1468) = (KAPHO2*rco3_ooh)
  RCONST(1469) = (KAPHO2*rco3_o3)
  RCONST(1470) = (KAPHO2*rco3_oh)
  RCONST(1471) = (KAPNO)
  RCONST(1472) = (k_CH3CO3_NO2)
! RCONST(1473) = constant rate coefficient
! RCONST(1474) = constant rate coefficient
  RCONST(1475) = (KRO2HO2(9)*rcoch2o2_ooh)
  RCONST(1476) = (KRO2HO2(9)*rcoch2o2_oh)
  RCONST(1477) = (KRO2NO)
  RCONST(1478) = (k1_RO2pORO2)
! RCONST(1479) = constant rate coefficient
! RCONST(1480) = constant rate coefficient
  RCONST(1481) = (6.00E-18*c(ind_H2O))
! RCONST(1482) = constant rate coefficient
! RCONST(1483) = constant rate coefficient
! RCONST(1484) = constant rate coefficient
  RCONST(1485) = (k_CH2CHOH_OH_HCOOH)
  RCONST(1486) = (k_CH2CHOH_HCOOH)
  RCONST(1487) = (k_ALD_HCOOH)
! RCONST(1488) = constant rate coefficient
  RCONST(1489) = (k_PAN_M)
! RCONST(1490) = constant rate coefficient
! RCONST(1491) = constant rate coefficient
! RCONST(1492) = constant rate coefficient
! RCONST(1493) = constant rate coefficient
! RCONST(1494) = constant rate coefficient
! RCONST(1495) = constant rate coefficient
  RCONST(1496) = (1.2E-11*EXP(440./TEMP))
  RCONST(1497) = (KRO2NO*(1.-(.65*alpha_AN(11,3,0,0,0,temp,cair)+.35*alpha_AN(11,2,0,0,0,temp,cair))))
  RCONST(1498) = (KRO2NO*(.65*alpha_AN(11,3,0,0,0,temp,cair)+.35*alpha_AN(11,2,0,0,0,temp,cair)))
  RCONST(1499) = (KRO2HO2(10)*(1.-rchohch2o2_oh))
  RCONST(1500) = ((1-ya_soan1-ya_soan2)*KRO2HO2(10)*rchohch2o2_oh)
  RCONST(1501) = (RO2*(0.65*k1_RO2tORO2+.35*k1_RO2sORO2))
! RCONST(1502) = constant rate coefficient
! RCONST(1503) = constant rate coefficient
! RCONST(1504) = constant rate coefficient
  RCONST(1505) = (KRO2NO)
  RCONST(1506) = (KRO2HO2(10))
  RCONST(1507) = (k1_RO2tORO2)
! RCONST(1508) = constant rate coefficient
  RCONST(1509) = (5.2E-12*EXP(600./TEMP))
! RCONST(1510) = constant rate coefficient
  RCONST(1511) = (k1_RO2RCO3*0.9)
  RCONST(1512) = (k1_RO2RCO3*0.1)
  RCONST(1513) = (KAPHO2*rco3_ooh)
  RCONST(1514) = (KAPHO2*rco3_o3)
  RCONST(1515) = (KAPHO2*rco3_oh)
  RCONST(1516) = (k_CH3CO3_NO2)
  RCONST(1517) = (KAPNO)
  RCONST(1518) = (KRO2NO3*1.74)
  RCONST(1519) = (k_PAN_M)
! RCONST(1520) = constant rate coefficient
! RCONST(1521) = constant rate coefficient
! RCONST(1522) = constant rate coefficient
  RCONST(1523) = (KRO2HO2(10))
  RCONST(1524) = (KRO2NO*(1.-alpha_AN(12,3,0,1,0,temp,cair)))
  RCONST(1525) = (KRO2NO*alpha_AN(12,3,0,1,0,temp,cair))
  RCONST(1526) = (k1_RO2tRO2)
! RCONST(1527) = constant rate coefficient
! RCONST(1528) = constant rate coefficient
  RCONST(1529) = (KRO2HO2(10))
  RCONST(1530) = (KRO2NO*0.875*(1.-alpha_AN(13,3,0,0,0,temp,cair)))
  RCONST(1531) = (KRO2NO*0.875*alpha_AN(13,3,0,0,0,temp,cair))
  RCONST(1532) = (k1_RO2tRO2)
! RCONST(1533) = constant rate coefficient
! RCONST(1534) = constant rate coefficient
  RCONST(1535) = (8.05E-16*EXP(-640./TEMP))
  RCONST(1536) = (1.00E-17*c(ind_H2O))
! RCONST(1537) = constant rate coefficient
! RCONST(1538) = constant rate coefficient
! RCONST(1539) = constant rate coefficient
  RCONST(1540) = (1.00E-17*c(ind_H2O)*(0.08+0.15))
  RCONST(1541) = (1.00E-17*c(ind_H2O)*0.77)
! RCONST(1542) = constant rate coefficient
! RCONST(1543) = constant rate coefficient
! RCONST(1544) = constant rate coefficient
  RCONST(1545) = (k1_RO2pORO2)
  RCONST(1546) = (KRO2NO)
  RCONST(1547) = (KRO2HO2(10)*rcoch2o2_ooh)
  RCONST(1548) = ((1-ya_soan1-ya_soan2)*KRO2HO2(10)*rcoch2o2_oh)
! RCONST(1549) = constant rate coefficient
! RCONST(1550) = constant rate coefficient
  RCONST(1551) = (1.2E-12*EXP(490./temp))
  RCONST(1552) = ((0.65*k1_RO2tRO2+0.35*k1_RO2sRO2))
  RCONST(1553) = (KRO2NO)
  RCONST(1554) = (KRO2HO2(10))
  RCONST(1555) = (KRO2NO3)
  RCONST(1556) = ((.65*6.87E-12+.35*1.23E-11))
  RCONST(1557) = (1.47E-11*EXP(467./TEMP)*(0.8326*0.3+0.068)/(0.8326+0.068))
  RCONST(1558) = (1.47E-11*EXP(467./TEMP)*0.8326*0.7/(0.8326+0.068))
  RCONST(1559) = (KRO2HO2(10)*rcoch2o2_ooh)
  RCONST(1560) = ((1-ya_soan1-ya_soan2)*KRO2HO2(10)*rcoch2o2_oh)
  RCONST(1561) = (KRO2NO*(1.-alpha_AN(11,3,0,0,0,temp,cair)))
  RCONST(1562) = (KRO2NO*alpha_AN(11,3,0,0,0,temp,cair))
  RCONST(1563) = (k1_RO2tORO2)
! RCONST(1564) = constant rate coefficient
! RCONST(1565) = constant rate coefficient
  RCONST(1566) = (KRO2NO*(1.-alpha_AN(13,3,0,0,0,temp,cair)))
  RCONST(1567) = (KRO2NO*alpha_AN(13,3,0,0,0,temp,cair))
  RCONST(1568) = (k1_RO2tORO2)
  RCONST(1569) = (KRO2NO*(1.-alpha_AN(12,3,0,0,0,temp,cair)))
  RCONST(1570) = (KRO2NO*alpha_AN(12,3,0,0,0,temp,cair))
  RCONST(1571) = (KRO2HO2(10))
  RCONST(1572) = (k1_RO2sORO2)
  RCONST(1573) = (KRO2NO*(1.-alpha_AN(12,3,0,0,0,temp,cair)))
  RCONST(1574) = (KRO2NO*alpha_AN(12,3,0,0,0,temp,cair))
  RCONST(1575) = (KRO2HO2(10))
  RCONST(1576) = (k1_RO2sRO2)
  RCONST(1577) = (1.35E-15*EXP(-1270./TEMP)*.051/(1-.027))
  RCONST(1578) = (1.35E-15*EXP(-1270./TEMP)*.368/(1-.027))
  RCONST(1579) = (1.35E-15*EXP(-1270./TEMP)*.283/(1-.027))
  RCONST(1580) = (1.35E-15*EXP(-1270./TEMP)*(.104+.167)/(1-.027))
! RCONST(1581) = constant rate coefficient
  RCONST(1582) = (KRO2HO2(10))
  RCONST(1583) = (KRO2NO)
  RCONST(1584) = (KRO2NO3)
  RCONST(1585) = (k1_RO2tRO2*0.7)
  RCONST(1586) = (k1_RO2tRO2*0.3)
! RCONST(1587) = constant rate coefficient
! RCONST(1588) = constant rate coefficient
! RCONST(1589) = constant rate coefficient
  RCONST(1590) = (k_CH2CHOH_OH_HCOOH)
  RCONST(1591) = (k_CH2CHOH_HCOOH)
  RCONST(1592) = (k_ALD_HCOOH)
  RCONST(1593) = (8.8E-11*(.50+.25))
  RCONST(1594) = (8.8E-11*.25*.60)
  RCONST(1595) = (8.8E-11*.25*.40)
  RCONST(1596) = (3.7E-17*.50*.18)
  RCONST(1597) = (3.7E-17*.50*.16)
  RCONST(1598) = (3.7E-17*.50*.66)
  RCONST(1599) = (3.7E-17*.50*.12)
  RCONST(1600) = (3.7E-17*.50*(.22+.66))
! RCONST(1601) = constant rate coefficient
  RCONST(1602) = (1.47E-11*EXP(467./TEMP)*(0.8326*0.3+0.068)/(0.8326+0.068))
  RCONST(1603) = (1.47E-11*EXP(467./TEMP)*0.8326*0.7/(0.8326+0.068))
  RCONST(1604) = (1.35E-15*EXP(-1270./TEMP)*.051/(1-.027))
  RCONST(1605) = (1.35E-15*EXP(-1270./TEMP)*.368/(1-.027))
  RCONST(1606) = (1.35E-15*EXP(-1270./TEMP)*.283/(1-.027))
  RCONST(1607) = (1.35E-15*EXP(-1270./TEMP)*(.104+.167)/(1-.027))
! RCONST(1608) = constant rate coefficient
  RCONST(1609) = (1.47E-11*EXP(467./TEMP)*(0.8326*0.3+0.068)/(0.8326+0.068))
  RCONST(1610) = (1.47E-11*EXP(467./TEMP)*0.8326*0.7/(0.8326+0.068))
  RCONST(1611) = (1.35E-15*EXP(-1270./TEMP)*.051/(1-.027))
  RCONST(1612) = (1.35E-15*EXP(-1270./TEMP)*.368/(1-.027))
  RCONST(1613) = (1.35E-15*EXP(-1270./TEMP)*.283/(1-.027))
  RCONST(1614) = (1.35E-15*EXP(-1270./TEMP)*(.104+.167)/(1-.027))
! RCONST(1615) = constant rate coefficient
! RCONST(1616) = constant rate coefficient
! RCONST(1617) = constant rate coefficient
  RCONST(1618) = (2.8E-11*EXP(-250./temp))
  RCONST(1619) = (1.0E-12*EXP(-1590./temp))
  RCONST(1620) = (3.0E-11*EXP(-2450./temp))
  RCONST(1621) = (3.5E-13*EXP(-1370./temp))
  RCONST(1622) = (k_ClO_ClO)
  RCONST(1623) = (k_ClO_ClO/(2.16E-27*EXP(8537./temp)))
  RCONST(1624) = (1.1E-11*EXP(-980./temp))
  RCONST(1625) = (2.2E-12*EXP(340./temp))
  RCONST(1626) = (1.7E-12*EXP(-230./temp))
  RCONST(1627) = (6.2E-12*EXP(295./temp))
  RCONST(1628) = (k_3rd_iupac(temp,cair,1.6E-31,3.4,7.E-11,0.,0.4))
  RCONST(1629) = (6.918E-7*EXP(-10909./temp)*cair)
  RCONST(1630) = (6.2E-12*EXP(145./temp))
  RCONST(1631) = (6.6E-12*EXP(-1240./temp))
  RCONST(1632) = (8.1E-11*EXP(-34./temp))
! RCONST(1633) = constant rate coefficient
  RCONST(1634) = (1.8E-12*EXP(-600./temp))
  RCONST(1635) = (1.64E-12*EXP(-1520./temp))
  RCONST(1636) = (k_3rd_iupac(temp,cair,1.85E-29,3.3,6.0E-10,0.0,0.4))
! RCONST(1637) = constant rate coefficient
  RCONST(1638) = (k_3rd_iupac(temp,cair,6.1e-30,3.0,2.0e-10,0.,0.6))
  RCONST(1639) = (8.3E-11*EXP(-100./temp))
  RCONST(1640) = (1.3E-11*EXP(-1200./temp))
! RCONST(1641) = constant rate coefficient
! RCONST(1642) = constant rate coefficient
  RCONST(1643) = (1.6E-11*EXP(-2104./temp))
  RCONST(1644) = (2.1E-11*EXP(-830./temp))
! RCONST(1645) = constant rate coefficient
  RCONST(1646) = (5.4E-11*EXP(180./temp))
  RCONST(1647) = (1.5E-11*EXP(-1090./temp))
  RCONST(1648) = (1.4E-11*EXP(540./temp))
  RCONST(1649) = (1.6E-11*EXP(440./temp))
  RCONST(1650) = (2.2E-10*EXP(243./temp))
! RCONST(1651) = constant rate coefficient
! RCONST(1652) = constant rate coefficient
  RCONST(1653) = (k_I_NO2)
! RCONST(1654) = constant rate coefficient
  RCONST(1655) = (7.15E-12*EXP(300./temp))
  RCONST(1656) = (k_3rd_iupac(temp,cair,7.7E-31,5.,1.6E-11,0.,0.4))
  RCONST(1657) = (1.1E-12*EXP(542./temp))
  RCONST(1658) = (k_I_NO2/(3.7E-7*EXP(9568./temp)*1.E6*R_gas*temp/(atm2Pa*N_A)))
  RCONST(1659) = (2.1e15*EXP(-13670./temp))
! RCONST(1660) = constant rate coefficient
! RCONST(1661) = constant rate coefficient
  RCONST(1662) = (9.1E-11*EXP(-146./temp))
! RCONST(1663) = constant rate coefficient
! RCONST(1664) = constant rate coefficient
! RCONST(1665) = constant rate coefficient
  RCONST(1666) = (4.7E-12*EXP(280./temp))
  RCONST(1667) = (k_3rd(temp,cair,3.E-31,-3.3,1.5E-12,0.,0.6))
  RCONST(1668) = (1.13E-11*EXP(-253./temp))
  RCONST(1669) = (k_DMS_OH)
  RCONST(1670) = (1.9E-13*EXP(520./temp))
  RCONST(1671) = (k_DMSO_OH_B1)
  RCONST(1672) = (k_DMSO_OH_B2)
  RCONST(1673) = (1.0E13*EXP((-16500.*fch3so2/1.98635)/temp))
  RCONST(1674) = (k_CH3SO2_O3)
  RCONST(1675) = (k_CH3SO3_HO2)
  RCONST(1676) = (k_CH2OO_SO2)
! RCONST(1677) = constant rate coefficient
! RCONST(1678) = constant rate coefficient
! RCONST(1679) = constant rate coefficient
! RCONST(1680) = constant rate coefficient
! RCONST(1681) = constant rate coefficient
  RCONST(1682) = (3.2E-13*EXP(-925./temp))
  RCONST(1683) = (jx(ip_O2))
  RCONST(1684) = (jx(ip_O1D))
  RCONST(1685) = (jx(ip_O3P))
  RCONST(1686) = (jx(ip_H2O2))
  RCONST(1687) = (jx(ip_NO2))
  RCONST(1688) = (jx(ip_NO2O))
  RCONST(1689) = (jx(ip_NOO2))
  RCONST(1690) = (jx(ip_N2O5))
  RCONST(1691) = (jx(ip_HONO))
  RCONST(1692) = (jx(ip_HNO3))
  RCONST(1693) = (jx(ip_HNO4))
  RCONST(1694) = (jx(ip_CH3OOH))
  RCONST(1695) = (jx(ip_COH2))
  RCONST(1696) = (jx(ip_CHOH))
  RCONST(1697) = (jx(ip_CH3ONO))
  RCONST(1698) = (jx(ip_CH3NO3))
  RCONST(1699) = (jx(ip_CH3O2NO2))
  RCONST(1700) = (jx(ip_CH3OOH))
  RCONST(1701) = (jx(ip_CH3O2))
  RCONST(1702) = (jx(ip_HCOOH))
  RCONST(1703) = (jx(ip_CH3O2NO2))
  RCONST(1704) = (jx(ip_CH3OOH))
  RCONST(1705) = (jx(ip_CH3CHO))
  RCONST(1706) = (jx(ip_CH3CHO2VINY))
  RCONST(1707) = (jx(ip_CH3CO3H))
  RCONST(1708) = (jx(ip_PAN))
  RCONST(1709) = (jx(ip_HOCH2CHO)*0.83)
  RCONST(1710) = (jx(ip_HOCH2CHO)*0.07)
  RCONST(1711) = (jx(ip_HOCH2CHO)*0.10)
  RCONST(1712) = (jx(ip_CH3OOH))
  RCONST(1713) = (jx(ip_PAN))
  RCONST(1714) = (jx(ip_GLYOX))
  RCONST(1715) = (jx(ip_MGLYOX))
  RCONST(1716) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1717) = (jx(ip_CH3OOH))
  RCONST(1718) = (j_IC3H7NO3)
  RCONST(1719) = (2*jx(ip_CH3OOH))
  RCONST(1720) = (jx(ip_CH3OOH))
  RCONST(1721) = (j_ketene*0.36)
  RCONST(1722) = (jx(ip_CH3OOH))
  RCONST(1723) = ((jx(ip_C2H5NO3)+jx(ip_CH3CHO))*(jx(ip_NOA)+1E-10)/(0.59*j_IC3H7NO3+jx(ip_CH3COCH3)+1E-10))
  RCONST(1724) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1725) = (jx(ip_C2H5NO3))
  RCONST(1726) = (jx(ip_PAN))
  RCONST(1727) = (jx(ip_CH3O2NO2))
  RCONST(1728) = (jx(ip_CH3OOH))
  RCONST(1729) = (jx(ip_CH3COCH3))
  RCONST(1730) = (j_ACETOL)
  RCONST(1731) = (jx(ip_MGLYOX))
  RCONST(1732) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1733) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1734) = (j_IC3H7NO3)
  RCONST(1735) = (jx(ip_NOA))
  RCONST(1736) = (jx(ip_CH3OOH))
  RCONST(1737) = (jx(ip_CH3OOH))
  RCONST(1738) = (jx(ip_MGLYOX))
  RCONST(1739) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1740) = (jx(ip_MGLYOX))
  RCONST(1741) = (jx(ip_HOCH2CHO)*2.)
  RCONST(1742) = (jx(ip_HOCH2CHO))
  RCONST(1743) = (jx(ip_CH3OOH))
  RCONST(1744) = (2.*jx(ip_MGLYOX))
  RCONST(1745) = (jx(IP_CH3COCO2H))
  RCONST(1746) = (jx(IP_MGLYOX)+jx(ip_CH3OOH))
  RCONST(1747) = (j_ketene*0.36*2.)
  RCONST(1748) = (j_IC3H7NO3)
  RCONST(1749) = (jx(ip_CH3O2NO2)+jx(ip_CH3COCH3))
  RCONST(1750) = (jx(ip_CH3OOH))
  RCONST(1751) = (0.59*j_IC3H7NO3)
  RCONST(1752) = (jx(ip_C2H5CHO2HCO))
  RCONST(1753) = (jx(ip_C2H5CHO2ENOL))
  RCONST(1754) = (jx(ip_PAN))
  RCONST(1755) = (jx(ip_CH3OOH))
  RCONST(1756) = (jx(ip_MGLYOX))
  RCONST(1757) = (jx(ip_HOCH2CHO)+jx(ip_CH3OOH))
  RCONST(1758) = (jx(ip_HOCH2CHO)+jx(ip_CH3OOH))
  RCONST(1759) = (jx(ip_HOCH2CHO)*2+jx(ip_CH3OOH))
  RCONST(1760) = (jx(ip_HOCH2CHO)*2)
  RCONST(1761) = (jx(ip_CH3OOH))
  RCONST(1762) = (jx(ip_CH3OOH)*(k_p/(k_p+k_s)))
  RCONST(1763) = (jx(ip_CH3OOH)*(k_s/(k_p+k_s)))
  RCONST(1764) = (jx(ip_MVK))
  RCONST(1765) = (0.42*jx(ip_CHOH))
  RCONST(1766) = (jx(ip_CH3OOH)+0.42*jx(ip_CHOH))
  RCONST(1767) = (2.15*jx(ip_MGLYOX))
  RCONST(1768) = (j_IC3H7NO3*(k_p/(k_p+k_s)))
  RCONST(1769) = (j_IC3H7NO3*(k_s/(k_p+k_s)))
  RCONST(1770) = (jx(ip_PAN))
  RCONST(1771) = (jx(ip_CH3OOH))
  RCONST(1772) = (j_ACETOL)
  RCONST(1773) = (jx(ip_MACR))
  RCONST(1774) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO))
  RCONST(1775) = (2.77*jx(ip_HOCH2CHO))
  RCONST(1776) = (jx(ip_CH3OOH))
  RCONST(1777) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1778) = (jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1779) = (j_ACETOL)
  RCONST(1780) = (2.15*jx(ip_MGLYOX))
  RCONST(1781) = (j_KETENE)
  RCONST(1782) = (j_KETENE*0.5)
  RCONST(1783) = (j_KETENE*0.5)
  RCONST(1784) = (jx(ip_MGLYOX))
  RCONST(1785) = (2.15*jx(ip_MGLYOX))
  RCONST(1786) = (3.15*jx(ip_MGLYOX))
  RCONST(1787) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1788) = (2.15*jx(ip_MGLYOX))
  RCONST(1789) = (jx(ip_CH3OOH))
  RCONST(1790) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1791) = (jx(ip_HOCH2CHO))
  RCONST(1792) = (jx(ip_MGLYOX))
  RCONST(1793) = (jx(ip_CH3OOH)+jx(ip_MGLYOX))
  RCONST(1794) = (jx(ip_MEKNO3))
  RCONST(1795) = (jx(ip_MEKNO3))
  RCONST(1796) = ((2.84*j_IC3H7NO3+jx(ip_CH3CHO))*(jx(ip_MEKNO3)+1E-10)/(j_IC3H7NO3+0.42*jx(ip_CHOH)+1E-10))
  RCONST(1797) = (2.84*j_IC3H7NO3)
  RCONST(1798) = (jx(ip_CH3OOH))
  RCONST(1799) = (2.84*j_IC3H7NO3)
  RCONST(1800) = (jx(ip_CH3OOH))
  RCONST(1801) = (jx(ip_CH3OOH))
  RCONST(1802) = (j_IC3H7NO3)
  RCONST(1803) = (jx(ip_CH3OOH))
  RCONST(1804) = (j_IC3H7NO3)
  RCONST(1805) = (j_ACETOL)
  RCONST(1806) = (jx(ip_C3H7CHO2HCO))
  RCONST(1807) = (jx(ip_C3H7CHO2VINY))
  RCONST(1808) = (jx(ip_IPRCHO2HCO))
  RCONST(1809) = (j_IC3H7NO3)
  RCONST(1810) = (jx(ip_CH3OOH))
  RCONST(1811) = (jx(ip_CH3OOH))
  RCONST(1812) = (jx(ip_PAN))
  RCONST(1813) = (jx(ip_PeDIONE24))
  RCONST(1814) = (jx(ip_PeDIONE24))
  RCONST(1815) = (jx(ip_C2H5CHO2HCO))
  RCONST(1816) = (jx(ip_C2H5CHO2ENOL))
  RCONST(1817) = (jx(ip_C2H5CHO2HCO)*2.)
  RCONST(1818) = (jx(ip_C2H5CHO2ENOL)*2.)
  RCONST(1819) = (j_ACETOL)
  RCONST(1820) = (jx(ip_CH3OOH))
  RCONST(1821) = (jx(ip_HOCH2CHO)*2)
  RCONST(1822) = (jx(ip_CH3OOH))
  RCONST(1823) = (jx(ip_CH3OOH))
  RCONST(1824) = (jx(ip_MGLYOX)+jx(ip_HOCH2CHO))
  RCONST(1825) = (jx(ip_CH3OOH))
  RCONST(1826) = (jx(ip_MACR))
  RCONST(1827) = (jx(ip_CH3OOH))
  RCONST(1828) = (2.77*jx(ip_HOCH2CHO))
  RCONST(1829) = (jx(ip_NO2)*0.14)
  RCONST(1830) = (jx(ip_CH3OOH))
  RCONST(1831) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO))
  RCONST(1832) = (jx(ip_MGLYOX)*2)
  RCONST(1833) = (jx(ip_MACR))
  RCONST(1834) = (2.77*jx(ip_HOCH2CHO)*2)
  RCONST(1835) = (jx(ip_MGLYOX))
  RCONST(1836) = (jx(ip_CH3OOH))
  RCONST(1837) = (jx(ip_CH3OOH))
  RCONST(1838) = (0.59*j_IC3H7NO3)
  RCONST(1839) = (jx(ip_CH3OOH))
  RCONST(1840) = (2.84*j_IC3H7NO3)
  RCONST(1841) = (jx(ip_CH3OOH))
  RCONST(1842) = (j_IC3H7NO3)
  RCONST(1843) = (jx(ip_CH3OOH))
  RCONST(1844) = ((.59*j_IC3H7NO3+jx(ip_MACR))*(jx(ip_MEKNO3)+1E-10)/(j_IC3H7NO3+0.42*jx(ip_CHOH)+1E-10))
  RCONST(1845) = (jx(ip_CH3OOH))
  RCONST(1846) = (jx(ip_MACR))
  RCONST(1847) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO))
  RCONST(1848) = (j_HPALD)
  RCONST(1849) = (jx(ip_PAN))
  RCONST(1850) = (0.5*jx(ip_MVK))
  RCONST(1851) = (j_ACETOL+jx(ip_CH3OOH))
  RCONST(1852) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1853) = (jx(ip_HOCH2CHO))
  RCONST(1854) = (2.15*jx(ip_MGLYOX))
  RCONST(1855) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1856) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1857) = (jx(ip_HOCH2CHO)*2.)
  RCONST(1858) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1859) = (jx(ip_MGLYOX)+2.15*jx(ip_MGLYOX))
  RCONST(1860) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)*2.)
  RCONST(1861) = (j_IC3H7NO3+jx(ip_HOCH2CHO)*2.)
  RCONST(1862) = (j_HPALD*0.6*0.5)
  RCONST(1863) = (j_HPALD*0.6*0.5)
  RCONST(1864) = (j_HPALD*0.4*0.5)
  RCONST(1865) = (j_HPALD*0.4*0.5)
  RCONST(1866) = (j_HPALD)
  RCONST(1867) = (2.77*jx(IP_HOCH2CHO))
  RCONST(1868) = (2.*jx(IP_CH3OOH))
  RCONST(1869) = (jx(IP_CH3OOH))
  RCONST(1870) = (jx(ip_CH3OOH))
  RCONST(1871) = (jx(ip_CH3OOH))
  RCONST(1872) = (2.*2.77*jx(IP_HOCH2CHO))
  RCONST(1873) = (jx(ip_NO2)*0.1*0.5)
  RCONST(1874) = (j_IC3H7NO3)
  RCONST(1875) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1876) = (jx(ip_CH3OOH)*.67)
  RCONST(1877) = (jx(ip_CH3OOH)*.33)
  RCONST(1878) = (j_ACETOL)
  RCONST(1879) = (jx(ip_MGLYOX))
  RCONST(1880) = (jx(ip_CH3OOH)*.65)
  RCONST(1881) = (jx(ip_CH3OOH)*.35)
  RCONST(1882) = (jx(ip_CH3OOH))
  RCONST(1883) = (jx(ip_MGLYOX)+2.15*jx(ip_MGLYOX)*2)
  RCONST(1884) = (jx(ip_HOCH2CHO)+2.15*jx(ip_MGLYOX))
  RCONST(1885) = (jx(ip_CH3OOH)+jx(ip_MACR))
  RCONST(1886) = (jx(ip_MVK))
  RCONST(1887) = (jx(ip_NO2)*0.2)
  RCONST(1888) = (jx(ip_MACR))
  RCONST(1889) = (jx(ip_HOCH2CHO))
  RCONST(1890) = (jx(ip_CH3OOH))
  RCONST(1891) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1892) = (jx(ip_CH3OOH))
  RCONST(1893) = (jx(ip_CH3OOH))
  RCONST(1894) = (jx(ip_CH3OOH))
  RCONST(1895) = (jx(ip_CH3OOH))
  RCONST(1896) = (jx(ip_MGLYOX)+jx(ip_MACR))
  RCONST(1897) = (2.15*jx(ip_MGLYOX))
  RCONST(1898) = (jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX))
  RCONST(1899) = (jx(ip_MGLYOX))
  RCONST(1900) = (jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX))
  RCONST(1901) = (jx(ip_CH3OOH))
  RCONST(1902) = (jx(ip_MGLYOX)*2)
  RCONST(1903) = (jx(ip_CH3OOH)+jx(ip_MGLYOX))
  RCONST(1904) = (jx(ip_CH3OOH))
  RCONST(1905) = (j_IC3H7NO3)
  RCONST(1906) = (jx(ip_HOC6H4NO2))
  RCONST(1907) = (j_KETENE)
  RCONST(1908) = (jx(ip_CH3OOH))
  RCONST(1909) = (4.E3*jx(ip_MVK)*0.1)
  RCONST(1910) = (jx(ip_CH3OOH))
  RCONST(1911) = (jx(ip_HOCH2CHO)*2+j_ACETOL)
  RCONST(1912) = (jx(ip_MACR))
  RCONST(1913) = (jx(ip_CH3OOH))
  RCONST(1914) = (jx(ip_MVK)+jx(ip_CH3OOH))
  RCONST(1915) = (j_IC3H7NO3+jx(ip_CH3OOH))
  RCONST(1916) = (jx(ip_CH3OOH))
  RCONST(1917) = (jx(ip_CH3OOH))
  RCONST(1918) = (j_ACETOL)
  RCONST(1919) = (jx(ip_CH3OOH))
  RCONST(1920) = (jx(ip_CH3OOH))
  RCONST(1921) = (jx(ip_CH3OOH))
  RCONST(1922) = (jx(ip_MGLYOX)+jx(ip_MVK))
  RCONST(1923) = (jx(ip_CH3OOH))
  RCONST(1924) = (jx(ip_CH3OOH)+jx(ip_MACR))
  RCONST(1925) = (jx(ip_CH3OOH))
  RCONST(1926) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)*2)
  RCONST(1927) = (2.77*jx(ip_HOCH2CHO))
  RCONST(1928) = (jx(ip_HOC6H4NO2))
  RCONST(1929) = (j_KETENE)
  RCONST(1930) = (2.15*jx(ip_MGLYOX))
  RCONST(1931) = (jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX))
  RCONST(1932) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1933) = (jx(ip_CH3OOH))
  RCONST(1934) = (jx(ip_CH3OOH))
  RCONST(1935) = (4.E3*jx(ip_MVK)*0.1)
  RCONST(1936) = (jx(ip_CH3OOH))
  RCONST(1937) = (0.59*j_IC3H7NO3)
  RCONST(1938) = (jx(ip_BENZAL))
  RCONST(1939) = (jx(ip_CH3OOH))
  RCONST(1940) = (j_IC3H7NO3)
  RCONST(1941) = (j_ACETOL)
  RCONST(1942) = (jx(ip_CH3OOH))
  RCONST(1943) = (j_IC3H7NO3)
  RCONST(1944) = (jx(ip_CH3OOH))
  RCONST(1945) = (jx(ip_HOPh3Me2NO2))
  RCONST(1946) = (jx(ip_MACR))
  RCONST(1947) = (jx(ip_CH3OOH)+jx(ip_MACR))
  RCONST(1948) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1949) = (2.77*jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1950) = (2.77*jx(ip_HOCH2CHO)+2.15*jx(ip_MGLYOX))
  RCONST(1951) = (jx(ip_CH3OOH))
  RCONST(1952) = (jx(ip_CH3OOH))
  RCONST(1953) = (jx(ip_HOPh3Me2NO2))
  RCONST(1954) = (j_KETENE)
  RCONST(1955) = (jx(ip_HOPh3Me2NO2))
  RCONST(1956) = (j_KETENE)
  RCONST(1957) = (jx(ip_CH3OOH))
  RCONST(1958) = (jx(ip_CH3OOH))
  RCONST(1959) = (jx(ip_CH3OOH))
  RCONST(1960) = (jx(ip_CH3OOH))
  RCONST(1961) = (jx(ip_CH3OOH))
  RCONST(1962) = (jx(ip_CH3OOH))
  RCONST(1963) = (jx(ip_MGLYOX)*2)
  RCONST(1964) = (jx(ip_CH3OOH))
  RCONST(1965) = (jx(ip_CH3OOH))
  RCONST(1966) = (jx(ip_CH3OOH))
  RCONST(1967) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1968) = (jx(ip_CH3OOH))
  RCONST(1969) = (jx(ip_CH3OOH)+jx(ip_MGLYOX))
  RCONST(1970) = (jx(ip_HOCH2CHO))
  RCONST(1971) = (jx(ip_CH3OOH))
  RCONST(1972) = (jx(ip_CH3OOH))
  RCONST(1973) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1974) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1975) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1976) = (2.84*j_IC3H7NO3+jx(ip_HOCH2CHO))
  RCONST(1977) = (j_IC3H7NO3)
  RCONST(1978) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1979) = (jx(ip_CH3OOH))
  RCONST(1980) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1981) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1982) = ((jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX)))
  RCONST(1983) = (jx(ip_PINAL2HCO))
  RCONST(1984) = (jx(ip_PINAL2ENOL))
  RCONST(1985) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1986) = (jx(ip_HOCH2CHO))
  RCONST(1987) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1988) = (jx(ip_CH3OOH))
  RCONST(1989) = (jx(ip_CH3OOH))
  RCONST(1990) = (jx(ip_CH3OOH))
  RCONST(1991) = (jx(ip_CH3OOH))
  RCONST(1992) = (jx(ip_CH3OOH))
  RCONST(1993) = (jx(ip_PINAL2HCO))
  RCONST(1994) = (jx(ip_PINAL2ENOL))
  RCONST(1995) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1996) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1997) = (j_IC3H7NO3+jx(ip_HOCH2CHO))
  RCONST(1998) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1999) = (j_IC3H7NO3+jx(ip_HOCH2CHO))
  RCONST(2000) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(2001) = (jx(ip_MGLYOX)+jx(ip_HOCH2CHO))
  RCONST(2002) = (jx(ip_CH3OOH))
  RCONST(2003) = (jx(ip_CH3OOH))
  RCONST(2004) = (jx(ip_CH3OOH))
  RCONST(2005) = (2.84*j_IC3H7NO3+jx(ip_CH3OOH))
  RCONST(2006) = (2.84*j_IC3H7NO3)
  RCONST(2007) = (jx(ip_Cl2))
  RCONST(2008) = (jx(ip_Cl2O2))
  RCONST(2009) = (jx(ip_OClO))
  RCONST(2010) = (jx(ip_HOCl))
  RCONST(2011) = (jx(ip_ClNO2))
  RCONST(2012) = (jx(ip_ClNO3))
  RCONST(2013) = (jx(ip_ClONO2))
  RCONST(2014) = (jx(ip_I2))
  RCONST(2015) = (jx(ip_IO))
  RCONST(2016) = (jx(ip_HOI))
  RCONST(2017) = (jx(ip_INO2))
  RCONST(2018) = (jx(ip_INO3))
  RCONST(2019) = (jx(ip_CH2I2))
  RCONST(2020) = (jx(ip_CH3I))
  RCONST(2021) = (jx(ip_C3H7I))
  RCONST(2022) = (jx(ip_CH2ClI))
  RCONST(2023) = (jx(ip_ICl))
! RCONST(2024) = constant rate coefficient
! RCONST(2025) = constant rate coefficient
! RCONST(2026) = constant rate coefficient
! RCONST(2027) = constant rate coefficient
  RCONST(2028) = ((1-ya_soan1-ya_soan2-ya_soan5)*k_MMA_OH*xgcamin)
  RCONST(2029) = (ya_soan1*k_MMA_OH)
  RCONST(2030) = (ya_soan2*k_MMA_OH)
  RCONST(2031) = (ya_soan5*k_MMA_OH)
  RCONST(2032) = (10*1.1E-12*xgcnno)
! RCONST(2033) = constant rate coefficient
  RCONST(2034) = (0.5*7.7E-12)
  RCONST(2035) = (k_H2NCHO_OH)
  RCONST(2036) = (4.0E-17*wall)
  RCONST(2037) = ((1-ya_soan1-ya_soan2-ya_soan5)*k_MEA_OH*fkoh_mea*xgcamin)
  RCONST(2038) = (ya_soan1*k_MEA_OH*fkoh_mea)
  RCONST(2039) = (ya_soan2*k_MEA_OH*fkoh_mea)
  RCONST(2040) = (ya_soan5*k_MEA_OH*fkoh_mea)
  RCONST(2041) = (k_AAC_OH)
  RCONST(2042) = (KAPNO)
  RCONST(2043) = (KRO2NO*2)
  RCONST(2044) = (k_OXA_OH)
  RCONST(2045) = (KAPNO)
  RCONST(2046) = (KRO2NO)
  RCONST(2047) = (k_RO_O2*0.25)
  RCONST(2048) = (k_DEC*0.2)
  RCONST(2049) = (k_HAC_OH)
  RCONST(2050) = (1.4E-13*xgcnno)
! RCONST(2051) = constant rate coefficient
  RCONST(2052) = (8.5E-14*xgcnno)
  RCONST(2053) = (k_NITRAMA_OH)
! RCONST(2054) = constant rate coefficient
  RCONST(2055) = ((1-ya_soan1-ya_soan2-ya_soan5)*k_DMA_OH*xgcamin)
  RCONST(2056) = (ya_soan1*k_DMA_OH)
  RCONST(2057) = (ya_soan2*k_DMA_OH)
  RCONST(2058) = (ya_soan5*k_DMA_OH)
  RCONST(2059) = (2.39E-13*xgcnno)
! RCONST(2060) = constant rate coefficient
  RCONST(2061) = (3.18E-13*xgcnno)
! RCONST(2062) = constant rate coefficient
! RCONST(2063) = constant rate coefficient
! RCONST(2064) = constant rate coefficient
  RCONST(2065) = ((1-ya_soan1-ya_soan2-ya_soan5)*k_MMI_OH)
  RCONST(2066) = (ya_soan1*k_MMI_OH)
  RCONST(2067) = (ya_soan2*k_MMI_OH)
  RCONST(2068) = (ya_soan5*k_MMI_OH)
  RCONST(2069) = ((1-ya_soan1-ya_soan2-ya_soan5)*k_TMA_OH*xgcamin)
  RCONST(2070) = (ya_soan1*k_TMA_OH)
  RCONST(2071) = (ya_soan2*k_TMA_OH)
  RCONST(2072) = (ya_soan5*k_TMA_OH)
! RCONST(2073) = constant rate coefficient
  RCONST(2074) = (2.4E-15*5)
! RCONST(2075) = constant rate coefficient
  RCONST(2076) = (1.4E-11*0.25)
! RCONST(2077) = constant rate coefficient
  RCONST(2078) = (k_HAC_OH)
  RCONST(2079) = (k_RO_O2*0.25)
  RCONST(2080) = (KAPNO)
  RCONST(2081) = (KAPNO)
  RCONST(2082) = (k_RO_O2*0.25)
  RCONST(2083) = (k_RO_O2)
  RCONST(2084) = (k_DEA_OH*xgcamin)
  RCONST(2085) = (2.39E-13*xgcnno)
! RCONST(2086) = constant rate coefficient
  RCONST(2087) = (3.18E-13*xgcnno)
! RCONST(2088) = constant rate coefficient
! RCONST(2089) = constant rate coefficient
! RCONST(2090) = constant rate coefficient
  RCONST(2091) = (k_MMI_OH)
  RCONST(2092) = ((1-ya_soan1-ya_soan2-ya_soan5)*k_AMP_OH*fkoh_mea)
  RCONST(2093) = (ya_soan1*k_AMP_OH*fkoh_mea)
  RCONST(2094) = (ya_soan2*k_AMP_OH*fkoh_mea)
  RCONST(2095) = (ya_soan5*k_AMP_OH*fkoh_mea)
  RCONST(2096) = (0.26*3.18E-13)
! RCONST(2097) = constant rate coefficient
! RCONST(2098) = constant rate coefficient
  RCONST(2099) = (k_AAC_OH)
  RCONST(2100) = (KAPNO)
  RCONST(2101) = (k_CH3CO3_NO2)
  RCONST(2102) = (k_PAN_M)
  RCONST(2103) = (k_RO_O2*0.25)
  RCONST(2104) = (k_DEC*0.2)
  RCONST(2105) = (k_NITRAMA_OH)
  RCONST(2106) = (k_AMP_NO3)
! RCONST(2107) = constant rate coefficient
  RCONST(2108) = (k_TEA_OH*xgcamin)
! RCONST(2109) = constant rate coefficient
  RCONST(2110) = (2.4E-15*5)
! RCONST(2111) = constant rate coefficient
! RCONST(2112) = constant rate coefficient
! RCONST(2113) = constant rate coefficient
! RCONST(2114) = constant rate coefficient
  RCONST(2115) = (3.03E-15*EXP(-294./temp))
! RCONST(2116) = constant rate coefficient
  RCONST(2117) = (KRO2NO)
  RCONST(2118) = (2.88E-17*temp*temp*exp(309./temp))
  RCONST(2119) = (9.20E-14*RO2)
  RCONST(2120) = (0.770*KRO2HO2(6))
  RCONST(2121) = (KRO2NO)
  RCONST(2122) = (k_RO_O2)
  RCONST(2123) = (ya_soan1*KRO2HO2(10)*rchohch2o2_oh)
  RCONST(2124) = (ya_soan2*KRO2HO2(10)*rchohch2o2_oh)
  RCONST(2125) = (ya_soan1*KRO2HO2(10)*rcoch2o2_oh)
  RCONST(2126) = (ya_soan2*KRO2HO2(10)*rcoch2o2_oh)
  RCONST(2127) = (ya_soan1*KRO2HO2(10)*rcoch2o2_oh)
  RCONST(2128) = (ya_soan2*KRO2HO2(10)*rcoch2o2_oh)
  RCONST(2129) = ((1-ya_soan1-ya_soan2)*KRO2HO2(10))
  RCONST(2130) = (ya_soan1*KRO2HO2(10))
  RCONST(2131) = (ya_soan2*KRO2HO2(10))
! RCONST(2132) = constant rate coefficient
! RCONST(2133) = constant rate coefficient
! RCONST(2134) = constant rate coefficient
! RCONST(2135) = constant rate coefficient
! RCONST(2136) = constant rate coefficient
! RCONST(2137) = constant rate coefficient
! RCONST(2138) = constant rate coefficient
! RCONST(2139) = constant rate coefficient
! RCONST(2140) = constant rate coefficient
! RCONST(2141) = constant rate coefficient
! RCONST(2142) = constant rate coefficient
  RCONST(2143) = (1.3E-12*exp(-330/temp))
! RCONST(2144) = constant rate coefficient
! RCONST(2145) = constant rate coefficient
! RCONST(2146) = constant rate coefficient
! RCONST(2147) = constant rate coefficient
! RCONST(2148) = constant rate coefficient
! RCONST(2149) = constant rate coefficient
! RCONST(2150) = constant rate coefficient
! RCONST(2151) = constant rate coefficient
! RCONST(2152) = constant rate coefficient
! RCONST(2153) = constant rate coefficient
! RCONST(2154) = constant rate coefficient
! RCONST(2155) = constant rate coefficient
! RCONST(2156) = constant rate coefficient
  RCONST(2157) = (1.36E-12*EXP(374./temp))
  RCONST(2158) = (2.8E-11*EXP(240./temp))
! RCONST(2159) = constant rate coefficient
! RCONST(2160) = constant rate coefficient
! RCONST(2161) = constant rate coefficient
! RCONST(2162) = constant rate coefficient
! RCONST(2163) = constant rate coefficient
! RCONST(2164) = constant rate coefficient
! RCONST(2165) = constant rate coefficient
! RCONST(2166) = constant rate coefficient
! RCONST(2167) = constant rate coefficient
! RCONST(2168) = constant rate coefficient
! RCONST(2169) = constant rate coefficient
! RCONST(2170) = constant rate coefficient
! RCONST(2171) = constant rate coefficient
! RCONST(2172) = constant rate coefficient
! RCONST(2173) = constant rate coefficient
! RCONST(2174) = constant rate coefficient
! RCONST(2175) = constant rate coefficient
! RCONST(2176) = constant rate coefficient
  RCONST(2177) = (k_MSIA_OH)
! RCONST(2178) = constant rate coefficient
! RCONST(2179) = constant rate coefficient
! RCONST(2180) = constant rate coefficient
! RCONST(2181) = constant rate coefficient
! RCONST(2182) = constant rate coefficient
! RCONST(2183) = constant rate coefficient
! RCONST(2184) = constant rate coefficient
  RCONST(2185) = (k_CH3SO3_dec)
! RCONST(2186) = constant rate coefficient
! RCONST(2187) = constant rate coefficient
! RCONST(2188) = constant rate coefficient
! RCONST(2189) = constant rate coefficient
! RCONST(2190) = constant rate coefficient
! RCONST(2191) = constant rate coefficient
! RCONST(2192) = constant rate coefficient
! RCONST(2193) = constant rate coefficient
! RCONST(2194) = constant rate coefficient
! RCONST(2195) = constant rate coefficient
! RCONST(2196) = constant rate coefficient
  RCONST(2197) = (k_DMSO2_OH)
! RCONST(2198) = constant rate coefficient
! RCONST(2199) = constant rate coefficient
! RCONST(2200) = constant rate coefficient
! RCONST(2201) = constant rate coefficient
  RCONST(2202) = (5.53E08*EXP(-669.71/temp))
! RCONST(2203) = constant rate coefficient
  RCONST(2204) = (30.9*EXP(-4118.74/temp))
  RCONST(2205) = (9.96E08*EXP(-736.69/temp))
! RCONST(2206) = constant rate coefficient
! RCONST(2207) = constant rate coefficient
  RCONST(2208) = (5.29*EXP(-4487.08/temp))
  RCONST(2209) = (7.91E06*EXP(-1674.28/temp))
! RCONST(2210) = constant rate coefficient
  RCONST(2211) = (jx(ip_CH3CHO))
  RCONST(2212) = (jx(ip_CH3CHO))
  RCONST(2213) = (0.33*jx(ip_NO2))
  RCONST(2214) = (0.25*jx(ip_NO2))
  RCONST(2215) = (0.08*jx(ip_NO2))
  RCONST(2216) = (0.33*jx(ip_NO2))
  RCONST(2217) = (0.34*jx(ip_NO2))
  RCONST(2218) = (jx(ip_CH3CHO))
  RCONST(2219) = (jx(ip_CH3CHO))
  RCONST(2220) = (0.42*jx(ip_CHOH))
  RCONST(2221) = (xaer(01)*1.5E9*cvfac(01))
  RCONST(2222) = (xaer(01)*1.E10*cvfac(01))
  RCONST(2223) = (xaer(01)*5.5E9*cvfac(01))
  RCONST(2224) = (xaer(01)*k_arr(1.E8,-900.,temp)*cvfac(01))
  RCONST(2225) = (xaer(01)*7.1E9*cvfac(01))
  RCONST(2226) = (xaer(01)*k_arr(9.7E5,-2500.,temp)*cvfac(01))
  RCONST(2227) = (xaer(01)*k_arr(2.7E7,-1684.,temp)*cvfac(01))
  RCONST(2228) = (xaer(01)*k_arr(5.E5,-6950.,temp)*cvfac(01))
  RCONST(2229) = (xaer(01)*1.E8*cvfac(01))
  RCONST(2230) = (xaer(01)*8.E-1)
  RCONST(2231) = (xaer(01)*1.8E9*cvfac(01))
  RCONST(2232) = (xaer(01)*1.E10*cvfac(01))
  RCONST(2233) = (xaer(01)*k_arr(8.2E7,-2700.,temp)*cvfac(01))
  RCONST(2234) = (xaer(01)*1.E10*cvfac(01))
  RCONST(2235) = (xaer(01)*k_limited(k_arr(4.6E3,-6800.,temp),c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2236) = (xaer(01)*6.5E8*cvfac(01))
  RCONST(2237) = (xaer(01)*4.3E5*cvfac(01))
  RCONST(2238) = (xaer(01)*1.5E5*cvfac(01))
  RCONST(2239) = (xaer(01)*k_arr(3.1E9,-1240.,temp)*cvfac(01))
  RCONST(2240) = (xaer(01)*8.5E6*cvfac(01))
  RCONST(2241) = (xaer(01)*k_arr(7.7E8,-1020.,temp)*cvfac(01))
  RCONST(2242) = (xaer(01)*k_arr(1.1E8,-991.,temp)*cvfac(01))
  RCONST(2243) = (xaer(01)*5.E7*cvfac(01))
  RCONST(2244) = (xaer(01)*4.3E5*cvfac(01))
  RCONST(2245) = (xaer(01)*9.7E8*cvfac(01))
  RCONST(2246) = (xaer(01)*k_arr(2.7E7,-1715.,temp)*cvfac(01))
  RCONST(2247) = (xaer(01)*k_arr(1.1E7,-1715.,temp)*cvfac(01))
  RCONST(2248) = (xaer(01)*8.8E7*cvfac(01))
  RCONST(2249) = (xaer(01)*3.5E9*cvfac(01))
  RCONST(2250) = (xaer(01)*3.E-3*cvfac(01))
  RCONST(2251) = (xaer(01)*1.E9*cvfac(01))
  RCONST(2252) = (xaer(01)*1.E9*cvfac(01))
  RCONST(2253) = (xaer(01)*1.8E5*cvfac(01))
  RCONST(2254) = (xaer(01)*k_arr(2.7E7,-1684.,temp)*cvfac(01))
  RCONST(2255) = (xaer(01)*4.2E9*cvfac(01))
  RCONST(2256) = (xaer(01)*1.E9*cvfac(01))
  RCONST(2257) = (xaer(01)*k_arr(21.8,-8012.,temp))
  RCONST(2258) = (xaer(01)*1.3E10*cvfac(01))
  RCONST(2259) = (xaer(01)*7.5E6*cvfac(01))
  RCONST(2260) = (xaer(01)*7.5E6*cvfac(01))
  RCONST(2261) = (xaer(01)*k_limited(k_arr(2.2E4,-3508.,temp),c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2262) = (xaer(01)*6.0E9)
  RCONST(2263) = (xaer(01)*2.4E10*cvfac(01))
  RCONST(2264) = (xaer(01)*1.E8*cvfac(01))
  RCONST(2265) = (xaer(01)*3.4E8*cvfac(01))
  RCONST(2266) = (xaer(01)*6.E7*cvfac(01))
  RCONST(2267) = (xaer(01)*5.E4*cvfac(01))
  RCONST(2268) = (xaer(01)*k_arr(4.2E9,-9311.,temp)*cvfac(01))
  RCONST(2269) = (xaer(01)*1.5E9*cvfac(01))
  RCONST(2270) = (xaer(01)*6.E1*cvfac(01))
  RCONST(2271) = (xaer(01)*6.E2*cvfac(01))
  RCONST(2272) = (xaer(01)*k_limited(4.4E12_dp,c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2273) = (xaer(01)*k_limited(2.E10_dp,c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2274) = (xaer(01)*2.4E6)
  RCONST(2275) = (xaer(01)*k_limited(3.5E11_dp,c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2276) = (xaer(01)*1.5E3*cvfac(01))
  RCONST(2277) = (xaer(01)*k_limited(2.9E10_dp,c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2278) = (xaer(01)*1.E6*cvfac(01))
  RCONST(2279) = (xaer(01)*5.E5*cvfac(01))
  RCONST(2280) = (xaer(01)*1.1E9*cvfac(01))
  RCONST(2281) = (xaer(01)*1.5E9*cvfac(01))
  RCONST(2282) = (xaer(01)*k_arr(1.5E9,-5300.,temp)*cvfac(01))
  RCONST(2283) = (xaer(01)*3.5E9*cvfac(01))
  RCONST(2284) = (xaer(01)*4.6E8*cvfac(01))
  RCONST(2285) = (xaer(01)*2.3E8*cvfac(01))
  RCONST(2286) = (xaer(01)*1.3E7*cvfac(01))
  RCONST(2287) = (xaer(01)*1.E8*cvfac(01))
  RCONST(2288) = (xaer(01)*5.5E9*cvfac(01))
  RCONST(2289) = (xaer(01)*1.E9*cvfac(01))
  RCONST(2290) = (xaer(01)*3.5E9*cvfac(01))
  RCONST(2291) = (xaer(01)*k_arr(1.1E1,-1110.,temp)*cvfac(01))
  RCONST(2292) = (xaer(01)*1.2E7*cvfac(01))
  RCONST(2293) = (xaer(01)*3.E3*cvfac(01))
  RCONST(2294) = (xaer(01)*k_arr(3.7E5,-5500.,temp)*cvfac(01))
  RCONST(2295) = (xaer(01)*4.5E9*cvfac(01))
  RCONST(2296) = (xaer(01)*3.E3*cvfac(01))
  RCONST(2297) = (xaer(01)*k_SIV_H2O2(5.2E6,-3650.,C(ind_Hp_a01)*cvfac(01),temp)*cvfac(01))
  RCONST(2298) = (xaer(01)*8.E8*cvfac(01))
  RCONST(2299) = (xaer(01)*1.E5*cvfac(01))
  RCONST(2300) = (xaer(01)*k_limited(7.1E6_dp,c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2301) = (xaer(01)*5.E4*cvfac(01))
  RCONST(2302) = (xaer(01)*1.E5*cvfac(01))
  RCONST(2303) = (xaer(01)*k_arr(1.4E9,-2000.,temp)*cvfac(01))
  RCONST(2304) = (xaer(01)*3.1E5*cvfac(01))
  RCONST(2305) = (xaer(01)*1.4E4*cvfac(01))
  RCONST(2306) = (xaer(01)*k_limited(k_arr(1.6E7,-3800.,temp),c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2307) = (xaer(01)*4.3E-1*cvfac(01))
  RCONST(2308) = (xaer(01)*k_limited(k_arr(1.6E7,-3800.,temp),c(ind_Hp_a01)*cvfac(01))*cvfac(01)*cvfac(01))
  RCONST(2309) = (xaer(01)*3.6E3*cvfac(01))
  RCONST(2310) = (xaer(01)*6.2E7*cvfac(01))
  RCONST(2311) = (xaer(01)*7.6E8*cvfac(01))
  RCONST(2312) = (xaer(01)*2.5E8*cvfac(01))
  RCONST(2313) = (xaer(01)*2.1E8*cvfac(01))
  RCONST(2314) = (xaer(01)*k_arr(4.7E8,-1082.,temp)*cvfac(01))
  RCONST(2315) = (xaer(01)*7.6E8*cvfac(01))
  RCONST(2316) = (xaer(01)*k_arr(1.8E-3,-7352.,temp)*cvfac(01))
  RCONST(2317) = (xaer(01)*1.7E9*cvfac(01))
  RCONST(2318) = (xaer(01)*1E7*cvfac(01))
  RCONST(2319) = (xaer(01)*5E7*cvfac(01))
  RCONST(2320) = (xaer(01)*8.2E5*cvfac(01))
  RCONST(2321) = (xaer(01)*2.7E8*cvfac(01))
  RCONST(2322) = (xaer(01)*2.7E8*cvfac(01))
  RCONST(2323) = (xaer(01)*5.5E1*cvfac(01))
  RCONST(2324) = (xaer(01)*5.9E6*cvfac(01))
  RCONST(2325) = (xaer(01)*2.3E-3)
  RCONST(2326) = (xaer(01)*2.3E-3)
  RCONST(2327) = (xaer(01)*1.2E6*cvfac(01))
  RCONST(2328) = (xaer(01)*1.5E8*cvfac(01))
  RCONST(2329) = (xaer(01)*1.5E8*cvfac(01))
  RCONST(2330) = (xaer(01)*1.0E7*cvfac(01))
  RCONST(2331) = (xaer(01)*4.3E8*cvfac(01))
  RCONST(2332) = (xaer(01)*1.0E4*cvfac(01))
  RCONST(2333) = (xaer(01)*1.3E-2)
  RCONST(2334) = (xaer(01)*2.0E6*cvfac(01))
  RCONST(2335) = (xaer(01)*1.0E7*cvfac(01))
  RCONST(2336) = (xaer(01)*1.4E5*cvfac(01))
  RCONST(2337) = (xaer(01)*1.8E4*cvfac(01))
  RCONST(2338) = (xaer(01)*2.0*cvfac(01))
  RCONST(2339) = (xaer(01)*0.49)
  RCONST(2340) = (xaer(01)*1.1E4*cvfac(01))
  RCONST(2341) = (xaer(01)*8.0E6*cvfac(01))
  RCONST(2342) = (xaer(01)*5.9E9*cvfac(01))
  RCONST(2343) = (xaer(01)*1E7*cvfac(01))
  RCONST(2344) = (xaer(01)*4.E6*cvfac(01))
  RCONST(2345) = (xaer(01)*1.2E6*cvfac(01))
  RCONST(2346) = (xaer(01)*1E7*cvfac(01))
  RCONST(2347) = (xaer(01)*2E4*cvfac(01))
  RCONST(2348) = (xaer(01)*2E4*cvfac(01))
  RCONST(2349) = (xaer(01)*5E7*cvfac(01))
  RCONST(2350) = (xaer(01)*5E7*cvfac(01))
  RCONST(2351) = (xaer(01)*1E2*cvfac(01))
  RCONST(2352) = (xaer(01)*4.5E5*cvfac(01))
  RCONST(2353) = (xaer(01)*2.5E5*cvfac(01))
  RCONST(2354) = (xaer(01)*30*cvfac(01))
  RCONST(2355) = (xaer(01)*8E5*cvfac(01))
  RCONST(2356) = (xaer(01)*3.0E4*cvfac(01))
  RCONST(2357) = (xaer(01)*3.6E7*cvfac(01))
  RCONST(2358) = (xaer(01)*3E7*cvfac(01))
  RCONST(2359) = (xaer(01)*2.16E6*cvfac(01))
  RCONST(2360) = (k_exf(01,ind_O2))
  RCONST(2361) = (k_exb(01,ind_O2))
  RCONST(2362) = (k_exf(01,ind_O3))
  RCONST(2363) = (k_exb(01,ind_O3))
  RCONST(2364) = (k_exf(01,ind_OH))
  RCONST(2365) = (k_exb(01,ind_OH))
  RCONST(2366) = (k_exf(01,ind_HO2))
  RCONST(2367) = (k_exb(01,ind_HO2))
  RCONST(2368) = (k_exf(01,ind_H2O2))
  RCONST(2369) = (k_exb(01,ind_H2O2))
  RCONST(2370) = (k_exf(01,ind_NO2))
  RCONST(2371) = (k_exb(01,ind_NO2))
  RCONST(2372) = (k_exf(01,ind_NO3))
  RCONST(2373) = (k_exb(01,ind_NO3))
  RCONST(2374) = (k_exf(01,ind_NH3))
  RCONST(2375) = (k_exb(01,ind_NH3))
  RCONST(2376) = (k_exf_N2O5(01)*C(ind_H2O_a01))
  RCONST(2377) = (k_exf(01,ind_HONO))
  RCONST(2378) = (k_exb(01,ind_HONO))
  RCONST(2379) = (k_exf(01,ind_HNO3))
  RCONST(2380) = (k_exb(01,ind_HNO3))
  RCONST(2381) = (k_exf(01,ind_HNO4))
  RCONST(2382) = (k_exb(01,ind_HNO4))
  RCONST(2383) = (k_exf(01,ind_CO2))
  RCONST(2384) = (k_exb(01,ind_CO2))
  RCONST(2385) = (k_exf(01,ind_HCHO))
  RCONST(2386) = (k_exb(01,ind_HCHO))
  RCONST(2387) = (k_exf(01,ind_CH3O2))
  RCONST(2388) = (k_exb(01,ind_CH3O2))
  RCONST(2389) = (k_exf(01,ind_HCOOH))
  RCONST(2390) = (k_exb(01,ind_HCOOH))
  RCONST(2391) = (k_exf(01,ind_CH3OOH))
  RCONST(2392) = (k_exb(01,ind_CH3OOH))
  RCONST(2393) = (k_exf(01,ind_Cl2))
  RCONST(2394) = (k_exb(01,ind_Cl2))
  RCONST(2395) = (k_exf(01,ind_HCl))
  RCONST(2396) = (k_exb(01,ind_HCl))
  RCONST(2397) = (k_exf(01,ind_HOCl))
  RCONST(2398) = (k_exb(01,ind_HOCl))
  RCONST(2399) = (k_exf_N2O5(01)*5.E2)
  RCONST(2400) = (k_exf_ClNO3(01)*C(ind_H2O_a01))
  RCONST(2401) = (k_exf_ClNO3(01)*5.E2)
  RCONST(2402) = (k_exf(01,ind_I2))
  RCONST(2403) = (k_exb(01,ind_I2))
  RCONST(2404) = (k_exf(01,ind_IO))
  RCONST(2405) = (k_exb(01,ind_IO))
  RCONST(2406) = (k_exf(01,ind_OIO))
  RCONST(2407) = (k_exf(01,ind_I2O2))
  RCONST(2408) = (k_exf(01,ind_HOI))
  RCONST(2409) = (k_exb(01,ind_HOI))
  RCONST(2410) = (k_exf(01,ind_HI))
  RCONST(2411) = (k_exf(01,ind_HIO3))
  RCONST(2412) = (k_exf(01,ind_INO2))
  RCONST(2413) = (k_exf(01,ind_INO3))
  RCONST(2414) = (k_exf(01,ind_ICl))
  RCONST(2415) = (k_exb(01,ind_ICl))
  RCONST(2416) = (xnom7so2*k_exf(01,ind_SO2))
  RCONST(2417) = (xnom7so2*k_exb(01,ind_SO2))
  RCONST(2418) = (xnom7sulf*k_exf(01,ind_H2SO4))
  RCONST(2419) = (xnom7dmso*k_exf(01,ind_DMSO))
  RCONST(2420) = (xnom7dmso*k_exb(01,ind_DMSO))
  RCONST(2421) = (xnom7dmso*k_exf(01,ind_CH3SO3H))
  RCONST(2422) = (xnom7dmso*k_exf(01,ind_DMS))
  RCONST(2423) = (xnom7dmso*k_exb(01,ind_DMS))
  RCONST(2424) = (xaer(01)*1.6E-1*testfac_HO2)
  RCONST(2425) = (xaer(01)*1.E4*cvfac(01)*testfac_HO2)
  RCONST(2426) = (xaer(01)*testfac_H2O*k_arr(1.8E-8,-6716.,temp))
  RCONST(2427) = (xaer(01)*testfac_H2O*1.E8*cvfac(01))
  RCONST(2428) = (xaer(01)*testfac_NH3*k_arr(5.87647E-7,-2391.,temp))
  RCONST(2429) = (xaer(01)*testfac_NH3*1.E3*cvfac(01))
  RCONST(2430) = (xaer(01)*k_arr(5.1E1,-1260.,temp)*testfac_HONO)
  RCONST(2431) = (xaer(01)*1.E5*cvfac(01)*testfac_HONO)
  RCONST(2432) = (xaer(01)*testfac_HNO3*k_arr(1.54E-2,8700.,temp))
  RCONST(2433) = (xaer(01)*testfac_HNO3*1.E-3*cvfac(01))
  RCONST(2434) = (xaer(01)*2.E-1*testfac_HNO4)
  RCONST(2435) = (xaer(01)*2.E4*cvfac(01)*testfac_HNO4)
  RCONST(2436) = (xaer(01)*testfac_CO2*k_arr(4.3E-4,-913.,temp))
  RCONST(2437) = (xaer(01)*testfac_CO2*1.E3*cvfac(01))
  RCONST(2438) = (xaer(01)*testfac_HCOOH*1.8E-4)
  RCONST(2439) = (xaer(01)*testfac_HCOOH*1.E0*cvfac(01))
  RCONST(2440) = (xaer(01)*5.7E4)
  RCONST(2441) = (xaer(01)*7.8E9*cvfac(01))
  RCONST(2442) = (xaer(01)*testfac_HCl*k_arr(1.7E5,6896.,temp))
  RCONST(2443) = (xaer(01)*testfac_HCl*1.E-1*cvfac(01))
  RCONST(2444) = (xaer(01)*3.2E-2*testfac_HOCl)
  RCONST(2445) = (xaer(01)*1.E6*cvfac(01)*testfac_HOCl)
  RCONST(2446) = (xaer(01)*1.E-3*cvfac(01)*testfac_ICl)
  RCONST(2447) = (xaer(01)*1.3E-5*testfac_ICl)
  RCONST(2448) = (xaer(01)*testfac_SO2*k_arr(1.7E1,2090.E0,temp))
  RCONST(2449) = (xaer(01)*testfac_SO2*1.E3*cvfac(01))
  RCONST(2450) = (xaer(01)*testfac_HSO3m*k_arr(6.E-2,1120.E0,temp))
  RCONST(2451) = (xaer(01)*testfac_HSO3m*1.E6*cvfac(01))
  RCONST(2452) = (xaer(01)*testfac_HSO4m*k_arr(1.02E-7,2720.E0,temp))
  RCONST(2453) = (xaer(01)*testfac_HSO4m*1.E-5*cvfac(01))
  RCONST(2454) = (xaer(01)*1.E6*testfac_H2SO4)
  RCONST(2455) = (xaer(01)*1.E3*cvfac(01)*testfac_H2SO4)
  RCONST(2456) = (xaer(01)*2.34E7)
  RCONST(2457) = (xaer(01)*1E10*cvfac(01))
  RCONST(2458) = (xaer(01)*2E6)
  RCONST(2459) = (xaer(01)*1E10*cvfac(01))
  RCONST(2460) = (xaer(01)*3.1E7*cvfac(01))
  RCONST(2461) = (xaer(01)*1E10*cvfac(01))
  RCONST(2462) = (xaer(01)*2E6*cvfac(01))
  RCONST(2463) = (xaer(01)*1E10*cvfac(01))
  RCONST(2464) = (xaer(01)*6.61E10*cvfac(01))
  RCONST(2465) = (xaer(01)*1E10)
  RCONST(2466) = (xaer(01)*1E10*cvfac(01))
  RCONST(2467) = (xaer(01)*6.3E9)
  RCONST(2468) = (xaer(01)*1.2E8*cvfac(01))
  RCONST(2469) = (xaer(01)*1E6)
  RCONST(2470) = (xaer(01)*8.25E8*cvfac(01))
  RCONST(2471) = (xaer(01)*1E6)
  RCONST(2472) = (xaer(01)*3.0E6*cvfac(01))
  RCONST(2473) = (xaer(01)*0.19)
  RCONST(2474) = (xaer(01)*4.51E-3*0.312)
  RCONST(2475) = (xaer(01)*5.77E-3*0.255)
  RCONST(2476) = (xaer(01)*6.43E-3*7.9E-3)
! RCONST(2477) = constant rate coefficient
  RCONST(2478) = (xaer(01)*6.4E6*cvfac(01))
  RCONST(2479) = (xaer(01)*4.5E8*cvfac(01))
  RCONST(2480) = (xaer(01)*1.1E9*cvfac(01))
  RCONST(2481) = (xaer(01)*1.0E8*cvfac(01))
  RCONST(2482) = (xaer(01)*4.5E9*cvfac(01))
  RCONST(2483) = (xaer(01)*1.0E3*cvfac(01))
  RCONST(2484) = (xaer(01)*1.6E3*cvfac(01))
  RCONST(2485) = (xaer(01)*1.E10*cvfac(01))
  RCONST(2486) = (xaer(01)*5.6*cvfac(01))
  RCONST(2487) = (xaer(01)*k_arr(1.7E8,-2200.,temp)*cvfac(01))
  RCONST(2488) = (xaer(01)*1.0E9*cvfac(01))
  RCONST(2489) = (xaer(01)*k_arr(6.0E6,-1715.,temp)*cvfac(01))
  RCONST(2490) = (xaer(01)*1.0E9*cvfac(01))
  RCONST(2491) = (xaer(01)*4.0E7*cvfac(01)*xaqcamin)
  RCONST(2492) = (xaer(01)*6.9E9*cvfac(01)*xaqcamin)
  RCONST(2493) = (xaer(01)*3.5E9*cvfac(01))
  RCONST(2494) = (xaer(01)*4.0*cvfac(01))
  RCONST(2495) = (xaer(01)*2.0E9*cvfac(01))
  RCONST(2496) = (xaer(01)*2.0E9*cvfac(01))
  RCONST(2497) = (xaer(01)*1.1E8*cvfac(01)*xaqcamin)
  RCONST(2498) = (xaer(01)*7.83E-4*cvfac(01))
  RCONST(2499) = (xaer(01)*3.7E8*cvfac(01))
  RCONST(2500) = (xaer(01)*5.44E8*cvfac(01)*xaqcnno)
  RCONST(2501) = (xaer(01)*k_arr(1.1E9,-1516.,temp)*cvfac(01))
  RCONST(2502) = (xaer(01)*k_arr(3.6E8,-1000.,temp)*cvfac(01))
  RCONST(2503) = (xaer(01)*k_arr(2.9E9,-4300.,temp)*cvfac(01))
  RCONST(2504) = (xaer(01)*1.2E9*cvfac(01))
  RCONST(2505) = (xaer(01)*1.2E9*cvfac(01))
  RCONST(2506) = (xaer(01)*k_arr(1.6E8,-4300.,temp)*cvfac(01))
  RCONST(2507) = (xaer(01)*k_arr(1.9E8,-2800.,temp)*cvfac(01))
  RCONST(2508) = (xaer(01)*1.4E6*cvfac(01))
  RCONST(2509) = (xaer(01)*k_arr(1.0E8,-1800.,temp)*cvfac(01))
  RCONST(2510) = (xaer(01)*k_arr(1.5E7,-1330.,temp)*cvfac(01))
  RCONST(2511) = (xaer(01)*4.29E7*cvfac(01)*xaqcamin)
  RCONST(2512) = (xaer(01)*4.0E7*cvfac(01)*xaqcamin)
  RCONST(2513) = (xaer(01)*0.1*cvfac(01)*xaqcamin)
  RCONST(2514) = (xaer(01)*0.1*cvfac(01)*xaqcamin)
  RCONST(2515) = (xaer(01)*1.0E4*cvfac(01))
  RCONST(2516) = (xaer(01)*8.9E9*cvfac(01)*xaqcamin)
  RCONST(2517) = (xaer(01)*3.5E9*cvfac(01))
  RCONST(2518) = (xaer(01)*4.0*cvfac(01))
  RCONST(2519) = (xaer(01)*2.0E9*cvfac(01))
  RCONST(2520) = (xaer(01)*2.0E9*cvfac(01))
  RCONST(2521) = (xaer(01)*6.0E7*cvfac(01)*xaqcamin)
  RCONST(2522) = (xaer(01)*4.0E7*cvfac(01)*xaqcamin)
  RCONST(2523) = (xaer(01)*2.9E9*cvfac(01)*xaqcamin)
  RCONST(2524) = (xaer(01)*1.0E9*cvfac(01))
  RCONST(2525) = (xaer(01)*3.0E8*cvfac(01)*xaqcamin)
  RCONST(2526) = (xaer(01)*1.9E8*cvfac(01))
  RCONST(2527) = (xaer(01)*1.2E9*cvfac(01))
  RCONST(2528) = (xaer(01)*4.5E8*cvfac(01)*xaqcnno)
  RCONST(2529) = (xaer(01)*5.44E8*cvfac(01)*xaqcnno)
  RCONST(2530) = (xaer(01)*4.5E8*cvfac(01)*xaqcnno)
  RCONST(2531) = (xaer(01)*5.44E8*cvfac(01)*xaqcnno)
  RCONST(2532) = (xaer(01)*7.83E-4*cvfac(01))
  RCONST(2533) = (xaer(01)*k_arr(1.1E9,-1600.,temp)*cvfac(01))
  RCONST(2534) = (xaer(01)*7.0E8*cvfac(01))
  RCONST(2535) = (xaer(01)*1.2E8*cvfac(01))
  RCONST(2536) = (xaer(01)*4.1E8*cvfac(01))
  RCONST(2537) = (xaer(01)*5.0E7*cvfac(01))
  RCONST(2538) = (xaer(01)*4.0E7*cvfac(01)*xaqcamin)
  RCONST(2539) = (xaer(01)*4.0E7*cvfac(01)*xaqcamin)
  RCONST(2540) = (xaer(01)*1.2E10*cvfac(01)*xaqcamin)
  RCONST(2541) = (xaer(01)*3.5E9*cvfac(01))
  RCONST(2542) = (xaer(01)*4.0*cvfac(01))
  RCONST(2543) = (xaer(01)*2.0E9*cvfac(01))
  RCONST(2544) = (xaer(01)*2.0E9*cvfac(01))
  RCONST(2545) = (xaer(01)*4.0E8*cvfac(01)*xaqcamin)
  RCONST(2546) = (xaer(01)*1.7E9*cvfac(01))
  RCONST(2547) = (xaer(01)*5.0E7*cvfac(01))
  RCONST(2548) = (xaer(01)*1.0E7*cvfac(01)*xaqcamin)
  RCONST(2549) = (xaer(01)*4.0E7*cvfac(01)*xaqcamin)
  RCONST(2550) = (xaer(01)*0.1*cvfac(01)*xaqcamin)
  RCONST(2551) = (xaer(01)*0.1*cvfac(01)*xaqcamin)
  RCONST(2552) = (xaer(01)*0.0*cvfac(01))
  RCONST(2553) = (xaer(01)*8.0E9*cvfac(01)*xaqcamin)
  RCONST(2554) = (xaer(01)*1.0E9*cvfac(01))
  RCONST(2555) = (xaer(01)*4.5E8*cvfac(01)*xaqcamin)
  RCONST(2556) = (xaer(01)*6.99E8*cvfac(01)*xaqcnno)
  RCONST(2557) = (xaer(01)*8.67E8*cvfac(01)*xaqcnno)
  RCONST(2558) = (xaer(01)*1.0E7*cvfac(01))
  RCONST(2559) = (xaer(01)*1.0E7*cvfac(01))
  RCONST(2560) = (xaer(01)*2.0E10*cvfac(01)*xaqcamin)
  RCONST(2561) = (xaer(01)*3.18E9*cvfac(01))
  RCONST(2562) = (xaer(01)*3.0E6*cvfac(01))
  RCONST(2563) = (xaer(01)*2.0E9*cvfac(01))
  RCONST(2564) = (xaer(01)*2.0E9*cvfac(01)*xaqcamin)
  RCONST(2565) = (xaer(01)*2.9E5*cvfac(01)*xaqcamin)
  RCONST(2566) = (xaer(01)*4.0E7*cvfac(01)*xaqcamin)
  RCONST(2567) = (xaer(01)*k_arr(0.436,-2990.,temp)*cvfac(01))
  RCONST(2568) = (xaer(01)*1.22E-7*cvfac(01))
  RCONST(2569) = (xaer(01)*k_arr(3.8E-6,-5530.,temp)*cvfac(01))
  RCONST(2570) = (xaer(01)*k_arr(1.36E5,-2450.,temp)*cvfac(01))
  RCONST(2571) = (xaer(01)*3.0E8*cvfac(01))
  RCONST(2572) = (xnom7nox*k_exf(01,ind_N2O3))
  RCONST(2573) = (xnom7nox*k_exb(01,ind_N2O3))
  RCONST(2574) = (xnom7nox*k_exf(01,ind_N2O4))
  RCONST(2575) = (xnom7nox*k_exb(01,ind_N2O4))
  RCONST(2576) = (xnom7amin*k_exf(01,ind_MMA))
  RCONST(2577) = (xnom7amin*k_exb(01,ind_MMA))
  RCONST(2578) = (xnom7nno*k_exf(01,ind_MMNNO2))
  RCONST(2579) = (xnom7nno*k_exb(01,ind_MMNNO2))
  RCONST(2580) = (xnom7amin*k_exf(01,ind_HNCO))
  RCONST(2581) = (xnom7amin*k_exb(01,ind_HNCO))
  RCONST(2582) = (xnom7amin*k_exf(01,ind_H2NCHO))
  RCONST(2583) = (xnom7amin*k_exb(01,ind_H2NCHO))
  RCONST(2584) = (xnom7co2*k_exf(01,ind_HOCH2CHO))
  RCONST(2585) = (xnom7co2*k_exb(01,ind_HOCH2CHO))
  RCONST(2586) = (xnom7co2*k_exf(01,ind_HOCH2CO2H))
  RCONST(2587) = (xnom7co2*k_exb(01,ind_HOCH2CO2H))
  RCONST(2588) = (xnom7co2*k_exf(01,ind_HCOCO2H))
  RCONST(2589) = (xnom7co2*k_exb(01,ind_HCOCO2H))
  RCONST(2590) = (xnom7co2*k_exf(01,ind_GLYOX))
  RCONST(2591) = (xnom7co2*k_exb(01,ind_GLYOX))
  RCONST(2592) = (xnom7amin*k_exf(01,ind_DMA))
  RCONST(2593) = (xnom7amin*k_exb(01,ind_DMA))
  RCONST(2594) = (xnom7amin*k_exf(01,ind_MEA))
  RCONST(2595) = (xnom7amin*k_exb(01,ind_MEA))
  RCONST(2596) = (xnom7nno*k_exf(01,ind_MEANNO))
  RCONST(2597) = (xnom7nno*k_exb(01,ind_MEANNO))
  RCONST(2598) = (xnom7nno*k_exf(01,ind_MEANNO2))
  RCONST(2599) = (xnom7nno*k_exb(01,ind_MEANNO2))
  RCONST(2600) = (xnom7nno*k_exf(01,ind_NDMA))
  RCONST(2601) = (xnom7nno*k_exb(01,ind_NDMA))
  RCONST(2602) = (xnom7nno*k_exf(01,ind_DMNNO2))
  RCONST(2603) = (xnom7nno*k_exb(01,ind_DMNNO2))
  RCONST(2604) = (xnom7amin*k_exf(01,ind_H2NCOCH2OH))
  RCONST(2605) = (xnom7amin*k_exb(01,ind_H2NCOCH2OH))
  RCONST(2606) = (xnom7amin*k_exf(01,ind_CH3NHCHO))
  RCONST(2607) = (xnom7amin*k_exb(01,ind_CH3NHCHO))
  RCONST(2608) = (xnom7co2*k_exf(01,ind_MGLYOX))
  RCONST(2609) = (xnom7co2*k_exb(01,ind_MGLYOX))
  RCONST(2610) = (xnom7co2*k_exf(01,ind_MGLYOAC))
  RCONST(2611) = (xnom7co2*k_exb(01,ind_MGLYOAC))
  RCONST(2612) = (xnom7amin*k_exf(01,ind_TMA))
  RCONST(2613) = (xnom7amin*k_exb(01,ind_TMA))
  RCONST(2614) = (xnom7amin*k_exf(01,ind_DMNCHO))
  RCONST(2615) = (xnom7amin*k_exb(01,ind_DMNCHO))
  RCONST(2616) = (xnom7amin*k_exf(01,ind_DEA))
  RCONST(2617) = (xnom7amin*k_exb(01,ind_DEA))
  RCONST(2618) = (xnom7nno*k_exf(01,ind_NDELA))
  RCONST(2619) = (xnom7nno*k_exb(01,ind_NDELA))
  RCONST(2620) = (xnom7nno*k_exf(01,ind_DEANNO2))
  RCONST(2621) = (xnom7nno*k_exb(01,ind_DEANNO2))
  RCONST(2622) = (xnom7co2*k_exf(01,ind_BSOV))
  RCONST(2623) = (xnom7co2*k_exb(01,ind_BSOV))
  RCONST(2624) = (xnom7amin*k_exf(01,ind_TEA))
  RCONST(2625) = (xnom7amin*k_exb(01,ind_TEA))
  RCONST(2626) = (xnom7co2*k_exf(01,ind_BLOV))
  RCONST(2627) = (xnom7co2*k_exb(01,ind_BLOV))
  RCONST(2628) = (xaer(01)*testfac_GLYOAC*6.6E-4)
  RCONST(2629) = (xaer(01)*testfac_GLYOAC*1.E0*cvfac(01))
  RCONST(2630) = (xaer(01)*testfac_MGLYOAC*4.07E-3)
  RCONST(2631) = (xaer(01)*testfac_MGLYOAC*1.E0*cvfac(01))
  RCONST(2632) = (xaer(01)*testfac_OXALAC*6.4E-2)
  RCONST(2633) = (xaer(01)*testfac_OXALAC*1.E0*cvfac(01))
  RCONST(2634) = (xaer(01)*testfac_HC2O4m*5.25E-5)
  RCONST(2635) = (xaer(01)*testfac_HC2O4m*1.E0*cvfac(01))
  RCONST(2636) = (xaer(01)*testfac_SUCCAC*6.4E-2)
  RCONST(2637) = (xaer(01)*testfac_SUCCAC*1.E0*cvfac(01))
  RCONST(2638) = (xaer(01)*testfac_C2H5C2O4m*5.25E-5)
  RCONST(2639) = (xaer(01)*testfac_C2H5C2O4m*1.E0*cvfac(01))
  RCONST(2640) = (xaer(01)*3.5E-4*xaeq(01))
  RCONST(2641) = (xaer(01)*1.60E7*cvfac(01)*xaeq(01))
  RCONST(2642) = (xaer(01)*3.5E-4*xaeq(01))
  RCONST(2643) = (xaer(01)*1.88E7*cvfac(01)*xaeq(01))
  RCONST(2644) = (xaer(01)*3.5E-4*xaeq(01))
  RCONST(2645) = (xaer(01)*2.01E6*cvfac(01)*xaeq(01))
  RCONST(2646) = (xaer(01)*3.5E-4*xaeq(01))
  RCONST(2647) = (xaer(01)*8.79E5*cvfac(01)*xaeq(01))
  RCONST(2648) = (xaer(01)*3.5E-4*xaeq(01))
  RCONST(2649) = (xaer(01)*2.98E5*cvfac(01)*xaeq(01))
  RCONST(2650) = (xaer(01)*3.5E-4*xaeq(01))
  RCONST(2651) = (xaer(01)*2.11E4*cvfac(01)*xaeq(01))
  RCONST(2652) = (xaer(01)*3.0E6*xaeq(01))
  RCONST(2653) = (xaer(01)*1.2E10*cvfac(01)*xaeq(01))
  RCONST(2654) = (xaer(01)*3.5E1*xaeq(01))
  RCONST(2655) = (xaer(01)*2.00E9*cvfac(01)*xaeq(01))
  RCONST(2656) = (xaer(01)*3.0E6*xaeq(01))
  RCONST(2657) = (xaer(01)*1.2E10*cvfac(01)*xaeq(01))
  RCONST(2658) = (xaer(01)*3.5E1*xaeq(01))
  RCONST(2659) = (xaer(01)*2.00E9*cvfac(01)*xaeq(01))
  RCONST(2660) = (xaer(01)*3.0E6*xaeq(01))
  RCONST(2661) = (xaer(01)*1.2E10*cvfac(01)*xaeq(01))
  RCONST(2662) = (xaer(01)*3.5E1*xaeq(01))
  RCONST(2663) = (xaer(01)*2.00E9*cvfac(01)*xaeq(01))
  RCONST(2664) = (xaer(01)*3.0E6*xaeq(01))
  RCONST(2665) = (xaer(01)*1.2E10*cvfac(01)*xaeq(01))
  RCONST(2666) = (xaer(01)*3.5E1*xaeq(01))
  RCONST(2667) = (xaer(01)*2.00E9*cvfac(01)*xaeq(01))
  RCONST(2668) = (xaer(01)*3.0E6*xaeq(01))
  RCONST(2669) = (xaer(01)*1.2E10*cvfac(01)*xaeq(01))
  RCONST(2670) = (xaer(01)*3.5E1*xaeq(01))
  RCONST(2671) = (xaer(01)*2.00E9*cvfac(01)*xaeq(01))
  RCONST(2672) = (xaer(01)*3.0E6*xaeq(01))
  RCONST(2673) = (xaer(01)*1.2E10*cvfac(01)*xaeq(01))
  RCONST(2674) = (xaer(01)*3.5E1*xaeq(01))
  RCONST(2675) = (xaer(01)*2.00E9*cvfac(01)*xaeq(01))
  RCONST(2676) = (xaer(01)*2.0E-4*xaeq(01))
  RCONST(2677) = (xaer(01)*1.E0*cvfac(01)*xaeq(01))
  RCONST(2678) = (xaer(01)*jx(ip_H2O2)*7.11E-1)
  RCONST(2679) = (xaer(01)*jx(ip_NO2O)*1.91E-6)
  RCONST(2680) = (xaer(01)*jx(ip_NO2)*2.50E-3)
  RCONST(2681) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
  RCONST(2682) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
  RCONST(2683) = (xaer(01)*jx(ip_NO2)*1.30E-1*xaqcnno)
  RCONST(2684) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
  RCONST(2685) = (xaer(01)*jx(ip_NO2)*1.30E-1*xaqcnno)
  RCONST(2686) = (xaer(01)*jx(ip_NO2)*5.3E-2*xaqcnno)
  RCONST(2687) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE messy_mecca_kpp_Global

  RCONST(1683) = (jx(ip_O2))
  RCONST(1684) = (jx(ip_O1D))
  RCONST(1685) = (jx(ip_O3P))
  RCONST(1686) = (jx(ip_H2O2))
  RCONST(1687) = (jx(ip_NO2))
  RCONST(1688) = (jx(ip_NO2O))
  RCONST(1689) = (jx(ip_NOO2))
  RCONST(1690) = (jx(ip_N2O5))
  RCONST(1691) = (jx(ip_HONO))
  RCONST(1692) = (jx(ip_HNO3))
  RCONST(1693) = (jx(ip_HNO4))
  RCONST(1694) = (jx(ip_CH3OOH))
  RCONST(1695) = (jx(ip_COH2))
  RCONST(1696) = (jx(ip_CHOH))
  RCONST(1697) = (jx(ip_CH3ONO))
  RCONST(1698) = (jx(ip_CH3NO3))
  RCONST(1699) = (jx(ip_CH3O2NO2))
  RCONST(1700) = (jx(ip_CH3OOH))
  RCONST(1701) = (jx(ip_CH3O2))
  RCONST(1702) = (jx(ip_HCOOH))
  RCONST(1703) = (jx(ip_CH3O2NO2))
  RCONST(1704) = (jx(ip_CH3OOH))
  RCONST(1705) = (jx(ip_CH3CHO))
  RCONST(1706) = (jx(ip_CH3CHO2VINY))
  RCONST(1707) = (jx(ip_CH3CO3H))
  RCONST(1708) = (jx(ip_PAN))
  RCONST(1709) = (jx(ip_HOCH2CHO)*0.83)
  RCONST(1710) = (jx(ip_HOCH2CHO)*0.07)
  RCONST(1711) = (jx(ip_HOCH2CHO)*0.10)
  RCONST(1712) = (jx(ip_CH3OOH))
  RCONST(1713) = (jx(ip_PAN))
  RCONST(1714) = (jx(ip_GLYOX))
  RCONST(1715) = (jx(ip_MGLYOX))
  RCONST(1716) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1717) = (jx(ip_CH3OOH))
  RCONST(1718) = (j_IC3H7NO3)
  RCONST(1719) = (2*jx(ip_CH3OOH))
  RCONST(1720) = (jx(ip_CH3OOH))
  RCONST(1721) = (j_ketene*0.36)
  RCONST(1722) = (jx(ip_CH3OOH))
  RCONST(1723) = ((jx(ip_C2H5NO3)+jx(ip_CH3CHO))*(jx(ip_NOA)+1E-10)/(0.59*j_IC3H7NO3+jx(ip_CH3COCH3)+1E-10))
  RCONST(1724) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1725) = (jx(ip_C2H5NO3))
  RCONST(1726) = (jx(ip_PAN))
  RCONST(1727) = (jx(ip_CH3O2NO2))
  RCONST(1728) = (jx(ip_CH3OOH))
  RCONST(1729) = (jx(ip_CH3COCH3))
  RCONST(1730) = (j_ACETOL)
  RCONST(1731) = (jx(ip_MGLYOX))
  RCONST(1732) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1733) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1734) = (j_IC3H7NO3)
  RCONST(1735) = (jx(ip_NOA))
  RCONST(1736) = (jx(ip_CH3OOH))
  RCONST(1737) = (jx(ip_CH3OOH))
  RCONST(1738) = (jx(ip_MGLYOX))
  RCONST(1739) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1740) = (jx(ip_MGLYOX))
  RCONST(1741) = (jx(ip_HOCH2CHO)*2.)
  RCONST(1742) = (jx(ip_HOCH2CHO))
  RCONST(1743) = (jx(ip_CH3OOH))
  RCONST(1744) = (2.*jx(ip_MGLYOX))
  RCONST(1745) = (jx(IP_CH3COCO2H))
  RCONST(1746) = (jx(IP_MGLYOX)+jx(ip_CH3OOH))
  RCONST(1747) = (j_ketene*0.36*2.)
  RCONST(1748) = (j_IC3H7NO3)
  RCONST(1749) = (jx(ip_CH3O2NO2)+jx(ip_CH3COCH3))
  RCONST(1750) = (jx(ip_CH3OOH))
  RCONST(1751) = (0.59*j_IC3H7NO3)
  RCONST(1752) = (jx(ip_C2H5CHO2HCO))
  RCONST(1753) = (jx(ip_C2H5CHO2ENOL))
  RCONST(1754) = (jx(ip_PAN))
  RCONST(1755) = (jx(ip_CH3OOH))
  RCONST(1756) = (jx(ip_MGLYOX))
  RCONST(1757) = (jx(ip_HOCH2CHO)+jx(ip_CH3OOH))
  RCONST(1758) = (jx(ip_HOCH2CHO)+jx(ip_CH3OOH))
  RCONST(1759) = (jx(ip_HOCH2CHO)*2+jx(ip_CH3OOH))
  RCONST(1760) = (jx(ip_HOCH2CHO)*2)
  RCONST(1761) = (jx(ip_CH3OOH))
  RCONST(1762) = (jx(ip_CH3OOH)*(k_p/(k_p+k_s)))
  RCONST(1763) = (jx(ip_CH3OOH)*(k_s/(k_p+k_s)))
  RCONST(1764) = (jx(ip_MVK))
  RCONST(1765) = (0.42*jx(ip_CHOH))
  RCONST(1766) = (jx(ip_CH3OOH)+0.42*jx(ip_CHOH))
  RCONST(1767) = (2.15*jx(ip_MGLYOX))
  RCONST(1768) = (j_IC3H7NO3*(k_p/(k_p+k_s)))
  RCONST(1769) = (j_IC3H7NO3*(k_s/(k_p+k_s)))
  RCONST(1770) = (jx(ip_PAN))
  RCONST(1771) = (jx(ip_CH3OOH))
  RCONST(1772) = (j_ACETOL)
  RCONST(1773) = (jx(ip_MACR))
  RCONST(1774) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO))
  RCONST(1775) = (2.77*jx(ip_HOCH2CHO))
  RCONST(1776) = (jx(ip_CH3OOH))
  RCONST(1777) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1778) = (jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1779) = (j_ACETOL)
  RCONST(1780) = (2.15*jx(ip_MGLYOX))
  RCONST(1781) = (j_KETENE)
  RCONST(1782) = (j_KETENE*0.5)
  RCONST(1783) = (j_KETENE*0.5)
  RCONST(1784) = (jx(ip_MGLYOX))
  RCONST(1785) = (2.15*jx(ip_MGLYOX))
  RCONST(1786) = (3.15*jx(ip_MGLYOX))
  RCONST(1787) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1788) = (2.15*jx(ip_MGLYOX))
  RCONST(1789) = (jx(ip_CH3OOH))
  RCONST(1790) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1791) = (jx(ip_HOCH2CHO))
  RCONST(1792) = (jx(ip_MGLYOX))
  RCONST(1793) = (jx(ip_CH3OOH)+jx(ip_MGLYOX))
  RCONST(1794) = (jx(ip_MEKNO3))
  RCONST(1795) = (jx(ip_MEKNO3))
  RCONST(1796) = ((2.84*j_IC3H7NO3+jx(ip_CH3CHO))*(jx(ip_MEKNO3)+1E-10)/(j_IC3H7NO3+0.42*jx(ip_CHOH)+1E-10))
  RCONST(1797) = (2.84*j_IC3H7NO3)
  RCONST(1798) = (jx(ip_CH3OOH))
  RCONST(1799) = (2.84*j_IC3H7NO3)
  RCONST(1800) = (jx(ip_CH3OOH))
  RCONST(1801) = (jx(ip_CH3OOH))
  RCONST(1802) = (j_IC3H7NO3)
  RCONST(1803) = (jx(ip_CH3OOH))
  RCONST(1804) = (j_IC3H7NO3)
  RCONST(1805) = (j_ACETOL)
  RCONST(1806) = (jx(ip_C3H7CHO2HCO))
  RCONST(1807) = (jx(ip_C3H7CHO2VINY))
  RCONST(1808) = (jx(ip_IPRCHO2HCO))
  RCONST(1809) = (j_IC3H7NO3)
  RCONST(1810) = (jx(ip_CH3OOH))
  RCONST(1811) = (jx(ip_CH3OOH))
  RCONST(1812) = (jx(ip_PAN))
  RCONST(1813) = (jx(ip_PeDIONE24))
  RCONST(1814) = (jx(ip_PeDIONE24))
  RCONST(1815) = (jx(ip_C2H5CHO2HCO))
  RCONST(1816) = (jx(ip_C2H5CHO2ENOL))
  RCONST(1817) = (jx(ip_C2H5CHO2HCO)*2.)
  RCONST(1818) = (jx(ip_C2H5CHO2ENOL)*2.)
  RCONST(1819) = (j_ACETOL)
  RCONST(1820) = (jx(ip_CH3OOH))
  RCONST(1821) = (jx(ip_HOCH2CHO)*2)
  RCONST(1822) = (jx(ip_CH3OOH))
  RCONST(1823) = (jx(ip_CH3OOH))
  RCONST(1824) = (jx(ip_MGLYOX)+jx(ip_HOCH2CHO))
  RCONST(1825) = (jx(ip_CH3OOH))
  RCONST(1826) = (jx(ip_MACR))
  RCONST(1827) = (jx(ip_CH3OOH))
  RCONST(1828) = (2.77*jx(ip_HOCH2CHO))
  RCONST(1829) = (jx(ip_NO2)*0.14)
  RCONST(1830) = (jx(ip_CH3OOH))
  RCONST(1831) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO))
  RCONST(1832) = (jx(ip_MGLYOX)*2)
  RCONST(1833) = (jx(ip_MACR))
  RCONST(1834) = (2.77*jx(ip_HOCH2CHO)*2)
  RCONST(1835) = (jx(ip_MGLYOX))
  RCONST(1836) = (jx(ip_CH3OOH))
  RCONST(1837) = (jx(ip_CH3OOH))
  RCONST(1838) = (0.59*j_IC3H7NO3)
  RCONST(1839) = (jx(ip_CH3OOH))
  RCONST(1840) = (2.84*j_IC3H7NO3)
  RCONST(1841) = (jx(ip_CH3OOH))
  RCONST(1842) = (j_IC3H7NO3)
  RCONST(1843) = (jx(ip_CH3OOH))
  RCONST(1844) = ((.59*j_IC3H7NO3+jx(ip_MACR))*(jx(ip_MEKNO3)+1E-10)/(j_IC3H7NO3+0.42*jx(ip_CHOH)+1E-10))
  RCONST(1845) = (jx(ip_CH3OOH))
  RCONST(1846) = (jx(ip_MACR))
  RCONST(1847) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO))
  RCONST(1848) = (j_HPALD)
  RCONST(1849) = (jx(ip_PAN))
  RCONST(1850) = (0.5*jx(ip_MVK))
  RCONST(1851) = (j_ACETOL+jx(ip_CH3OOH))
  RCONST(1852) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1853) = (jx(ip_HOCH2CHO))
  RCONST(1854) = (2.15*jx(ip_MGLYOX))
  RCONST(1855) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1856) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1857) = (jx(ip_HOCH2CHO)*2.)
  RCONST(1858) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1859) = (jx(ip_MGLYOX)+2.15*jx(ip_MGLYOX))
  RCONST(1860) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)*2.)
  RCONST(1861) = (j_IC3H7NO3+jx(ip_HOCH2CHO)*2.)
  RCONST(1862) = (j_HPALD*0.6*0.5)
  RCONST(1863) = (j_HPALD*0.6*0.5)
  RCONST(1864) = (j_HPALD*0.4*0.5)
  RCONST(1865) = (j_HPALD*0.4*0.5)
  RCONST(1866) = (j_HPALD)
  RCONST(1867) = (2.77*jx(IP_HOCH2CHO))
  RCONST(1868) = (2.*jx(IP_CH3OOH))
  RCONST(1869) = (jx(IP_CH3OOH))
  RCONST(1870) = (jx(ip_CH3OOH))
  RCONST(1871) = (jx(ip_CH3OOH))
  RCONST(1872) = (2.*2.77*jx(IP_HOCH2CHO))
  RCONST(1873) = (jx(ip_NO2)*0.1*0.5)
  RCONST(1874) = (j_IC3H7NO3)
  RCONST(1875) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1876) = (jx(ip_CH3OOH)*.67)
  RCONST(1877) = (jx(ip_CH3OOH)*.33)
  RCONST(1878) = (j_ACETOL)
  RCONST(1879) = (jx(ip_MGLYOX))
  RCONST(1880) = (jx(ip_CH3OOH)*.65)
  RCONST(1881) = (jx(ip_CH3OOH)*.35)
  RCONST(1882) = (jx(ip_CH3OOH))
  RCONST(1883) = (jx(ip_MGLYOX)+2.15*jx(ip_MGLYOX)*2)
  RCONST(1884) = (jx(ip_HOCH2CHO)+2.15*jx(ip_MGLYOX))
  RCONST(1885) = (jx(ip_CH3OOH)+jx(ip_MACR))
  RCONST(1886) = (jx(ip_MVK))
  RCONST(1887) = (jx(ip_NO2)*0.2)
  RCONST(1888) = (jx(ip_MACR))
  RCONST(1889) = (jx(ip_HOCH2CHO))
  RCONST(1890) = (jx(ip_CH3OOH))
  RCONST(1891) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1892) = (jx(ip_CH3OOH))
  RCONST(1893) = (jx(ip_CH3OOH))
  RCONST(1894) = (jx(ip_CH3OOH))
  RCONST(1895) = (jx(ip_CH3OOH))
  RCONST(1896) = (jx(ip_MGLYOX)+jx(ip_MACR))
  RCONST(1897) = (2.15*jx(ip_MGLYOX))
  RCONST(1898) = (jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX))
  RCONST(1899) = (jx(ip_MGLYOX))
  RCONST(1900) = (jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX))
  RCONST(1901) = (jx(ip_CH3OOH))
  RCONST(1902) = (jx(ip_MGLYOX)*2)
  RCONST(1903) = (jx(ip_CH3OOH)+jx(ip_MGLYOX))
  RCONST(1904) = (jx(ip_CH3OOH))
  RCONST(1905) = (j_IC3H7NO3)
  RCONST(1906) = (jx(ip_HOC6H4NO2))
  RCONST(1907) = (j_KETENE)
  RCONST(1908) = (jx(ip_CH3OOH))
  RCONST(1909) = (4.E3*jx(ip_MVK)*0.1)
  RCONST(1910) = (jx(ip_CH3OOH))
  RCONST(1911) = (jx(ip_HOCH2CHO)*2+j_ACETOL)
  RCONST(1912) = (jx(ip_MACR))
  RCONST(1913) = (jx(ip_CH3OOH))
  RCONST(1914) = (jx(ip_MVK)+jx(ip_CH3OOH))
  RCONST(1915) = (j_IC3H7NO3+jx(ip_CH3OOH))
  RCONST(1916) = (jx(ip_CH3OOH))
  RCONST(1917) = (jx(ip_CH3OOH))
  RCONST(1918) = (j_ACETOL)
  RCONST(1919) = (jx(ip_CH3OOH))
  RCONST(1920) = (jx(ip_CH3OOH))
  RCONST(1921) = (jx(ip_CH3OOH))
  RCONST(1922) = (jx(ip_MGLYOX)+jx(ip_MVK))
  RCONST(1923) = (jx(ip_CH3OOH))
  RCONST(1924) = (jx(ip_CH3OOH)+jx(ip_MACR))
  RCONST(1925) = (jx(ip_CH3OOH))
  RCONST(1926) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO)*2)
  RCONST(1927) = (2.77*jx(ip_HOCH2CHO))
  RCONST(1928) = (jx(ip_HOC6H4NO2))
  RCONST(1929) = (j_KETENE)
  RCONST(1930) = (2.15*jx(ip_MGLYOX))
  RCONST(1931) = (jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX))
  RCONST(1932) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1933) = (jx(ip_CH3OOH))
  RCONST(1934) = (jx(ip_CH3OOH))
  RCONST(1935) = (4.E3*jx(ip_MVK)*0.1)
  RCONST(1936) = (jx(ip_CH3OOH))
  RCONST(1937) = (0.59*j_IC3H7NO3)
  RCONST(1938) = (jx(ip_BENZAL))
  RCONST(1939) = (jx(ip_CH3OOH))
  RCONST(1940) = (j_IC3H7NO3)
  RCONST(1941) = (j_ACETOL)
  RCONST(1942) = (jx(ip_CH3OOH))
  RCONST(1943) = (j_IC3H7NO3)
  RCONST(1944) = (jx(ip_CH3OOH))
  RCONST(1945) = (jx(ip_HOPh3Me2NO2))
  RCONST(1946) = (jx(ip_MACR))
  RCONST(1947) = (jx(ip_CH3OOH)+jx(ip_MACR))
  RCONST(1948) = (jx(ip_CH3OOH)+2.77*jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1949) = (2.77*jx(ip_HOCH2CHO)+j_ACETOL)
  RCONST(1950) = (2.77*jx(ip_HOCH2CHO)+2.15*jx(ip_MGLYOX))
  RCONST(1951) = (jx(ip_CH3OOH))
  RCONST(1952) = (jx(ip_CH3OOH))
  RCONST(1953) = (jx(ip_HOPh3Me2NO2))
  RCONST(1954) = (j_KETENE)
  RCONST(1955) = (jx(ip_HOPh3Me2NO2))
  RCONST(1956) = (j_KETENE)
  RCONST(1957) = (jx(ip_CH3OOH))
  RCONST(1958) = (jx(ip_CH3OOH))
  RCONST(1959) = (jx(ip_CH3OOH))
  RCONST(1960) = (jx(ip_CH3OOH))
  RCONST(1961) = (jx(ip_CH3OOH))
  RCONST(1962) = (jx(ip_CH3OOH))
  RCONST(1963) = (jx(ip_MGLYOX)*2)
  RCONST(1964) = (jx(ip_CH3OOH))
  RCONST(1965) = (jx(ip_CH3OOH))
  RCONST(1966) = (jx(ip_CH3OOH))
  RCONST(1967) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1968) = (jx(ip_CH3OOH))
  RCONST(1969) = (jx(ip_CH3OOH)+jx(ip_MGLYOX))
  RCONST(1970) = (jx(ip_HOCH2CHO))
  RCONST(1971) = (jx(ip_CH3OOH))
  RCONST(1972) = (jx(ip_CH3OOH))
  RCONST(1973) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1974) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1975) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1976) = (2.84*j_IC3H7NO3+jx(ip_HOCH2CHO))
  RCONST(1977) = (j_IC3H7NO3)
  RCONST(1978) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1979) = (jx(ip_CH3OOH))
  RCONST(1980) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1981) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1982) = ((jx(ip_CH3OOH)+2.15*jx(ip_MGLYOX)))
  RCONST(1983) = (jx(ip_PINAL2HCO))
  RCONST(1984) = (jx(ip_PINAL2ENOL))
  RCONST(1985) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1986) = (jx(ip_HOCH2CHO))
  RCONST(1987) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1988) = (jx(ip_CH3OOH))
  RCONST(1989) = (jx(ip_CH3OOH))
  RCONST(1990) = (jx(ip_CH3OOH))
  RCONST(1991) = (jx(ip_CH3OOH))
  RCONST(1992) = (jx(ip_CH3OOH))
  RCONST(1993) = (jx(ip_PINAL2HCO))
  RCONST(1994) = (jx(ip_PINAL2ENOL))
  RCONST(1995) = (jx(ip_CH3OOH)+j_ACETOL)
  RCONST(1996) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1997) = (j_IC3H7NO3+jx(ip_HOCH2CHO))
  RCONST(1998) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(1999) = (j_IC3H7NO3+jx(ip_HOCH2CHO))
  RCONST(2000) = (jx(ip_CH3OOH)+jx(ip_HOCH2CHO))
  RCONST(2001) = (jx(ip_MGLYOX)+jx(ip_HOCH2CHO))
  RCONST(2002) = (jx(ip_CH3OOH))
  RCONST(2003) = (jx(ip_CH3OOH))
  RCONST(2004) = (jx(ip_CH3OOH))
  RCONST(2005) = (2.84*j_IC3H7NO3+jx(ip_CH3OOH))
  RCONST(2006) = (2.84*j_IC3H7NO3)
  RCONST(2007) = (jx(ip_Cl2))
  RCONST(2008) = (jx(ip_Cl2O2))
  RCONST(2009) = (jx(ip_OClO))
  RCONST(2010) = (jx(ip_HOCl))
  RCONST(2011) = (jx(ip_ClNO2))
  RCONST(2012) = (jx(ip_ClNO3))
  RCONST(2013) = (jx(ip_ClONO2))
  RCONST(2014) = (jx(ip_I2))
  RCONST(2015) = (jx(ip_IO))
  RCONST(2016) = (jx(ip_HOI))
  RCONST(2017) = (jx(ip_INO2))
  RCONST(2018) = (jx(ip_INO3))
  RCONST(2019) = (jx(ip_CH2I2))
  RCONST(2020) = (jx(ip_CH3I))
  RCONST(2021) = (jx(ip_C3H7I))
  RCONST(2022) = (jx(ip_CH2ClI))
  RCONST(2023) = (jx(ip_ICl))
  RCONST(2211) = (jx(ip_CH3CHO))
  RCONST(2212) = (jx(ip_CH3CHO))
  RCONST(2213) = (0.33*jx(ip_NO2))
  RCONST(2214) = (0.25*jx(ip_NO2))
  RCONST(2215) = (0.08*jx(ip_NO2))
  RCONST(2216) = (0.33*jx(ip_NO2))
  RCONST(2217) = (0.34*jx(ip_NO2))
  RCONST(2218) = (jx(ip_CH3CHO))
  RCONST(2219) = (jx(ip_CH3CHO))
  RCONST(2220) = (0.42*jx(ip_CHOH))
  RCONST(2474) = (xaer(01)*4.51E-3*0.312)
  RCONST(2475) = (xaer(01)*5.77E-3*0.255)
  RCONST(2476) = (xaer(01)*6.43E-3*7.9E-3)
  RCONST(2678) = (xaer(01)*jx(ip_H2O2)*7.11E-1)
  RCONST(2679) = (xaer(01)*jx(ip_NO2O)*1.91E-6)
  RCONST(2680) = (xaer(01)*jx(ip_NO2)*2.50E-3)
  RCONST(2681) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
  RCONST(2682) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
  RCONST(2683) = (xaer(01)*jx(ip_NO2)*1.30E-1*xaqcnno)
  RCONST(2684) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
  RCONST(2685) = (xaer(01)*jx(ip_NO2)*1.30E-1*xaqcnno)
  RCONST(2686) = (xaer(01)*jx(ip_NO2)*5.3E-2*xaqcnno)
  RCONST(2687) = (xaer(01)*jx(ip_NO2)*5.3E-3*xaqcnno)
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Rates

