clear

%new structure of size_dis.res
% 1st line: dry diameter
% 2nd line: dlogDp
% 3rd line: dNdlogDp(t=0)
% first value is model_time
%%%

load ../output/size_dis.res;

infile='size_dis.res';
in=strrep(infile,'.res','');
y=eval(in);
[row,col]=size(y);


%time column
t=y(4:row,1);
t=t/3600.;
t=t-2; 
%dlogDp
dlogdp=y(2,2:col);
%N rows
%Number conc (=dN/dlogDp) in # cm^-3
A= y(4:row,2:col)*1.e-6; 
%dry diameter nm
x= y(1,2:col)*1.e9;
Alog=log10(A);

pcolor(t,x,Alog');
shading interp
%shading flat
hold on
contour(t,x,Alog',[1.58,2],'k');
colormap jet;
%set(gca,'zscale', 'log') 

tx=10.0:1.0:15.0;
set(gca,'xtick',tx);
txtext=['10:00';'11:00';'12:00';'13:00';'14:00';'15:00']; 
set(gca, 'xticklabel', txtext)

set(gca,'yscale', 'log');
set(gca,'xlim', [9.98,15.02]);
set(gca,'clim', [0.8,5.05]);
set(gca,'ylim', [10.,1000])   %nm

colorbar
h=colorbar;
set(h,'ytick',[1,2,2.477,3,3.477,4,4.447,5])	
set(h,'yticklabel',[10,100,300,1000,3000,10000,30000,100000]);

grid

set (gca,'fontsize',16); 
set(h,'fontsize',17);
b=ylabel('diameter (nm)');
a=xlabel('Time (hours)');
%a=xlabel('DOY');
set(a,'fontsize',22);
set(b,'fontsize',22);
%set(c,'fontsize',20)
%d=gtext({'dN/dlogDp'},'fontsize',18)
%d=gtext({'dN/dlogDp','[cm^{-3}]'},'fontsize',18)
title('Sequential size distribution, dN/dlogDp [cm^{-3}]','fontsize',12,'FontName','Arial');
% Create line
%annotation('line',[0.230 0.230],...
annotation('line',[0.220 0.220],...
    [0.113 0.928],'LineStyle','--','linewidth',2.,'Color','k');
% Create line
%annotation('line',[0.752 0.752],...
annotation('line',[0.695 0.695],...
    [0.113 0.928],'LineStyle','--','linewidth',2.,'Color','k');

%uncomment below line to save as jpg
print -r300 -djpg '../afigs_chamber/2009-05-11-profile_mod.jpg'

