clear

load ../output/wetdp.res;
load ../output/size_dis.res;

%FIT dN/dlogDp
%AEROFOR
% Peak
%t=0s
ma16_0_nm=[  1.6800000e-09   1.8000000e-09   1.8800000e-09   2.0000000e-09   2.2000000e-09   2.4000000e-09   2.4000000e-09   2.6000000e-09   2.6000000e-09   2.8000000e-09   3.0000000e-09   3.2000000e-09   3.4000000e-09   3.6000000e-09   4.0000000e-09   4.0000000e-09   4.4000000e-09   4.6000000e-09   4.8000000e-09   5.2000000e-09   5.4000000e-09   5.8000000e-09   6.2000000e-09   6.6000000e-09   6.8000000e-09   7.4000000e-09   7.8000000e-09   8.2000000e-09   8.8000000e-09   9.4000000e-09   9.8000000e-09   1.0400000e-08   1.1200000e-08   1.1600000e-08   1.2600000e-08   1.3200000e-08   1.4200000e-08   1.5000000e-08   1.6000000e-08   1.7000000e-08   1.7600000e-08   1.8800000e-08   1.9800000e-08   2.2000000e-08   2.2000000e-08   2.4000000e-08   2.4000000e-08   2.6000000e-08   2.8000000e-08   3.0000000e-08   3.2000000e-08   3.4000000e-08   3.6000000e-08   3.8000000e-08   4.0000000e-08   4.4000000e-08   4.4000000e-08   5.0000000e-08   5.0000000e-08   5.4000000e-08   5.8000000e-08   6.0000000e-08   6.4000000e-08   6.8000000e-08   7.2000000e-08   7.6000000e-08   8.2000000e-08   8.6000000e-08   9.2000000e-08   9.6000000e-08   1.0200000e-07   1.0800000e-07   1.1600000e-07   1.2400000e-07   1.3000000e-07   1.3800000e-07   1.4400000e-07   1.5800000e-07   1.6400000e-07   1.7400000e-07   1.8600000e-07   1.9400000e-07   2.0000000e-07   2.2000000e-07   2.4000000e-07   2.6000000e-07   2.6000000e-07   2.8000000e-07   3.0000000e-07   3.2000000e-07   3.4000000e-07   3.6000000e-07   3.8000000e-07   4.0000000e-07   4.2000000e-07   4.4000000e-07   4.8000000e-07   5.0000000e-07   5.2000000e-07   5.6000000e-07 ];
ma16_0_nm=ma16_0_nm*1.e9;
%ma16_0_nm_dry=[  1.50E-09	1.60E-09	1.68E-09	1.78E-09	1.90E-09	2.00E-09	2.20E-09	2.20E-09	2.40E-09	2.60E-09	2.60E-09	2.80E-09	3.00E-09	3.20E-09	3.40E-09	3.60E-09	3.80E-09	4.00E-09	4.40E-09	4.60E-09	4.80E-09	5.20E-09	5.40E-09	5.80E-09	6.20E-09	6.60E-09	6.80E-09	7.40E-09	7.80E-09	8.20E-09	8.80E-09	9.20E-09	9.80E-09	1.04E-08	1.10E-08	1.16E-08	1.24E-08	1.32E-08	1.40E-08	1.48E-08	1.56E-08	1.66E-08	1.76E-08	1.88E-08	1.98E-08	2.20E-08	2.20E-08	2.40E-08	2.60E-08	2.60E-08	2.80E-08	3.00E-08	3.20E-08	3.40E-08	3.60E-08	3.80E-08	4.00E-08	4.20E-08	4.60E-08	4.80E-08	5.00E-08	5.40E-08	5.80E-08	6.00E-08	6.40E-08	6.80E-08	7.20E-08	7.60E-08	8.20E-08	8.60E-08	9.20E-08	9.60E-08	1.02E-07	1.08E-07	1.16E-07	1.22E-07	1.30E-07	1.38E-07	1.46E-07	1.54E-07	1.64E-07	1.74E-07	1.84E-07	1.96E-07	2.00E-07	2.20E-07	2.40E-07	2.40E-07	2.60E-07	2.80E-07	3.00E-07	3.20E-07	3.40E-07	3.60E-07	3.80E-07	4.00E-07	4.20E-07	4.40E-07	4.80E-07	5.00E-07 ];
%ma16_0_nm_dry=ma16_0_nm_dry*1.e9;
ma16_0_dndlogdp_not_diluted=[ 0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   4.7564712e+03   5.9455890e+03   7.9274519e+03   1.0702060e+04   1.3873041e+04   1.9422257e+04   2.8142454e+04   4.3600986e+04   7.5310793e+04   1.3476668e+05   2.4178728e+05   4.3600986e+05   7.5310793e+05   1.2287551e+06   1.9422257e+06   2.8142454e+06   3.8448142e+06   5.1528438e+06   5.9455890e+06   6.7383341e+06   7.1347067e+06   7.1347067e+06   6.3419616e+06   5.5492164e+06   4.7564712e+06   3.6862652e+06   2.8142454e+06   2.1800493e+06   1.7440394e+06   1.4665786e+06   1.3476668e+06   1.3080296e+06   1.3476668e+06   1.4269413e+06   1.5458531e+06   1.6251276e+06   1.7440394e+06   1.8233139e+06   1.9422257e+06   2.0215002e+06   2.1007748e+06   2.1800493e+06   2.2196865e+06   2.2593238e+06   2.2989611e+06   2.3385983e+06   2.3385983e+06   2.3385983e+06   2.2989611e+06   2.2593238e+06   2.2196865e+06   2.1800493e+06   2.1007748e+06   2.0215002e+06   1.9422257e+06   1.8233139e+06   1.7440394e+06   1.6251276e+06   1.5062159e+06   1.4269413e+06   1.3080296e+06   1.1891178e+06   1.1098433e+06   9.9093149e+05   9.1165697e+05   7.9274519e+05   7.1347067e+05   6.3419616e+05   5.5492164e+05   4.7564712e+05   4.3600986e+05   3.7259024e+05   3.2106180e+05   2.7349709e+05   2.3385983e+05   1.9818630e+05   1.6647649e+05   1.3873041e+05   1.1494805e+05   9.5129423e+04   7.9274519e+04   6.3419616e+04   5.1528438e+04   4.3600986e+04   3.3295298e+04   2.6556964e+04   2.1007748e+04   1.6647649e+04   1.3080296e+04   1.0305688e+04 ];
ma16_0_dndlogdp=ma16_0_dndlogdp_not_diluted;

%t=0.1s
ma16_1_nm=[ 1.7200000e-09   1.8600000e-09   1.9400000e-09   2.2000000e-09   2.2000000e-09   2.4000000e-09   2.4000000e-09   2.6000000e-09   2.8000000e-09   3.0000000e-09   3.2000000e-09   3.4000000e-09   3.6000000e-09   3.8000000e-09   4.0000000e-09   4.2000000e-09   4.6000000e-09   4.8000000e-09   5.2000000e-09   5.4000000e-09   5.8000000e-09   6.0000000e-09   6.6000000e-09   7.0000000e-09   7.4000000e-09   7.8000000e-09   8.2000000e-09   8.8000000e-09   9.4000000e-09   1.0000000e-08   1.0400000e-08   1.1000000e-08   1.1800000e-08   1.2400000e-08   1.3400000e-08   1.4200000e-08   1.4800000e-08   1.6000000e-08   1.6800000e-08   1.8200000e-08   1.9000000e-08   2.0000000e-08   2.2000000e-08   2.2000000e-08   2.4000000e-08   2.6000000e-08   2.6000000e-08   2.8000000e-08   3.0000000e-08   3.2000000e-08   3.4000000e-08   3.6000000e-08   4.0000000e-08   4.0000000e-08   4.4000000e-08   4.6000000e-08   4.8000000e-08   5.2000000e-08   5.4000000e-08   5.8000000e-08   6.2000000e-08   6.4000000e-08   6.8000000e-08   7.4000000e-08   7.8000000e-08   8.2000000e-08   8.6000000e-08   9.2000000e-08   9.8000000e-08   1.0400000e-07   1.1200000e-07   1.1800000e-07   1.2400000e-07   1.3200000e-07   1.4000000e-07   1.5000000e-07   1.6000000e-07   1.6600000e-07   1.8000000e-07   1.8800000e-07   1.9800000e-07   2.0000000e-07   2.2000000e-07   2.4000000e-07   2.6000000e-07   2.6000000e-07   2.8000000e-07   3.0000000e-07   3.2000000e-07   3.4000000e-07   3.6000000e-07   3.8000000e-07   4.2000000e-07   4.2000000e-07   4.4000000e-07   4.8000000e-07   5.0000000e-07   5.4000000e-07   5.8000000e-07   6.0000000e-07 ];
ma16_1_nm=ma16_1_nm*1.e9;
ma16_1_dndlogdp=[ 7.9274519e+06   1.2287551e+07   1.0702060e+07   7.1347067e+06   3.4484416e+06   1.3476668e+06   4.3600986e+05   1.1494805e+05   2.6160591e+04   5.1528438e+03   9.9093149e+02   6.7383341e+02   1.1494805e+03   1.7836767e+03   2.5764219e+03   3.6069906e+03   5.1528438e+03   7.5310793e+03   1.2287551e+04   2.1800493e+04   3.9637260e+04   7.5310793e+04   1.3476668e+05   2.2989611e+05   3.8448142e+05   5.9455890e+05   8.7201971e+05   1.1891178e+06   1.4665786e+06   1.7440394e+06   1.9422257e+06   1.9818630e+06   1.9422257e+06   1.7836767e+06   1.5062159e+06   1.2287551e+06   9.5129423e+05   7.5310793e+05   5.5492164e+05   4.7564712e+05   3.9637260e+05   3.8448142e+05   3.8844514e+05   3.9637260e+05   4.3600986e+05   4.7564712e+05   4.7564712e+05   5.1528438e+05   5.5492164e+05   5.5492164e+05   5.9455890e+05   5.9455890e+05   6.3419616e+05   6.3419616e+05   6.3419616e+05   6.7383341e+05   6.7383341e+05   6.7383341e+05   6.3419616e+05   6.3419616e+05   6.3419616e+05   5.9455890e+05   5.9455890e+05   5.5492164e+05   5.5492164e+05   5.1528438e+05   4.7564712e+05   4.7564712e+05   4.3600986e+05   3.9637260e+05   3.6862652e+05   3.4088043e+05   3.0917063e+05   2.8142454e+05   2.5367846e+05   2.2593238e+05   2.0215002e+05   1.7836767e+05   1.5854904e+05   1.3873041e+05   1.1891178e+05   1.0305688e+05   9.1165697e+04   7.5310793e+04   6.7383341e+04   5.5492164e+04   4.7564712e+04   3.8844514e+04   3.2502553e+04   2.6556964e+04   2.1800493e+04   1.7836767e+04   1.4665786e+04   1.1891178e+04   9.5129423e+03   7.5310793e+03   5.9455890e+03   4.7564712e+03   3.6466279e+03   2.8935200e+03 ];
%t=0.9s
ma16_6_nm=[  1.7600000e-09   1.8800000e-09   2.0000000e-09   2.2000000e-09   2.2000000e-09   2.4000000e-09   2.6000000e-09   2.6000000e-09   3.0000000e-09   3.0000000e-09   3.4000000e-09   3.4000000e-09   3.8000000e-09   3.8000000e-09   4.0000000e-09   4.4000000e-09   4.6000000e-09   5.0000000e-09   5.2000000e-09   5.6000000e-09   5.8000000e-09   6.2000000e-09   6.6000000e-09   7.0000000e-09   7.6000000e-09   8.0000000e-09   8.4000000e-09   9.0000000e-09   9.6000000e-09   1.0200000e-08   1.0600000e-08   1.1400000e-08   1.2200000e-08   1.2800000e-08   1.3600000e-08   1.4600000e-08   1.5600000e-08   1.6600000e-08   1.7600000e-08   1.8200000e-08   1.9600000e-08   2.2000000e-08   2.2000000e-08   2.4000000e-08   2.6000000e-08   2.6000000e-08   2.8000000e-08   3.0000000e-08   3.2000000e-08   3.2000000e-08   3.6000000e-08   3.8000000e-08   4.0000000e-08   4.2000000e-08   4.6000000e-08   4.8000000e-08   5.2000000e-08   5.2000000e-08   5.6000000e-08   6.0000000e-08   6.4000000e-08   6.6000000e-08   7.2000000e-08   7.6000000e-08   8.0000000e-08   8.4000000e-08   9.0000000e-08   9.6000000e-08   1.0000000e-07   1.0800000e-07   1.1400000e-07   1.2200000e-07   1.2800000e-07   1.3600000e-07   1.4600000e-07   1.5400000e-07   1.6200000e-07   1.7200000e-07   1.8400000e-07   1.9600000e-07   2.0000000e-07   2.2000000e-07   2.4000000e-07   2.4000000e-07   2.6000000e-07   2.8000000e-07   2.8000000e-07   3.0000000e-07   3.2000000e-07   3.4000000e-07   3.6000000e-07   4.0000000e-07   4.2000000e-07   4.4000000e-07   4.8000000e-07   5.0000000e-07   5.4000000e-07   5.6000000e-07   5.8000000e-07   6.2000000e-07 ];
ma16_6_nm=ma16_6_nm*1.e9;
ma16_6_dndlogdp=[ 2.0215002e+06   2.2196865e+06   2.3782356e+06   2.5764219e+06   2.9331572e+06   3.1313435e+06   3.3295298e+06   3.8051769e+06   3.9637260e+06   4.3600986e+06   4.7564712e+06   5.5492164e+06   5.5492164e+06   6.3419616e+06   6.7383341e+06   7.5310793e+06   8.3238245e+06   8.7201971e+06   9.5129423e+06   1.0305688e+07   1.1494805e+07   1.2287551e+07   1.3476668e+07   1.4665786e+07   1.5062159e+07   1.4665786e+07   1.4269413e+07   1.2683923e+07   9.9093149e+06   7.5310793e+06   5.1528438e+06   3.2898926e+06   1.9422257e+06   1.2683923e+06   9.9093149e+05   9.9093149e+05   1.1891178e+06   1.4269413e+06   1.5854904e+06   1.7044022e+06   1.5854904e+06   1.3476668e+06   1.1494805e+06   8.7201971e+05   6.3419616e+05   5.1528438e+05   4.3600986e+05   4.3600986e+05   3.9637260e+05   4.3600986e+05   4.3600986e+05   4.3600986e+05   4.7564712e+05   4.7564712e+05   4.7564712e+05   5.1528438e+05   5.1528438e+05   5.1528438e+05   5.1528438e+05   5.1528438e+05   5.1528438e+05   4.7564712e+05   4.7564712e+05   4.3600986e+05   4.3600986e+05   3.9637260e+05   3.8844514e+05   3.6466279e+05   3.4484416e+05   3.1313435e+05   2.9331572e+05   2.6556964e+05   2.4575101e+05   2.1800493e+05   1.9818630e+05   1.7836767e+05   1.5854904e+05   1.3873041e+05   1.2287551e+05   1.0702060e+05   9.1165697e+04   7.9274519e+04   6.7383341e+04   5.9455890e+04   4.7564712e+04   3.9637260e+04   3.4484416e+04   2.8538827e+04   2.3782356e+04   1.9422257e+04   1.5854904e+04   1.3080296e+04   1.0702060e+04   8.3238245e+03   6.7383341e+03   5.5492164e+03   4.3600986e+03   3.3691671e+03   2.6160591e+03   2.1800493e+03 ];
%t=2.7s
ma16_9_nm=[ 1.7600000e-09   1.8800000e-09   2.0000000e-09   2.2000000e-09   2.2000000e-09   2.4000000e-09   2.6000000e-09   2.6000000e-09   3.0000000e-09   3.0000000e-09   3.4000000e-09   3.4000000e-09   3.8000000e-09   3.8000000e-09   4.0000000e-09   4.4000000e-09   4.6000000e-09   5.0000000e-09   5.2000000e-09   5.6000000e-09   5.8000000e-09   6.2000000e-09   6.6000000e-09   7.0000000e-09   7.6000000e-09   8.0000000e-09   8.4000000e-09   9.0000000e-09   9.6000000e-09   1.0200000e-08   1.0600000e-08   1.1400000e-08   1.2200000e-08   1.2800000e-08   1.3600000e-08   1.4600000e-08   1.5600000e-08   1.6600000e-08   1.7600000e-08   1.8200000e-08   1.9600000e-08   2.2000000e-08   2.2000000e-08   2.4000000e-08   2.6000000e-08   2.6000000e-08   2.8000000e-08   3.0000000e-08   3.2000000e-08   3.2000000e-08   3.6000000e-08   3.8000000e-08   4.0000000e-08   4.2000000e-08   4.6000000e-08   4.8000000e-08   5.2000000e-08   5.2000000e-08   5.6000000e-08   6.0000000e-08   6.4000000e-08   6.6000000e-08   7.2000000e-08   7.6000000e-08   8.0000000e-08   8.4000000e-08   9.0000000e-08   9.6000000e-08   1.0000000e-07   1.0800000e-07   1.1400000e-07   1.2200000e-07   1.2800000e-07   1.3600000e-07   1.4600000e-07   1.5400000e-07   1.6200000e-07   1.7200000e-07   1.8400000e-07   1.9600000e-07   2.0000000e-07   2.2000000e-07   2.4000000e-07   2.4000000e-07   2.6000000e-07   2.8000000e-07   2.8000000e-07   3.0000000e-07   3.2000000e-07   3.4000000e-07   3.6000000e-07   4.0000000e-07   4.2000000e-07   4.4000000e-07   4.8000000e-07   5.0000000e-07   5.4000000e-07   5.6000000e-07   5.8000000e-07   6.2000000e-07 ];
ma16_9_nm=ma16_9_nm*1.e9;
ma16_9_dndlogdp=[ 7.1347067e+05   7.5310793e+05   8.3238245e+05   9.5129423e+05   1.0702060e+06   1.1891178e+06   1.3080296e+06   1.5458531e+06   1.6647649e+06   1.9422257e+06   2.0611375e+06   2.4575101e+06   2.5764219e+06   3.0520690e+06   3.4484416e+06   3.8051769e+06   4.3600986e+06   4.7564712e+06   5.1528438e+06   5.9455890e+06   6.7383341e+06   7.1347067e+06   7.9274519e+06   9.1165697e+06   9.9093149e+06   1.1098433e+07   1.2287551e+07   1.3873041e+07   1.5062159e+07   1.6647649e+07   1.9025885e+07   2.0611375e+07   2.1800493e+07   2.3385983e+07   2.3782356e+07   2.2196865e+07   2.0215002e+07   1.7044022e+07   1.3476668e+07   1.0702060e+07   7.1347067e+06   4.7564712e+06   3.6466279e+06   2.8142454e+06   2.2196865e+06   1.9422257e+06   1.6647649e+06   1.3476668e+06   1.0702060e+06   8.3238245e+05   6.7383341e+05   5.9455890e+05   5.1528438e+05   5.5492164e+05   5.1528438e+05   5.5492164e+05   5.5492164e+05   5.9455890e+05   5.9455890e+05   5.9455890e+05   5.9455890e+05   5.5492164e+05   5.5492164e+05   5.1528438e+05   5.1528438e+05   4.7564712e+05   4.3600986e+05   4.3600986e+05   3.9637260e+05   3.6069906e+05   3.3295298e+05   3.0520690e+05   2.8142454e+05   2.4971474e+05   2.2196865e+05   1.9818630e+05   1.7836767e+05   1.5458531e+05   1.3476668e+05   1.1494805e+05   9.9093149e+04   8.7201971e+04   7.5310793e+04   6.3419616e+04   5.1528438e+04   4.3600986e+04   3.6862652e+04   3.0520690e+04   2.5367846e+04   2.0611375e+04   1.7044022e+04   1.3873041e+04   1.1098433e+04   9.1165697e+03   7.1347067e+03   5.5492164e+03   4.3600986e+03   3.4880789e+03   2.6953337e+03   2.3782356e+03 ];

% SMPS at 2.7s (end of experiment)
bga16_0_nm=[ 2.5945500e-09   2.6896000e-09   2.7881300e-09   2.8902600e-09   2.9961400e-09   3.1059000e-09   3.2196800e-09   3.3376200e-09   3.4598900e-09   3.5866400e-09   3.7180300e-09   3.8542300e-09   3.9954200e-09   4.1417800e-09   4.2935100e-09   4.4507900e-09   4.6138400e-09   4.7828600e-09   4.9580700e-09   5.1397000e-09   5.3279800e-09   5.5231600e-09   5.7254900e-09   5.9352300e-09   6.1526500e-09   6.3780400e-09   6.6116900e-09   6.8539000e-09   7.1049700e-09   7.3652500e-09   7.6350600e-09   7.9147600e-09   8.2047000e-09   8.5052600e-09   8.8168300e-09   9.1398200e-09   9.4746400e-09   9.8217200e-09   1.0181500e-08   1.0554500e-08   1.0941100e-08   1.1341900e-08   1.1757400e-08   1.2188100e-08   1.2634600e-08   1.3097500e-08   1.3577300e-08   1.4074600e-08   1.4590200e-08   1.5124700e-08   1.5678800e-08   1.6253100e-08   1.6848500e-08   1.7465800e-08   1.8105600e-08   1.8768800e-08   1.9456400e-08   2.0169100e-08   2.0908000e-08   2.1673900e-08   2.2467900e-08   2.3291000e-08   2.4144200e-08   2.5028700e-08   2.5945500e-08   2.6896000e-08   2.7881300e-08   2.8902600e-08   2.9961400e-08   3.1059000e-08   3.2196800e-08   3.3376200e-08   3.4598900e-08   3.5866400e-08   3.7180300e-08   3.8542300e-08   3.9954200e-08   4.1417800e-08   4.2935100e-08   4.4507900e-08   4.6138400e-08   4.7828600e-08   4.9580700e-08   5.1397000e-08   5.3279800e-08   5.5231600e-08   5.7254900e-08   5.9352300e-08   6.1526500e-08   6.3800000e-08   6.6100000e-08   6.8500000e-08   7.1000000e-08   7.3700000e-08   7.6400000e-08   7.9100000e-08   8.2000000e-08   8.5100000e-08   8.8200000e-08   9.1400000e-08   9.4700000e-08   9.8200000e-08   1.0180000e-07   1.0550000e-07   1.0940000e-07   1.1340000e-07   1.1760000e-07   1.2190000e-07   1.2630000e-07   1.3100000e-07   1.3580000e-07   1.4070000e-07   1.4590000e-07   1.5120000e-07   1.5680000e-07   1.6250000e-07   1.6850000e-07   1.7470000e-07   1.8110000e-07   1.8770000e-07   1.9460000e-07   2.0170000e-07   2.0910000e-07   2.1670000e-07   2.2470000e-07   2.3290000e-07   2.4140000e-07   2.5030000e-07   2.5950000e-07   2.6900000e-07   2.7880000e-07   2.8900000e-07   2.9960000e-07   3.1060000e-07   3.2200000e-07   3.3380000e-07   3.4600000e-07   3.5870000e-07   3.7180000e-07   3.8540000e-07   3.9950000e-07   ];
bga16_0_nm=bga16_0_nm*1.e9;
bga16_0_dndlogdp=[  0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   7.3000000e+05   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   6.8333333e+05   0.0000000e+00   0.0000000e+00   2.0166667e+05   3.3833333e+05   3.4250000e+05   2.0166667e+05   9.0833333e+04   4.8666667e+05   5.2250000e+05   9.5833333e+05   7.4916667e+05   9.2500000e+05   1.4083333e+06   1.2583333e+06   2.0916667e+06   3.3083333e+06   2.7000000e+06   4.2250000e+06   4.8250000e+06   5.3250000e+06   6.7250000e+06   7.5750000e+06   8.4166667e+06   9.6666667e+06   1.0250000e+07   1.1750000e+07   1.4250000e+07   1.6250000e+07   1.7583333e+07   1.9250000e+07   2.0500000e+07   2.2416667e+07   2.3416667e+07   2.3750000e+07   2.2500000e+07   2.2750000e+07   2.1583333e+07   2.0583333e+07   1.8666667e+07   1.7583333e+07   1.4916667e+07   1.4083333e+07   1.2083333e+07   1.0416667e+07   8.9166667e+06   8.9166667e+06   8.8333333e+06   8.9166667e+06   8.4166667e+06   8.1000000e+06   7.1333333e+06   5.7583333e+06   4.8166667e+06   3.9250000e+06   3.1500000e+06   2.3250000e+06   1.8250000e+06   1.3333333e+06   1.1750000e+06   8.5000000e+05   7.3583333e+05   6.0166667e+05   6.3916667e+05   6.0583333e+05   7.0500000e+05   8.2916667e+05   7.5500000e+05   8.5833333e+05   7.9250000e+05   8.9166667e+05   9.0833333e+05   9.9166667e+05   1.0583333e+06   9.5833333e+05   9.0000000e+05   9.0000000e+05   7.2083333e+05   7.0916667e+05   7.1500000e+05   6.8583333e+05   6.8166667e+05   6.2916667e+05   5.7750000e+05   5.6666667e+05   5.2083333e+05   5.0583333e+05   4.8833333e+05   4.8083333e+05   4.2166667e+05   4.0416667e+05   3.6416667e+05   3.4083333e+05   3.3500000e+05   2.9416667e+05   2.8583333e+05   2.4583333e+05   2.3000000e+05   2.1166667e+05   1.9083333e+05   1.8250000e+05   1.6416667e+05   1.5250000e+05   1.4583333e+05   1.3500000e+05   1.2250000e+05   1.1583333e+05   1.0000000e+05   9.2500000e+04   9.3333333e+04   7.1583333e+04   6.8750000e+04   6.0000000e+04   6.6250000e+04   5.2333333e+04   5.4500000e+04   3.9250000e+04   4.7500000e+04   3.3750000e+04   2.5833333e+04   2.7916667e+04   2.7000000e+04   2.2000000e+04   1.9166667e+04   1.7166667e+04   1.4416667e+04   1.5166667e+04   1.1333333e+04   9.0000000e+03 ];

% SMPS meas dN/dlogDp [# cm-3]   
bg_number_dmps=bga16_0_dndlogdp(1:141);
bg_dndlogdp_dmps=bg_number_dmps;
bg_diameter_dmps(1:141)=0.;

ma0_number_dmps=ma16_0_dndlogdp(1:100);
ma0_dndlogdp_dmps=ma0_number_dmps;
ma0_diameter_dmps(1:100)=0.;

ma1_number_dmps=ma16_1_dndlogdp(1:100);
ma1_dndlogdp_dmps=ma1_number_dmps;

ma6_number_dmps=ma16_6_dndlogdp(1:100);
ma6_dndlogdp_dmps=ma6_number_dmps;

ma9_number_dmps=ma16_9_dndlogdp(1:100);
ma9_dndlogdp_dmps=ma9_number_dmps;


for i=1:141
  bg_diameter_dmps(i)=bga16_0_nm(i);
end 
% emission diamter_smps %[nm]
for i=1:100
  ma0_diameter_dmps(i)=ma16_0_nm(i);
  ma1_diameter_dmps(i)=ma16_1_nm(i);
  ma6_diameter_dmps(i)=ma16_6_nm(i);
  ma9_diameter_dmps(i)=ma16_9_nm(i);
  %ma0_diameter_dmps(i)=ma16_0_nm_dry(i);
  %ma1_diameter_dmps(i)=ma16_0_nm_dry(i);
  %ma6_diameter_dmps(i)=ma16_0_n '../afigs_aging/diesel-sizedisnum.eps'm_dry(i);
  %ma9_diameter_dmps(i)=ma16_0_nm_dry(i);
end


%new structure of size_dis.res
% 1st line: dry diameter
% 2nd line: dlogDp
% 3rd line: dNdlogDp backgr
% 4th line: dNdlogDp(t=0)
% first value is model_time
%%%
infile='size_dis.res';
in=strrep(infile,'.res','');
y=eval(in);
[row,col]=size(y);               '../afigs_aging/diesel-sizedisnum.eps'      %row=xxx col=61

infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
dp=eval(indp);
[rowdp,coldp]=size(dp);

%dndlogdp_binbg=y(3,2:col)   *1e-6  *2.303;
% 0.0s
dndlogdp_bin01=y(4,2:col)   *1e-6 *2.303;      % #/m3-->#/cm3
diameter_bin01=y(1,2:col)*1e9; 
diameter_bin01=dp(1,2:coldp)*1e9; 
% 0.1s
dndlogdp_bin02=y(4+1,2:col)   *1e-6 *2.303;    % #/m3-->#/cm3
diameter_bin02=y(1,2:col)*1e9; 
diameter_bin02=dp(1,2:coldp)*1e9; 
% 0.9s
dndlogdp_bin03=y(4+9,2:col)   *1e-6 *2.303;    % #/m3-->#/cm3
diameter_bin03=y(1,2:col)*1e9; 
diameter_bin03=dp(1+9,2:coldp)*1e9;
% 2.7s
dndlogdp_bin04=y(4+27,2:col)   *1e-6 *2.303;   % #/m3-->#/cm3
diameter_bin04=y(1,2:col)*1e9; 
diameter_bin04=dp(1+27,2:coldp)*1e9; 


%loglog
% first 8h: hourly. then every 8h 
%1 hour= 1*60*6 = 360
% TIME UTC HERE AND ABOVE
figure(1)
axes('linewidth',2,'fontsize',13)
%AEROFOR 0.0s
loglog(ma0_diameter_dmps,ma16_0_dndlogdp,'ks-','MarkerSize',4.0,'LineWidth',1.1)
hold
ax=gca;
set(ax,'linewidth',2,'fontsize',11)
%MAFOR   0.0s
loglog(diameter_bin01,dndlogdp_bin01,      '--k' ,'LineWidth',2.4)
%AEROFOR, MAFOR 0.1s
loglog(ma1_diameter_dmps,ma16_1_dndlogdp,  'rs-','MarkerSize',4.0,'LineWidth',1.1)
loglog(diameter_bin02,dndlogdp_bin02,      '--r' ,'LineWidth',2.4)
%loglog(ma1_diameter_dmps,ma16_2_dndlogdp,'ko-','MarkerSize',5.,'LineWidth',1.4)
%loglog(ma1_diameter_dmps,ma16_3_dndlogdp,'ko-','MarkerSize',5.,'LineWidth',1.4)
%loglog(ma1_diameter_dmps,ma16_4_dndlogdp,'ko-','MarkerSize',5.,'LineWidth',1.4)
%loglog(ma1_diameter_dmps,ma16_5_dndlogdp,'ko-','MarkerSize',5.,'LineWidth',1.4)
%AEROFOR, MAFOR 0.9s
loglog(ma1_diameter_dmps,ma16_6_dndlogdp,  'gs-','MarkerSize',4.0,'LineWidth',1.1)
loglog(diameter_bin03,dndlogdp_bin03,      '--g' ,'LineWidth',2.43)
%loglog(ma1_diameter_dmps,ma16_7_dndlogdp,'ko:','MarkerSize',5.,'LineWidth',1.4)
%AEROFOR, MAFOR 2.7s
loglog(ma9_diameter_dmps,ma16_9_dndlogdp,  'bs-','MarkerSize',4.0,'LineWidth',1.1)
loglog(diameter_bin04,dndlogdp_bin04,      '--b' ,'LineWidth',2.4)
%SMPS 2.7s
loglog(bg_diameter_dmps,bga16_0_dndlogdp,'bd','MarkerSize',5.0,'LineWidth',1.1)
%modelled background size distribution
%loglog(diameter_bin,dndlogdp_binbg,      '-k' ,'LineWidth',2.1)

%modelled at xxx m
%loglog(diameter_bin,dndlogdp_bin02,      '--y' ,'LineWidth',2.1)
%loglog(diameter_bin,dndlogdp_bin03,      '--m' ,'LineWidth',2.1)
%loglog(diameter_bin,dndlogdp_bin04,      '--g' ,'LineWidth',2.1)
%loglog(diameter_bin,dndlogdp_bin05,      '--c' ,'LineWidth',2.1)
%loglog(diameter_bin,dndlogdp_bin06,      '--b' ,'LineWidth',2.1)
%loglog(diameter_bin,dndlogdp_bin07,      '--k' ,'LineWidth',2.1)
%LEGEND
legend('AEROF 0.0s','MAFOR 0.0s','AEROF 0.1s','MAFOR 0.1s','AEROF 0.9s','MAFOR 0.9s','AEROF 2.7s','MAFOR 2.7s','SMPS   2.7s','Location','NorthEastOutside')  

xlabel('Wet diameter D_p (nm)','FontSize',16)
ylabel('dN/dlogDp (particles/cm^3)','FontSize',16)
%loglog
set(gca,'xtick',[1,10,50,100,500,1000]);
set(gca, 'xticklabel', [1,10,50,100,500,1000]);
set(gca,'XLim',[1. 600.],'Ylim',[5.e2 1.e8]); 

%print -dbmp '../afigs_aging/diesel-sizedisnum.bmp'
%print -depsc '../afigs_aging/diesel-sizedisnum.eps'
print -djpg  '../afigs_aging/diesel-sizedisnum.jpg'
