clear

load ../output/iconw1/wetdp.res;
load ../output/iconw1/size_dis.res;

%new structure of size_dis.res
% 1st line: dry diameter
% 2nd line: dlogDp
% 3rd line: dNdlogDp(t=0)
% first value is model_time
%%%

% wet diameter in wetdp.res
infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
xdp=eval(indp);
[rowdp,coldp]=size(xdp);
%wet diameter nm
diam = xdp(1:rowdp,2:coldp)*1.e9;   %nm
for i=1:coldp-1
   x(i,1)=diam(1,i);
end

infile='size_dis.res';
in=strrep(infile,'.res','');
y=eval(in);
[row,col]=size(y);

%time column
t=y(3:row,1);
t=t/3600.;
jd=234;
t=t/24;
t=t+jd;
%dlogDp
dlogdp=y(2,2:col);
%N rows
%Number conc (=dN/dlogDp) in # cm^-3
A= y(3:row,2:col)*1.e-6;   %*0.1561 
Alog=log10(A);

pcolor(t,x,Alog');
shading interp
%shading flat
hold on
%contour(t,x,Alog',[1.58,2],'k');
colormap jet;
%set(gca,'zscale', 'log') 

JD=234.46:0.0833:234.71;
set(gca,'xtick',JD);
JDtext=['234.46';'234.54';'234.63';'234.71'];  %LT
set(gca, 'xticklabel', JDtext);

set(gca,'yscale', 'log') 
set(gca,'xlim', [234.457,  234.68]) 
set(gca,'clim', [0.8 3.5]);
set(gca,'ylim', [1.,1000])   %nm

colorbar
h=colorbar;
set(h,'ytick',[1,1.477,2,2.477,3,3.477]);
set(h,'yticklabel',[10,30,100,300,1000,3000]);
%set(h,'ytick',[0,1,2,3]);
%set(h,'yticklabel',[0,100,1000,10000]);

grid

set (gca,'fontsize',16); 
set(h,'fontsize',17);
b=ylabel('diameter (nm)');
%a=xlabel('Time (hours)');
%a=xlabel('Julian Day');
a=xlabel('DOY');
set(a,'fontsize',17)
set(b,'fontsize',17)
%d=gtext({'dN/dlogDp','[cm^{-3}]'},'fontsize',18);
title('ICONW=1 | Seq. size distribution, dN/dlogDp [cm^{-3}]','fontsize',17,'fontname','Arial');

print -r300 -djpg '../afigs_mesa/cabauw_seqdis_iconw1.jpg'



load ../output/iconw2/wetdp.res;
load ../output/iconw2/size_dis.res;

% wet diameter in wetdp.res
infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
xdp=eval(indp);
[rowdp,coldp]=size(xdp);
%wet diameter nm
diam = xdp(1:rowdp,2:coldp)*1.e9;   %nm
for i=1:coldp-1
   x(i,1)=diam(1,i);
end

infile='size_dis.res';
in=strrep(infile,'.res','');
y=eval(in);
[row,col]=size(y);

%time column
t=y(3:row,1);
t=t/3600.;
jd=234;
t=t/24;
t=t+jd;
%dlogDp
dlogdp=y(2,2:col);
%N rows
%Number conc (=dN/dlogDp) in # cm^-3
A= y(3:row,2:col)*1.e-6;   %*0.1561 
Alog=log10(A);

pcolor(t,x,Alog');
shading interp
%shading flat
hold on
%contour(t,x,Alog',[1.58,2],'k');
colormap jet;
%set(gca,'zscale', 'log') 

JD=234.46:0.0833:234.71;
set(gca,'xtick',JD);
JDtext=['234.46';'234.54';'234.63';'234.71'];  %LT
set(gca, 'xticklabel', JDtext);

set(gca,'yscale', 'log') 
set(gca,'xlim', [234.457,  234.68]) 
set(gca,'clim', [0.8 3.5]);
set(gca,'ylim', [1.,1000])   %nm

colorbar
h=colorbar;
set(h,'ytick',[1,1.477,2,2.477,3,3.477]);
set(h,'yticklabel',[10,30,100,300,1000,3000]);
%set(h,'ytick',[0,1,2,3]);
%set(h,'yticklabel',[0,100,1000,10000]);

grid

set (gca,'fontsize',16); 
set(h,'fontsize',17);
b=ylabel('diameter (nm)');
%a=xlabel('Time (hours)');
%a=xlabel('Julian Day');
a=xlabel('DOY');
set(a,'fontsize',17)
set(b,'fontsize',17)
%d=gtext({'dN/dlogDp','[cm^{-3}]'},'fontsize',18);
title('ICONW=2 | Seq. size distribution, dN/dlogDp [cm^{-3}]','fontsize',17,'fontname','Arial');

print -r300 -djpg '../afigs_mesa/cabauw_seqdis_iconw2.jpg'
