clear

%new structure of size_dis.res
% 1st line: dry diameter
% 2nd line: dlogDp
% 3rd line: dNdlogDp(t=0)
% first value is model_time
%%%

% wet diameter in wetdp.res
load ../output/wetdp.res;
infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
xdp=eval(indp);
[rowdp,coldp]=size(xdp);
%wet diameter nm
diam = xdp(1:rowdp,2:coldp)*1.e9;   %nm
for i=1:coldp-1
   x(i,1)=diam(1,i);
end

load ../output/size_dis.res;
infile='size_dis.res';
in=strrep(infile,'.res','');
y=eval(in);
[row,col]=size(y);

%time column
t=y(3:row,1);
t=t/3600.;
jd=165;
t=t/24;
t=t+jd;
%dlogDp
dlogdp=y(2,2:col);
%N rows
%Number conc (=dN/dlogDp) in # cm^-3
A= y(3:row,2:col)*1.e-6;   %*0.1561 
Alog=log10(A);

pcolor(t,x,Alog');
shading interp
%shading flat
hold on
contour(t,x,Alog',[1.58,2],'k');
colormap jet;
%set(gca,'zscale', 'log') 

set(gca,'yscale', 'log') 
set(gca,'clim', [0.8,3.477]);
set(gca,'ylim', [1.e0,1.e4])   %nm
set(gca,'ytick',[1.e0,1.e1,1.e2,1.e3,1.e4])	

colorbar
h=colorbar;
set(h,'ytick',[1,1.477,2,2.477,3,3.477])	
set(h,'yticklabel',[10,30,100,300,1000,3000]);

grid

set (gca,'fontsize',15); 
set(h,'fontsize',15);
b=ylabel('diameter (nm)');
%a=xlabel('Time (hours)');
%a=xlabel('Julian Day');
a=xlabel('DOY');
set(a,'fontsize',17)
set(b,'fontsize',17)
%d=gtext({'dN/dlogDp','[cm^{-3}]'},'fontsize',18);
title('Sequential size distribution, dN/dlogDp [cm^{-3}]','fontsize',15);

%Save to file takes very long in Octave
%uncomment below line to save as jpg
print -r60 -djpg '../afigs_aqchem/marine_aqchem_seqdis.jpg'

