PROGRAM mafor_salsa_box_driver  
  USE mo_salsa_box                       ! Module for this box model.
                                         ! The routines here should probably be redesigned
                                         ! for easier implementation in host models
  USE mo_submctl                         ! kbdim,kproma,klev... are here, also bin numbers and switches; should bin number be in mo_salsa_type?
  USE mo_salsa, ONLY : salsa
  USE mo_salsa_types                                 ! Holds particle size distributions,
                                                     ! class object for process rate diagnostics
                                                     ! and coagulation kernel arrays (is this a good place?)
  USE mo_salsa_init, ONLY : define_salsa, salsa_initialize
  USE mo_salsa_math, ONLY : satmixrat_l, satmixrat_i
  USE mo_salsa_properties, ONLY : equilibration
  USE classSection, ONLY : Section                    ! Maybe try to get rid of this?
  IMPLICIT NONE

  !!SAVE
  
  ! ======================================================================== !
  REAL, PARAMETER :: tstep = 0.5        ! Timestep in seconds
  REAL, PARAMETER :: tstep_salsa = 0.01 ! Timestep in seconds (only SALSA)
  INTEGER, PARAMETER :: nsteps = 242    ! Number of timesteps = simulation length / tstep 
  REAL :: time

  REAL, PARAMETER :: INIT_RH = 0.598  ! Initial RH; is used to define vapor mix rat for the BOX model

  CHARACTER(LEN=200) :: fmt_output
  CHARACTER(LEN=200) :: fmt_output_mpsd
  CHARACTER(LEN=200) :: fmt_output_psd
  CHARACTER(LEN=200) :: fmt_rc
  CHARACTER(LEN=200) :: header_output
  CHARACTER(LEN=200) :: header_output_mpsd
  CHARACTER(LEN=200) :: header_output_psd
  CHARACTER(LEN=200) :: header_rc

  CHARACTER(LEN=*), PARAMETER :: filename_emission_psd = 'emission_psd_measured.csv'
  CHARACTER(LEN=*), PARAMETER :: filename_error = 'error.txt'
  CHARACTER(LEN=*), PARAMETER :: filename_output = 'mafor_output.csv'
  CHARACTER(LEN=*), PARAMETER :: filename_output_mpsd = 'mafor_output_mpsd.csv'
  CHARACTER(LEN=*), PARAMETER :: filename_output_psd = 'mafor_output_psd.csv'
  CHARACTER(LEN=*), PARAMETER :: filename_rc = 'mafor_run_control.csv'

  INTEGER :: fu_emission    ! file unit
  INTEGER :: fu_error       ! file unit
  INTEGER :: fu_output      ! file unit
  INTEGER :: fu_output_psd  ! file unit
  INTEGER :: fu_output_mpsd ! file unit
  INTEGER :: fu_rc          ! file unit
  INTEGER :: i              ! loop index
  INTEGER :: io_status      ! input/output file status
  INTEGER :: xind           ! index of variable x in x_lanes

  INTEGER, PARAMETER :: emission_switch(1:5) = (/1, 0, 1, 0, 0/)

  LOGICAL :: dilution = .FALSE.
  LOGICAL :: emission = .FALSE.

  LOGICAL, PARAMETER :: bg_in_dilution = .TRUE.
  LOGICAL, PARAMETER :: deposition = .TRUE.
  LOGICAL, PARAMETER :: dilution_master_switch = .TRUE.

  INTEGER, ALLOCATABLE :: emission_size_index(:) ! index of dmid in emission_size_modes
  
  REAL :: dilution_rate    ! dilution rate for the plume
  REAL :: distance         ! path (m) that the box has travelled
  REAL :: emission_aerosol !
  REAL :: h_plume          ! height of the box (m)
  REAL :: rate_of_dilution ! rate of change for dilution for the plume
  REAL :: time_after_rs    ! time after the plume exists the roadside
  REAL :: time_dilution    ! time stamp for dilution
  REAL :: unit_conc        ! Unit concentration for debugging
  
  REAL, PARAMETER :: EF_to_north = 1.68e11  ! EF of total aerosol number on the lanes to north in #/m/s
  REAL, PARAMETER :: EF_to_south = 1.25e11  ! EF of total aerosol number on the lanes to south in #/m/s
  REAL, PARAMETER :: lane_width_to_north = 7.0 ! width of the lane(s) leading to the north
  REAL, PARAMETER :: lane_width_to_south = 9.5 ! width of the lane(s) leading to the south
  REAL, PARAMETER :: wind_speed = 1.0  ! horizontal wind speed, m/s

  REAL, PARAMETER :: emission_mass_frac_bc(1:4) = (/0.0, 0.2, 0.6, 0.4/)
  REAL, PARAMETER :: emission_mass_frac_oc(1:4) = (/1.0, 0.8, 0.4, 0.6/)
  REAL, PARAMETER :: emission_size_modes(1:5) = (/1.0E-9, 1.0E-8, 1.0E-7, 4.0E-7, 1.0/)
  REAL, PARAMETER :: x_lanes(1:5) = (/0.0, 7.1, 13.1, 22.6, 1000.0/)

  REAL :: dg_dilution(1:5)  ! rate of change in gas concentrations due to dilution
  REAL :: dg_emission(1:5)  ! rate of change in gas concentrations due to emission
  REAL :: gconc(1:5)        ! Gas concentrations
  REAL :: gconc_bg(1:5)     ! Background gas concentrations
  REAL :: rho_components(1:8) ! Density of different mass components

  REAL, ALLOCATABLE :: bin_diameter(:)   ! bin diameter in m
  REAL, ALLOCATABLE :: dN_dilution(:)    ! dN/dt due to dilution
  REAL, ALLOCATABLE :: dN_emission(:)    ! dN/dt due to emission
  REAL, ALLOCATABLE :: dV_dilution(:,:)  ! dV/dt due to dilution
  REAL, ALLOCATABLE :: dV_emission(:,:)  ! dV/dt due to emission
  REAL, ALLOCATABLE :: msect_out(:,:)      ! mass size distribution
  REAL, ALLOCATABLE :: nsect_bg(:)     ! background aerosol number size distribution (1/m3)
  REAL, ALLOCATABLE :: relative_share(:) ! relative share of the emission per size bin
  REAL, ALLOCATABLE :: vsect_bg(:,:)  ! background aerosol mass size distribution (1/m3)
  ! ======================================================================== !

   ! Variables for coagulation calls in varying temporal intervals
   ! --------------------------------------------------------------
  ! Storage of the coagulation kernels:
  !!!! THIS ACTUALLY DID NOT WORK WITHOUT THE SAVE ATTRIBUTE, IS IT BECAUSE THESE ARE NOT MODULE VARIABLES (WHERE SAVE IS IMPLICIT)???
  !!!! THE ALLOCATION GOT MESSED UP...
  ! In LES the coagulation kernel storage is written in the LES grid as they need to be stored in the host model points. But this should be
  ! made universal somehow!
   REAL, ALLOCATABLE, SAVE :: sto_aa(:,:,:,:,:), sto_cc(:,:,:,:,:), sto_pp(:,:,:,:,:), sto_ii(:,:,:,:,:),  &
                        sto_ca(:,:,:,:,:), sto_pa(:,:,:,:,:), sto_ia(:,:,:,:,:),   &
                        sto_pc(:,:,:,:,:), sto_ic(:,:,:,:,:),                  &
                        sto_ip(:,:,:,:,:)
   LOGICAL :: cgsto_initialized = .FALSE.
  
  ! "External" variables, input to salsa
  REAL, SAVE :: ppres(kbdim,klev),    &   ! Pressure (Pa),
                ptemp(kbdim,klev)         ! Temperature (K)
  REAL, SAVE :: prv(kbdim,klev),   &      ! Water vapor mix rat (kg/kg)
                prs(kbdim,klev),   &      ! Saturation mix rat (kg/kg)          
                prsi(kbdim,klev)          ! Saturation mix rat for ice (kg/kg)
                                          ! The saturation mix rats could be obtained from temperature inside SALSA, but
                                          ! Usually they are calculated also within the host model, so this would provide
                                          ! consistency. Which is better?
  REAL :: pw(kbdim,klev)            ! Vertical velocity (needed only for parameterized activation)

  REAL :: zrh(kbdim,klev)           ! local RH
  
  
  TYPE(Section) :: pactd(kbdim,klev,14) ! ... used to get the number of newly activated for some LES mess when using the
                                     ! parameterized activation; This should be same size as cloud!
  ! Gas tracers??
  REAL, SAVE :: pc_h2so4(kbdim,klev), pc_ocnv(kbdim,klev), pc_ocsv(kbdim,klev), pc_hno3(kbdim,klev), pc_nh3(kbdim,klev)
  
  INTEGER :: tt, bb, tt_salsa, cc

  INTEGER :: level = 4 ! This is from LES defining thermodynamic "level", 4 = salsa with liq only, 5 = salsa with ice...

  LOGICAL :: initialize 

  REAL :: mass
  INTEGER :: ndry, nwet, iwa, ino, inh, ibc, ioc, iso4, idu, iss

  ! ======================================================================== !
  ppres = 102560.0       ! Pa
  ptemp = 260.1          ! K
  dilution_rate = 0.0    !
  distance = 0.0         ! m
  emission_aerosol = 0.0 ! #/m3/s
  h_plume = 0.8          ! m
  rate_of_dilution = 0.0 ! 1/s
  time_after_rs = 0.0    ! s
  time_dilution = 0.0    ! s
  xind = 1
  unit_conc = 1000.0

  ! Precursor concentrations
  pc_h2so4 = 1.0 ! 3.0e15
  pc_ocnv = 1.0 ! 1.0e-10 * avog * ppres(1,1)/(rg*ptemp(1,1))  ! 0.1 ppb
  pc_ocsv = 2.5e14
  pc_hno3 = 1.0 !1.0e-9 * avog * ppres(1,1)/(rg*ptemp(1,1))  ! 0.1 ppb
  pc_nh3 = 1.0 ! 1.0e-9 * avog * ppres(1,1)/(rg*ptemp(1,1))   ! 0.1 ppb
  
  ! Vertical velocity for parameterized activation
  pw = 0.0  ! m/s

  ! Open the error output file
  OPEN(ACTION='write', FILE=filename_error, STATUS='replace', iostat=io_status, newunit=fu_error)
  IF (io_status /= 0) THEN
     WRITE(*,*) 'Error: opening file ', filename_error, ' failed'
     STOP
  ENDIF

  ! Open the output files: everything else except the size distribution
  OPEN(ACTION='write', FILE=filename_output, STATUS='replace', iostat=io_status, newunit=fu_output)
  IF (io_status /= 0) THEN
     WRITE(fu_error,*) 'Error: opening file ', filename_output, ' failed'
     STOP
  ENDIF

  ! Open the output files: size distribution
  OPEN(ACTION='write', FILE=filename_output_psd, STATUS='replace', iostat=io_status, newunit=fu_output_psd)
  IF (io_status /= 0) THEN
     WRITE(fu_error,*) 'Error: opening file ', filename_output_psd, ' failed'
     STOP
  ENDIF

  ! Open the output files: mass size distribution
  OPEN(ACTION='write', FILE=filename_output_mpsd, STATUS='replace', iostat=io_status, newunit=fu_output_mpsd)
  IF (io_status /= 0) THEN
     WRITE(fu_error,*) 'Error: opening file ', filename_output_mpsd, ' failed'
     STOP
  ENDIF

  ! Open the run control file
  OPEN(ACTION='write', FILE=filename_rc, STATUS='replace', iostat=io_status, newunit=fu_rc)
  IF (io_status /= 0) THEN
     WRITE(fu_rc,*) 'Error: opening file ', filename_rc, ' failed'
     STOP
  ENDIF

  ! Define output headers and formats

  header_output = 'time,T,w,RH,pc_h2so4,pc_ocnv,pc_ocsv,pc_hno3,pc_nh3,volc_so4,'//&
                  'volc_oc,volc_bc,volc_no,volc_nh,volc_du,volc_ss,volc_iwa,numc,PM1'
  header_output_psd = 'row 1: dmid (m), row 2: vlolim, row 3: vhilim, row 4-->: time, conc per bin (#/cm3)'
  header_output_mpsd = 'row 1: dmid (m), row 2-->: time, component index, conc per bin (#/cm3)'
  header_rc = 'time,distance,h_plume,rate_of_dilution,emission_aerosol,unit_conc'

  fmt_output = '(4(F7.2,:,","),15(E15.7,:,","))'
  fmt_output_psd = '(*(E15.7,:,","))'
  fmt_output_mpsd = '(*(E15.7,:,","))'
  fmt_rc = '(4(F7.2,:,","),1(E15.7,:,","),4(F7.2,:,","))'

  ! ======================================================================== !

  ! Initialize rest
  prv = 0.
  prs = 0.
  prsi = 0.
  zrh = 0.
  
  ! Saturation vapor mix rats; WOULD IT BE BETTER TO CALCULATE THESE INSIDE SALSA, NOT NEEDED IN VERY MANY PLACES
  CALL satmixrat_l(kbdim,klev,ppres,ptemp,prs)  
  CALL satmixrat_i(kbdim,klev,ppres,ptemp,prsi)

  ! For the box, initialize vapor mix rat using the initial RH
  prv = INIT_RH*prs

  
  ! These have to be called in this order!
  ! ---------------------------------------
  ! Read namelist parameters
  CALL define_salsa(level)
  
  ! Call initialization
  CALL salsa_initialize()
  
  ! Initialize aerosol size distributions (take dist parameters from namelist, call size distribution...)
  CALL aerosol_init()
  ! ---------------------------------------

  ! Not necessarily needed here
  DO bb = 1,ntotal
     CALL allSALSA(1,1,bb)%updateDiameter(.TRUE.,type="all")
     CALL allSALSA(1,1,bb)%updateRhomean()
  END DO
  
  ! Initialize some local arrays and switches needed here locally
  !IF (.NOT. cgsto_initialized) &
  CALL initialize_coagstorage(1,1,1)  ! Dimensions for LES...see comments on CALL fetch_coag

  ! Some indices
  ndry = spec%getNSpec(type="dry")
  nwet = spec%getNSpec(type="wet")  ! excludes rimed ice
  iwa = spec%getIndex("H2O")    ! water/unrimed ice
  ino = spec%getIndex("NO")
  inh = spec%getIndex("NH")
  ibc = spec%getIndex("BC")
  ioc = spec%getIndex("OC")
  iso4 = spec%getIndex("SO4")
  iss = spec%getIndex("SS")
  idu = spec%getIndex("DU")

  ! ======================================================================== !
  ! Read in emission size distribution
  ALLOCATE(bin_diameter(in1a:fn2a), relative_share(in1a:fn2a))
  OPEN(ACTION='read', file=filename_emission_psd, iostat=io_status, newunit=fu_emission)
  IF (io_status /= 0) THEN
     WRITE(fu_error,*) 'Error: opening file ', filename_emission_psd, ' failed'
     STOP
  ENDIF
  READ(fu_emission, *, iostat=io_status) ! skip header
  DO i = in1a, fn2a
     READ(fu_emission, *, iostat=io_status) bin_diameter(i), relative_share(i)
  ENDDO
  CLOSE(fu_emission)

  ! Define emission_size_index = index of each dmid in the emission_size_modes array
  ALLOCATE(emission_size_index(in1a:fn2a))
  DO bb = in1a, fn2a
     DO i = 1, SIZE(emission_size_modes)
        IF (emission_size_modes(i) > aero(1,1,bb)%dmid) THEN
           emission_size_index(bb) = i-1
           EXIT
        ENDIF
     ENDDO
  ENDDO

  ! Save the background size distributions and gas concentrations
  ALLOCATE(nsect_bg(1:nbins), vsect_bg(1:nwet,1:nbins))
  nsect_bg = 0.0
  vsect_bg = 0.0
  

  ! Allocate difference arrays
  ALLOCATE(dN_dilution(nbins), dN_emission(nbins), dV_dilution(nwet,nbins), dV_emission(nwet,nbins))
  dN_dilution = 0.0
  dN_emission = 0.0
  dV_dilution = 0.0
  dV_emission = 0.0
  dg_dilution = 0.0
  dg_emission = 0.0

  ! Allocate and initialise the mass size distribution array
  rho_components(ibc) = rhobc
  rho_components(ino) = rhono
  rho_components(inh) = rhonh
  rho_components(ioc) = rhooc
  rho_components(iso4)= rhosu
  rho_components(idu) = rhodu
  rho_components(iss) = rhoss
  rho_components(iwa) = rhowa
  ALLOCATE(msect_out(1:nwet, 1:nbins))
  msect_out = 0.0
  DO bb = 1, nbins
     msect_out(:,bb) = aero(1,1,bb)%volc(1:nwet) * rho_components(1:nwet)
  END DO

  ! Print headers and background data to the output files
  WRITE(fu_output, *) header_output

  WRITE(fu_output_psd, *) header_output_psd
  WRITE(fu_output_psd, fmt_output_psd) 0., aero(1,1,:)%dmid
  WRITE(fu_output_psd, fmt_output_psd) 0., aero(1,1,:)%vlolim
  WRITE(fu_output_psd, fmt_output_psd) 0., aero(1,1,:)%vhilim
  WRITE(fu_output_psd, fmt_output_psd) 0.0, aero(1,1,:)%numc*1.e-6

  WRITE(fu_output_mpsd, fmt_output_mpsd) 0., aero(1,1,:)%dmid
  DO cc = 1, nwet
     WRITE(fu_output_mpsd, fmt_output_mpsd) 0.0, 1.0*cc, msect_out(cc,:)
  ENDDO
 
  WRITE(fu_rc, *) header_rc
  ! ======================================================================== !
  
  initialize = .TRUE.
  ! Time loop
  time = 0.
  DO tt = 1, nsteps

     write(*,*) 'Timestep: ', tt, '/', nsteps

     ! ======================================================================== !
     ! MAFOR STUFF

     CALL update_gconc(gconc, pc_h2so4, pc_ocnv, pc_ocsv, pc_hno3, pc_nh3)

     IF (emission_switch(xind) > 0) THEN
        emission = .TRUE.
     ELSE
        emission = .FALSE.
     ENDIF

     IF (initialize) THEN
        emission = .FALSE.
        dilution = .FALSE.
     ELSE
        dilution = .TRUE.
     ENDIF

     IF (dilution) THEN
        IF (distance > x_lanes(2) .AND. distance <= x_lanes(3)) THEN
           rate_of_dilution = rate_of_dilution
           h_plume = h_plume
        ELSE
           time_dilution = time_dilution + tstep
           rate_of_dilution = (-2.0 * time_dilution * 0.1**2 * 0.23**2 + 2 * 0.29 * (SQRT(2.011) + &
                             0.29 * time_dilution) / 2.011)
           h_plume = SQRT(((SQRT(2.011) + time_dilution * 0.29)**2 - (time_dilution * 0.1 * 0.23)**2) / pi)
        ENDIF

        IF (distance <= 22.5) THEN
           dilution_rate = 1.0 + rate_of_dilution * time
           DO bb = in1a, fn2b
              dN_dilution(bb) = -((aero(1,1,bb)%numc - nsect_bg(bb)) / dilution_rate**2) * rate_of_dilution
              dV_dilution(1:nwet,bb) = -((aero(1,1,bb)%volc(1:nwet) - vsect_bg(1:nwet,bb)) / &
                                         dilution_rate**2) * rate_of_dilution

           ENDDO
           dg_dilution(1:5) = -((gconc(1:5) - gconc_bg(1:5)) / dilution_rate**2) * rate_of_dilution
        ELSE
           time_after_rs = time_after_rs + tstep
           DO bb = in1a, fn2b
              dN_dilution(bb) = -(0.306 / time_after_rs) * (aero(1,1,bb)%numc - nsect_bg(bb))
              dV_dilution(1:nwet,bb) = -(0.306 / time_after_rs) * (aero(1,1,bb)%volc(1:nwet) - vsect_bg(1:nwet,bb))
           ENDDO
           dg_dilution(1:5) = -(0.306 / time_after_rs) * (gconc(1:5) - gconc_bg(1:5))
        ENDIF

     ELSE
        dN_dilution = 0.0
        dV_dilution = 0.0
     ENDIF

     IF (emission) THEN
        IF (distance < 10.0) THEN
           emission_aerosol = EF_to_north / (h_plume * lane_width_to_north)
           CALL traffic_emissions(EF_to_north, relative_share, h_plume, lane_width_to_north, &
                                  dN_emission, dV_emission, dg_emission)
        ELSE
           emission_aerosol = EF_to_south / (h_plume * lane_width_to_south)
           CALL traffic_emissions(EF_to_south, relative_share, h_plume, lane_width_to_south, &
                                  dN_emission, dV_emission, dg_emission)
        ENDIF
     ELSE
        dg_emission = 0.0
        dN_emission = 0.0
        dV_emission = 0.0
        emission_aerosol = 0.0
     ENDIF

     ! Update the concentrations
     DO bb = in1a, fn2b
        IF (dilution_master_switch) THEN
           aero(1,1,bb)%numc = aero(1,1,bb)%numc + dN_dilution(bb) * tstep
           aero(1,1,bb)%volc(1:nwet) = aero(1,1,bb)%volc(1:nwet) + dV_dilution(1:nwet,bb) * tstep
        ENDIF
        aero(1,1,bb)%numc = aero(1,1,bb)%numc + dN_emission(bb) * tstep
        aero(1,1,bb)%volc(1:nwet) = aero(1,1,bb)%volc(1:nwet) + dV_emission(1:nwet,bb) * tstep
     ENDDO
     IF (dilution_master_switch) gconc(1:5) = gconc(1:5) + dg_dilution(1:5) * tstep
     gconc(1:5) = gconc(1:5) + dg_emission(1:5) * tstep

     CALL update_pcs(gconc, pc_h2so4, pc_ocnv, pc_ocsv, pc_hno3, pc_nh3)

     ! ======================================================================== !

     DO tt_salsa = 1, 50

        ! Set the SALSA runtime config (takes into account process delays etc.)
        CALL set_salsa_runtime(time,tstep_salsa,tt_salsa)

        ! Update some particle properties (if this is done within the processes, it's not neede here. Doesn't hurt though.)
        DO bb = 1, ntotal
           CALL allSALSA(1,1,bb)%updateDiameter(.FALSE.,type="all")
           CALL allSALSA(1,1,bb)%updateRhomean()

           !!! WHERE IS THIS NEEDED? as far as I know it is not...
           IF (allSALSA(1,1,bb)%numc > allSALSA(1,1,bb)%nlim) THEN
              allSALSA(1,1,bb)%core = SUM(allSALSA(1,1,bb)%volc(1:ndry))/allSALSA(1,1,bb)%numc
           ELSE
              allSALSA(1,1,bb)%core = pi6*(allSALSA(1,1,bb)%dmid)**3
           END IF
        END DO

        !!!! WOULD IT BE BETTER TO CALL THIS IN SOME DEDICATED INITIALIZATION LOOP
        IF (tt > 1 .AND. tt_salsa > 1)  initialize = .FALSE.
        zrh = 0.9  ! Used for the initialization call only...     
        ! If this is an initialization call, calculate the equilibrium particle
        If (initialize)   &
             CALL equilibration(kproma,kbdim,klev,zrh,ptemp,.TRUE.)
           
        ! Reset process rate diagnostics
        CALL rateDiag%Reset()

        ! If reduced coagulation kernel update freq, and NOT update timestep,
        !copy kernels from memory
        IF ( lscoag%mode == 2 .AND. .NOT. lcgupdt) &
             CALL fetch_coag(1,1,1) ! Note the indices are currently written for UCLALES-SALSA; HOW TO DEAL WITH THIS 
                                    ! This also requires some additional storage from host model
     
        CALL salsa(ppres,    prv, prs, prsi,    ptemp,  tstep_salsa,     &
                   pc_h2so4, pc_ocnv,  pc_ocsv, pc_hno3,    &
                   pc_nh3,   pactd,    pw,      level )
        
        ! ======================================================================== !
        IF (initialize) THEN
           DO bb = 1, nbins
              nsect_bg(bb) = aero(1,1,bb)%numc
              vsect_bg(1:nwet,bb) = aero(1,1,bb)%volc(1:nwet)
           ENDDO
           gconc_bg(1) = pc_h2so4(1,1)
           gconc_bg(2) = pc_ocnv(1,1)
           gconc_bg(3) = pc_ocsv(1,1)
           gconc_bg(4) = pc_hno3(1,1)
           gconc_bg(5) = pc_nh3(1,1)
        ELSE
           ! Deposition by Zhang et al. (2001)

           IF (deposition) CALL depo_zhang2001(h_plume, ptemp(1,1))

           ! Limit the minimum aerosol mass per bin per component
           DO bb = 1, nbins
              DO cc = 1, nwet
                 aero(1,1,bb)%volc(cc) = MAX(1.0e-99, aero(1,1,bb)%volc(cc))
              ENDDO
           ENDDO
        ENDIF
        ! ======================================================================== !
          
        ! Saturation vapor mix rats; WOULD IT BE BETTER TO CALCULATE THESE INSIDE SALSA, NOT NEEDED IN VERY MANY PLACES
        CALL satmixrat_l(kbdim,klev,ppres,ptemp,prs)  
        CALL satmixrat_i(kbdim,klev,ppres,ptemp,prsi)

        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
        ! Latent heating etc missing!!
        ! !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
        
        ! If reduced coagulation kernel update frequency and is update timestep, store the updated kernels
        IF (lscoag%mode == 2 .AND. lcgupdt) &
             CALL store_coag(1,1,1)  ! Same as with fetch

     ENDDO !! salsa time stepping
          
     ! ======================================================================== !
     if (dilution) then
        if (distance <= 22.5) THEN
           unit_conc = unit_conc - (unit_conc / dilution_rate**2) * rate_of_dilution * tstep
        else
           unit_conc = unit_conc - (0.306 / time_after_rs) * unit_conc * tstep
        endif
     endif

     ! Write output to a file
     IF (.NOT. initialize) THEN
     
        IF (MOD(tt, 1)==0) THEN
           mass = SUM(aero(1,1,:)%volc(iso4)) * rhosu + SUM(aero(1,1,:)%volc(ioc)) * rhooc + &
                  SUM(aero(1,1,:)%volc(ibc)) * rhobc  + SUM(aero(1,1,:)%volc(ino)) * rhono + &
                  SUM(aero(1,1,:)%volc(inh)) * rhonh  + SUM(aero(1,1,:)%volc(idu)) * rhodu + &
                  SUM(aero(1,1,:)%volc(iss)) * rhoss  !!+ SUM(aero(1,1,:)%volc(iwa)) * rhowa

           WRITE(fu_output, fmt_output) time, ptemp(1,1), prv(1,1)*1.e3, prv(1,1)/prs(1,1), &
                                        pc_h2so4(1,1), pc_ocnv(1,1), pc_ocsv(1,1), pc_hno3(1,1), pc_nh3(1,1), &
                                        SUM(aero(1,1,:)%volc(iso4)), SUM(aero(1,1,:)%volc(ioc)), &
                                        SUM(aero(1,1,:)%volc(ibc)), SUM(aero(1,1,:)%volc(ino)),  &
                                        SUM(aero(1,1,:)%volc(inh)), SUM(aero(1,1,:)%volc(idu)),  &
                                        SUM(aero(1,1,:)%volc(iss)), SUM(aero(1,1,:)%volc(iwa)),  &
                                        SUM(aero(1,1,:)%numc)*1.e-6, mass * 1.0E9

           WRITE(fu_output_psd, fmt_output_psd) time, aero(1,1,:)%numc*1.e-6

           WRITE(fu_rc, fmt_rc) time, distance, h_plume, rate_of_dilution, emission_aerosol, unit_conc

           DO bb = 1, nbins
              msect_out(:,bb) = aero(1,1,bb)%volc(1:nwet) * rho_components(1:nwet)
           ENDDO

           DO cc = 1, nwet
              WRITE(fu_output_mpsd, fmt_output_mpsd) time, 1.0*cc, msect_out(cc,:)
           ENDDO

        ENDIF
     
        distance = distance + wind_speed * tstep
        DO i = 1, SIZE(x_lanes)
           IF (x_lanes(i) > distance) THEN
              xind = i-1
              EXIT
           ENDIF
        ENDDO
     
        time = time + tstep
     ENDIF
     
     ! ======================================================================== !

  END DO

  CLOSE(fu_error)
  CLOSE(fu_output)
  CLOSE(fu_output_psd)

  CONTAINS

    !
    !---------------------------------------------------------------
    ! SET_SALSA_RUNTIME
    ! Set the master process %state:s based on the values of %switch and %delay.
    ! Added some new time-dependent switches
    !
    ! Juha Tonttila, FMI, 2014;2020
    !
    SUBROUTINE set_SALSA_runtime(time, tstep, istp)
      IMPLICIT NONE
      REAL, INTENT(in) :: time, tstep
      INTEGER, INTENT(in) :: istp
      INTEGER :: i
      
      ! All the non-interface parameters used below are found in mo_submctl
      
      DO i = 1,Nmaster
         IF( lsmaster(i)%switch .AND. time >= lsmaster(i)%delay ) lsmaster(i)%state = .TRUE.
      END DO
      
      ! Some other switches
      ! Constraining RH in condensation
      IF ( lsfreeRH%switch .AND. time > lsfreeRH%delay ) lsfreeRH%state = .TRUE.
      
      ! Constraining contact angle in ice nucleation
      IF ( lsFreeTheta%switch .AND. time > lsFreeTheta%delay) lsFreeTheta%state = .TRUE.
      
      ! Determine coagulation kernel update status if low freq updating is active
      lcgupdt = ( lscoag%state .AND. lscoag%mode == 2 .AND.    &
           (MOD(time,cgintvl) < tstep .OR. istp <= 1)   ) ! Making sure the kernels
                                                          ! are calculated on the first
                                                          ! timestep of HISTORY runs
      
    END SUBROUTINE set_SALSA_runtime
    

   !
   ! ----------------------------------------------------
   ! Initializes the coagulation kernel storage 
   !
   SUBROUTINE initialize_coagstorage(nzp,nxp,nyp)
     INTEGER, INTENT(in) :: nxp,nyp,nzp

     IF (lscgaa) THEN
        ALLOCATE(sto_aa(nzp,nxp,nyp,nbins,nbins))
        sto_aa = 0.
     END IF
     IF (lscgcc) THEN
        ALLOCATE(sto_cc(nzp,nxp,nyp,ncld,ncld))
        sto_cc = 0.
     END IF
     IF (lscgpp) THEN
        ALLOCATE(sto_pp(nzp,nxp,nyp,nprc,nprc))
        sto_pp = 0.
     END IF
     IF (lscgii) THEN
        ALLOCATE(sto_ii(nzp,nxp,nyp,nice,nice))
        sto_ii = 0.
     END IF
        
     IF (lscgca) THEN
        ALLOCATE(sto_ca(nzp,nxp,nyp,nbins,ncld))
        sto_ca = 0.
     END IF
     IF (lscgpa) THEN
        ALLOCATE(sto_pa(nzp,nxp,nyp,nbins,nprc))
        sto_pa = 0.
     END IF
     IF (lscgia) THEN
        ALLOCATE(sto_ia(nzp,nxp,nyp,nbins,nice))
        sto_ia = 0.
     END IF

     IF (lscgpc) THEN
        ALLOCATE(sto_pc(nzp,nxp,nyp,ncld,nprc))
        sto_pc = 0.
     END IF
     IF (lscgic) THEN
        ALLOCATE(sto_ic(nzp,nxp,nyp,ncld,nice))
        sto_ic = 0.
     END IF
        
     IF (lscgip) THEN
        ALLOCATE(sto_ip(nzp,nxp,nyp,nice,nprc))
        sto_ip = 0.     
     END IF

     cgsto_initialized = .TRUE.
     
   END SUBROUTINE initialize_coagstorage
   
   !
   ! ------------------------------------------------------
   ! Store updated coagulation kernels
   !
   SUBROUTINE store_coag(kk,ii,jj)
     INTEGER, INTENT(in) :: ii,jj,kk
     
     IF (lscgaa) sto_aa(kk,ii,jj,:,:) = zccaa(1,1,:,:)
     IF (lscgcc) sto_cc(kk,ii,jj,:,:) = zcccc(1,1,:,:)
     IF (lscgpp) sto_pp(kk,ii,jj,:,:) = zccpp(1,1,:,:)
     IF (lscgii) sto_ii(kk,ii,jj,:,:) = zccii(1,1,:,:)

     IF (lscgca) sto_ca(kk,ii,jj,:,:) = zccca(1,1,:,:)
     IF (lscgpa) sto_pa(kk,ii,jj,:,:) = zccpa(1,1,:,:)
     IF (lscgia) sto_ia(kk,ii,jj,:,:) = zccia(1,1,:,:)

     IF (lscgpc) sto_pc(kk,ii,jj,:,:) = zccpc(1,1,:,:)
     IF (lscgic) sto_ic(kk,ii,jj,:,:) = zccic(1,1,:,:)

     IF (lscgip) sto_ip(kk,ii,jj,:,:) = zccip(1,1,:,:)
     
   END SUBROUTINE store_coag

   !
   ! -----------------------------------------------------
   ! Copy coagulation kernels from storage for current timestep,
   ! i.e. avoid calculating new ones
   !
   SUBROUTINE fetch_coag(kk,ii,jj)
     INTEGER, INTENT(in) :: ii,jj,kk

     IF (lscgaa) zccaa(1,1,:,:) = sto_aa(kk,ii,jj,:,:) 
     IF (lscgcc) zcccc(1,1,:,:) = sto_cc(kk,ii,jj,:,:) 
     IF (lscgpp) zccpp(1,1,:,:) = sto_pp(kk,ii,jj,:,:)
     IF (lscgii) zccii(1,1,:,:) = sto_ii(kk,ii,jj,:,:)

     IF (lscgca) zccca(1,1,:,:) = sto_ca(kk,ii,jj,:,:)
     IF (lscgpa) zccpa(1,1,:,:) = sto_pa(kk,ii,jj,:,:) 
     IF (lscgia) zccia(1,1,:,:) = sto_ia(kk,ii,jj,:,:) 

     IF (lscgpc) zccpc(1,1,:,:) = sto_pc(kk,ii,jj,:,:) 
     IF (lscgic) zccic(1,1,:,:) = sto_ic(kk,ii,jj,:,:) 

     IF (lscgip) zccip(1,1,:,:) = sto_ip(kk,ii,jj,:,:)
     
   END SUBROUTINE fetch_coag

   !
   ! -----------------------------------------------------
   ! Increase aerosol number and mass and gas concentrations by traffic emissions
   !
   SUBROUTINE traffic_emissions(emission_factor, psd, plume_height, street_width, dN, dV, dg)
      REAL, INTENT(in) :: emission_factor
      REAL, INTENT(in) :: plume_height
      REAL, INTENT(in) :: street_width
      REAL, INTENT(in) :: psd(:)
      REAL, INTENT(inout) :: dg(1:5)
      REAL, INTENT(inout) :: dN(:)
      REAL, INTENT(inout) :: dV(:,:)

      INTEGER :: bb ! loop index for bins
      INTEGER :: esi ! index in the emission_size_index
      INTEGER :: ibc, ioc, iwa
      REAL :: core
      REAL :: normalizer

      normalizer = 1.0 / (plume_height * street_width)

      ! Aerosol emissions:

      ibc = spec%getIndex("BC", notFoundValue = 0)
      ioc = spec%getIndex("OC", notFoundValue = 0)
      iwa = spec%getIndex("H2O", notFoundValue = 0)

      DO bb = in1a, fn2a

         core = pi6 * aero(1,1,bb)%dmid**3

         ! Add number
         dN(bb) = emission_factor * normalizer * psd(bb)

         ! Find index
         esi = emission_size_index(bb)

         ! Add mass. Also add a tiny amount of water due to a condensation issue.
         dV(ibc,bb) = dN(bb) * emission_mass_frac_bc(esi) * core
         dV(ioc,bb) = dN(bb) * emission_mass_frac_oc(esi) * core
         dV(iwa,bb) = dN(bb) * 1.0E-6 * core
      ENDDO

      ! Gas emissions:
      IF (street_width < (lane_width_to_south - 0.5)) THEN
         dg(1) = 2.49E14 * normalizer
         dg(3) = 5.31E14 * normalizer
      ELSE
         dg(1) = 1.85E14 * normalizer
         dg(3) = 3.94E14 * normalizer
      ENDIF

   END SUBROUTINE traffic_emissions

   SUBROUTINE update_gconc(conc_array, c_h2so4, c_ocnv, c_ocsv, c_hno3, c_nh3)
      REAL, INTENT(in) :: c_h2so4(1,1)
      REAL, INTENT(in) :: c_ocnv(1,1)
      REAL, INTENT(in) :: c_ocsv(1,1)
      REAL, INTENT(in) :: c_hno3(1,1)
      REAL, INTENT(in) :: c_nh3(1,1)
      REAL, INTENT(inout) :: conc_array(1:5)

      conc_array(1) = c_h2so4(1,1)
      conc_array(2) = c_ocnv(1,1)
      conc_array(3) = c_ocsv(1,1)
      conc_array(4) = c_hno3(1,1)
      conc_array(5) = c_nh3(1,1)

   END SUBROUTINE update_gconc

   SUBROUTINE update_pcs(conc_array, c_h2so4, c_ocnv, c_ocsv, c_hno3, c_nh3)
      REAL, INTENT(inout) :: c_h2so4(1,1)
      REAL, INTENT(inout) :: c_ocnv(1,1)
      REAL, INTENT(inout) :: c_ocsv(1,1)
      REAL, INTENT(inout) :: c_hno3(1,1)
      REAL, INTENT(inout) :: c_nh3(1,1)
      REAL, INTENT(in) :: conc_array(1:5)

      c_h2so4(1,1) = conc_array(1)
      c_ocnv(1,1) = conc_array(2)
      c_ocsv(1,1) = conc_array(3)
      c_hno3(1,1) = conc_array(4)
      c_nh3(1,1) = conc_array(5)

   END SUBROUTINE update_pcs
   
   SUBROUTINE depo_zhang2001(h, tk)
   
      REAL, INTENT(in) :: h  ! plume height (m)
      REAL, INTENT(in) :: tk ! temperature in kelvins
      
      REAL, PARAMETER :: adn = 1.3 ! air density
      REAL, PARAMETER :: alpha = 1.5 !
      REAL, PARAMETER :: am_airmol = 4.8096E-26 ! Average mass of an air molecule
      REAL, PARAMETER :: dcol = 0.002 ! collector size (m)
      REAL, PARAMETER :: gamma = 0.56 ! 
      REAL, PARAMETER :: pdn = 1500.0 ! particle density
      REAL, PARAMETER :: ustar = 0.52  ! friction velocity (m/s)
      REAL, PARAMETER :: z0 = 0.4 ! roughness length (m)
      REAL, PARAMETER :: zC = 10.0 ! canopy height (m)

      REAL :: avis   ! molecular viscocity
      REAL :: depo   !
      REAL :: kvis   ! kinematic viscocity
      REAL :: lambda !
      REAL :: mdiff  !
      REAL :: ra     !
      REAL :: rs     !
      REAL :: Sc     !
      REAL :: St     !
      REAL :: va     !
      
      REAL :: beta(1:nbins)  !
      REAL :: Kn(1:nbins)    !
      REAL :: vc(1:nbins)    !
      REAL :: zdwet(1:nbins) !
      
      INTEGER :: bb
      
      ! Molecular viscosity of air (Eq. 4.54)
      avis = 1.8325E-5 * ( 416.16 / ( tk + 120.0 ) ) * ( tk / 296.16 )**1.5
   
      ! Kinematic viscocity
      kvis = avis / adn

      ! Thermal velocity of an air molecule (Eq. 15.32)
      va = SQRT( 8.0 * boltz * tk / ( pi * am_airmol ) )

      ! Mean free path (m) (Eq. 15.24)
      lambda = 2.0 * avis / ( adn * va )

      ! Particle wet diameter (m)
      zdwet = aero(1,1,1:nbins)%dwet

      ! Knudsen number (Eq. 15.23)
      Kn = MAX( 1.0E-2, lambda / ( zdwet * 0.5 ) ) ! To avoid underflow

      ! Cunningham slip-flow correction
      beta = 1.0 + Kn * ( 1.257 + 0.4 * EXP( -1.1 / Kn ) )

      ! Critical fall speed i.e. settling velocity  (Eq. 20.4)
      vc = MIN(1.0, zdwet**2 * (pdn - adn) * grav * beta / (18.0 * avis))
      
      ! Aerodynamic resistance
      ra = LOG(h / z0) / (0.4 * ustar)
      
      DO bb = 1, nbins
      
         ! Stokes number
         St = vc(bb) * ustar**2 / kvis  ! for surfaces with bluff roughness elements
         
         ! Particle diffusivity coefficient (Eq. 15.29)
         mdiff = (boltz * tk * beta(bb)) / (3.0 * pi * avis * zdwet(bb))
         
         ! Schmidt number
         Sc = kvis / mdiff
      
         ! The overall quasi-laminar resistance for particles (Zhang et al., Eq. 5)
         rs = MAX(EPSILON(1.0), (3.0 * ustar * EXP(-St**0.5) * (Sc**(-gamma) + &
                                 (St / (alpha + St))**2 + 0.5 * (zdwet(bb) / dcol)**2)&
                                 )&
                 )
         rs = 1.0 / rs

         ! Total deposition velocity
         depo = vc(bb) + 1.0 / (ra + rs)
         
         ! Calculate the change in concentrations
         aero(1,1,bb)%numc = aero(1,1,bb)%numc * EXP(-depo * tstep_salsa / h * 0.7)
         aero(1,1,bb)%volc(:) = aero(1,1,bb)%volc(:) * EXP(-depo * tstep_salsa / h * 0.7)

      ENDDO
   
   END SUBROUTINE depo_zhang2001
    
END PROGRAM mafor_salsa_box_driver
  
