library(openair)

### Print modStats from aerosol dynamics models for the urban case

# Relative directory path of openair/data file
datafile <- "./data/ucdata_bc.csv"
# Relative directory path of statistic output file
compdir <- "./comp/"

# AE22/BC - MAFOR - SALSA
mydata<-read.csv(file = datafile, header = T, sep = ";", na.strings = "-999")[,1:5]
colnames(mydata) <- c("date","obs","mod","model","scenario")

mydata$date <- as.POSIXct(mydata$date, format =  "%d.%m.%Y %H:%M", tz = "GMT")
date <- mydata$date
#print(date)

dfmydata <- data.frame(mydata)
#print(dfmydata)


### Statistics
setwd(compdir)
openAir_modStatsPN <- modStats(dfmydata, type = "model", rank.name = dfmydata$model )
write.csv(openAir_modStatsPN, file=paste("urbancase_stats_bc.csv",sep="_"), row.names = F, quote = F)


