
%%% PLOT SCRIPT
%%% SENSITIVITY ORGANIC VAPORS
%%% FIGURE 14
%%% USE GNU OCTAVE

clear

%REFERENCE
load ../mafor/output_ALL/wetdp.res;
load ../mafor/output_ALL/size_dism.res;

%SENS5 [EF(SVOC)x50]
%load ../mafor/output_SENS5/wetdp.res;
%load ../mafor/output_SENS5/size_dism.res;

infiledp='wetdp.res';
indp=strrep(infiledp,'.res','');
dp=eval(indp);
[rowdp,coldp]=size(dp);
% t0
diameter_bin00=dp(4+0,2:coldp)*1e9;
% 6s
diameter_bin01=dp(4+55,2:coldp)*1e9; 
% 30s
diameter_bin02=dp(4+305,2:coldp)*1e9; 
% 50s
diameter_bin03=dp(1+505,2:coldp)*1e9;
% 78s
diameter_bin04=dp(1+785,2:coldp)*1e9; 

% Mass distribution
infileam='size_dism.res';
inam=strrep(infileam,'.res','');
yam=eval(inam);
[row,col]=size(yam);                    %row=xxx col=61

o= 1;
a= 55*21 +1;   %   55 x 21 + 1
b=305*21 +1;   %  305 x 21 + 1 
c=505*21 +1;   %  505 x 21 + 1
d=785*21 +1;   %  785 x 21 + 1

%TOTAL MASS kg/m3-->ng/m3
dmdlogdp_bin00=yam(o,2:col)   *1e12  *2.303;
dmdlogdp_bin01=yam(a,2:col)   *1e12  *2.303;
dmdlogdp_bin02=yam(b,2:col)   *1e12  *2.303;
dmdlogdp_bin03=yam(c,2:col)   *1e12  *2.303; 
dmdlogdp_bin04=yam(d,2:col)   *1e12  *2.303; 

%Sulfate ng/m3
dmdlogdp_bin00_sul=yam(o+1,2:col)    *2.303;
dmdlogdp_bin01_sul=yam(a+1,2:col)    *2.303;
dmdlogdp_bin02_sul=yam(b+1,2:col)    *2.303; 
dmdlogdp_bin03_sul=yam(c+1,2:col)    *2.303; 
dmdlogdp_bin04_sul=yam(d+1,2:col)    *2.303; 

%SOA-7 ng/m3 (PIOV)
dmdlogdp_bin00_adi=yam(o+12,2:col)    *2.303; 
dmdlogdp_bin01_adi=yam(a+12,2:col)    *2.303; 
dmdlogdp_bin02_adi=yam(b+12,2:col)    *2.303; 
dmdlogdp_bin03_adi=yam(c+12,2:col)    *2.303; 
dmdlogdp_bin04_adi=yam(d+12,2:col)    *2.303; 

%SOA-8 ng/m3 (PSOV)
dmdlogdp_bin00_sov=yam(o+13,2:col)   *2.303;
dmdlogdp_bin01_sov=yam(a+13,2:col)   *2.303;
dmdlogdp_bin02_sov=yam(b+13,2:col)   *2.303; 
dmdlogdp_bin03_sov=yam(c+13,2:col)   *2.303; 
dmdlogdp_bin04_sov=yam(d+13,2:col)   *2.303; 

%SOOT
dmdlogdp_bin00_ebc=yam(o+17,2:col)   *2.303; 
dmdlogdp_bin01_ebc=yam(a+17,2:col)   *2.303; 
dmdlogdp_bin02_ebc=yam(b+17,2:col)   *2.303; 
dmdlogdp_bin03_ebc=yam(c+17,2:col)   *2.303; 
dmdlogdp_bin04_ebc=yam(d+17,2:col)   *2.303; 

%POM (=PBA)
dmdlogdp_bin00_pom=yam(o+19,2:col)   *2.303; 
dmdlogdp_bin01_pom=yam(a+19,2:col)   *2.303; 
dmdlogdp_bin02_pom=yam(b+19,2:col)   *2.303; 
dmdlogdp_bin03_pom=yam(c+19,2:col)   *2.303; 
dmdlogdp_bin04_pom=yam(d+19,2:col)   *2.303; 

%H2O
dmdlogdp_bin00_wat=yam(o+20,2:col)   *2.303;
dmdlogdp_bin01_wat=yam(a+20,2:col)   *2.303;
dmdlogdp_bin02_wat=yam(b+20,2:col)   *2.303; 
dmdlogdp_bin03_wat=yam(c+20,2:col)   *2.303; 
dmdlogdp_bin04_wat=yam(d+20,2:col)   *2.303;

dlogdp=0.5805E-01;
w1=50.0;
w2=110.0;
w3=340.0;
w4=840.0;



% Divide four ranges of size distribution
for i=1:120
X(i) = diameter_bin01(i);
W1(i) =       dmdlogdp_bin01_wat(i)*1.e-3*dlogdp;
P1(i) = W1(i)+dmdlogdp_bin01_pom(i)*1.e-3*dlogdp;
B1(i) = P1(i)+dmdlogdp_bin01_ebc(i)*1.e-3*dlogdp;
S1(i) = B1(i)+dmdlogdp_bin01_sul(i)*1.e-3*dlogdp;
I1(i) = S1(i)+dmdlogdp_bin01_sov(i)*1.e-3*dlogdp;
J1(i) = I1(i)+dmdlogdp_bin01_adi(i)*1.e-3*dlogdp;
if (i>64)
  W1(i)=0; P1(i)=0; B1(i)=0; S1(i)=0; I1(i)=0; J1(i)=0;
end
end
for i=1:120
if (i<65) || (i>80)
  W2(i)=0; P2(i)=0; B2(i)=0; S2(i)=0; I2(i)=0; J2(i)=0;
else
  W2(i) =       dmdlogdp_bin01_wat(i)*1.e-3*dlogdp;
  P2(i) = W2(i)+dmdlogdp_bin01_pom(i)*1.e-3*dlogdp;
  B2(i) = P2(i)+dmdlogdp_bin01_ebc(i)*1.e-3*dlogdp;
  S2(i) = B2(i)+dmdlogdp_bin01_sul(i)*1.e-3*dlogdp;
  I2(i) = S2(i)+dmdlogdp_bin01_sov(i)*1.e-3*dlogdp;
  J2(i) = I2(i)+dmdlogdp_bin01_adi(i)*1.e-3*dlogdp;
end
end
for i=1:120
if (i<81) || (i>100)
  W3(i)=0; P3(i)=0; B3(i)=0; S3(i)=0; I3(i)=0; J3(i)=0;
else
  W3(i) =       dmdlogdp_bin01_wat(i)*1.e-3*dlogdp;
  P3(i) = W3(i)+dmdlogdp_bin01_pom(i)*1.e-3*dlogdp;
  B3(i) = P3(i)+dmdlogdp_bin01_ebc(i)*1.e-3*dlogdp;
  S3(i) = B3(i)+dmdlogdp_bin01_sul(i)*1.e-3*dlogdp;
  I3(i) = S3(i)+dmdlogdp_bin01_sov(i)*1.e-3*dlogdp;
  J3(i) = I3(i)+dmdlogdp_bin01_adi(i)*1.e-3*dlogdp;
end
end
for i=1:120
if (i<101)
  W4(i)=0; P4(i)=0; B4(i)=0; S4(i)=0; I4(i)=0; J4(i)=0;
else
  W4(i) =       dmdlogdp_bin01_wat(i)*1.e-3*dlogdp;
  P4(i) = W4(i)+dmdlogdp_bin01_pom(i)*1.e-3*dlogdp;
  B4(i) = P4(i)+dmdlogdp_bin01_ebc(i)*1.e-3*dlogdp;
  S4(i) = B4(i)+dmdlogdp_bin01_sul(i)*1.e-3*dlogdp;
  I4(i) = S4(i)+dmdlogdp_bin01_sov(i)*1.e-3*dlogdp;
  J4(i) = I4(i)+dmdlogdp_bin01_adi(i)*1.e-3*dlogdp;
end
end

% Create stacked bar graphs
figure(2);clf
axes('fontsize',16,'tickdir','out')
p1=bar(X,J1,w1,'stacked'); hold on;
ax=gca;
set(ax,'fontsize',16,'tickdir','out')
o1=bar(X,I1,w1,'stacked');
n1=bar(X,S1,w1,'stacked');
m1=bar(X,B1,w1,'stacked');
l1=bar(X,P1,w1,'stacked');
k1=bar(X,W1,w1,'stacked');
p2=bar(X,J2,w2,'stacked');
o2=bar(X,I2,w2,'stacked');
n2=bar(X,S2,w2,'stacked');
m2=bar(X,B2,w2,'stacked');
l2=bar(X,P2,w2,'stacked');
k2=bar(X,W2,w2,'stacked');
p3=bar(X,J3,w3,'stacked');
o3=bar(X,I3,w3,'stacked');
n3=bar(X,S3,w3,'stacked');
m3=bar(X,B3,w3,'stacked');
l3=bar(X,P3,w3,'stacked');
k3=bar(X,W3,w3,'stacked');
p4=bar(X,J4,w4,'stacked');
o4=bar(X,I4,w4,'stacked');
n4=bar(X,S4,w4,'stacked');
m4=bar(X,B4,w4,'stacked');
l4=bar(X,P4,w4,'stacked');
k4=bar(X,W4,w4,'stacked');
%water
set(k1,'facecolor',[0 0.447 0.741])
set(k1,'edgecolor','none')
set(k2,'facecolor',[0 0.447 0.741])
set(k2,'edgecolor','none')
set(k3,'facecolor',[0 0.447 0.741])
set(k3,'edgecolor','none')
set(k4,'facecolor',[0 0.447 0.741])
set(k4,'edgecolor','none')
%POM
set(l1,'facecolor',[0.85 0.325 0.098])
set(l1,'edgecolor','none')
set(l2,'facecolor',[0.85 0.325 0.098])
set(l2,'edgecolor','none')
set(l3,'facecolor',[0.85 0.325 0.098])
set(l3,'edgecolor','none')
set(l4,'facecolor',[0.85 0.325 0.098])
set(l4,'edgecolor','none')
%BC
set(m1,'facecolor','k')
set(m1,'edgecolor','none')
set(m2,'facecolor','k')
set(m2,'edgecolor','none')
set(m3,'facecolor','k')
set(m3,'edgecolor','none')
set(m4,'facecolor','k')
set(m4,'edgecolor','none')
%SO4
set(n1,'facecolor','b')
set(n1,'edgecolor','none')
set(n2,'facecolor','b')
set(n2,'edgecolor','none')
set(n3,'facecolor','b')
set(n3,'edgecolor','none')
set(n4,'facecolor','b')
set(n4,'edgecolor','none')
%PSOV
set(o1,'facecolor','g')
set(o1,'edgecolor','none')
set(o2,'facecolor','g')
set(o2,'edgecolor','none')
set(o3,'facecolor','g')
set(o3,'edgecolor','none')
set(o4,'facecolor','g')
set(o4,'edgecolor','none')
%PIOV
set(p1,'facecolor',[0.635 0.078 0.184])
set(p1,'edgecolor','none')
set(p2,'facecolor',[0.635 0.078 0.184])
set(p2,'edgecolor','none')
set(p3,'facecolor',[0.635 0.078 0.184])
set(p3,'edgecolor','none')
set(p4,'facecolor',[0.635 0.078 0.184])
set(p4,'edgecolor','none')
[g]=legend('PIOV','PSOV','sulfate','soot','POM','water','Location','NorthWest');
set(g,'fontsize',14);
grid off
set(gca,'Layer','top')
xlabel('particle diameter (nm)','FontSize',16)
ylabel('mass conc. per bin ({\mu}g m^{-3})','FontSize',16)
title('Time 5.5s','FontSize',16)
set(gca,'xscale','log','FontSize',16)
set(gca,'XLim',[1. 1000.])
set(gca,'YLim',[0. 1.8])
ty=0:0.2:2;
set(gca,'ytick',ty);
set(gca,'yTickLabel',{'0.0','0.2','0.4','0.6','0.8','1.0','1.2','1.4','1.6','1.8','2.0'})

print -djpg '../plots/Figure14a.jpg'
%print -djpg '../plots/Figure14b.jpg'



% Divide four ranges of size distribution
for i=1:120
X(i) = diameter_bin04(i);
W1(i) =       dmdlogdp_bin04_wat(i)*1.e-3*dlogdp;
P1(i) = W1(i)+dmdlogdp_bin04_pom(i)*1.e-3*dlogdp;
B1(i) = P1(i)+dmdlogdp_bin04_ebc(i)*1.e-3*dlogdp;
S1(i) = B1(i)+dmdlogdp_bin04_sul(i)*1.e-3*dlogdp;
I1(i) = S1(i)+dmdlogdp_bin04_sov(i)*1.e-3*dlogdp;
J1(i) = I1(i)+dmdlogdp_bin04_adi(i)*1.e-3*dlogdp;
if (i>64)
  W1(i)=0; P1(i)=0; B1(i)=0; S1(i)=0; I1(i)=0; J1(i)=0;
end
end
for i=1:120
if (i<65) || (i>80)
  W2(i)=0; P2(i)=0; B2(i)=0; S2(i)=0; I2(i)=0; J2(i)=0;
else
  W2(i) =       dmdlogdp_bin04_wat(i)*1.e-3*dlogdp;
  P2(i) = W2(i)+dmdlogdp_bin04_pom(i)*1.e-3*dlogdp;
  B2(i) = P2(i)+dmdlogdp_bin04_ebc(i)*1.e-3*dlogdp;
  S2(i) = B2(i)+dmdlogdp_bin04_sul(i)*1.e-3*dlogdp;
  I2(i) = S2(i)+dmdlogdp_bin04_sov(i)*1.e-3*dlogdp;
  J2(i) = I2(i)+dmdlogdp_bin04_adi(i)*1.e-3*dlogdp;
end
end
for i=1:120
if (i<81) || (i>100)
  W3(i)=0; P3(i)=0; B3(i)=0; S3(i)=0; I3(i)=0; J3(i)=0;
else
  W3(i) =       dmdlogdp_bin04_wat(i)*1.e-3*dlogdp;
  P3(i) = W3(i)+dmdlogdp_bin04_pom(i)*1.e-3*dlogdp;
  B3(i) = P3(i)+dmdlogdp_bin04_ebc(i)*1.e-3*dlogdp;
  S3(i) = B3(i)+dmdlogdp_bin04_sul(i)*1.e-3*dlogdp;
  I3(i) = S3(i)+dmdlogdp_bin04_sov(i)*1.e-3*dlogdp;
  J3(i) = I3(i)+dmdlogdp_bin04_adi(i)*1.e-3*dlogdp;
end
end
for i=1:120
if (i<101)
  W4(i)=0; P4(i)=0; B4(i)=0; S4(i)=0; I4(i)=0; J4(i)=0;
else
  W4(i) =       dmdlogdp_bin04_wat(i)*1.e-3*dlogdp;
  P4(i) = W4(i)+dmdlogdp_bin04_pom(i)*1.e-3*dlogdp;
  B4(i) = P4(i)+dmdlogdp_bin04_ebc(i)*1.e-3*dlogdp;
  S4(i) = B4(i)+dmdlogdp_bin04_sul(i)*1.e-3*dlogdp;
  I4(i) = S4(i)+dmdlogdp_bin04_sov(i)*1.e-3*dlogdp;
  J4(i) = I4(i)+dmdlogdp_bin04_adi(i)*1.e-3*dlogdp;
end
end

% Create stacked bar graphs
figure(3);clf
axes('fontsize',16,'tickdir','out')
p1=bar(X,J1,w1,'stacked'); hold on;
ax=gca;
set(ax,'fontsize',16,'tickdir','out')
o1=bar(X,I1,w1,'stacked');
n1=bar(X,S1,w1,'stacked');
m1=bar(X,B1,w1,'stacked');
l1=bar(X,P1,w1,'stacked');
k1=bar(X,W1,w1,'stacked');
p2=bar(X,J2,w2,'stacked');
o2=bar(X,I2,w2,'stacked');
n2=bar(X,S2,w2,'stacked');
m2=bar(X,B2,w2,'stacked');
l2=bar(X,P2,w2,'stacked');
k2=bar(X,W2,w2,'stacked');
p3=bar(X,J3,w3,'stacked');
o3=bar(X,I3,w3,'stacked');
n3=bar(X,S3,w3,'stacked');
m3=bar(X,B3,w3,'stacked');
l3=bar(X,P3,w3,'stacked');
k3=bar(X,W3,w3,'stacked');
p4=bar(X,J4,w4,'stacked');
o4=bar(X,I4,w4,'stacked');
n4=bar(X,S4,w4,'stacked');
m4=bar(X,B4,w4,'stacked');
l4=bar(X,P4,w4,'stacked');
k4=bar(X,W4,w4,'stacked');
%water
set(k1,'facecolor',[0 0.447 0.741])
set(k1,'edgecolor','none')
set(k2,'facecolor',[0 0.447 0.741])
set(k2,'edgecolor','none')
set(k3,'facecolor',[0 0.447 0.741])
set(k3,'edgecolor','none')
set(k4,'facecolor',[0 0.447 0.741])
set(k4,'edgecolor','none')
%POM
set(l1,'facecolor',[0.85 0.325 0.098])
set(l1,'edgecolor','none')
set(l2,'facecolor',[0.85 0.325 0.098])
set(l2,'edgecolor','none')
set(l3,'facecolor',[0.85 0.325 0.098])
set(l3,'edgecolor','none')
set(l4,'facecolor',[0.85 0.325 0.098])
set(l4,'edgecolor','none')
%BC
set(m1,'facecolor','k')
set(m1,'edgecolor','none')
set(m2,'facecolor','k')
set(m2,'edgecolor','none')
set(m3,'facecolor','k')
set(m3,'edgecolor','none')
set(m4,'facecolor','k')
set(m4,'edgecolor','none')
%SO4
set(n1,'facecolor','b')
set(n1,'edgecolor','none')
set(n2,'facecolor','b')
set(n2,'edgecolor','none')
set(n3,'facecolor','b')
set(n3,'edgecolor','none')
set(n4,'facecolor','b')
set(n4,'edgecolor','none')
%PSOV
set(o1,'facecolor','g')
set(o1,'edgecolor','none')
set(o2,'facecolor','g')
set(o2,'edgecolor','none')
set(o3,'facecolor','g')
set(o3,'edgecolor','none')
set(o4,'facecolor','g')
set(o4,'edgecolor','none')
%PIOV
set(p1,'facecolor',[0.635 0.078 0.184])
set(p1,'edgecolor','none')
set(p2,'facecolor',[0.635 0.078 0.184])
set(p2,'edgecolor','none')
set(p3,'facecolor',[0.635 0.078 0.184])
set(p3,'edgecolor','none')
set(p4,'facecolor',[0.635 0.078 0.184])
set(p4,'edgecolor','none')
[g]=legend('PIOV','PSOV','sulfate','soot','POM','water','Location','NorthWest');
set(g,'fontsize',14);
grid off
set(gca,'Layer','top')
xlabel('particle diameter (nm)','FontSize',16)
ylabel('mass conc. per bin ({\mu}g m^{-3})','FontSize',16)
title('Time 78.5s','FontSize',16)
set(gca,'xscale','log','FontSize',16)
set(gca,'XLim',[1. 1000.])
set(gca,'YLim',[0. 1.8])
ty=0:0.2:2;
set(gca,'ytick',ty);
set(gca,'yTickLabel',{'0.0','0.2','0.4','0.6','0.8','1.0','1.2','1.4','1.6','1.8','2.0'})

print -djpg '../plots/Figure14c.jpg'
%print -djpg '../plots/Figure14d.jpg'
