
%%% PLOT SCRIPT URBAN CASE, U=1 m/s
%%% FIGURE 13
%%% USE GNU OCTAVE

clear

load  ../outputs/aerofor_gases.dat;
load  ../outputs/mafor_gases.dat;
load  ../outputs/salsa_gases.dat;

%GASES CONCENTRATION
%MAFOR
tmafor      =mafor_gases(:,1);
sulf_mafor  =mafor_gases(:,2);
svoc_mafor  =mafor_gases(:,3);

%AEROFOR
taerofor    =aerofor_gases(:,1);
sulf_aerofor=aerofor_gases(:,2);
svoc_aerofor=aerofor_gases(:,3);

%SALSA
tsalsa      =salsa_gases(:,1);
sulf_salsa  =salsa_gases(:,2);
svoc_salsa  =salsa_gases(:,3);

%COMPARE H2SO4 and SVOC(total)
figure(1)
axes('linewidth',1.6,'fontsize',16 ,'tickdir','out')
plot(tmafor,svoc_mafor*1.e-8,'-k','LineWidth',2.8)
hold
ax=gca;
set(ax,'linewidth',1.6,'fontsize',16,'tickdir','out')
plot(taerofor,svoc_aerofor*1.e-8,'-b','LineWidth',2.8)
plot(tsalsa,svoc_salsa*1.e-8,'-','Color',[.1 .45 .1] ,'LineWidth',2.8)
[g]=legend('MAFOR','AEROFOR','SALSA', ...
           'Location','NorthEast');
set(g,'fontsize',20);
xlabel('Downwind distance (m)'     ,'FontSize',18,'FontName','Arial')
ylabel('SVOC gas concentration (10^{8} cm^{-3})','FontSize',18,'FontName','Arial')
set(gca,'XLim',[0. 120.],'Ylim',[0 6.0]);

print -djpg '../plots/Figure13a.jpg'


figure(2)
axes('linewidth',1.6,'fontsize',16 ,'tickdir','out')
plot(tmafor,sulf_mafor*1.e-8    ,'-k','LineWidth',2.8)
hold
ax=gca;
set(ax,'linewidth',1.6,'fontsize',16,'tickdir','out')
plot(taerofor,sulf_aerofor*1.e-8,'-b','LineWidth',2.8)
plot(tsalsa,sulf_salsa*1.e-8    ,'-','Color',[.1 .45 .1] ,'LineWidth',2.8)
[g]=legend('MAFOR','AEROFOR','SALSA', ...
           'Location','NorthEast');
set(g,'fontsize',20);
xlabel('Downwind distance (m)'     ,'FontSize',18,'FontName','Arial')
ylabel('H_{2}SO_{4} concentration (10^{8} cm^{-3})','FontSize',18,'FontName','Arial')
set(gca,'XLim',[0. 120.],'Ylim',[0 2.0]);

print -djpg '../plots/Figure13b.jpg'
