
%%% PLOT SCRIPT URBAN CASE, U=1 m/s
%%% FIGURE 12a AND 12b
%%% USE GNU OCTAVE

clear

load  ../outputs/mafor_pmbc.dat;
load  ../outputs/salsa_pmbc.dat;

% OBSERVATION DATA POINTS A-E
% See folder experiment_data
% ExperimentalData.xlsx
%
%PM2.5 corrected from DustTrak
%pm25obs=[16.35 13.83 11.31 11.80 11.82]; %uncorrected
pm25obs=[11.18 9.46 7.73 7.57 8.08];
pm25std=[3.21 2.16 1.52 0.50 2.10];
%
%PM1 corrected from ELPI
pm1elp =[10.75 8.16 6.35 5.04 5.94];
pm1std =[2.17 2.18 0.55 0.51 3.26];
%
%BC corrected from Aethalometer AE22
bcobs  =[8.98 2.29 1.37 1.36 3.12];
bcstd  =[7.40 0.40 0.41 0.37 3.93];
%
% observation times
timeobs=[5.5 30.5 50.5 78.5 82.5];
%%%%%%%%%%%%%%%%%%%%%%%%%

%AEROSOL MASS CONCENTRATION FROM MODELS
%MAFOR
tmafor       =mafor_pmbc(:,1);
pmtotal_mafor=mafor_pmbc(:,2);
pmecbt_mafor =mafor_pmbc(:,3);

%SALSA
tsalsa       =salsa_pmbc(:,1);
pmtotal_salsa=salsa_pmbc(:,2);
pmecbt_salsa =salsa_pmbc(:,3);


%COMPARE PM1 modelled with PM1 and PM2.5 measured
figure(1)
axes('linewidth',1.6,'fontsize',16 ,'tickdir','out')
plot(tmafor,pmtotal_mafor,'-k','LineWidth',2.8)
hold
ax=gca;
set(ax,'linewidth',1.6,'fontsize',16,'tickdir','out')
plot(tsalsa,pmtotal_salsa,'-','LineWidth',2.8, 'Color',[.1 .45 .1])
plot(timeobs,pm1elp ,'ro', 'MarkerSize',8.,'LineWidth',4.0)
plot(timeobs,pm25obs,'o','MarkerSize',8.,'LineWidth',4.0,'Color',[.4 .4 .4])
[e1]=errorbar (timeobs, pm1elp,  pm1std,"~.r")
[e2]=errorbar (timeobs, pm25obs, pm25std,"~.k")
set(e1,'LineWidth',1.8);
%LEGEND
[g]=legend('MAFOR (PM1)', 'SALSA (PM1)', ...
           'PM_{1} meas (ELPI)', ...
           'PM_{2.5} meas (DustTrak)', ...
           'Location','NorthEast');
set(g,'fontsize',16);
xlabel('Downwind distance (m)'     ,'FontSize',18,'FontName','Arial')
ylabel('Particle mass conc. (\mug m^{-3})','FontSize',18,'FontName','Arial')
set(gca,'XLim',[0. 120.],'Ylim',[0 35.0]);

print -djpg '../plots/Figure12a.jpg'


%COMPARE BC modelled with BC measured
figure(2)
axes('linewidth',1.6,'fontsize',16 ,'tickdir','out')
plot(tmafor,pmecbt_mafor ,'-k', 'LineWidth',2.8)
hold
ax=gca;
set(ax,'linewidth',1.6,'fontsize',16,'tickdir','out')
plot(tsalsa,pmecbt_salsa ,'-', 'LineWidth',2.8,'Color',[.1 .45 .1])
plot(timeobs,bcobs  ,'bs','MarkerSize',8.,'LineWidth',4.0)
[e2]=errorbar (timeobs, bcobs, bcstd,"~.b")
set(e2,'LineWidth',1.8);
%LEGEND
[g]=legend('MAFOR BC','SALSA BC','BC measured (AE22)','Location','NorthEast');
set(g,'fontsize',18);
xlabel('Downwind distance (m)'     ,'FontSize',18,'FontName','Arial')
ylabel('BC mass conc. (\mug m^{-3})','FontSize',18,'FontName','Arial')

set(gca,'XLim',[0. 120.],'Ylim',[0 20.0]);

print -djpg '../plots/Figure12b.jpg'
