
%%% PLOT SCRIPT URBAN CASE, U=1 m/s
%%% FIGURE 11
%%% USE GNU OCTAVE
%%% 

clear

% OBSERVATION DATA POINTS A-D
% See folder experiment_data
% ExperimentalData.xlsx

%SMPS dN/dlogDp
% Sniffer in M2 between the buildings
%Dg is geometric mean diameter of the bin, 
%the total measured size range is from 2.0 nm to 414.2 nm
% given in [nm]
smps_diameter_dmps=[2.09E+00	2.17E+00	2.25E+00	2.33E+00	2.41E+00	2.50E+00 ...
                    2.59E+00	2.69E+00	2.79E+00	2.89E+00	3.00E+00	3.11E+00	3.22E+00 ...
                    3.34E+00	3.46E+00	3.59E+00	3.72E+00	3.85E+00	4.00E+00	4.14E+00 ...
                    4.29E+00	4.45E+00	4.61E+00	4.78E+00	4.96E+00	5.14E+00	5.33E+00 ...
                    5.52E+00	5.73E+00	5.94E+00	6.15E+00	6.38E+00	6.61E+00	6.85E+00 ...
                    7.10E+00	7.37E+00	7.64E+00	7.91E+00	8.20E+00	8.51E+00	8.82E+00 ...
                    9.14E+00	9.47E+00	9.82E+00	1.02E+01	1.06E+01	1.09E+01	1.13E+01 ...
                    1.18E+01	1.22E+01	1.26E+01	1.31E+01	1.36E+01	1.41E+01	1.46E+01 ...
                    1.51E+01	1.57E+01	1.63E+01	1.68E+01	1.75E+01	1.81E+01	1.88E+01 ...
                    1.95E+01	2.02E+01	2.09E+01	2.17E+01	2.25E+01	2.33E+01	2.41E+01 ...
                    2.50E+01	2.59E+01	2.69E+01	2.79E+01	2.89E+01	3.00E+01	3.11E+01 ...
                    3.22E+01	3.34E+01	3.46E+01	3.59E+01	3.72E+01	3.85E+01	4.00E+01 ...
                    4.14E+01	4.29E+01	4.45E+01	4.61E+01	4.78E+01	4.96E+01	5.14E+01 ...
                    5.33E+01	5.52E+01	5.73E+01	5.94E+01	6.15E+01	6.38E+01	6.61E+01 ...
                    6.85E+01	7.10E+01	7.37E+01	7.64E+01	7.91E+01	8.20E+01	8.51E+01 ...
                    8.82E+01	9.14E+01	9.47E+01	9.82E+01	1.02E+02	1.06E+02	1.09E+02 ...
                    1.13E+02	1.18E+02	1.22E+02	1.26E+02	1.31E+02	1.36E+02	1.41E+02 ...
                    1.46E+02	1.51E+02	1.57E+02	1.63E+02	1.69E+02	1.75E+02	1.81E+02 ...
                    1.88E+02	1.95E+02	2.02E+02	2.09E+02	2.17E+02	2.25E+02	2.33E+02 ...
                    2.41E+02	2.50E+02	2.60E+02	2.69E+02	2.79E+02	2.89E+02	3.00E+02 ...
                    3.11E+02	3.22E+02	3.34E+02	3.46E+02	3.59E+02	3.72E+02	3.85E+02 ...
                    4.00E+02	4.14E+02];

% POINT A "0 m"
ma16_0_dndlogdp=[0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 0.00E+00	0.00E+00	0.00E+00	3.77E+04	0.00E+00	2.94E+04	0.00E+00 ...
                 4.56E+04	4.33E+04	3.57E+04	2.19E+03	3.13E+04	0.00E+00	4.43E+04 ...
                 4.50E+04	5.99E+04	5.46E+04	1.87E+04	6.90E+04	4.30E+04	3.89E+04 ...
                 2.51E+04	5.64E+04	5.38E+04	4.47E+04	2.61E+04	6.21E+04	1.32E+05 ...
                 1.21E+05	1.10E+05	9.34E+04	1.01E+05	6.05E+04	9.32E+04	1.08E+05 ...
                 1.06E+05	7.65E+04	9.26E+04	6.09E+04	1.17E+05	8.88E+04	1.22E+05 ...
                 1.07E+05	1.42E+05	1.93E+05	2.05E+05	2.42E+05	2.39E+05	2.41E+05 ...
                 2.84E+05	2.32E+05	2.05E+05	1.77E+05	1.57E+05	2.16E+05	2.04E+05 ...
                 2.24E+05	1.95E+05	1.41E+05	1.13E+05	1.11E+05	1.10E+05	1.02E+05 ...
                 9.88E+04	7.21E+04	8.43E+04	7.25E+04	6.61E+04	4.31E+04	4.30E+04 ...
                 4.02E+04	3.29E+04	2.66E+04	4.13E+04	3.78E+04	3.44E+04	3.06E+04 ...
                 4.03E+04	2.65E+04	2.04E+04	2.69E+04	1.06E+04	1.32E+04	1.52E+04 ...
                 8.57E+03	1.14E+04	1.03E+04	9.54E+03	7.04E+03	7.71E+03	1.09E+04 ...
                 8.84E+03	8.19E+03	7.26E+03	1.49E+03	2.79E+03	1.20E+04	9.32E+03 ...
                 8.28E+03	7.61E+03	8.08E+03	5.98E+03	4.35E+03	5.62E+03	7.94E+03 ...
                 8.13E+03	5.55E+03	3.81E+03	3.08E+03	1.76E+03	4.71E+03	2.04E+03 ...
                 5.67E+03	3.00E+03	3.46E+03	4.96E+03	0.00E+00	1.64E+03	0.00E+00 ...
                 3.04E+03	1.78E+03	5.42E+03	2.74E+03	9.29E+02	1.89E+03	0.00E+00 ...
                 0.00E+00	9.88E+02	0.00E+00	2.03E+03	1.04E+03	0.00E+00	0.00E+00	1.09E+03];

% POINT B "8 m"
ma16_1_dndlogdp=[0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	9.99E+03 ...
                 0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	4.68E+03	4.22E+03 ...
                 1.14E+04	1.49E+04	1.26E+04	7.53E+03	2.35E+04	1.20E+04	1.58E+04 ...
                 7.86E+03	1.39E+04	3.36E+04	1.73E+04	1.68E+04	2.06E+04	2.67E+04 ...
                 1.38E+04	2.50E+04	2.76E+04	2.06E+04	2.45E+04	3.53E+04	2.25E+04 ...
                 3.17E+04	3.64E+04	3.54E+04	3.31E+04	3.60E+04	4.07E+04	4.16E+04 ...
                 4.40E+04	5.21E+04	6.28E+04	5.86E+04	6.11E+04	6.27E+04	7.03E+04 ...
                 6.10E+04	5.74E+04	6.42E+04	6.71E+04	7.68E+04	7.31E+04	8.34E+04 ...
                 7.77E+04	8.21E+04	8.94E+04	8.47E+04	8.90E+04	8.55E+04	8.31E+04 ...
                 7.27E+04	6.78E+04	6.89E+04	6.39E+04	6.24E+04	5.25E+04	5.05E+04 ...
                 5.34E+04	3.96E+04	3.96E+04	3.81E+04	3.45E+04	2.97E+04	2.74E+04 ...
                 2.95E+04	2.79E+04	2.71E+04	2.30E+04	2.13E+04	1.86E+04	1.90E+04 ...
                 1.80E+04	1.74E+04	1.59E+04	1.53E+04	1.54E+04	1.65E+04	1.26E+04 ...
                 9.53E+03	1.42E+04	1.05E+04	1.25E+04	1.01E+04	8.34E+03	8.47E+03 ...
                 6.35E+03	6.92E+03	6.21E+03	7.44E+03	5.57E+03	6.87E+03	4.17E+03 ...
                 5.32E+03	5.16E+03	4.79E+03	4.71E+03	5.57E+03	4.13E+03	4.18E+03 ...
                 5.08E+03	3.29E+03	3.02E+03	2.90E+03	3.39E+03	1.71E+03	1.45E+03 ...
                 2.29E+03	9.89E+02	1.64E+03	2.40E+03	2.55E+03	8.77E+02	1.57E+03 ...
                 9.53E+02	1.71E+03	1.27E+03	1.42E+03	1.28E+03	1.13E+03	8.84E+02 ...
                 1.38E+03	1.70E+03	4.96E+02	8.39E+02	5.27E+02	8.62E+02	6.21E+02	4.50E+02];

% POINT C "28 m"
ma16_2_dndlogdp=[0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 4.81E+03	0.00E+00	0.00E+00	0.00E+00	0.00E+00	5.20E+03	4.69E+03 ...
                 4.23E+03	7.64E+03	1.74E+03	1.59E+03	8.72E+03	3.99E+03	1.22E+03 ...
                 7.90E+03	7.24E+03	7.67E+03	6.24E+03	4.96E+03	6.31E+03	9.12E+03 ...
                 1.21E+04	1.35E+04	1.16E+04	9.12E+03	1.60E+04	1.58E+04	1.83E+04 ...
                 1.86E+04	2.01E+04	1.82E+04	2.38E+04	2.78E+04	3.52E+04	2.97E+04 ...
                 3.17E+04	3.11E+04	3.28E+04	3.20E+04	4.04E+04	3.51E+04	3.66E+04 ...
                 3.33E+04	3.79E+04	4.00E+04	4.48E+04	4.32E+04	4.35E+04	3.90E+04 ...
                 3.89E+04	3.42E+04	3.44E+04	3.53E+04	3.51E+04	3.82E+04	3.47E+04 ...
                 3.43E+04	3.23E+04	3.25E+04	3.35E+04	3.21E+04	2.74E+04	2.98E+04 ...
                 2.80E+04	2.56E+04	2.30E+04	2.52E+04	2.13E+04	2.13E+04	2.16E+04 ...
                 2.00E+04	1.82E+04	1.88E+04	1.64E+04	1.48E+04	1.79E+04	1.51E+04 ...
                 1.48E+04	1.26E+04	1.22E+04	1.47E+04	1.24E+04	1.42E+04	1.19E+04 ...
                 1.21E+04	1.37E+04	1.16E+04	9.19E+03	1.23E+04	1.01E+04	1.18E+04 ...
                 7.30E+03	6.96E+03	9.05E+03	8.37E+03	7.67E+03	6.85E+03	5.93E+03 ...
                 8.69E+03	4.69E+03	6.96E+03	5.31E+03	5.03E+03	4.98E+03	3.66E+03 ...
                 5.60E+03	3.29E+03	4.83E+03	3.46E+03	4.46E+03	2.78E+03	3.15E+03 ...
                 2.39E+03	1.94E+03	3.08E+03	3.10E+03	1.03E+03	2.43E+03	1.64E+03 ...
                 1.81E+03	1.47E+03	2.23E+03	1.55E+03	1.33E+03	1.20E+03	2.10E+03 ...
                 2.13E+03	5.37E+02	1.17E+03	2.06E+02	1.16E+03	2.10E+03	7.96E+02	5.97E+02];

% POINT D ("56 m")
ma16_3_dndlogdp=[0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00 ...
                 0.00E+00	1.91E+03	5.22E+03	3.17E+03	0.00E+00	1.33E+03	5.61E+03 ...
                 9.48E+03	1.09E+04	6.10E+03	6.84E+03	1.59E+04	3.40E+03	1.22E+04 ...
                 1.46E+04	8.23E+03	1.12E+04	1.17E+04	1.08E+04	1.51E+04	1.78E+04 ...
                 1.66E+04	1.69E+04	1.81E+04	1.57E+04	1.89E+04	2.06E+04	2.06E+04 ...
                 2.56E+04	2.06E+04	2.54E+04	2.12E+04	2.54E+04	2.08E+04	2.61E+04 ...
                 2.55E+04	2.47E+04	2.53E+04	2.69E+04	2.63E+04	2.62E+04	2.60E+04 ...
                 2.71E+04	2.54E+04	2.32E+04	2.64E+04	2.64E+04	2.59E+04	2.37E+04 ...
                 2.51E+04	2.35E+04	2.09E+04	1.80E+04	1.74E+04	1.59E+04	1.68E+04 ...
                 1.72E+04	1.36E+04	1.37E+04	1.34E+04	1.11E+04	1.16E+04	1.16E+04 ...
                 1.12E+04	9.94E+03	9.73E+03	1.05E+04	9.00E+03	9.11E+03	9.47E+03 ...
                 8.81E+03	9.23E+03	7.60E+03	6.38E+03	7.07E+03	7.12E+03	7.85E+03 ...
                 8.37E+03	6.66E+03	6.08E+03	7.02E+03	5.93E+03	6.72E+03	7.17E+03 ...
                 4.49E+03	6.34E+03	5.65E+03	4.68E+03	4.33E+03	4.78E+03	3.87E+03 ...
                 4.55E+03	3.21E+03	3.50E+03	2.79E+03	2.80E+03	3.23E+03	2.25E+03 ...
                 2.22E+03	1.69E+03	2.81E+03	2.48E+03	2.20E+03	1.38E+03	1.43E+03 ...
                 1.79E+03	1.94E+03	1.52E+03	1.16E+03	8.02E+02	1.03E+03	6.79E+02 ...
                 1.03E+03	9.57E+02	3.96E+02	3.95E+02	1.65E+03	8.54E+02	5.56E+02 ...
                 7.35E+02	4.61E+02	5.04E+02	3.54E+02	8.90E+02	5.59E+02	3.43E+02	2.72E+02];


%%%%%% Sniffer in-plume measurements
%%% same instruments/size channel
ma0_diameter_dmps=smps_diameter_dmps;
ma1_diameter_dmps=smps_diameter_dmps;
ma2_diameter_dmps=smps_diameter_dmps;
ma3_diameter_dmps=smps_diameter_dmps;

ma0_dndlogdp_dmps=ma16_0_dndlogdp;
ma1_dndlogdp_dmps=ma16_1_dndlogdp;
ma2_dndlogdp_dmps=ma16_2_dndlogdp;
ma3_dndlogdp_dmps=ma16_3_dndlogdp;


%%% MAFOR dNdlogDp
load ../outputs/mafor_dNdlogDp.dat
infile='mafor_dNdlogDp.dat';
in=strrep(infile,'.dat','');
y1=eval(in);
[row1,col1]=size(y1);  
diameter_bin_mafor  =y1(  2,2:col1)*1e9;
dndlogdp_bin02_mafor=y1( 14,2:col1);
dndlogdp_bin03_mafor=y1( 64,2:col1);
dndlogdp_bin04_mafor=y1(104,2:col1);
dndlogdp_bin05_mafor=y1(203,2:col1);


%%% AEROFOR dNdlogDp
load ../outputs/aerofor_dNdlogDp.dat
infile='aerofor_dNdlogDp.dat';
in=strrep(infile,'.dat','');
y2=eval(in);
[row2,col2]=size(y2);  
diameter_bin_aerof=y2(2,2: col2)*1e9;
dndlogdp_bin02_aerof=y2(4,2:col2);
dndlogdp_bin03_aerof=y2(5,2:col2);
dndlogdp_bin04_aerof=y2(6,2:col2);
dndlogdp_bin05_aerof=y2(7,2:col2);


%SALSA
load ../outputs/salsa_dNdlogDp.dat
infile='salsa_dNdlogDp.dat';
in=strrep(infile,'.dat','');
y3=eval(in);
[row3,col3]=size(y3);  
diameter_bin_salsa=y3(2,2: col3)*1e9;
dndlogdp_bin02_salsa=y3(4,2:col3);
dndlogdp_bin03_salsa=y3(5,2:col3);
dndlogdp_bin04_salsa=y3(6,2:col3);
dndlogdp_bin05_salsa=y3(7,2:col3);



figure(1);clf
axes('linewidth',1.6,'fontsize',20 , 'XScale','log','YScale','log','tickdir','out')
loglog(diameter_bin_mafor,dndlogdp_bin02_mafor,       '-k' ,'LineWidth',2.0);
hold
ax=gca;
set(ax,'linewidth',1.2,'fontsize',16,'tickdir','out')
loglog(diameter_bin_aerof,dndlogdp_bin02_aerof,       '-b' ,'LineWidth',2.0);
loglog(diameter_bin_salsa,dndlogdp_bin02_salsa, '-','Color',[.1 .45 .1] ,'LineWidth',2.0);
loglog(ma0_diameter_dmps,ma0_dndlogdp_dmps,'ro','MarkerSize',6.,'LineWidth',3.0); 
title('after 5.5 s (A)', 'fontsize',18);
xlabel('Particle diameter (nm)','FontSize',18,'FontName','Arial')
ylabel('dN/dlogDp (particles/cm^3)','FontSize',18,'FontName','Arial')
[g]=legend('MAFOR','AEROFOR','SALSA','SMPS',  ...
           'Location','NorthEast')  
set(gca,'xtick',[1,10,100,1000]);
set(gca,'xticklabel', [1,10,100,1000]);
set(gca,'XLim',[1.0 1000.],'Ylim',[1.e2 1.e6]);

print -dtif '../plots/Figure11_A.tif'

figure(2);clf
axes('linewidth',1.6,'fontsize',20 , 'XScale','log','YScale','log','tickdir','out')
loglog(diameter_bin_mafor,dndlogdp_bin03_mafor,       '-k' ,'LineWidth',2.0);
hold
ax=gca;
set(ax,'linewidth',1.2,'fontsize',16,'tickdir','out')
loglog(diameter_bin_aerof,dndlogdp_bin03_aerof,       '-b' ,'LineWidth',2.0);
loglog(diameter_bin_salsa,dndlogdp_bin03_salsa, '-','Color',[.1 .45 .1] ,'LineWidth',2.0);
loglog(ma1_diameter_dmps,ma1_dndlogdp_dmps,'ro','MarkerSize',6.,'LineWidth',3.0); 
title('after 30.5 s (B)', 'fontsize',18);
xlabel('Particle diameter (nm)','FontSize',18,'FontName','Arial')
ylabel('dN/dlogDp (particles/cm^3)','FontSize',18,'FontName','Arial')
[g]=legend('MAFOR','AEROFOR','SALSA','SMPS',  ...
           'Location','NorthEast')  
set(gca,'xtick',[1,10,100,1000]);
set(gca,'xticklabel', [1,10,100,1000]);
set(gca,'XLim',[1.0 1000.],'Ylim',[1.e2 1.e6]);

print -dtif '../plots/Figure11_B.tif'

figure(3);clf
axes('linewidth',1.6,'fontsize',20 , 'XScale','log','YScale','log','tickdir','out')
loglog(diameter_bin_mafor,dndlogdp_bin04_mafor,       '-k' ,'LineWidth',2.0);
hold
ax=gca;
set(ax,'linewidth',1.2,'fontsize',16,'tickdir','out')
loglog(diameter_bin_aerof,dndlogdp_bin04_aerof,       '-b' ,'LineWidth',2.0);
loglog(diameter_bin_salsa,dndlogdp_bin04_salsa, '-','Color',[.1 .45 .1] ,'LineWidth',2.0);
loglog(ma2_diameter_dmps,ma2_dndlogdp_dmps,'ro','MarkerSize',6.,'LineWidth',3.0); 
title('after 50.5 s (C)', 'fontsize',18);
xlabel('Particle diameter (nm)','FontSize',18,'FontName','Arial')
ylabel('dN/dlogDp (particles/cm^3)','FontSize',18,'FontName','Arial')
[g]=legend('MAFOR','AEROFOR','SALSA','SMPS',  ...
           'Location','NorthEast')  
set(gca,'xtick',[1,10,100,1000]);
set(gca,'xticklabel', [1,10,100,1000]);
set(gca,'XLim',[1.0 1000.],'Ylim',[1.e2 1.e6]);

print -dtif '../plots/Figure11_C.tif'

figure(4);clf
axes('linewidth',1.6,'fontsize',20 , 'XScale','log','YScale','log','tickdir','out')
loglog(diameter_bin_mafor,dndlogdp_bin05_mafor,       '-k' ,'LineWidth',2.0);
hold
ax=gca;
set(ax,'linewidth',1.2,'fontsize',16,'tickdir','out')
loglog(diameter_bin_aerof,dndlogdp_bin05_aerof,       '-b' ,'LineWidth',2.0);
loglog(diameter_bin_salsa,dndlogdp_bin05_salsa, '-','Color',[.1 .45 .1] ,'LineWidth',2.0);
loglog(ma3_diameter_dmps,ma3_dndlogdp_dmps,'ro','MarkerSize',6.,'LineWidth',3.0); 
title('after 78.5 s (D)', 'fontsize',18);
xlabel('Particle diameter (nm)','FontSize',18,'FontName','Arial')
ylabel('dN/dlogDp (particles/cm^3)','FontSize',18,'FontName','Arial')
[g]=legend('MAFOR','AEROFOR','SALSA','SMPS',  ...
           'Location','NorthEast')  
set(g,'fontsize',24);
set(gca,'xtick',[1,10,100,1000]);
set(gca,'xticklabel', [1,10,100,1000]);
set(gca,'XLim',[1.0 1000.],'Ylim',[1.e2 1.e6]);

print -dtif '../plots/Figure11_D.tif'
