
%%% PLOT SCRIPT URBAN CASE, U=1 m/s
%%% FIGURE 10
%%% USE GNU OCTAVE

clear

%%%MAFOR
load  ../outputs/mafor_ntot_ALL.dat;
%%%SALSA
load  ../outputs/salsa_ntot.dat;
%%%AEROFOR
load  ../outputs/aerofor_ntot.dat;


% OBSERVATION DATA POINTS A-D
% See folder experiment_data
% ExperimentalData.xlsx
%
% MEASURED SMPS Ntot
tobs=[5.5 30.5 50.5 78.5];
ntotobs=[1.14E+05 5.22E+04 3.08E+04 2.05E+04];
ntotstd=[3.06E+04 1.48E+04 3.65E+03 7.08E+03];
%ntotstd=2.0*ntotstd;
%%%%%%%%%%%%%%%%%%%%%%%%


%%% MAFOR
tmafor=mafor_ntot_ALL(:,1);
ntot_mafor=mafor_ntot_ALL(:,2);

%%% AEROFOR
taerof=aerofor_ntot(:,1);
ntot_aerof=aerofor_ntot(:,2);

%%% SALSA
tsalsa=salsa_ntot(:,1);
ntot_salsa=salsa_ntot(:,2);


figure(1)
axes('linewidth',1.6,'fontsize',16 ,'tickdir','out')
%MAFOR
plot(tmafor,ntot_mafor*1.e-4,  '-k' ,'LineWidth',3.0,'MarkerSize',2.0)
hold
ax=gca;
set(ax,'linewidth',1.6,'fontsize',16,'tickdir','out')
%AEROFOR
plot(taerof,ntot_aerof*1.e-4, '-b' ,'LineWidth',3.0,'MarkerSize',2.0)
%SALSA
plot(tsalsa,ntot_salsa*1.e-4, '-','Color',[.1 .45 .1] ,'LineWidth',3.0,'MarkerSize',2.0)
%SMPS measurements and error bars
plot(tobs,ntotobs*1.e-4,'rs','MarkerSize',8.,'LineWidth',4.0)
[e]=errorbar (tobs, ntotobs*1.e-4, ntotstd*1.e-4,"~.r")
set(e,'LineWidth',1.8);

%LEGEND
[g]=legend('MAFOR','AEROFOR','SALSA',  'SMPS', ...
           'Location','NorthEast')  
set(g,'fontsize',20);

xlabel('Downwind distance (m)'     ,'FontSize',18,'FontName','Arial')
ylabel('Total number concentration (10^{4}particles cm^{-3})'  ,'FontSize',18,'FontName','Arial')
set(gca,'ytick', [2,4,6,8,10,12,14,16] );
tytext=['2'; '4';'6'; '8'; '10';'12'; '14'; '16'];
set(gca, 'yticklabel', tytext)
set(gca,'XLim',[0. 120.],'Ylim',[1. 16. ]);

print -djpg '../plots/Figure10.jpg'
