
%%% script to synchronize size resolution of modelled dN/dlogDp
%%% to the size resolution of the SMPS measurements

%%% POINT C - all data

% SMPS data series
load ../../experiment_data/smps_dNdlogDp.dat
infile1='smps_dNdlogDp.dat';
in1=strrep(infile1,'.dat','');
y1=eval(in1);
[row1,col1]=size(y1);
% number of size channels
binmax=col1-1;
% diameter axis in nm
diameter_bin_smps  =y1( 1,2:col1);
% dN/dlogDp at point C
dndlogdp_C_smps    =y1( 4,2:col1);


% MAFOR data series
load ../outputs/mafor_dNdlogDp.dat
infile2='mafor_dNdlogDp.dat';
in2=strrep(infile2,'.dat','');
y2=eval(in2);
[row2,col2]=size(y2);
% diameter axis in nm
diameter_bin_mafor =y2(  2,2:col2)*1e9;
% dN/dlogDp at point C
dndlogdp_C_mafor   =y2(104,2:col2);


%%% AEROFOR data series
load ../outputs/aerofor_dNdlogDp.dat
infile3='aerofor_dNdlogDp.dat';
in3=strrep(infile3,'.dat','');
y3=eval(in3);
[row3,col3]=size(y3);
% diameter axis in nm
diameter_bin_aerof =y3(2,2: col3)*1e9;
% dN/dlogDp at point C
dndlogdp_C_aerof   =y3(6,2:col3);


%SALSA data series
load ../outputs/salsa_dNdlogDp.dat
infile4='salsa_dNdlogDp.dat';
in4=strrep(infile4,'.dat','');
y4=eval(in4);
[row4,col4]=size(y4);
% diameter axis in nm
diameter_bin_salsa =y4(2,2: col4)*1e9;
% dN/dlogDp at point C
dndlogdp_C_salsa   =y4(6,2:col4);


% Size-synchronize the model data to SMPS size resolution
new_mafor_C =interp1(diameter_bin_mafor,dndlogdp_C_mafor,diameter_bin_smps);
new_aerof_C =interp1(diameter_bin_aerof,dndlogdp_C_aerof,diameter_bin_smps);
new_salsa_C =interp1(diameter_bin_salsa,dndlogdp_C_salsa,diameter_bin_smps);

% Open output file
fid = fopen('../../openair/data/ucdata_dndlogdp_C.csv', 'wt');

% write header to csv file
fprintf(fid, '"date";"obs";"mod";"model";"scenario"\n');

% Loop over size bins, SMPS, MAFOR
% loop parameters
j=12;
%date string required by openair.
% f: 31 yyyy-mm-dd HH:MM:SS
% start with random date
tstart=737736.64584;
%ds=0.0006944; % 60 sec
ds= 0.0416670; %3600s
tpt = tstart;
while diameter_bin_smps(j)<diameter_bin_smps(binmax) 

  str=datestr (tpt, 31);
  v  =datevec(str);
  inchamline = [v(3) v(2) v(1) v(4) v(5) dndlogdp_C_smps(j) new_mafor_C(j)]; 
  if ( v(3)<10 )
    if ( v(4)<10 )
     fprintf(fid, '0%d.%d.%d 0%d:%d;%7.3e;%7.3e;"mafor";"urbancase"\n', inchamline);
    else
     fprintf(fid, '0%d.%d.%d %d:%d;%7.3e;%7.3e;"mafor";"urbancase"\n', inchamline);
    endif
  else
    if ( v(4)<10 )
     fprintf(fid, '%d.%d.%d 0%d:%d;%7.3e;%7.3e;"mafor";"urbancase"\n', inchamline);
    else
     fprintf(fid, '%d.%d.%d %d:%d;%7.3e;%7.3e;"mafor";"urbancase"\n', inchamline);
    endif    
  endif
  tpt=tpt+ds;
  j=j+1;

end
str = datestr (tpt, 31);
v =datevec(str);
inchamline = [v(3) v(2) v(1) v(4) v(5) dndlogdp_C_smps(binmax) new_mafor_C(binmax)]; 
fprintf(fid, '%d.%d.%d 0%d:%d;%7.3e;%7.3e;"mafor";"urbancase"\n', inchamline);


% Loop over size bins, SMPS, AEROFOR
% loop parameters
j=12;
tstart=737736.64584;
ds= 0.0416670; %3600s
tpt = tstart; 
while diameter_bin_smps(j)<diameter_bin_smps(binmax) 
  str=datestr (tpt, 31);
  v =datevec(str);
  inchamline = [v(3) v(2) v(1) v(4) v(5) dndlogdp_C_smps(j) new_aerof_C(j)]; 
  if ( v(3)<10 )
    if ( v(4)<10 )
     fprintf(fid, '0%d.%d.%d 0%d:%d;%7.3e;%7.3e;"aerofor";"urbancase"\n', inchamline);
    else
     fprintf(fid, '0%d.%d.%d %d:%d;%7.3e;%7.3e;"aerofor";"urbancase"\n', inchamline);
    endif
  else
    if ( v(4)<10 )
     fprintf(fid, '%d.%d.%d 0%d:%d;%7.3e;%7.3e;"aerofor";"urbancase"\n', inchamline);
    else
     fprintf(fid, '%d.%d.%d %d:%d;%7.3e;%7.3e;"aerofor";"urbancase"\n', inchamline);
    endif    
  endif
  tpt=tpt+ds;
  j=j+1;
end
str = datestr (tpt, 31);
v =datevec(str);
inchamline = [v(3) v(2) v(1) v(4) v(5) dndlogdp_C_smps(binmax) new_aerof_C(binmax)]; 
fprintf(fid, '%d.%d.%d 0%d:%d;%7.3e;%7.3e;"aerofor";"urbancase"\n', inchamline);


% Loop over size bins, SMPS, SALSA
% loop parameters
j=12;
tstart=737736.64584;
ds= 0.0416670; %3600s
tpt = tstart;
while diameter_bin_smps(j)<diameter_bin_smps(binmax) 
  str=datestr (tpt, 31);
  v =datevec(str);
  inchamline = [v(3) v(2) v(1) v(4) v(5) dndlogdp_C_smps(j) new_salsa_C(j)]; 
  if ( v(3)<10 )
    if ( v(4)<10 )
     fprintf(fid, '0%d.%d.%d 0%d:%d;%7.3e;%7.3e;"salsa";"urbancase"\n', inchamline);
    else
     fprintf(fid, '0%d.%d.%d %d:%d;%7.3e;%7.3e;"salsa";"urbancase"\n', inchamline);
    endif
  else
    if ( v(4)<10 )
     fprintf(fid, '%d.%d.%d 0%d:%d;%7.3e;%7.3e;"salsa";"urbancase"\n', inchamline);
    else
     fprintf(fid, '%d.%d.%d %d:%d;%7.3e;%7.3e;"salsa";"urbancase"\n', inchamline);
    endif    
  endif
  tpt=tpt+ds;
  j=j+1;
end
str = datestr (tpt, 31);
v =datevec(str);
inchamline = [v(3) v(2) v(1) v(4) v(5) dndlogdp_C_smps(binmax) new_salsa_C(binmax)]; 
fprintf(fid, '%d.%d.%d 0%d:%d;%7.3e;%7.3e;"salsa";"urbancase"\n', inchamline);

fclose(fid);
 