
%Input data = MAFOR output

% Load time series files
load ../output_ALL/aerconc.res
load ../output_ALL/plume.res

% MAFOR time series
% with output record every 0.1s
timemafor = aerconc(:,1);
timeplume = plume(:,2);

%AEROSOL MASS CONCENTRATION
pmsulct=aerconc(:,2)+aerconc(:,3)+aerconc(:,4)+aerconc(:,5);
%no msa_p
%xxxx=BPBA
pmxxxct=aerconc(:,10)+aerconc(:,11)+aerconc(:,12)+aerconc(:,13);
pmorgct=aerconc(:,14)+aerconc(:,15)+aerconc(:,16)+aerconc(:,17);
pmamoct=aerconc(:,18)+aerconc(:,19)+aerconc(:,20)+aerconc(:,21);
pmnitct=aerconc(:,22)+aerconc(:,23)+aerconc(:,24)+aerconc(:,25);
pmecbct=aerconc(:,26)+aerconc(:,27)+aerconc(:,28)+aerconc(:,29);
pmashct=aerconc(:,30)+aerconc(:,31)+aerconc(:,32)+aerconc(:,33);
pmseact=aerconc(:,34)+aerconc(:,35)+aerconc(:,36)+aerconc(:,37);
pmwatct=aerconc(:,38)+aerconc(:,39)+aerconc(:,40)+aerconc(:,41);
pmsulf =pmsulct*1.e-3;
pmammo =pmamoct*1.e-3;
pmanit =pmnitct*1.e-3;
pmwatt =pmwatct*1.e-3;
pmdust =pmashct*1.e-3;
pmseat =pmseact*1.e-3;
pmorgt =pmorgct*1.e-3;
pmecbt =pmecbct*1.e-3; 
% TOTAL in ug/m3 (dry mass)
pmtotal=(pmorgct+pmecbct +pmsulct+pmamoct+pmnitct +pmashct+pmseact)*1e-3;

% open output file --> template
fid = fopen('../../outputs/mafor_pmbc.dat', 'wt');

j=1;
rec=1201;
c=5;
count=5;  %write every 0.5s 

while timemafor(j)<timemafor(rec)

  if ( c == count) 
    c=0;
    % write to output file
    inchamline = [timeplume(j) pmtotal(j) pmecbt(j) ]; 
    fprintf(fid, '%g %7.3e %7.3e  \n', inchamline);
  end

  c=c+1; 
  j=j+1;

end 

inchamline = [timeplume(rec) pmtotal(rec) pmecbt(rec) ]; 
fprintf(fid, '%g %7.3e %7.3e  \n', inchamline);
    
% close file
fclose(fid);
 