
%Input data = MAFOR output

% Load time series files
load ../output_ALL/total_n.res
load ../output_ALL/plume.res

% MAFOR time series
% with output record every 0.1s
timemafor = total_n(:,1);
timeplume = plume(:,2);

% MAFOR total number series, ntot
np_nu  = total_n(:,3);
np_ai  = total_n(:,4);
np_as  = total_n(:,5);
np_cs  = total_n(:,6);
ntot   = np_nu+np_ai+np_as+np_cs;
ntot   = ntot*1e-6;

% open output file --> template
fid = fopen('../../outputs/mafor_ntot_ALL.dat', 'wt');

j=1;
rec=1201;
c=5;
count=5;  %write every 0.5s 

while timemafor(j)<timemafor(rec)

  if ( c == count) 
    c=0;
    % write to output file
    inchamline = [timeplume(j) ntot(j) ]; 
    fprintf(fid, '%g %7.3e  \n', inchamline);
  end

  c=c+1; 
  j=j+1;

end 

inchamline = [timeplume(rec) ntot(rec) ]; 
fprintf(fid, '%g %7.3e  \n', inchamline);
    
% close file
fclose(fid);
 