
%Input data = MAFOR output

% Load time series files
load ../output_ALL/plume.res

% MAFOR time series
% with output record every 0.1s
timeplume = plume(:,2);

% MAFOR total number series
sulf=plume(:,8);
svoc=plume(:,9)+plume(:,10);
% convert from ug/m3 to mlc/cm3
avog=6.022e23;
AVOug=1.e12/avog;
mso4=98.07;
msvc=(311+395)/2;
molec2ug_sulf=mso4*AVOug;
sulf=sulf/molec2ug_sulf;
molec2ug_svoc=msvc*AVOug;
svoc=svoc/molec2ug_svoc;


% open output file --> template
fid = fopen('../../outputs/mafor_gases.dat', 'wt');

j=1;
rec=1201;
c=5;
count=5;  %write every 0.5s 

while timeplume(j)<timeplume(rec)

  if ( c == count) 
    c=0;
    % write to output file
    inchamline = [timeplume(j) sulf(j) svoc(j) ]; 
    fprintf(fid, '%g %7.3e %7.3e  \n', inchamline);
  end

  c=c+1; 
  j=j+1;

end 

inchamline = [timeplume(rec) sulf(rec) svoc(rec) ]; 
fprintf(fid, '%g %7.3e %7.3e  \n', inchamline);
    
% close file
fclose(fid);
 